  0  d    c  f infob listboxe  d commandt  previouss  nextv  addw  commentr  exit                                                                                                                                              g  every_minute                                   h  0_minute,  2  8  >  -  3  9  ?  .  4  :  @  /  5  ;  A  j  
every_hour0  6  <  B  1  7  =  C  k  midnight                                      m  	every_day                        l  first_day_in_month                n  every_month         o  JanuaryY  \  _  Z  ]  q  
every_weekday[  ^  p  monday` Hinte   f   D  E  F  a  X  menu_dialog 0`  
menu_popup/* set menu-options and display popup-menu */
CALL menu_dialog.emphasize.MenuChecked global.eEmphasize	/* check/uncheck menu */
CALL menu_dialog.Menu.MenuPopup global.eDefaultMenuOption	/* show menu */menu_emphasizePROCEDURE EXPOSE global.

global.eEmphasize = \global.eEmphasize		/* toggle */

CALL menu_dialog.emphasize.MenuChecked global.eEmphasize	/* check/uncheck menu */

IF global.eEmphasize THEN
   bg_color = "#0"		/* white */
ELSE
   bg_color = "#15"		/* grey */

ranges = "200 259 300 323 401 431 501 512 601 607"	/* loop over all checkboxes */

dialog = "D100"
DO WHILE ranges <> ""
   PARSE VAR ranges bottom top ranges
   DO i = bottom TO top
      control = "C" || i
      clicked = SelectFor(dialog, control)

      /* set color */
      IF clicked THEN
         CALL ColorFor dialog, control, "-", bg_color	/* set background color */
   END
END 

RETURNini_save_entries/* save present cron-file-specs */
CALL SysIni global.eIniFile, global.eIniApp, global.eIniKey, global.eCronfile 
CALL SysIni global.eIniFile, global.eIniApp, global.eIniKey.eEmphasize, global.eEmphasize 
ini_get_entriesPROCEDURE EXPOSE global.

PARSE SOURCE . . thisProcName

global.eIniApp = "Cronedit"
global.eIniKey = "LastFileEdited"
global.eIniKey.eEmphasize = "Option - Emphasize"

global.eIniFile = SUBSTR(thisProcName, 1, LASTPOS(".", thisProcName)) || "ini"

IF STREAM(global.eIniFile, "C", "QUERY EXISTS") = "" THEN		/* default to same directory as program */
DO
   global.eIniCronFile = FILESPEC("Drive", thisProcName) || FILESPEC("Path", thisProcName) || "*.*"
   global.eEmphasize = 1		/* default to emphasize */
END
ELSE
DO
   global.eIniCronFile = SysIni(global.eIniFile, global.eIniApp, global.eIniKey)	/* get stored FileName */
   global.eEmphasize = SysIni(global.eIniFile, global.eIniApp, global.eIniKey.eEmphasize)
END

RETURNset_dimensionsPARSE ARG sx, sy, x, y, cx, cy

sxx = sx
syy = sy

/*
sx = 800*3
sy = 600*3

say "sx" sx "sy" sy "x" x "y" y "cx" cx "cy" cy
*/


IF cx > sx | cy > sy THEN
DO
   x_factor = sx / cx 
   y_factor = sy / cy 
   factor = MIN(x_factor, y_factor)
END
ELSE
DO
/*

   x_factor = sx / cx
   y_factor = sy / cy
   factor = MIN(x_factor, y_factor)

   IF factor = 1 THEN 
      RETURN
*/
   RETURN				/* let DrRexx do the dimensioning */  

END


cxx = TRUNC(cx * factor)
cyy = TRUNC(cy * factor)

start_x = (sxx - cxx) % 2
start_y = (syy - cyy) % 2
CALL Position start_x, start_y, cxx, cyy	/* set start position and dimensions */


CALL dialogs					/* get all dialogs */
do i = 1 to dialogs.0
   myDialog = dialogs.i

   CALL ControlsFor myDialog
   CALL ClassesFor myDialog
   DO j = 1 TO controls.0  
      IF classes.j <> "DIALOG" THEN 
      DO
         position = PositionFor(dialogs.i, controls.j)           
         PARSE VAR position x y cx cy
         new_x  = TRUNC(x * factor)
         new_y  = TRUNC(y * factor)
         new_cx = TRUNC(cx * factor)
         new_cy = TRUNC(cy * factor)

         CALL PositionFor dialogs.i, controls.j, new_x, new_y, new_cx, new_cy
         
	 font     = FontFor(dialogs.i, controls.j)

	 IF font <> "" THEN
         DO   
            PARSE VAR font size "." face		/* get font's face */

            IF POS("00"x, face) > 0 THEN		/* 00x trailing ?? */
               PARSE VAR face face "00"x .

            IF LEFT(face, 1) = "S" THEN			/* change System-fonts to Helvetica for scaling */
               face = "Helvetica"
         END
         ELSE
         DO
            size = 10
            face = "Helvetica"
         END

         new_font = TRUNC( size * factor)  || "." || face
         CALL FontFor dialogs.i, controls.j, new_font
      END
   END
END	init_d100
PROCEDURE EXPOSE global.

PARSE ARG argument			/* get argument, which may be a file only */

global.eHeading = "cronedit (cronrgf-editor)"
global.eDefaultMenuOption = "Save"	/* default option on pop-up menu */

CALL ini_get_entries			/* get ini-file entries, if any */

/* is argument a valid file ? */
global.eCronfile = ""

IF argument <> "" THEN
   global.eCronfile = STREAM(argument, "C", "QUERY EXISTS")
ELSE 
   CALL menu_about		/* no argument given, hence show about box */

/* get file from user */
IF global.eCronfile = "" THEN
   global.eCronfile = FilePrompt(global.eIniCronFile, global.eHeading  "- Open cron controlfile...", "Open")

IF global.eCronfile = "" THEN EXIT

/* set labels for checkboxes */ 
/* minutes */
DO I=200 TO 259
   CALL TextFor "D100", "C" || i, i-200
END

/* hours */
DO I=300 TO 323
   CALL TextFor "D100", "C" || i, i-300
END

/* day in months */
DO I=401 TO 431
    CALL TextFor "D100", "C" || i, i-400
END

/* months */
months = "January February March April May June July August September October November December"

DO I=501 TO 512
    CALL TextFor "D100", "C" || i, WORD(months, i-500)
END

/* weekdays */
weekdays = "Monday Tuesday Wednesday Thursday Friday Saturday Sunday"

DO I=601 TO 607
    CALL TextFor "D100", "C" || i, WORD(weekdays, i-600)
END


CALL Text global.eHeading  "-" global.eCronfile	/* set title */
CALL fill_listbox			/* fill the list-box with file-contents */

/* center dialog in screen, if possible */
PARSE VALUE position() WITH x y cx cy
PARSE VALUE ScreenSize() WITH sx sy

CALL set_dimensions sx, sy, x, y, cx, cy	/* handle, if smaller than 900x750 */
check_number
PROCEDURE EXPOSE global.
/* check whether numbers are setup like: n[(,n)...]|* where n is: # or #-# */
PARSE ARG string

error = 0	

IF string = "*" THEN 		/* o.k., all valid values */
   RETURN 0

number = 0	/* number */
symbol = 0 	/* either comma (,) or dash (-) followed by number */
comma  = 0	/* a comma after the next number mandatory (if dash encountered) ? */

DO i = 1 TO LENGTH(string)
   tmp = SUBSTR(string, i, 1)

   IF \number THEN 		/* this must be a number */
   DO
      error = \DATATYPE(tmp, "W")	/* if not a number, then error */
      number = 1		/* next maybe a number */
      symbol = 0		/* next maybe a symbol */
   END
   ELSE 			/* this may be a symbol or a number */
   DO
      tmp_symbol = (VERIFY(tmp, ",-") = 0)	/* symbol in hand ? */
      tmp_number = DATATYPE(tmp, "W")		/* number in hand ? */

      IF \symbol THEN				/* no symbol as of yet */
      DO
	 IF tmp_symbol | tmp_number THEN	/* must be a symbol or number */
	 DO
	    IF tmp_symbol THEN			/* symbol in hand */
	    DO
               IF comma & tmp <> "," THEN
                  RETURN 1

               symbol = 1			/* next must not be a symbol */
               comma = (tmp = "-")
	       number = 0			/* next must be a number */
	    END

            ITERATE
	 END
         ELSE 
	    error = 1 			/* error in string, neither a number nor a symbol */
      END
      ELSE					/* this must be a number */
      DO
         IF \tmp_number THEN			/* sorry, it's not a number */
	    error = 1
      END
   END

   IF error THEN 
      RETURN 1
END

RETURN symbol	/* if very last char was a symbol instead of a number, than we are in trouble */	add_entryCALL AddFor "D100", "LISTBOX", "", "L"		/* add blank line & comment */
line  = "#" global.eHeading || ", added new cron-item on" DATE(S) TIME()
CALL AddFor "D100", "LISTBOX", line, "L"

line  = "0 0 * * *" global.eHeading || ": added new command"	/* add template */
CALL AddFor "D100", "LISTBOX", line, "L"	

global.eLast = ItemFor("D100", "LISTBOX")	/* get # of entries in Listbox */
global.eListIndex = global.eLast		/* make it the current */

IF global.eFirst = 0 THEN			/* no cron-entry as of yet ? */
   global.eFirst = global.eLast

global.eNrOfEntries = global.eNrOfEntries + 1	/* increase counter */		

CALL SelectFor "D100", "LISTBOX", global.eLast	/* select new entry */

global.eListbox_changed = 1	/* indicate change */
	menu_openPROCEDURE EXPOSE global.

IF global.eListbox_changed THEN
DO
   response = exit_called()	/* do exit-processing    */

   IF response = 2 THEN		/* if not CANCEL pressed */
      SIGNAL RETURN
END


tmpFile = FILESPEC("Drive", global.eCronfile) || FILESPEC("PATH", global.eCronfile) || "*.*"
tmpFile = FilePrompt(tmpFile, global.eHeading  "- Open cron controlfile...", "Open")

IF tmpFile = "" THEN 
   SIGNAL RETURN

global.eCronfile = tmpFile

CALL D100.LISTBOX.Hide "N"	/* no update to the listbox */
CALL D100.Listbox.Delete	/* delete listbox content */
global.eFirst 		= 0	/* first cron-entry */
global.eLast  		= 0	/* last cron-entry */
global.eNrOfEntries 	= 0	/* total of cron-entries */
global.eListbox_changed = 0	/* indicate, if changes occurred */
global.eNrOfEntries     = 0	/* remember # of cron-entries    */

CALL fill_listbox
CALL D100.Text global.eHeading  "-" global.eCronfile	/* set title */
CALL D100.LISTBOX.Show		/* display new content */

exit_calledresponse = 0		/* default to nothing */

IF global.eListbox_changed THEN
DO
   response = RxMessageBox("cronfile has changed - save changes?",,
                      "This is a tough question ... ",,
                      "YESNOCANCEL",,
                      "Question")

   IF response = 6 THEN 	/* YES was pressed, save and leave */
      CALL menu_save_as	
END

IF global.eCronfile <> "" THEN
   CALL ini_save_entries	/* save last file we worked on */


RETURN responsemenu_newPROCEDURE EXPOSE global.

IF global.eListbox_changed THEN
DO
   response = exit_called()	/* do exit-processing    */

   IF response = 2 THEN		/* if not CANCEL pressed */
      SIGNAL RETURN
END

global.eCronfile = ""		/* no name as of yet */

CALL D100.LISTBOX.Hide "N"	/* no update to the listbox */
CALL D100.Listbox.Delete	/* delete listbox content */

line  = "#" global.eHeading || ": created this file on" DATE(S) TIME()
CALL AddFor "D100", "LISTBOX", line, "L"

CALL D100.Text global.eHeading  "- (UNTITLED)"	/* set title */
global.eFirst 		= 0	/* first cron-entry */
global.eLast  		= 0	/* last cron-entry */
global.eNrOfEntries 	= 0	/* total of cron-entries */
global.eListbox_changed = 0	/* indicate, if changes occurred */
global.eNrOfEntries     = 0	/* remember # of cron-entries    */
CALL add_entry			/* add entry at end */
CALL D100.LISTBOX.Show		/* display new content */


menu_save_asPROCEDURE EXPOSE global.

outfile = FilePrompt(global.eCronfile, "Save cron controlfile...", "Save") 

IF outfile <> "" THEN
DO
   global.eCronfile = outfile
   CALL D100.Text global.eHeading  "-" global.eCronfile	/* set title */
   CALL write_listbox_to_file
END

global.eListbox_changed = 0		/* reset flag */
	menu_exitPROCEDURE EXPOSE global.

response = exit_called()	/* do exit-processing    */

IF response <> 2 THEN		/* if not CANCEL pressed */
   EXIT

menu_aboutPROCEDURE EXPOSE global.

crlf = "0D0A"x

txt = "Editor for cron-files - written in REXX with DrDialog (DevCon 6)" || crlf
txt = txt || "V 1.00, 1995-05-18, copyright 1995, all rights reserved, Vienna/Austria" || crlf 
txt = txt || "donated to the public domain; you may use this program together with commercial programs,",  
      "if you don't charge any money for it (as you didn't write it); no guarantees that it works without", 
      "(severe) errors, although it was tested thoroughly" || crlf 
txt = txt || "author: Rony G. Flatscher, Vienna/Austria (heart of Europe)"

IF global.eUnix = 1 THEN
   txt = txt || crlf || x2c("10") FILESPEC("Name", global.eCronfile) x2c("11") ,
         "looks like a Unix-file, only LF's (linefeeds) are and will be used for line-breaks ..."

response = RxMessageBox(txt,,
                      "About" global.eHeading "...",,
                      "OK",,
                      "Information")

RETURN
	menu_savePROCEDURE EXPOSE global.

IF global.eCronfile = "" THEN	/* new file, has no file-name as of yet */
   CALL menu_save_as		/* ask for file-name to write to */
ELSE IF global.eListbox_changed THEN
   CALL write_listbox_to_file

RETURNwrite_listbox_to_filePROCEDURE EXPOSE global.
/* write listbox' content to file */

CALL SysFileDelete global.eCronfile	/* make sure, file does not exist */
CALL STREAM global.eCronfile, "C", "OPEN WRITE"

DO i = 1 TO ItemFor("D100", "LISTBOX")	/* save contents of listbox */
   CALL CHAROUT global.eCronfile, ItemFor("D100", "LISTBOX", i, "Value") || global.eCRLF
END

IF global.eEOFEncountered THEN
   CALL CHAROUT global.eCronfile, "1A"x		/* write EOF */

CALL STREAM global.eCronfile, "C", "CLOSE"
global.eListbox_changed = 0		/* reset flag */

RETURNshow_statisticsPROCEDURE EXPOSE global.

lines = ItemFor("D100", "LISTBOX")
hint = "[cron-entry at line #" global.eListIndex,
        "(total of" global.eNrOfEntries "cron-entries)]"
CALL TextFor "d100", "info", hintLB_get_selectionPROCEDURE EXPOSE global.	/* find/previous next cron-entry */
PARSE ARG increment

start = SelectFor("D100", "LISTBOX")	/* get line # */

/* already seleceted/displayed */
IF (start = global.eListIndex & increment = -1 & start <= global.eFirst) |, 
   (start = global.eListIndex & increment =  1 & start >= global.eLast)  THEN
DO
   CALL BEEP 1000, 100
   RETURN
END

IF increment = 1 THEN  
   end = global.eLast
ELSE
   end = global.eFirst

start = start + increment 	/* don't start with very first entry */

tmpLine   = ""

IF start < global.eFirst THEN		/* beyond first cron-entry */
   global.eListIndex = global.eFirst
ELSE IF start > global.eLast THEN	/* beyond last cron-entry */
   global.eListIndex = global.eLast	
ELSE					/* o.k., let's search */
DO i = start TO MAX(1, end) BY increment
   tmpLine = ItemFor("D100", "LISTBOX", i, "Value")

   IF check_if_command(tmpLine) THEN
   DO
      global.eListIndex = i
      CALL SelectFor "D100", "LISTBOX", global.eListIndex
      LEAVE
   END
END

IF tmpLine = "" THEN
   CALL SelectFor "D100", "LISTBOX", global.eListIndex

RETURNcheck_if_commandPROCEDURE EXPOSE global.

PARSE ARG line

/* no comment and no blank lines ? */
is_command = \((line = "") | LEFT(line, 1) =";" | LEFT(line, 1) = "#")

IF is_command THEN	/* check whether the first words are made of valid symbols */
DO
   IF WORDS(line) > 5 THEN
   DO
      tmp = SUBSTR(line, 1, WORDINDEX(line, 6)-1) /* get number parts */
      is_command = (VERIFY(tmp, "0123456789,-* ", "N") = 0)	/* o.k. ? */
   END
   ELSE
      is_command = 0	/* false, no command */
END

RETURN is_commandmake_range_workPROCEDURE EXPOSE global.
PARSE ARG dialog, lower, upper

tmp_low  = "-1"
tmp_high = "-1"
string   = ""
base     = RIGHT(lower, 1)      /* 0 or 1 based */

DO i = lower TO upper
   control = "C" || i
   tmp = SelectFor(dialog, control)
   tmp_num = i + base - lower   /* transform to "cron"-base */

   IF \tmp THEN                 /* not set, anything in hand ? */
   DO
      IF tmp_low <> "-1" THEN
      DO
         IF tmp_high <> "-1" THEN
            string = string "," tmp_low "-" tmp_high
         ELSE
            string   = string "," tmp_low

         tmp_low  = "-1"
         tmp_high = "-1"
      END
      ITERATE
   END

   IF tmp_low = "-1" THEN
   DO
      tmp_low = tmp_num
      ITERATE
   END

   /* increment of one ? If so, it's a range */
   IF (tmp_high = "-1" & (tmp_low  + 1 = tmp_num)) |,
                       (tmp_high + 1 = tmp_num) THEN
   DO
      tmp_high = tmp_num
      ITERATE
   END

   IF tmp_high <> "-1" THEN       /* range in hand ? */
   DO
      string = string "," tmp_low "-" tmp_high
      tmp_low  = tmp_num        /* start of new range (possibly) */
      tmp_high = "-1"
   END
   ELSE
   DO
      string = string "," tmp_low
      tmp_low = tmp_num
   END
END

IF tmp_low <> "-1" THEN           /* anything in hand ? */
DO
   IF tmp_high <> "-1" THEN
   DO                             /* all possible values == "*" */
      IF tmp_low = base & tmp_high + lower - base = upper THEN
         string = "*"		
      ELSE			/* range in hand */
         string = string "," tmp_low "-" tmp_high
   END
   ELSE				/* single value in hand */
     string  = string "," tmp_low
END

string = STRIP(SPACE(string,0), "B", ",")

IF string = "" THEN             /* NOTHING checked, impossible !    */
DO
   string = base                        /* default to first entry   */
   control = "C" || lower
   CALL SelectFor dialog, control, "1"  /* check first entry        */
   CALL clicked dialog, control         /* show visually with color */
END

RETURN string


make_rangePROCEDURE EXPOSE global.

PARSE ARG control

tmp = SUBSTR(control, 2, 1)   /* get set from control-id */

SELECT
   WHEN tmp = "2" THEN global.pMin = make_range_work("D100", 200, 259) /* minutes */
   WHEN tmp = "3" THEN global.pHou = make_range_work("D100", 300, 323) /* hours */
   WHEN tmp = "4" THEN global.pDay = make_range_work("D100", 401, 431) /* days */
   WHEN tmp = "5" THEN global.pMon = make_range_work("D100", 501, 512) /* month */
   WHEN tmp = "6" THEN global.pWee = make_range_work("D100", 601, 607) /* weekday */
   OTHERWISE NOP
END  

CALL ItemFor "D100", "LISTBOX", global.eListIndex, "Value",,
             global.pMin global.pHou global.pDay global.pMon global.pWee global.pCommand   

RETURN
parse_and_setPARSE ARG string

CALL show_statistics	/* update info-control */

PARSE VAR string global.pMin global.pHou global.pDay global.pMon global.pWee global.pCommand
CALL TextFor "D100", "command", STRIP(global.pCommand, "L")

global.eError = 0		/* no error by default */

errstr = ""
IF parse_numbers("D100", 200, 259, global.pMin) THEN 
DO
   errstr = "|minutes"
   global.pMin = "*"
END
IF parse_numbers("D100", 300, 323, global.pHou) THEN 
DO
   errstr = errstr "|hours"
   global.pHou = "*"
END
IF parse_numbers("D100", 401, 431, global.pDay) THEN 
DO
   errstr = errstr "|days"
   global.pDay = "*"
END
IF parse_numbers("D100", 501, 512, global.pMon) THEN 
DO
   errstr = errstr "|months"
   global.pMon = "*"
END
IF parse_numbers("D100", 601, 607, global.pWee) THEN 
DO
   errstr = errstr "|weekdays"
   global.pWee = "*"
END

IF global.eError THEN		/* error occurred in parsing numbers */
DO
   response = RxMessageBox("Cron entry is in error !",,
                      global.eHeading,,
                      "OK",,
                      "ERROR")

  i = global.eListIndex  
  /* comment line in error */
  CALL ItemFor "D100", "LISTBOX", i, "Value", "#" string

  i = i + 1
  errstr = TRANSLATE(STRIP(SPACE(errstr,0), "B", "|"), "+", "|")

  tmp = "#" global.eHeading "(" || DATE(S) TIME() || ") - *ERROR* in above cron-entry occurred in [" || errstr || "], changed to:" 
  CALL AddFor "D100", "LISTBOX", tmp, i

  i = i + 1
  tmp = global.pMin global.pHou global.pDay global.pMon global.pWee global.pCommand
  CALL AddFor "D100", "LISTBOX", tmp, i
  global.eListIndex = i

  i = i + 1
  CALL AddFor "D100", "LISTBOX", "", i	/* insert empty line */

  /* adjust for insertions */
  global.eLast = global.eLast + 3
  global.eListbox_changed = 1		/* indicate that changes occurred */

  CALL SelectFor "D100", "LISTBOX", global.eListIndex	/* select new entry */
END
parse_numbersPROCEDURE  EXPOSE global.

ARG dialog, lower, upper, string .

IF check_number(string) THEN	/* returns 1, if string in error */
DO
   global.eError = 1
   RETURN 1			/* indicate that error happened */
END

error = 0

low  = RIGHT(lower, 2) + 0	/* get lower bound in cron values */
high = RIGHT(upper, 2)  	/* get upper bound in cron values */

/* dialog, control: lower #, control: upper #,
   string to parse, low val in numbers, 
   high val in numbers */

tmpVal. = 0

DO WHILE string <> ""
   PARSE VAR string tmpcomma "," string

   PARSE VAR tmpcomma tmpdash "-" tmpcomma

   /* error: no number, nor asterisk follows comma */
   IF tmpdash <> "*" THEN
   DO
      IF tmpdash < low | tmpdash > high THEN	/* beyond limits ? */
      DO
         global.eError = 1
         error = 1
         tmpVal. = 0	/* set all options */
         LEAVE		/* leave loop */
      END
   END

   IF tmpcomma <> "" THEN			/* upper bound given = dash was there */
   DO
       /* error: no number follows comma */
       IF tmpcomma < low | tmpcomma > high THEN	/* beyond limits ? */
       DO
         global.eError = 1
         error = 1
         tmpVal. = 0	/* don't set options */
         LEAVE		/* leave loop */
      END

       IF tmpcomma < tmpdash THEN  /* wrap */
       DO
          DO i = low TO tmpcomma
             tmpVal.i = 1	/* set flag */
          END
          tmpcomma = high
       END

       /* do the rest */
       DO i = tmpdash TO tmpcomma
          tmpVal.i = 1
       END
   END
   ELSE /* only one single number left */
   DO
       IF tmpdash = "*" THEN	/* all values */
       DO
          DO i = low TO high
             tmpVal.i = 1
          END
          LEAVE			/* leave loop */
       END
       ELSE
          tmpVal.tmpdash = 1      
   END
END

base = (low = 1) 	/* adjust, if base 1 */
DO i = lower TO upper
   control = "C" || i
   
   idx = i - lower + base
   CALL set_checkbox dialog, control, tmpVal.idx
END

RETURN errorfill_listboxPROCEDURE EXPOSE global.

listbox = "LISTBOX"

i = 0
global.eFirst 		= 0		/* first cron-entry */
global.eLast  		= 0		/* last cron-entry */
global.eNrOfEntries 	= 0		/* total of cron-entries */
global.eListbox_changed = 0		/* indicate, if changes occurred */
global.eNrOfEntries     = 0		/* remember # of cron-entries    */

size = STREAM(global.eCronfile, "C", "QUERY SIZE")
CALL STREAM global.eCronfile, "C", "open read"
fileContent = CHARIN(global.eCronfile, 1, size)	/* read entire file into variable */
CALL STREAM global.eCronfile, "C", "close"

LF = "0A"x		/* linefeed char */
CR = "0D"x		/* carriage return */
EOF = "1A"x		/* EOF == CTL-Z */

PARSE VAR fileContent . (lf) -1 tmpCR +1 tmpLF +1 .	/* get LF and possible CR, if not a unix-file */

IF CR = tmpCR THEN
   global.eCRLF = CR || LF
ELSE 
   global.eCRLF = LF

global.eUnix = (global.eCRLF = LF)	/* Unix-file (LF's only) ? */
global.eEOFEncountered = 0		/* default to no EOF == CTL-Z */

DO WHILE LENGTH(fileContent) > 0
   i = i + 1
   PARSE VAR fileContent line (global.eCRLF) fileContent

   IF line = EOF THEN 			/* EOF encountered, leave, even if Unix-file */
   DO
      global.eEOFEncountered = 1
      LEAVE
   END

   IF check_if_command(line) THEN
   DO
      IF global.eFirst = 0 THEN     
         global.eFirst = i		/* remember first cron-entry */

      global.eNrOfEntries = global.eNrOfEntries + 1 /* remember # of entries */
      global.eLast = i			/* remember last cron-entry */
   END

   CALL AddFor "D100", listbox, line
END


IF global.eFirst > 0 THEN	/* select first command */
DO
   CALL SelectFor "D100", listbox, global.eFirst
END
ELSE
DO
   crlf = "0D0A"x
   aha = RxMessageBox("File:" || crlf || "[" || global.eCronfile"]" || crlf ||,
                      "is not a cron file (does not contain valid cron-entries) !",,
                      "Warning !",,
                      "OK",,
                      "ERROR")  
END

global.eListIndex = global.eFirstall_optionsPROCEDURE EXPOSE global.

PARSE ARG bottom, top

DO I=bottom TO top
   control = "C" || i
   CALL set_checkbox "D100", control, "1"
END

CALL make_range control		/* control to work on	*/
global.eListbox_changed = 1	/* indicate change	*/

RETURNfirst_optionPROCEDURE EXPOSE global.

PARSE ARG bottom, top

control = "C" || bottom
CALL set_checkbox "D100", control, "1"

DO I = top TO bottom + 1 BY -1
   control = "C" || i
   CALL set_checkbox "D100", control, "0"
END

CALL make_range control		/* control to work on	*/
global.eListbox_changed = 1	/* indicate change 	*/

RETURNset_checkboxPARSE ARG dialog, control, state

tmp = SelectFor(dialog, control)

IF SelectFor(dialog, control) = state THEN	/* already set */
   RETURN

CALL SelectFor dialog, control, state
CALL clicked dialog, control
clickedPROCEDURE EXPOSE global.

PARSE ARG dialog, control

IF global.eEmphasize THEN	/* draw color around selected checkboxes ? */
DO
   clicked = SelectFor(dialog, control)

   /* set color */
   IF clicked THEN
      CALL ColorFor dialog, control, "-", "#0"	/* white */
   ELSE
      CALL ColorFor dialog, control, "-", "#15"    /* grey  */
END

RETURN d 0,  ,              
  2 5  d $        ( Z  c;        U _ U fZ            2 b           -  e          7  	 d          J  4  t             4  s             4  v            4  w            4  r           	   	            	   	           ) 	   	  *         V 	   	  W          	 ~  	            	 r  	            	 f  	           
 	 Z  	           7 	 N  	  8         d 	 B  	  e          	 6  	            	 *  	                	                	           E     	  F         r     	  s            ~  	              r  	              f  	           &   Z  	  '         S   N  	  T            B  	              6  	              *  	            7   	           4 7   	  5         a 7   	  b          7   	            7 ~  	            7 r  	            7 f  	           B 7 Z  	  C         o 7 N  	  p          7 B  	            7 6  	            7 *  	          # N   	  $         P N   	  Q         } N   	  ~          N   	            N ~  	            N r  	           1 N f  	  2         ^ N Z  	  _          N N  	            N B  	            N 6  	            N *  	         ?  	  Q  g          L e   	  M         y e   	  z          e   	            e   	             e ~  	           - e r  	  .         Z e f  	  [          e Z  	            e N  	            e B  	            e 6  	           ; e *  	 <        h  f    h          j    	 ,k             	 2             	 8             	 >             	 -         K    	 3L         x    	 9y             	 ?             	 .             	 4           ,     	 :-          Y     	 @Z               	 /               	 5               	 ;          
!    	 A!       
 :!   i Q  j          E!    	 0F!         r!    	 6s!         !    	 <!         !    	 B!         !    	 1!         &"    	 7'"         S"    	 =T"         "    	 C"        "   i 0  k          "   	 "         "   	 "         #   	 #         =#   	 >#         j# ~  	 k#         # 0  	 #         # 0  	 #         # 0  	 #         $ 0  	 $         K$ 0~  	 L$         x$ G  	 y$         $ G  	 $         $ G  	 $         $ G  	  %         ,% G~  	 -%         Y% ^  	 Z%         % ^  	 %         % ^  	 %         % ^  	 %       	 
&  i Q  m          & u  	 &         D& u  	 E&         q& u  	 r&         & u  	 &         &   	 &         &   	 &         %'   	 &'         R'   	 S'         '   	 '         '   	 '         '   	 '         (   	 (       	 3(  i 0  l          =(  N , 	 >(         j(  B , 	 k(         (  6 , 	 (         (  * , 	 (         (  N , 	 (         )  B , 	 )         K)  6 , 	 L)         x)  * , 	 y)        )    Q  n          )  N - 	 )         )  B - 	 )         *  6 - 	 *         8*  * - 	  9*        e*    0  o          m* N 3 	 Yn*         * B 3 	 \*         * 6 3 	 _*         * ON 3 	 Z*         !+ OB 3 	 ]"+       
 N+   Q  q          \+ N 3 	 []+         + B 3 	 ^+        +   0  p          +  
 `+        +    y  e +        ,   d  \ f ,       
 <,  d  \ DJ,        t,     P E{,        ,    P F,         ,    
 acronedit (cronrgf-editor)    Commands available          10.Helvetica  Text &         10.Helvetica                   Command          10.Helvetica         Previous Next Add Comment Exit  (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman  every minute  (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman  0  (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman  every hour  (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman  midnight  (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman  every day  (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman  first day  (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman  every month  (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman  January  (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman   (                  10.Times New Roman  every weekday  (                  10.Times New Roman   (                  10.Times New Roman  Monday                    	   Minutes &         10.Helvetica                  Hours &         10.Helvetica                  Days in Month &         10.Helvetica                  Months &         10.Helvetica                  Only, on following Weekdays &         10.Helvetica                   d 0N  d ShowMenuICALL menu_dialog.Menu.MenuPopup global.eDefaultMenuOption	/* show menu */InitPARSE ARG argument

IF RxFuncQuery( 'SysLoadFuncs' ) THEN DO
   CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
   CALL SysLoadFuncs
END

CALL init_d100 argument		/* initialize global variables, dialogs */

CALL showaShowMenu9CALL menu_dialog.Menu.MenuPopup global.eDefaultMenuOptionFShowMenu9CALL menu_dialog.Menu.MenuPopup global.eDefaultMenuOptionEShowMenu9CALL menu_dialog.Menu.MenuPopup global.eDefaultMenuOptionDShowMenu9CALL menu_dialog.Menu.MenuPopup global.eDefaultMenuOptionf ShowMenu9CALL menu_dialog.Menu.MenuPopup global.eDefaultMenuOptione ShowMenu9CALL menu_dialog.Menu.MenuPopup global.eDefaultMenuOption`InitIsDefault("DialogHint")p InitICALL Text "~Monday"	/* has to be explicitly set, due to DrDialog-Bug */
ClickCALL First_Option 601, 607q InitPCALL Text "every ~weekday"	/* has to be explicitly set, due to DrDialog-Bug */
ClickCALL all_options 601, 607o InitJCALL Text "~January"	/* has to be explicitly set, due to DrDialog-Bug */
ClickCALL First_Option 501, 512n InitNCALL Text "every m~onth"	/* has to be explicitly set, due to DrDialog-Bug */
ClickCALL all_options 501, 512l InitLCALL Text "~first day"	/* has to be explicitly set, due to DrDialog-Bug */
ClickCALL First_Option 401, 431m InitLCALL Text "every ~day"	/* has to be explicitly set, due to DrDialog-Bug */
ClickCALL all_options 401, 431k InitICALL Text "midni~ght"	/* has to be explicitly set, due to DrDialog-Bug */ClickCALL First_Option 300, 323j InitMCALL Text "every ~hour"	/* has to be explicitly set, due to DrDialog-Bug */
ClickCALL all_options 300, 323h InitDCALL Text "~0"	/* has to be explicitly set, due to DrDialog-Bug */
ClickCALL First_Option 200, 259g InitOCALL Text "every m~inute"	/* has to be explicitly set, due to DrDialog-Bug */
ClickCALL all_options 200, 259r InitGCALL Text "E~xit"	/* has to be explicitly set, due to DrDialog-Bug */
Clickwresponse = exit_called()	/* do exit-processing    */

IF response <> 2 THEN		/* if not CANCEL pressed */
   EXIT

w InitJCALL Text "~Comment"	/* has to be explicitly set, due to DrDialog-Bug */
Click	/* get selected text */

IF global.eNrOfEntries  = 0 THEN 	/* no cron-entry available */
DO
   CALL BEEP 1000, 100
   SIGNAL RETURN
END


selected_text = ItemFor("D100", "LISTBOX", global.eListIndex, "Value")
/* comment it */
CALL ItemFor "D100", "LISTBOX", global.eListIndex, "Value", "#" selected_text

/* reflect the change */
global.eNrOfEntries = global.eNrOfEntries - 1	/* decrease counter */

IF global.eNrOfEntries = 0 THEN		/* no more cron-entries available */
DO
   CALL SelectFor "D100", "LISTBOX", global.eListIndex, "U"	/* unselect */
   global.eFirst = 0
   global.eLast  = 0
   global.eListIndex = 0

   CALL show_statistics			/* update info-control explicitly */
END
ELSE IF global.eListIndex = global.eLast THEN
DO
   CALL LB_get_selection -1		/* at end, get previous cron-entry */
   global.eLast = global.eListIndex 
END
ELSE
DO
   change_first = (global.eFirst = global.eListIndex)	/* first cron-entry to be adjusted ? */
   CALL LB_get_selection 1	/* get next cron-entry */
   IF change_first THEN
      global.eFirst = global.eListIndex 
END

global.eListbox_changed = 1	/* indicate change */
v InitFCALL Text "~Add"	/* has to be explicitly set, due to DrDialog-Bug */
Click=CALL add_entry		/* add an entry at the end of the file */

s InitGCALL Text "~Next"	/* has to be explicitly set, due to DrDialog-Bug */
Click4CALL LB_get_selection 1	/* loop will be increased */t InitICALL Text "~Previous"	/* has to be explicitly set, due to DrDialog-Bug */Click5CALL LB_get_selection -1	/* loop will be decreased */d	LoseFocusIF global.pCommand = "" THEN
DO
    aha = RxMessageBox("You need to enter a command !",,
                      "Warning !",,
                      "OK",,
                      "EXCLAMATION")

    CALL Text "You need to enter a command here !"
/*
    line = ItemFor("D100", "LISTBOX", global.eListIndex, "Value") ||,
                   "You need to enter a command here !"
    CALL ItemFor "D100", "LISTBOX", global.eListIndex, "Value", line
*/

    CALL SelectFor "D100", "LISTBOX", global.eListIndex 
    CALL Focus		/* set focus to entry field */
ENDChangedglobal.pCommand = TextFor("D100", "command")			/* get new command */
CALL ItemFor "D100", "LISTBOX", global.eListIndex, "Value",,	/* set listbox */
             global.pMin global.pHou global.pDay global.pMon,
             global.pWee global.pCommand    

global.eListbox_changed = 1	/* indicate change */
bSelecttmpInd   = SelectFor("D100", "LISTBOX")

IF tmpInd = 0 THEN		/* nothing selected, came from commenting */
   SIGNAL RETURN

line = ItemFor("D100", "LISTBOX", tmpInd, "Value")

IF check_if_command(line) THEN
DO
   global.eListIndex = tmpInd
   CALL parse_and_set line
END
ELSE
DO	
   /* a commented cron-entry ? if so, reactivate it ? */
   IF LEFT(line, 1) = "#" | LEFT(line, 1) = ";" THEN	/* looks like a commented cron-entry ? */
   DO
      IF check_if_command(SUBSTR(line, 2)) THEN
      DO
         aha = RxMessageBox("Do you wish to reactivate the cron-entry ?",,
                      "This looks like a commented cron-entry:",,
                      "YESNO",,
                      "QUESTION")
         IF aha = 6 THEN
         DO 
            line =  STRIP(SUBSTR(line, 2), "L")
            CALL ItemFor "D100", "LISTBOX", tmpInd, "Value", line	/* uncomment */
            global.eNrOfEntries = global.eNrOfEntries + 1	/* increase counter */

	    IF global.eNrOfEntries = 1 THEN		/* very first selectable cron entry ? */
            DO
	       global.eFirst = tmpInd
	       global.eLast  = tmpInd
            END
            ELSE IF tmpInd < global.eFirst THEN	/* adjust indicators */
               global.eFirst = tmpInd
            ELSE IF tmpInd > global.eLast THEN
               global.eLast = tmpInd

	    global.eListIndex = tmpInd
            global.eListbox_changed = 1		/* indicate change 	*/
            CALL show_statistics		/* update info for user */
		
            CALL SelectFor "D100", "LISTBOX", global.eListIndex
            CALL parse_and_set line
         END
         ELSE 
            CALL SelectFor "D100", "LISTBOX", global.eListIndex

         SIGNAL RETURN
      END
   END

   aha = RxMessageBox("Not a valid cron-entry !",,
                      "Warning !",,
                      "OK",,
                      "EXCLAMATION")  
   CALL SelectFor "D100", "LISTBOX", global.eListIndex
END

d 0    Clickz/* check button was pressed */
call clicked dialog(), control()
call make_range control()
global.eListbox_changed = 1
d 0~  %d pop-up menu: MB2 (right mouse button)>FWeekday(s) to invoke on, pop-up menu: MB2 (right mouse button)<EMonth(s) to invoke on, pop-up menu: MB2 (right mouse button)EDDay(s) of a month to invoke on, pop-up menu: MB2 (right mouse button);f Hour(s) to invoke on, pop-up menu: MB2 (right mouse button)=e Minute(s) to invoke on, pop-up menu: MB2 (right mouse button)%`This is the hint-line, isn't it ? :-)p mondays only^weekday to invoke on[weekday to invoke on
q every weekday]weekday to invoke onZweekday to invoke on_weekday to invoke on\weekday to invoke onYweekday to invoke ono January only month to invoke onmonth to invoke onmonth to invoke onmonth to invoke onn every monthmonth to invoke onmonth to invoke onmonth to invoke onmonth to invoke onmonth to invoke onmonth to invoke onmonth to invoke onmonth to invoke onl first day of a month onlyday of a month to invoke onday of a month to invoke onday of a month to invoke onday of a month to invoke onday of a month to invoke onday of a month to invoke onday of a month to invoke onday of a month to invoke onday of a month to invoke onday of a month to invoke onday of a month to invoke onday of a month to invoke onm every day of a monthday of a month to invoke onday of a month to invoke onday of a month to invoke onday of a month to invoke onday of a month to invoke onday of a month to invoke onday of a month to invoke onday of a month to invoke onday of a month to invoke onday of a month to invoke onday of a month to invoke onday of a month to invoke onday of a month to invoke onday of a month to invoke onday of a month to invoke onday of a month to invoke onday of a month to invoke onday of a month to invoke onday of a month to invoke onk at midnight onlyChour to invoke on=hour to invoke on7hour to invoke on1hour to invoke onBhour to invoke on<hour to invoke on6hour to invoke on0hour to invoke on
j every hourAhour to invoke on;hour to invoke on5hour to invoke on/hour to invoke on@hour to invoke on:hour to invoke on4hour to invoke on.hour to invoke on?hour to invoke on9hour to invoke on3hour to invoke on-hour to invoke on>hour to invoke on8hour to invoke on2hour to invoke on,hour to invoke onh at full hours onlyminute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke ong every minuteminute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke onminute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke on minute to invoke onr Exit Program3w selected cron-entry will be commented (inactivated)v add a new cron-entrys go to next cron-entryt go to previous cron-entrydcommand(s) to be executed>bclicking on a commented cron-entry allows you to reactivate it X0L   L                ,   D   q XH DrDialog: An Oberon Program     X0            menu          Abou~t ...     O~ptions          ~Emphasize   @   	 ~Open ...    
 ~New ...   @    ~Save    
 Save ~As ...   @    E~xit   @X0    menu  aboutcall menu_about options  	emphasizeCALL menu_emphasize	 openCALL menu_open
 new
CALL menu_new savecall menu_save
 save_ascall menu_save_as exitCALL menu_exitX0  XOpen/* initial state of menus can be set only, after the dialog to which the menu belongs
   is finished initializing */

tmp_emph = menu_dialog.emphasize.MenuChecked()

IF tmp_emph <> global.eEmphasize THEN 
   CALL menu_dialog.emphasize.MenuChecked global.eEmphasize

