:
#	@(#) bootpart.sh  V.1
#
#	By L.I.Kirby      70734.126@compuserve.com
#	Distribute freely
#
# Generates variants of the /dos file in SCO systems to allow partitions other
# than Unix or DOS to be booted.

SRCDEF=/dos

getinp() {
	default=$1
	shift
	while echo "$*\c"
	do
		read line
		case $line in
		Q|q)	exit 1
		;;
		"")	if [ "$default" ]
			then
				line=$default
				echo "Using $default default"
				return 0
			fi
		;;
		*)	return 0
		esac
	done
}

getlen() {
srclen=$5
}

echo "\n\nSCO Xenix/Unix is supplied with a file called 'dos' in the root directory"
echo "which permits you to boot a DOS partition on your hard disk from the"
echo "Boot prompt. It is possible to boot up other partitions by invoking a"
echo "suitable variant of the 'dos' file. This script is designed to create"
echo "these variants based on your original 'dos' file.\n"
echo "There are several ways to specify the target partition. Probably the"
echo "simplest is by partition number. This will work for a particular installation"
echo "until the partition table is rearranged. You may alternatively specify"
echo "either one or two partition types if you know the correct values. This"
echo "is more system independent. For two types the highest partition with a type"
echo "that matches either value is booted. Please note partition values should be"
echo "entered in octal without a leading zero.\n"
echo "This script will patch older SCO dos files with a file length of 577 bytes"
echo "or the new dos file in SCO Unix 3.2.4."
echo "The new file should be placed in the root directory and its name defines"
echo "the command you type at the boot prompt to start it.\n"
echo "Some typical partition types are (in octal):"
echo "1  DOS FAT < 16Mbyte     4 DOS FAT > 16 < 32Mbyte     6 DOS FAT  > 32Mbyte"
echo "2  Xenix 1               3 Xenix 2"
echo "7  IFS (e.g. OS/2 HPFS)  12 OS/2 Boot manager\n"

getinp "$SRCDEF" "Enter name of souce file (default $SRCDEF) "
srcfile=$line
echo

[ -r "$srcfile" ] || { echo "Sorry, can't read source file $srcfile"; exit 1; }

getlen `ls -l "$srcfile"`
case $srclen in
577)
	ver324=false
;;
584)
	ver324=true
;;
*)
	echo Source file is not suitable
	exit 1
esac

getinp "" "Enter name of new file (should be root directory) "
destfile=$line

echo "\nYou may specify:"
echo "a) a partition number"
echo "b) one partition type"
echo "c) two partition types"
while getinp "" "Enter option required (a-c) "
do
	boottype=$line
	case $boottype in
	a|A)
		echo
		while getinp "" "Enter partition number (1-4)"
		do
			partnum=$line
			case $partnum in
			1|2|3|4) break
			esac
		done
		break
		;;
	b|B)
		echo
		getinp "" "Enter partition type (octal) "
		parttype=$line
		break
		;;
	c|C)
		echo
		getinp "" "Enter partition type 1 (octal) "
		parttype1=$line
		echo
		getinp "" "Enter partition type 2 (octal) "
		parttype2=$line
		break
	;;
	*)
		continue
	esac
done

# Create new boot file

echo "\nCreating $destfile...\n"
	
rm -f "$destfile"
dd if="$srcfile" of="$destfile" bs=247 count=1

if $ver324
then
	echo -n "\0220\0220\0220\0220\0220\0220\0220" >> "$destfile"
	rpos=266
else
	rpos=259
fi

case $boottype in
a|A)
	echo -n "\0220\0220\0220\0220\0220\0220\0220\0220\0220\0203\0371\0$partnum" >> "$destfile"
	;;
b|B)
	echo -n "\0220\0220\0220\0220\0220\0220\0220\046\0200\0174\04\0$parttype" >> "$destfile"
	;;
c|C)
	echo -n "\046\0200\0174\04\0$parttype1\0164\07\046\0200\0174\04\0$parttype2" >> "$destfile"
esac

dd if="$srcfile" of="$destfile" bs=$rpos seek=1 skip=1
chmod 400 "$destfile"
chgrp bin "$destfile"
chown bin "$destfile"

echo "\n$destfile has now been created. Use this name at the Unix Boot prompt"
echo "to start up the other partition. Just press <enter> or type dos as normal"
echo "to start up Unix or DOS respectively."
