/* Present a query to the user, and return the user's response
 *
 * Arguments
 *   arg(1) - the dialog name. This will be the title line for VIO and the
 *            name of the tab on the Display Monitor.
 *   arg(2) - the default value. If the user simply presses OK or Enter,
 *            this is the value returned.
 *   arg(3) - a string containing the query to the user. This string has
 *            a maximum length of 900 characters.
 *   arg(4) - data type; optional parameter; F=File, T=Text, D=Directory
 *            default is File.
 *
 * Copyright (C) 2006 Blonde Guy
 * All Rights Reserved
 */

pipeName = '\pipe\suntan'
dialogName = 'Query Test'

if arg() = 0 then do
   response = query(dialogName, "default value", "Testing the query screen.", "Text")
   say response
   exit
end

call SysWaitNamedPipe pipename, -1
pipestate = stream(pipeName, 'c', 'open')
if left(pipestate, 8) = 'NOTREADY' then do
   dialogName = arg(1)
   defaultValue = arg(2)
   say dialogName
   say ""
   call SayWords arg(3)
   say ""
   say "Press Enter to accept a value of" defaultValue
   say "or enter a new value and press Enter."
   parse pull response
   if response = '' then do
      response = defaultValue
   end
   response = 'dc=' || response
end
else do
   x = arg(1)
   do i = 2 to arg()
      x = x || d2c(10) || arg(i)
   end

   call lineout pipeName, "!query" x
   
   call SysSleep 1
   
   response = ''
   do until response \= ''
      pipeState = stream(pipeName, 'c', 'open')
      if left(pipestate, 8) = 'NOTREADY' then return arg(2)
      call lineout pipeName, "!dialogwait"
      response = linein(pipeName)
      call SysSleep 1
   end
end

return substr(response, 4)
