/* Present a TwoPanel to the user, and return the user's choice
 *
 * Arguments
 *   arg(1)    - the dialog name. This will be the title line for VIO and the
 *               name of the tab on the Display Monitor.
 *   arg(2)    - a string containing the instructions to the user.
 *   arg(3)    - a string containing the name of the callback rexx program.
 *   arg(4..n) - the items in the TwoPanel list
 *
 * Copyright (C) 2005 Blonde Guy
 * All Rights Reserved
 */

pipeName = '\pipe\suntan'

if arg() = 0 then do
   response = TwoPanel('TwoPanel Test', "Pick one item from this list.", "TPCallback.cmd", "item 1", "item 2", "item 3")
   say response
   exit
end

pipestate = stream(pipeName, 'c', 'open')
if left(pipestate, 8) = 'NOTREADY' then do
   dialogName = arg(1)
   instructions = arg(2)
   say ""
   say instructions
   say "Enter one item from this list."
   do i = 3 to arg()
      say arg(i)
   end
   say ""
   say "Enter item."
   parse pull response
   response = 'dc=' || response
end
else do
   x = arg(1)
   do i = 2 to arg()
      x = x || d2c(10) || arg(i)
   end

   call lineout pipeName, "!twopanel" x
   
   call SysSleep 1
   
   response = ''
   do until response \= ''
      pipeState = stream(pipeName, 'c', 'open')
      if left(pipestate, 8) = 'NOTREADY' then return ''
      call lineout pipeName, "!dialogwait"
      response = linein(pipeName)
      call SysSleep 0.1
   end
end

return substr(response, 4)
