/* Setup Directory Editor
 * This program is intended to be called from Suntan Special
 *
 * Description
 *   This command runs the Setup Directory Editor. The Setup Directory
 *   Editor displays all of the applications in the setup directory.
 *   Each application may be selected by the user for deletion.
 *
 * Copyright (C) 2016 Blonde Guy
 * All Rights Reserved
 */

productName = "Setup Editor"
productDate = '2016-12-13 14:14:10'
productCategory = 'Configuration'

pipeName = '\pipe\suntan'
dialogName = 'Setup Dir'
response = ''
myDir = cdglobal('setupDir')
originalDir = Directory()

cr = d2c(13)
instructions = "Directory Editor" || cr || cr ||,
               "Single click each line to get a description of the application",
               "on that line. Double click or press enter to select",
               "the setting for deletion."

x = dialogName || d2c(10) ||,
    instructions || d2c(10) ||,
    originalDir || "\DirEdCB.cmd"  || d2c(10) ||,
    originalDir || "\DirEdCB.cmd" || d2c(10) ||,
    "~Delete"

/* should editor wait for the list panel to return OK */
action = 'Wait'
if action = "Wait" then do
   x = x || d2c(10) || "Wait"
end
else do
   x = x || d2c(10) || "Continue"
end

/* get application list */
call SysFileTree myDir || '\*.*', 'dirlist.', 'DO'
numDirs = 0
do i=1 to dirlist.0
   if stream(dirlist.i || '\cdi.cmd', 'c', 'query exists') <> '' then do
      numDirs = numDirs + 1
      app.numDirs = dirlist.i
   end
end
app.0 = numDirs

call BubbleSort

x = x || d2c(10) || ';' myDir
do sn = 1 to numDirs
   ls = lastpos('\', app.sn)
   if ls > 0 then do
      x = x || d2c(10) || substr(app.sn, ls + 1)
   end
end

call LogCdi "!listpanel" x

if action = 'Wait' then do
   qname = RxQueue('Create', 'SetEd')
   if qname <> 'SETED' then do
      say 'RxQueue(Create, SetEd) returned' qname
      call RxQueue 'Delete', qname
   end
   oldq = RxQueue('Set', 'SetEd')
   SetEdEnd = LineIn('QUEUE:')
   call RxQueue 'Set', oldq
   call RxQueue 'Delete', 'SetEd'
end

return 0


 /* ------------------------------------------------------------------ */
 /* function: bubble sort routine from REXX tips and tricks            */
 /*                                                                    */
 /* call:     BubbleSort                                               */
 /*                                                                    */
 /* returns:  nothing                                                  */
 /*                                                                    */
 /* notes:    You must save the elements to sort in the stem "app."    */
 /*           app.0 must contain the number of elements in the app.  */
 /*                                                                    */
 /*                                                                    */
 BubbleSort: PROCEDURE expose app.
 
   do i = app.0 to 1 by -1 until flip_flop = 1
     flip_flop = 1
     do j = 2 to i
       m = j - 1
       mName = translate(filespec('name', app.m))
       jName = translate(filespec('name', app.j))
       if mName >> jName then do
         /* say "Swapping" mName "and" jName */
         xchg = app.m
         app.m = app.j
         app.j = xchg
         flip_flop = 0
       end /* if app.m ... */
     end /* do j = 2 ... */
   end /* do i = app.0 ... */
 return
