/* Restore Boot Manager
 * This program is intended to be called from Suntan Special
 *
 * Description
 *   This command restores the boot manager options saved by the
 *   Save Boot Manager command.
 *
 * Copyright (C) 2005 Blonde Guy
 * All Rights Reserved
 */

productName = 'Restore Boot Manager'
productDate = '2006-12-28 18:56:12'
productCategory = 'Configuration'

call LogCdi "restore boot manager options"
suntanDir = strip(sysini("User", 'Suntan Special', 'Settings'), 'T', d2c(0))
setBootFile = suntanDir || '\setboot.txt'

if stream(setBootFile, 'c', 'query exists') = '' then do
   call LogCdi "Error, saved boot settings not found"
   return 1
end

call restoreboot setBootFile
rc = SysFileDelete(setBootFile)
if rc <> 0 then do
   call LogCdi "Error" rc "deleting" setBootFile
end

call LogCdi productName "complete"
return 0


/* 
 * restore boot manager data
 *
 * Copyright (C) 2002 Blonde Guy
 * All Rights Reserved
 */
restoreboot:

parse arg bootFile
call LogCdi "Restoring Boot Manager settings from" bootFile

if bootFile = '' then do
   call LogCdi "Boot File not specified"
   return
end

if stream(bootFile, 'c', 'query exists') = '' then do
   call LogCdi "Boot Manager saved settings not found in" bootfile
   return
end

bootline = linein(bootfile)
parse var bootline . timeout
bootline = linein(bootfile)
parse var bootline . . index
bootline = linein(bootfile)
parse var bootline . mode
bootline = linein(bootfile)
parse var bootline . . System0
bootline = linein(bootfile)
parse var bootline . . System1
bootline = linein(bootfile)
parse var bootline . . System2
bootline = linein(bootfile)
parse var bootline . . System3
bootline = linein(bootfile)
parse var bootline . . currentSystem

call stream bootfile, 'c', 'close'

timeout = strip(timeout)
index = strip(index)
mode = strip(mode)
System0 = strip(System0)
System1 = strip(System1)
System2 = strip(System2)
System3 = strip(System3)
currentSystem = strip(currentSystem)

call LogCdi "Restore Boot Manager"
call LogCdi "Timeout:" timeout
call LogCdi "Mode:" mode
call LogCdi "System 0:" system0
call LogCdi "System 1:" system1
call LogCdi "System 2:" system2
call LogCdi "System 3:" system3
call LogCdi "Current System:" currentSystem

address cmd '@setboot /t:' || timeout '/m:' || mode '/x:' || index '/0:' || system0 '/1:' || system1 '/2:' || system2 '/3:' || system3
call LogCdi "return code from setboot" rc

if system0 = 'None' then do
   call LogCdi "Erasing default choice"
   address cmd '@setboot /0:'
   call LogCdi "return code from setboot" rc
end

return

