/* SetSetting.cmd
 *
 * Updates settings with one keyword value pair.
 * arg(1) = keyword
 * arg(2) = value
 *
 * If the value contains a single quote, it is assumed to be an expression.
 * If there is no single quote, then it is assumed to be a constant string.
 *
 * If the first character of keyword is a exclamation point ('!'), then the
 * keyword is deleted.
 *
 * Copyright (C) 2006 Blonde Guy
 * All Rights Reserved
 */

setKeyword = arg(1)
delKeyword = 0
if left(setKeyword, 1) = '!' then do
   delKeyword = 1
end
else if pos("'", arg(2)) > 0 then do
   setValue = arg(2)
end
else do
   setValue = "'" || arg(2) || "'"
end

if pos("=", setKeyword) > 0 then do
   parse arg setKeyword '=' setValue
end

settingsDir = strip(SysIni('User', 'Suntan Special', 'Settings'), 't', d2c(0))
if settingsDir \= 'ERROR:' then do
   settingsFile = settingsDir || '\Settings.txt'
end
else do
   settingsFile = 'Settings.txt'
end

/* call LogCdi "Set Setting" setKeyword "=" setValue "in" settingsFile */

queue 'ReadConfigFile'
queue 'RemoveLine' setKeyword
if delKeyword = 0 then do
   queue 'AppendLine' setKeyword '=' setValue
end
queue 'WriteConfigFile'
queue 'exit'
call EditFile 'nul' settingsFile

return
