/* turn off the archive the desktop at system boot
 * This program is intended to be called from Suntan Special
 *
 * Description
 *   This command sets the computer to NOT archive the desktop at system
 *   boot. There is a companion command, archiveON, that sets the computer to
 *   archive the desktop a system boot.
 *
 * Copyright (C) 2006 Blonde Guy
 * All Rights Reserved
 */

productName = 'Turn off Desktop Archive'
productDate = '2011-11-30 09:54:08'
productCategory = 'Configuration'

call LogCdi "Setting up the computer to NOT Archive the Desktop at System boot"
arcDir = FindBootDrive() || ':\os2\boot'
originalDir = Directory()
arcFile = 'ARCHBASE.$$$'
parse arg appsDir
semFile = appsDir || '\Suntan\archive.$$$'
f1File = arcDir || '\altf1mid.scr'

call Directory arcDir
address cmd '@attrib -r' arcFile

rc = stream(arcFile, 'c', 'open')

rc = charout(arcFile, d2c(0), 208)
if rc <> 0 then do
   call LogCdi "Charout returned" rc "but 0 was expected"
end

rc = stream(arcFile, 'c', 'close')

address cmd '@attrib +r' arcFile

if stream(semFile, 'c', 'query exists')  \= '' then do
   call LogCdi "modifying archive text message"
   archiveOnTime = linein(semFile)
   call stream semFile, 'c', 'close'
   call SysFileDelete semFile
   fi = 0
   do while (lines(f1File))
      fi = fi + 1
      f1Line.fi = linein(f1File)
      if compare(f1Line.fi, '   1) Archive created') > 10 then do
         if pos('Suntan Special', f1Line.fi) = 0 then do
            f1Line.fi = '   1) Archive created by Suntan Special' substr(f1Line.fi, 23)
            call LogCdi f1Line.fi
         end
      end
   end
   call stream f1File, 'c', 'close'
   address cmd '@attrib' f1File '-r'
   call SysFileDelete f1File
   do i=1 to fi
      call lineout f1File, f1Line.i
   end
   call stream f1File, 'c', 'close'
   address cmd '@attrib' f1File '+r'
end

call Directory originalDir
call LogCdi "The system has been set to NOT Archive the Desktop at System boot"
return 0
