/* GetExtra.cmd
 * get extra files from user
 * Paramaters:
 *       testFile    - semicolon delimited file list
 *       keyword     - application keyword
 *       productName - name of product
 *       description - description of files needed
 *
 * Returns: full path of testFile found or empty string to abort
 *
 * Notes: look for testFile appended to current directory
 *        look for testFile in the root of the CD-ROM.
 *        look for keyword\testFile in each directory in sourcePath
 *
 * Copyright (C) 2007 Blonde Guy
 * All Rights Reserved
 */

testFile = arg(1)
keyword = arg(2)
productName = arg(3)
description = arg(4)

if testFile = '' then do
   say GetExtra('config.sys', 'configsys', 'testing', 'Enter some data')
   return
end

originalDir = directory()

testPath = cdglobal('sourceDir') || ';' || cdglobal('setupDir')
numTestDir = 0
numCDDir = 0
do while testPath <> ''
   numTestDir = numTestDir + 1
   parse var testPath testDir.numTestDir ';' testPath
end
cdLetter = cdglobal('cdLetter')
if cdLetter <> '' then do
   numCDDir = numCDDir + 1
   testCD.numCDDir = cdLetter || ':'
end
else do
   driveMap = SysDriveMap('c')
   do while driveMap <> ''
      parse var driveMap letter driveMap
      numCDDir = numCDDir + 1
      testCD.numTestDir = strip(letter)
   end
end
testDir.0 = numTestDir
testCD.0 = numCDDir

cr = d2c(13)
message = "Extra files are needed to install" productName || ".",
          "Enter the location of the needed files, or clear the",
          "entry field to skip the installation." || cr || cr ||,
          "File(s):" testFile || cr ||,
          "Description:" description

numTestFiles = 0
do while testFile <> ''
   numTestFiles = numTestFiles + 1
   parse var testFile testFName.numTestFiles ';' testFile
end
testFName.0 = numTestFiles

do while userFile <> ''
   do testFileNum = 1 to numTestFiles
      do testNum = 1 to numTestDir
         userPath = testDir.testNum || '\' || keyword || '\' || testFName.testFileNum
         if stream(userPath, 'c', 'query exists') <> '' then do
            return userPath
         end
      end
   end

   do testFileNum = 1 to numTestFiles
      do testNum = 1 to numCDDir
         userPath = testCD.testNum || '\' || testFName.testFileNum
         if stream(userPath, 'c', 'query exists') <> '' then do
            return userPath
         end
      end
   end

   userFile = query(productName, testFName.1, message)
   
   if userFile = '' then return userFile
   
   if stream(userFile, 'c', 'query exists') <> '' then do
      if cdglobal('saveWebApps') = 1 then do
         setupDir = cdglobal('setupDir') || '\' || keyword
         address cmd '@copy' userFile setupDir '> nul'
         if rc <> 0 then do
            call LogCdi "Error" rc "copying" userFile "to" setupDir
         end
         else do
            call LogCdi userFile "saved in" setupDir
         end
      end
      return stream(userFile, 'c', 'query exists')
   end
end

return ''
