/* @Echo OFF */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

Class = 'DDIcon'
RepClass = 'WPIcon'

If QueryClassExist(Class) then
 	Call DeRegClass Class
Else
	Say "Class '"Class"' is not registered and doesn't need to be deregistered!"

RepClasses = SysIni('USER', 'PM_Workplace:ReplaceList', RepClass)

If QueryRepClassExist(RepClasses Class) then
	Call UnReplaceClass(RepClasses RepClass Class)
Else
	Say "Class '"RepClass"' is not replaced with '"Class"' and doesn't need to be unreplaced."

Exit

/* ------------------------------------------------------------------------ */

QueryClassExist: Procedure
	Parse Arg Class
	Call SysQueryClassList "ClassList."
	rc = 0
	Do i = 1 to ClassList.0
		If SubWord(ClassList.i, 1, 1) = Class then
			rc = 1
	End
Return rc;

DeRegClass: Procedure
 	Parse Arg Class
	If SysDeRegisterObjectClass(Class) then
	Do
		Say "Class '"Class"' successfully deregistered!"
		rc = 1
	End
	Else
	Do
		Say "Deregistration of class '"Class"' failed!"
		rc = 0
	End
Return rc;

QueryRepClassExist: Procedure
	Parse Arg RepClasses Class
	rc = 0
	If RepClasses \= 'ERROR:' then
	Do
		RepClasses = Space(Translate(RepClasses, ' ', D2C(0)))
		Do i = 1 to Words(RepClasses)
			If Subword(RepClasses, i, 1) = Class then
				rc = 1
		End
	End
Return rc;

UnReplaceClass: Procedure
	Parse Arg RepClasses RepClass Class

	ClassPos = Pos(Class, RepClasses)
	ClassData = Left(RepClasses, ClassPos - 1) || SubStr(RepClasses, ClassPos + Length(Class) + 1)
	If ClassData = D2C(0) then
		rc = SysIni('USER', 'PM_Workplace:ReplaceList', RepClass, 'DELETE:')
	Else
		rc = SysIni('USER', 'PM_Workplace:ReplaceList', RepClass, ClassData)

	If rc = 'ERROR:' then
		Say "Class unreplacement of '"RepClass"' failed!"
	Else
	Do
		Say "Class unreplacement of '"RepClass"' successful!"
		Say "You should reboot OS/2 or restart the WPS to invoke the changes."
	End
Return;

