/* This header file is for -*- c++ -*- 
 *
 * StrBuffer : ꕶ镶ǗNXB
 *	StrBuffer buf;
 *	buf << 'a' << "hogehoge";
 * sƁAq[vɊmۂꂽ̈ɍŏ̂̂
 * ł䂭Bŕ̕A
 *	(const char *)buf
 *	buf.getTop()
 * ȂǂŎQƉ\BA const łAIuWFNgbuf
 * ̏ƋɎBA
 *	char *s=buf.finish();
 * sƁAq[v̕ buf ƓƗɎoƂłB
 *
 * s  strdup ֐Ȃǂɂčꂽʂ q[vƉ
 * ςƂ͂ȂBAStrBuffer ̃CX^X̓q[v
 * SɎ̂ŁA(const char *)ւ̃LXgœ
 * ͒Oɖ߂Ă܂(NULLł͂Ȃ)Bs ͎gpAI
 * free ĂKvB
 *
 * F
 *	try{
 *	    StrBuffer buf;
 *	    for(int i=0 ; i<argc ; i++ ){
 *		buf << argv[i] << ' ';
 *		printf("buf==[%s]\n",(const char *)buf);
 *	    }
 *	    char *s=buf.finish();
 *	    printf("buf==[%s]\nbuf.finish()==[%s]\n",(const char *)buf,s);
 *	    free(s);
 *	}catch( MallocError ){
 *	    fputs("Memory allocation error\n",stderr);
 *	}
 *
 * ̗ł́AŌ printf  ubuf==[]vƕ\B
 *
 * StrBuffer  malloc/realloc ŕǗĂ̂ŁA
 * q[vmێsNꂪB́AO MallocError
 *  catch 邱ƂőΉłBMallocError ̓o[Ȃ
 * NXB
 *
 * sӓ_t
 * StrBuffer  0̒iK(this->isZero()!=0)ł
 *    (const char *)    "\0" (Œ蕶 , const )
 *    getTop  \bh  "\0" (Œ蕶 , const )
 *    finish  \bh  NULL
 *    finish2 \bh  "\0" (q[vFvfree)
 * ԂB
 */

#ifndef STRBUFFER_H
#define STRBUFFER_H

#ifndef MALLOC_ERROR
#define MALLOC_ERROR
class MallocError{ };
#endif

class StrBuffer {
public:
  class MallocError : ::MallocError { };	/* OFmێs */
  class OverFlow { };				/* OFzYG[ */
private:
  int length;
  char *buffer;
  int max;	/*  max  length  max Ȃ̂ŁATCY +1 Kv */
  int inc;
  
  void grow(int x) throw(MallocError);
  static char zero[1];

public:
  bool isZero() const { return length==0; }
  StrBuffer &operator << ( const char *s ) throw(MallocError);
  StrBuffer &operator << ( char c ) throw(MallocError){
    if( length+1 >= max )
      grow(length+1+inc);
    buffer[ length++ ] = c;
    buffer[ length ] = 0;
    return *this;
  }
  StrBuffer &operator << ( int n ) throw(MallocError);
  
  /* ̈(擪AhX{oCg)ǉB*/
  StrBuffer &paste( const void *s , int size ) throw(MallocError);

  /* lEl߂ŏo͂ */
  StrBuffer &putNumber(int num,int width,char fillchar=' ',char sign='\0');

  /* q[vƂĎoB
   * ɃCX^X͋ɂȂB*/
  char *finish() throw();             /* 0 ł NULL ԂB*/
  char *finish2() throw(MallocError); /* 0 ł̓q[v"\0"Ԃ */

  /* nڈȍ~؂̂ĂB*/
  void back(int n) throw() { buffer[ length=n ] = '\0'; }

  /* nڂ𓾂BzTCỸ`FbN͂Ȃ */
  int operator[](int x)   const throw(){ return buffer[x] & 255; }

  /* nڂ𓾂BzTCYI[o[ƗO΂ */
  int at(int x) const throw(OverFlow){ 
    if( x < length )	return buffer[x] & 255;
    else		throw OverFlow();
  }

  int getLength()         const throw(){ return length; }
  const char *getTop()    const throw(){ return buffer; }
  operator const char *() const throw(){ return buffer; }

  StrBuffer() : length(0),buffer(zero),max(0),inc(80){ }
  StrBuffer(int x) : length(0),buffer(zero),max(0),inc(x){ }
  ~StrBuffer();
};
#endif
