/***************************************************************************/
/* F r e e C o d e                                                         */
/*                                                                         */
/* THIS CODE IS FREEWARE AND AS SUCH YOU ARE PERMITTED TO DO WHAT YOU WISH */
/* WITH IT. THESE PROGRAMS ARE PROVIDED AS IS WITHOUT ANY WARRANTY,        */
/* EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO FITNESS FOR ANY      */
/* PARTICULAR PURPOSE.                                                     */
/*                                                                         */
/* However, we would appriciate if you shared any enhancements to us       */
/* Please send them to www.jmast.se/free/ and we will include them in      */
/* future distributions.                                                   */
/*                                                                         */
/***************************************************************************/
/****************************************************************************

     Modul:      JCDLL.CPP, DLL for WarpCenter replacement

     Version:    0.077

     Tid:        001010, 001027, 8h

-------------------------------------------------------------------------
   001010: Started. (MA, 1h)
-------------------------------------------------------------------------
   001026: Created a systemwide hook for MINMAX. (MA, 7h)
-------------------------------------------------------------------------
****************************************************************************/
#define PROG_VERSION   "0.077 - October 27, 2000"

#define INCL_DOS
#define INCL_WIN
#define INCL_GPI

#include <os2.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

#include <stlibpmc.h>
#include <stlibstc.h>

#include "..\jc.h"

/* Shared variables */
char            szDebug[512];
HWND            hwndJC = NULLHANDLE;
HMODULE 	hmodJCDLL = NULLHANDLE;
HAB		habJC = NULLHANDLE;
PVOID  		pvMemJC = NULL;
BOOL		bJCPosition = FALSE;
int		iJCHeight = 0;


/*-----------------------------------------------------------------------------
   JCSetDLL:
-----------------------------------------------------------------------------*/
BOOL EXPENTRY JCSetDLL(HWND hwnd)
     {
     //-----------------------------
     // NULLHANDLE == Release hooks
     //-----------------------------
     if (hwnd == NULLHANDLE)
        {        
        WinReleaseHook(habJC, NULLHANDLE, HK_INPUT, (PFN) JCInputHook, hmodJCDLL);
        WinReleaseHook(habJC, NULLHANDLE, HK_SENDMSG, (PFN) JCSendMsgHook, hmodJCDLL);
        hwndJC = NULLHANDLE;
        DosFreeMem(pvMemJC);
        return(TRUE);
        }

     //-----------------------
     // Hooks are already set
     //-----------------------
     if (hwndJC != NULLHANDLE)
        return(FALSE);

     //-----------
     // Set hooks
     //-----------
     hwndJC = hwnd;
     habJC = WinQueryAnchorBlock(hwndJC);

     if (DosQueryModuleHandle(STR_DLLFILE, &hmodJCDLL))
        return (FALSE);

     if (DosAllocSharedMem(&pvMemJC, STR_DLLSHAREMEM, 4096, PAG_COMMIT | PAG_WRITE ))
        return (FALSE);
     
     WinSetHook(habJC, NULLHANDLE, HK_SENDMSG, (PFN) JCSendMsgHook, hmodJCDLL);
     WinSetHook(habJC, NULLHANDLE, HK_INPUT, (PFN) JCInputHook, hmodJCDLL);

     return (TRUE);
     }


/*-----------------------------------------------------------------------------
   JCSetMaxFrame:
-----------------------------------------------------------------------------*/
void EXPENTRY JCSetMaxFrame(BOOL bPosition, int iHeight)
     {
     // Set position
     bJCPosition = bPosition;

     // Set height
     iJCHeight = iHeight;
     }


/*-----------------------------------------------------------------------------
   JCSendMsgHook:
-----------------------------------------------------------------------------*/
BOOL EXPENTRY JCSendMsgHook(HAB hab, PSMHSTRUCT psmh, BOOL fInterTask)
     {
     static	BOOL bSent = FALSE;
     static     HWND hwndSent;
     PSWP       pswp;


     switch (psmh->msg)
            {
            case WM_MINMAXFRAME:
                 pswp = (PSWP)psmh->mp1;
                 if (pswp->fl & SWP_MAXIMIZE)
                    {
                    if (pswp->hwnd == hwndSent && bSent == TRUE)
                       {
                       bSent = FALSE;
                       return(TRUE);
                       }
                    else
                       {
                       // JC in bottom or top
                       if (bJCPosition == FALSE)
                          {
                          pswp->y = pswp->y + iJCHeight;
                          pswp->cy = pswp->cy - iJCHeight;
                          }
                       else
                          {
                          pswp->cy = pswp->cy - iJCHeight;
                          }
                       bSent = TRUE;
                       hwndSent = pswp->hwnd;
                       }
                    }
                 break;
            }
     return(FALSE);
     }


/*-----------------------------------------------------------------------------
   JCInputHook:
-----------------------------------------------------------------------------*/
BOOL EXPENTRY JCInputHook(HAB hab, PQMSG pQmsg, ULONG fs)
     {
     switch (pQmsg->msg)
            {
            case WM_MINMAXFRAME:
                 DosBeep(200,200);
                 break;
            }
     return(FALSE);
     }
