//----------------------------------------//
//                                        //
//  PDE Desktop Environment (OS/2)        //
//  http://os2progg.by.ru/pde             //
//                                        //
//  PDE Desktop Manager (pdm.exe)         //
//  Old "Logon" unit                      //
//  Copyleft [PDE Team] 2004              //
//                                        //
//----------------------------------------//

Unit LogonUnit;

Interface

Uses
  Classes, Forms, Graphics, ExtCtrls, StdCtrls, Buttons
  , SysUtils
  , pdeNLS;

Type
  TLogonForm = Class (TForm)
    lnImage: TImage;
    Bevel1: TBevel;
    Bevel2: TBevel;
    labName: TLabel;
    labPass: TLabel;
    edName: TEdit;
    edPass: TEdit;
    bOK: TButton;
    bReboot: TButton;
    labBottomMsg: TLabel;
    labTopMsg: TLabel;
    Procedure bRebootOnClick (Sender: TObject);
    Procedure bOKOnClick (Sender: TObject);
    Procedure LogonFormOnShow (Sender: TObject);
    Procedure LogonFormOnCreate (Sender: TObject);
  Private
    {Insert private declarations here}
  Public
    {Insert public declarations here}
  End;

Var
  LogonForm: TLogonForm;

Implementation

Uses
  pdmUnit1;

Procedure TLogonForm.bRebootOnClick (Sender: TObject);
Begin
  //MainForm.ShellExecute('shutdown.exe', '', '', 0, true);
  //APMShutdown('turnoff');
End;

Procedure TLogonForm.bOKOnClick (Sender: TObject);
Begin

if (user = edName.Text) and (pwd = edPass.Text) then
  Begin
  LoggedOn:=True;
  LogOnForm.Close;
  End
else
  Begin
  edName.Text:='';
  edPass.Text:='';
  LogOnForm.ActiveControl:=edName;
  End;

End;

Procedure TLogonForm.LogonFormOnShow (Sender: TObject);
var
  afile: TextFile;
  t: String;
Begin

  If fileexists(extractfilepath(application.exename)+'PDEConf\pswd.cfg') then
    Begin
    Assignfile(afile, extractfilepath(application.exename)+'PDEConf\pswd.cfg');
    Reset(afile);
    Readln(afile, t);
    if t <> '' then
      labTopMsg.Caption := t;
    Readln(afile, t);
    if t <> '' then
      labBottomMsg.Caption := t;
    Readln(afile, t);
    if FileExists(t) then
      lnImage.Bitmap.LoadFromFile(t);
    Readln(afile, user);
    Readln(afile, pwd);
    CloseFile(afile);

    BringToFront;
    End
  else
    begin
    LoggedOn:=True;
    LogOnForm.Close;
    end;

  Caption := pdeLoadNLS('pdmLogonCaption', 'System login');
  labName.Caption := pdeLoadNLS('pdmLogonName', 'Username:');
  labPass.Caption := pdeLoadNLS('pdmLogonPass', 'Password:');
  bOK.Caption := pdeLoadNLS('pdmLogonOK', 'Login');
  bReboot.Caption := pdeLoadNLS('pdmLogonReboot', 'Close system');

End;

Procedure TLogonForm.LogonFormOnCreate (Sender: TObject);
Begin

  BorderIcons := [];
  BorderStyle := bsStealthDlg;
  Position := poScreenCenter;
  ClientWidth := 400;
  ClientHeight := 210;

End;

Initialization
  RegisterClasses ([TLogonForm, TImage, TBevel, TLabel, TEdit, TButton]);
End.
