(*////////////////////////////////////////////////////
//    PDE -  graphical user shell for OS/2 Warp
//    Copyleft stVova, [PDE-Team], 2003
//    http://os2progg.by.ru/pde
//    FileHalf - "Properties" dialog
/////////////////////////////////////////////////////*)

Unit PropUnit;

Interface

Uses
  Classes, Forms, Graphics, ExtCtrls, Buttons, StdCtrls, SysUtils
  , TabCtrls, PMWin, pdeNLS, os2def;

Type
  TPropForm = Class (TForm)
    btnOK: TButton;
    btnCancel: TButton;
    LCaption: TLabel;
    LName: TLabel;
    LDir: TLabel;
    LSize: TLabel;
    LCreateDate: TLabel;
    LChDate: TLabel;
    LType: TLabel;
    LProg: TLabel;
    chSystem: TCheckBox;
    chReadOnly: TCheckBox;
    chArchiv: TCheckBox;
    chHidden: TCheckBox;
    Shape1: TShape;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Bevel3: TBevel;
    pBox: TPaintBox;
    Procedure pBoxOnPaint (Sender: TObject; Const rec: TRect);
    Procedure PropFormOnShow (Sender: TObject);
    Procedure Shape1OnDragDrop (Sender: TObject; Source: TObject; X: LongInt;
      Y: LongInt);
    Procedure LSizeOnDblClick (Sender: TObject);
    Procedure LTypeOnClick (Sender: TObject);
    Procedure PropFormOnCreate (Sender: TObject);
    Procedure PropFormOnTranslateShortCut (Sender: TObject; KeyCode: TKeyCode;
      Var ReceiveR: TForm);
    Procedure CancelOnClick (Sender: TObject);
    Procedure OkOnClick (Sender: TObject);
  Private
    {Insert private declarations here}
  Public
    {Insert public declarations here}
  End;

Var
  PropForm: TPropForm;
  bmp: LongWord;

Implementation

Uses
  Unit1;

Procedure TPropForm.pBoxOnPaint (Sender: TObject; Const rec: TRect);
var
  ps: hPS;
Begin
  {render image in "bmp" pointer}
  pBox.canvas.fillrect(pBox.Canvas.ClipRect, PropForm.Color);
  ps := WinGetPS(pBox.Handle);
  WinDrawPointer( ps, 0, 0, bmp, 0);
  WinReleasePS(ps);
End;

Procedure TPropForm.PropFormOnShow (Sender: TObject);
Begin
  Shape1.Brush.Color := MainForm.Color;
  LName.Color := MainForm.Color;
  LDir.Color := MainForm.Color;
  LSize.Color := MainForm.Color;
  LChDate.Color := MainForm.Color;
  LProg.Color := MainForm.Color;
  chSystem.Color := MainForm.Color;
  chHidden.Color := MainForm.Color;
  chReadOnly.Color := MainForm.Color;
  chArchiv.Color := MainForm.Color;
  btnOk.Color := MainForm.Color;
  btnCancel.Color := MainForm.Color;
  bmp := MainForm.vFiles.Items[MainForm.vFiles.ItemIndex].Icon;
End;

Procedure TPropForm.Shape1OnDragDrop (Sender: TObject; Source: TObject;
  X: LongInt; Y: LongInt);
Begin

End;

Procedure TPropForm.LSizeOnDblClick (Sender: TObject);
Begin

  LSize.Caption:= pdeLoadNLS('dlgPropertiesSize', ':')+' '
    +MainForm.CalcTreeSizeS(LDir.Caption + LName.Caption);

End;

Procedure TPropForm.LTypeOnClick (Sender: TObject);
Begin

End;

Procedure TPropForm.PropFormOnCreate (Sender: TObject);
Begin
  BorderStyle:=bsStealthDlg;
  caption := pdeLoadNLS('popupmenuProperies', '⢠');
  //Notes.Pages.Pages[0].Caption := pdeLoadNLS('dlgPropertiesFile', '');
  //Notes.Pages.Pages[0].Hint := pdeLoadNLS('dlgPropertiesNotepage1', '⢠ 䠩');
  //Notes.Pages.Pages[1].Hint := pdeLoadNLS('dlgPropertiesNotepage2', '. ਡ');
  //Notes.Refresh;
  LCaption.Caption := pdeLoadNLS('dlgPropertiesFile', '');
  chSystem.Caption := pdeLoadNLS('dlgPropertiesSystem', '⥬');
  chHidden.Caption := pdeLoadNLS('dlgPropertiesHidden', '');
  chReadonly.Caption := pdeLoadNLS('dlgPropertiesReadonly', '쪮 ⥭');
  chArchiv.Caption := pdeLoadNLS('dlgPropertiesArchive', '娢');
  btnOk.Caption := pdeLoadNLS('dlgOkButton', '');
  btnCancel.Caption := pdeLoadNLS('dlgCancelButton', '⬥');

End;

Procedure TPropForm.PropFormOnTranslateShortCut (Sender: TObject;
  KeyCode: TKeyCode; Var ReceiveR: TForm);
Begin
if KeyCode=kbEsc then
  CancelOnClick (Sender);
End;

Procedure TPropForm.CancelOnClick (Sender: TObject);
Begin
  PropForm.Close;
  WinSetActiveWindow(HWND_DESKTOP, MainForm.Handle);
End;

Procedure TPropForm.OkOnClick (Sender: TObject);
var
  attr: integer;
Begin
attr:=0;
if chSystem.Checked then
  attr:=attr or faSysFile;
if chHidden.Checked then
  attr:=attr or faHidden;
if chReadOnly.Checked then
  attr:=attr or faReadOnly;
if chArchiv.Checked then
  attr:=attr or faArchive;

FileSetAttr(LDir.Caption+LName.Caption, attr);
PropForm.Close;
WinSetActiveWindow(HWND_DESKTOP, MainForm.Handle);
End;

Uses Unit1;

Initialization
  RegisterClasses ([TPropForm, TLabel, TCheckBox,
    TButton, TShape, TBevel, TPaintBox]);
End.
