(*////////////////////////////////////////////////////
//    PDE -  graphic user shell for OS/2 Warp
//    Copyleft stVova, [PDE-Team], 2003-2004
//    http://os2progg.by.ru/pde
/////////////////////////////////////////////////////*)
//----------------------------------------------------
//File-manager FileHalf, main module
//Last updated: 30/05/04
//----------------------------------------------------
//ᬮ 䠩 TODO  Buglist,    ᫨ 
// 諨.   䠩 ᫥,  諮  㯨,  
// 㤠  :-)
//த- .                                 stVova
//----------------------------------------------------

Unit Unit1;

Interface

Uses
  Classes, Forms, Graphics, StdCtrls, SysUtils, Buttons, PMWin
  , BSEDos, ExtCtrls, os2def, dialogs, strings, FileCtrl
  , DirOutLn, PMStdDlg, BmpList, Hints, PMWP
  , CustomFileControls, Dos, ComCtrls, BseErr //Sibyl units
  , ListView2I, XplorBtn //Sibyl units, changed
  , PropUnit, PropUnit2, PropUnit3, fhUnit3, TypesHelperUnit //this projects' forms units
  , pdeDlgsDLL, pdeDlgs, PdeNLS, pdeNewLink; //PDE library units

//Name of the shared memory object
Const
    SharedMemName='DragDrop_ItemsInfo';
    Max_Assoc = 100;

//Drag source identification
Const
    DragSourceId='File or Folder to Copy';

Type
  TMainForm = Class (TForm)
    vFiles: TListView;
    mVCasePasteInCurrent: TMenuItem;
    bGo: TButton;
    MenuItem14: TMenuItem;
    mEditAssoc2: TMenuItem;
    ToolBar3: TToolbar;
    edPath: TEdit;
    LoadListProgress: TProgressBar;
    ToolBar1: TStatusBar;
    mBookmarksClear: TMenuItem;
    MenuItem17: TMenuItem;
    mAddBookmark: TMenuItem;
    MenuItem18: TMenuItem;
    mQuickRunClear: TMenuItem;
    mQuickRunAdd: TMenuItem;
    mShowHelp: TMenuItem;
    MenuItem22: TMenuItem;
    mAbout: TMenuItem;
    mHelp: TMenuItem;
    MenuItem3: TMenuItem;
    MenuItem8: TMenuItem;
    mIPF2: TMenuItem;
    mIPF: TMenuItem;
    mVCase: TMenuItem;
    mVCaseShow: TMenuItem;
    mVCaseAddAll: TMenuItem;
    mVCaseAdd: TMenuItem;
    l_case: TListBox;
    mVCaseClear: TMenuItem;
    mFlow: TMenuItem;
    mAsText: TMenuItem;
    mDuble: TMenuItem;
    mConvert10: TMenuItem;
    mConvertImage: TMenuItem;
    mConvert1: TMenuItem;
    mConvert2: TMenuItem;
    mConvert3: TMenuItem;
    mConvert4: TMenuItem;
    mConvert5: TMenuItem;
    mConvert6: TMenuItem;
    mConvert7: TMenuItem;
    mConvert8: TMenuItem;
    mConvert9: TMenuItem;
    InfoScroll: TScrollBox;
    InfoImage: TImage;
    Bevel5: TBevel;
    PopupPreview: TPopupMenu;
    mSavePreview: TMenuItem;
    Bevel4: TBevel;
    Bevel3: TBevel;
    InfoLabel: TMemo;
    PanImage: TImage;
    mGotoHome: TMenuItem;
    mOpenWith: TMenuItem;
    mShowPreview2: TMenuItem;
    mZoomPlus: TMenuItem;
    mZoomMinus: TMenuItem;
    MenuItem16: TMenuItem;
    mGotoDisks: TMenuItem;
    MenuItem11: TMenuItem;
    mShowHidden: TMenuItem;
    MenuItem12: TMenuItem;
    mNewWindow: TMenuItem;
    MenuItem10: TMenuItem;
    Dirs: TCustomDirectoryListBox;
    Drives: TCustomDriveComboBox;
    mPresent: TMenuItem;
    mIcons: TMenuItem;
    mTile: TMenuItem;
    mSmallIcons: TMenuItem;
    mArchive: TMenuItem;
    mFilter: TMenuItem;
    MenuItem7: TMenuItem;
    mViewFile: TMenuItem;
    mBookmarks: TMenuItem;
    mHTM2: TMenuItem;
    mHTM: TMenuItem;
    MenuItem6: TMenuItem;
    mFavor: TMenuItem;
    mAddFavor: TMenuItem;
    mPrevDrive: TMenuItem;
    MenuItem4: TMenuItem;
    mConfigPDE: TMenuItem;
    mNextDrive: TMenuItem;
    mEditAssoc: TMenuItem;
    MenuItem2: TMenuItem;
    bNewWindow: TExplorerButton;
    bRefresh: TExplorerButton;
    Bevel1: TBevel;
    Bevel2: TBevel;
    mRefresh: TMenuItem;
    MenuItem1: TMenuItem;
    bRename: TExplorerButton;
    bFind: TExplorerButton;
    bNew: TExplorerButton;
    mStatus: TMenuItem;
    mInfoPanel: TMenuItem;
    MenuItem15: TMenuItem;
    mQuickRun: TMenuItem;
    mButtons: TMenuItem;
    Image1: TImage;
    menuFile: TPopupMenu;
    mOpen: TMenuItem;
    mFind: TMenuItem;
    MenuItem5: TMenuItem;
    mCopy: TMenuItem;
    mMove: TMenuItem;
    mDel: TMenuItem;
    MenuItem9: TMenuItem;
    mRename: TMenuItem;
    mShortcut: TMenuItem;
    mProperies: TMenuItem;
    MenuItem19: TMenuItem;
    mFolder: TMenuItem;
    mText: TMenuItem;
    mOpen2: TMenuItem;
    mFind2: TMenuItem;
    MenuItem13: TMenuItem;
    mCopy2: TMenuItem;
    mMove2: TMenuItem;
    mDel2: TMenuItem;
    MenuItem21: TMenuItem;
    mShortcut2: TMenuItem;
    mRename2: TMenuItem;
    MenuItem24: TMenuItem;
    mCreateNew2: TMenuItem;
    mFolder2: TMenuItem;
    mText2: TMenuItem;
    bProperties: TExplorerButton;
    mProperties2: TMenuItem;
    mCreateNew: TMenuItem;
    ToolBar2: TToolbar;
    MainMenu1: TMainMenu;
    InfoPanel: TPanel;
    mView: TMenuItem;
    mGoto: TMenuItem;
    bBack: TExplorerButton;
    bForward: TExplorerButton;
    mGoBack: TMenuItem;
    mGoForv: TMenuItem;
    bMove: TExplorerButton;
    bCopy: TExplorerButton;
    bDelete: TExplorerButton;
    mGoUp: TMenuItem;
    mEdit: TMenuItem;
    mFile: TMenuItem;
    bUp: TExplorerButton;
    Procedure mVCasePasteInCurrentOnClick (Sender: TObject);
    Procedure edPathOnEnter (Sender: TObject);
    Procedure mQuickRunClearOnClick (Sender: TObject);
    Procedure mQuickRunAddOnClick (Sender: TObject);
    Procedure mBookmarksClearOnClick (Sender: TObject);
    Procedure mIPFOnClick (Sender: TObject);
    Procedure mVCaseAddAllOnClick (Sender: TObject);
    Procedure mVCaseAddOnClick (Sender: TObject);
    Procedure mVCaseClearOnClick (Sender: TObject);
    Procedure mVCaseShowOnClick (Sender: TObject);
    Procedure mAsTextOnClick (Sender: TObject);
    Procedure mFlowOnClick (Sender: TObject);
    Procedure mDubleOnClick (Sender: TObject);
    Procedure mConvertToOnClick (Sender: TObject);
    Procedure mSavePreviewOnClick (Sender: TObject);
    Procedure mShowPreview2OnClick (Sender: TObject);
    Procedure mGotoHomeOnClick (Sender: TObject);
    Procedure mZoomMinusOnClick (Sender: TObject);
    Procedure mZoomPlusOnClick (Sender: TObject);
    Procedure mShowPreviewOnClick (Sender: TObject);
    Procedure mShowHiddenOnClick (Sender: TObject);
    Procedure DirsOnClick (Sender: TObject);
    Procedure mShowHelpOnClick (Sender: TObject);
    Procedure MainFormOnCloseQuery (Sender: TObject; Var CanClose: Boolean);
    Procedure MainFormOnSetupShow (Sender: TObject);
    Procedure mTileOnClick (Sender: TObject);
    Procedure mIconsOnClick (Sender: TObject);
    Procedure mDeskTop2OnClick (Sender: TObject);
    Procedure DirsOnItemFocus (Sender: TObject; Index: LongInt);
    Procedure vFilesOnMouseUp (Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X: LongInt; Y: LongInt);
    Procedure vFilesOnMouseDown (Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X: LongInt; Y: LongInt);
    Procedure mArchiveOnClick (Sender: TObject);
    Procedure mFilterOnClick (Sender: TObject);
    Procedure mShortcut2OnClick (Sender: TObject);
    Procedure mHTMOnClick (Sender: TObject);
    Procedure mText2OnClick (Sender: TObject);
    Procedure MainFormOnTranslateShortCut (Sender: TObject; KeyCode: TKeyCode; Var ReceiveR: TForm);
    Procedure vFilesOnStartDrag (Sender: TObject; Var DragData: TDragDropData);
    Procedure vFilesOnEndDrag (Sender: TObject; target: TObject; X: LongInt; Y: LongInt);
    Procedure vFilesOnDragOver (Sender: TObject; Source: TObject; X: LongInt; Y: LongInt; State: TDragState; Var Accept: Boolean);
    Procedure vFilesOnDragDrop (Sender: TObject; Source: TObject; X: LongInt; Y: LongInt);
    Procedure vFilesOnCanDrag (Sender: TObject; X: LongInt; Y: LongInt; Var Accept: Boolean);
    Procedure mAddFavorOnClick (Sender: TObject);
    Procedure mGotoDisksOnClick (Sender: TObject);
    Procedure mDiskA2OnClick (Sender: TObject);
    Procedure mConfigPDEOnClick (Sender: TObject);
    Procedure mPrevDriveOnClick (Sender: TObject);
    Procedure mNextDriveOnClick (Sender: TObject);
    Procedure bBackOnClick (Sender: TObject);
    Procedure bForwardOnClick (Sender: TObject);
    Procedure Timer1OnTimer (Sender: TObject);
    Procedure mEditAssocOnClick (Sender: TObject);
    Procedure bNewWindowOnClick (Sender: TObject);
    Procedure mAboutOnClick (Sender: TObject);
    Procedure mSmallIconsOnClick (Sender: TObject);
    Procedure mInfoPanelOnClick (Sender: TObject);
    Procedure mStatusOnClick (Sender: TObject);
    Procedure mButtonsOnClick (Sender: TObject);
    Procedure mOpenAsTextOnClick (Sender: TObject);
    Procedure bPropertiesOnClick (Sender: TObject);
    Procedure bRefreshOnClick (Sender: TObject);
    Procedure bNewOnClick (Sender: TObject);
    Procedure bFindOnClick (Sender: TObject);
    Procedure bRenameOnClick (Sender: TObject);
    Procedure bDeleteOnClick (Sender: TObject);
    Procedure bMoveOnClick (Sender: TObject);
    Procedure bCopyOnClick (Sender: TObject);
    Procedure DirsOnItemSelect (Sender: TObject; Index: LongInt);
    Procedure DrivesOnChange (Sender: TObject);
    Procedure MainFormOnDestroy (Sender: TObject);
    Procedure mOpenOnClick (Sender: TObject);
    Procedure vFilesOnItemSelect (Sender: TObject; Index: LongInt);
    Procedure bUpOnClick (Sender: TObject);
    Procedure MainFormOnResize (Sender: TObject);
    Procedure MainFormOnCreate (Sender: TObject);
    Procedure bGoOnClick (Sender: TObject);
    Procedure Form1OnShow (Sender: TObject);

    Procedure QuickMenuClick(Sender: TObject);
    Procedure BookMarkClick(Sender: TObject);
    Procedure OpenWithMenuClick(Sender: TObject);
  Private
    {Insert private declarations here}
    Procedure FormShowHint(Var HintStr:String;Var CanShow:Boolean;Var HintInfo:THintInfo);
  Public
    {Insert public declarations here}
    function LoadList: integer;
    function Resolve_Id_diz: integer;
    function Resolve_One_PreView: integer;
    function ShowStatus: integer;
    function ShellExecute(fname, fdir, fparam: string; shortcut: boolean): Boolean;
    function _ShellExecute(fname, fdir, fparam: string; shortcut: boolean; fg, pgmCntr, rel: ULong): Boolean;
    function GoInto: integer;
    function ResolveAssociation(fname: string): integer;
    function FileHalfCfg: Integer;
    function CalcTreeSizeA(tpath: String; var files, folders: LongInt): ULong;
    function CalcTreeSize(tpath: String): ULong;
    function CalcTreeSizeS(tpath: String): String;
    function FStat: Integer;

    function ObjMove(source, dest: cstring): integer;
    function ObjDel(source: string): integer;
    function ObjRename(source, dest: string): integer;
    function CorectCaption(corstr: String): String;
    function DeCC(corstr: String): String;

    function LoadToPreview: Integer;
    function Check_L_Case: Integer;
    procedure SetButtonsTextNPos(col: Integer;);
  End;

  TAssociations=record
    flt: string;
    pgm: string;
    bmp: string;
  End;

  TDragDropItem=Record
                        Len:Byte;         //length of string
                        Data:Array[0..0] Of Char;
                  End;

    PDragDropInfo=^TDragDropInfo;
    TDragDropInfo=Record
                        Count:LongWord;   //Count of elements
                        Items:Array[0..0] Of TDragDropItem;
                  End;

  TCMDThread = class(TThread)
  Private
    FSource: CString;
    FDest:   CString;
    FOperation: CString;
  Protected
    procedure Execute; override;
  Public
    constructor Create(Source, Dest, Operation: String);
  End;

  TPreviewThread = class(TThread)
  private
  protected
    procedure Execute; override;
  public
  End;

Var
  MainForm: TMainForm;
  findUtil, txtUtil, archiveUtil, loc_dll: String;
  tmp: TIcon;
  _tmp: TIcon;
  tmp2: TPicture;
  prevDir, nextDir, prevDir2, nextDir2: String;
  sr : TSearchRec;
  path, filter: string; //⥪騩 
  i: integer;
  {file-types associations}
  assoc: array[1..Max_Assoc] of TAssociations;
  aIc: array[1..Max_Assoc] of LongWord; //TIcon;
  assocCount: Integer;
  count: integer;
  Year, Month, Day: Word;
  Days: array[1..7] of String; //= ('ᥭ', '쭨', '୨', '।', '⢥', '⭨', '㡮');
  quickmitem: TMenuItem;
  bookitem: TMenuItem;
  openwithitem: TMenuItem;
  iconsize: Integer;
  hptr: HPointer;

  id_diz_file: String;
  resolved_preview: Boolean;
  this_is_this: String;

  prList, prList2: TStringList;
  l_case2: TStringList;
  l_case_dest: String;
  prevNode: LongInt;

  Theme: String = 'Default_theme'; //theme and icons-theme
  ITheme: String = 'Default_theme';


Function DiskFreeKb(Drive: Byte): LongInt;
Function DiskSizeKb(Drive: Byte): LongInt;
Procedure OpComodo(op, op_text: String);
function ListDirectory(base, path: String): Integer;
function SysDirSetCurrent(Path: String): Longint;

Implementation

//--set current directory--
function SysDirSetCurrent(Path: String): Longint;
begin

  Result := DosSetDefaultDisk(ord(LowerCase(Path)[1])-96);
  Result := DosSetCurrentDir(Path);

end; {SysDirSetCurrent}

//----
function ListDirectory(base, path: String): Integer; // [base], [path]\
var
  sr: TSearchRec;
  attr, rez: Integer;
Begin

Application.ProcessMessages;

attr := faReadOnly Or faSysFile Or faArchive or faDirectory or faHidden;

  rez := FindFirst(base + '\' + path+'*', attr, sr);
  if rez = 0 then
  if (sr.attr and faDirectory)=0 then //file
      begin
      l_case2.Add('f ' + path + sr.name);
      end;

  while rez=0 do
    begin
    rez:=FindNext(sr);
    if rez<>0 then break;
    if (sr.attr and faDirectory)=0 then //file
      begin
      l_case2.Add('f ' + path + sr.name);
      end;

    end;

FindClose(sr);

//------//

attr := faReadOnly Or faSysFile Or faArchive or faDirectory or faHidden;

  rez := FindFirst(base +'\' + path+'*', attr, sr);
  if rez = 0 then
  if (sr.attr and faDirectory)=0 then //file
      begin
      ;
      end
      else
      begin
      if (sr.name <> '..') and (sr.name <> '.') then
        begin
          l_case2.Add('d ' + path + sr.name);

          ListDirectory(base, path + sr.name + '\');
        end;
      end;

  while rez=0 do
    begin
    rez:=FindNext(sr);
    if rez<>0 then break;
    if (sr.attr and faDirectory)=0 then //file
      begin
      ;
      end
      else
      begin
      if (sr.name <> '..') and (sr.name <> '.') then
        begin
        l_case2.Add('d ' + path + sr.name);

        ListDirectory(base, path + sr.name + '\');
        end;
      end;

    end;

FindClose(sr);

Result := 0;

End;

{==========================================}

Procedure OpComodo(op, op_text: String);
var
  li: LongInt;
  base, ltmp: String;
  afile: TextFile;
  sr: TSearchRec;
Begin

  {file operations using "comodo.exe"}
  if MainForm.l_case.Items.Count = 0 then exit;

  l_case2.Clear;

  for li := 0 to MainForm.l_case.Items.Count - 1 do
    begin
    ltmp := MainForm.l_case.Items[li];

    if FindFirst(ltmp+'\*.*', faAnyFile, sr) <> 0 then //file
      begin
      l_case2.Add('f ' + ltmp);
      FindClose(sr);
      end
      else
      begin
      FindClose(sr);
      base := ltmp;
      l_case2.Add('b ' + base);
      ListDirectory(base, '');
      end;

    end;

  MainForm.l_case.Clear;

  AssignFile(afile, GetEnv('TEMP')+'\~fhcomodo.txt');
  Rewrite(afile);

  Writeln(afile, IntToStr(l_case2.count));
  Writeln(afile, l_case_dest);
  for li := 0 to l_case2.count - 1 do
    Writeln(afile, l_case2.strings[li]);

  CloseFile(afile);

  MainForm.ShellExecute(ExtractFilePath(Application.ExeName)+'Utils\comodo.exe'
    , '', op+' '+pdeLoadCfgStrD('general.cfg', 'overwritefiles', '0')+' '+op_text, true);

  MainForm.LoadList;

End;

Function DiskFreeKb(Drive: Byte): LongInt;
Var
  Buffer: FSALLOCATE;
Begin

  If DosQueryFSInfo(Drive, FSIL_ALLOC, Buffer, SizeOf(Buffer)) = NO_ERROR Then
    With Buffer Do Result := Round((cUnitAvail / 1024) * cSectorUnit * cbSector)
  Else Result := -1;

End;

Function DiskSizeKb(Drive: Byte): LongInt;
Var
  Buffer: FSALLOCATE;
Begin
  If DosQueryFSInfo(Drive, FSIL_ALLOC, Buffer, SizeOf(Buffer)) = NO_ERROR Then
    With Buffer Do Result := Round((cUnit / 1024) * cSectorUnit * cbSector)
  Else Result := -1;
End;

//------------------------------------------

Procedure TMainForm.edPathOnEnter (Sender: TObject);
Begin

 bGo.Default := True;
 {when we press <ENTER> key - it will make click on "bGo"}

End;

procedure TMainForm.SetButtonsTextNPos(col: Integer;);
var
  t, k: Integer;
Begin

//set toolbar's buttons position
bBack.Align := alNone;
bForward.Align := alNone;
bUp.Align := alNone;
bRefresh.Align := alNone;
bCopy.Align := alNone;
bMove.Align := alNone;
bDelete.Align := alNone;
bRename.Align := alNone;
bFind.Align := alNone;
bNew.Align := alNone;
bProperties.Align := alNone;
bNewWindow.Align := alNone;
Bevel1.Align := alNone;
Bevel2.Align := alNone;

if pdeLoadThemeIntD(Theme, 'ShowButtonsText' , 0) = 0 then
begin
bBack.Caption := '';
bBack.SetWindowPos(2, 2, col, col);
bForward.Caption := '';
bForward.SetWindowPos(col+4, 2, col, col);
bUp.Caption := '';
bUp.SetWindowPos(2*col+6, 2, col, col);
bRefresh.Caption := '';
bRefresh.SetWindowPos(3*col+8, 2, col, col);
bCopy.Caption := '';
bCopy.SetWindowPos(4*col+16, 2, col, col);
bMove.Caption := '';
bMove.SetWindowPos(5*col+18, 2, col, col);
bDelete.Caption := '';
bDelete.SetWindowPos(6*col+20, 2, col, col);
bRename.Caption := '';
bRename.SetWindowPos(7*col+22, 2, col, col);
bFind.Caption := '';
bFind.SetWindowPos(8*col+30, 2, col, col);
bNew.Caption := '';
bNew.SetWindowPos(9*col+32, 2, col, col);
bProperties.Caption := '';
bProperties.SetWindowPos(10*col+34, 2, col, col);
bNewWindow.Caption := '';
bNewWindow.SetWindowPos(11*col+36, 2, col, col);

Bevel1.Left := 4*col+10;
Bevel2.Left := 8*col+24;
end
else  //--show buttons' captions
begin
k := 7;
bBack.Caption := pdeLoadNLS('BackwardButton', '');
t := Length(bBack.Caption)*k;
bBack.SetWindowPos(2, 2, col+t, col);
bForward.Caption := pdeLoadNLS('ForwardButton', '।');
t := Length(bForward.Caption)*k;
bForward.SetWindowPos(bBack.Width+4, 2, col+t, col);
bUp.Caption := pdeLoadNLS('UpDirButton', ' ஢ ');
t := Length(bUp.Caption)*k;
bUp.SetWindowPos(bForward.Left+bForward.Width+2, 2, col+t, col);
bRefresh.Caption := pdeLoadNLS('RefreshButton', '');
t := Length(bRefresh.Caption)*k;
bRefresh.SetWindowPos(bUp.Left+bUp.Width+2, 2, col+t, col);
bCopy.Caption := pdeLoadNLS('CopyButton', '஢');
t := Length(bCopy.Caption)*k;
bCopy.SetWindowPos(bRefresh.Left+bRefresh.Width+8, 2, col+t, col);
bMove.Caption := pdeLoadNLS('MoveButton', '६');
t := Length(bMove.Caption)*k;
bMove.SetWindowPos(bCopy.Left+bCopy.Width+2, 2, col+t, col);
bDelete.Caption := pdeLoadNLS('DeleteButton', '');
t := Length(bDelete.Caption)*k;
bDelete.SetWindowPos(bMove.Left+bMove.Width+2, 2, col+t, col);
bRename.Caption := pdeLoadNLS('RenameButton', '२');
t := Length(bRename.Caption)*k;
bRename.SetWindowPos(bDelete.Left+bDelete.Width+2, 2, col+t, col);
bFind.Caption := pdeLoadNLS('FindButton', '');
t := Length(bFind.Caption)*k;
bFind.SetWindowPos(bRename.Left+bRename.Width+8, 2, col+t, col);
bNew.Caption :=  pdeLoadNLS('NewFolderButton', ' ');
t := Length(bNew.Caption)*k;
bNew.SetWindowPos(bFind.Left+bFind.Width+2, 2, col+t, col);
bProperties.Caption := pdeLoadNLS('PropertiesButton', '⢠');
t := Length(bProperties.Caption)*k;
bProperties.SetWindowPos(bNew.Left+bNew.Width+2, 2, col+t, col);
bNewWindow.Caption := pdeLoadNLS('NewWindowButton', ' ');
t := Length(bNewWindow.Caption)*k;
bNewWindow.SetWindowPos(bProperties.Left+bProperties.Width+2, 2, col+t, col);

Bevel1.Left := bRefresh.Left+bRefresh.Width+2;
Bevel2.Left := bRename.Left+bRename.Width+2;
end;

Bevel1.Height := col;
Bevel1.Bottom := 2;
Bevel2.Height := col;
Bevel2.Bottom := 2;

bBack.Align := alFixedLeftBottom;
bForward.Align := alFixedLeftBottom;
bUp.Align := alFixedLeftBottom;
bRefresh.Align := alFixedLeftBottom;
bCopy.Align := alFixedLeftBottom;
bMove.Align := alFixedLeftBottom;
bDelete.Align := alFixedLeftBottom;
bRename.Align := alFixedLeftBottom;
bFind.Align := alFixedLeftBottom;
bNew.Align := alFixedLeftBottom;
bProperties.Align := alFixedLeftBottom;
bNewWindow.Align := alFixedLeftBottom;
Bevel1.Align := alFixedLeftBottom;
Bevel2.Align := alFixedLeftBottom;

End;

//--Quick run-------------------------------
Procedure TMainForm.mQuickRunClearOnClick (Sender: TObject);
var
  afile: TextFile;
Begin

  //clear quick run
  Assignfile(afile, extractfilepath(application.exename)+'\PDEConf\quickrun.cfg');
  Rewrite(afile);
  Closefile(afile);

  While mQuickRun.Count > 3 do
    mQuickRun.Items[3].Free;

End;

Procedure TMainForm.mQuickRunAddOnClick (Sender: TObject);
var
  cptn, fname: String;
  afile: TextFile;
Begin

  //add item to Quick run list
  if vFiles.ItemCount = 0 then exit;

  cptn := pdedlgsdll.pdePromptDialog(mQuickRunAdd.Caption, mQuickRun.Caption
    , vFiles.Items[vFiles.ItemIndex].RealFileName);

  if cptn = '' then exit;

  fname := path + vFiles.Items[vFiles.ItemIndex].RealFileName;

  if not FileExists(extractfilepath(application.exename)+'\PDEConf\quickrun.cfg') then
    begin
    Assignfile(afile, extractfilepath(application.exename)+'\PDEConf\quickrun.cfg');
    Rewrite(afile);
    Closefile(afile);
    end;

  Assignfile(afile, extractfilepath(application.exename)+'\PDEConf\quickrun.cfg');
  Append(afile);
  Writeln(afile, cptn);
  Writeln(afile, fname);
  Closefile(afile);

  quickmitem:=TMenuItem.Create(self);
  quickmitem.Caption:=cptn;
  quickmitem.hint:=fname;
  quickmitem.onclick:=QuickMenuClick;
  mQuickRun.add(quickmitem);

End;
//--end Quick run---------------------------

function TMainForm.Check_L_Case: Integer;
var
  ii: LongInt;
  lctmp: String;
Begin

  {check all files/folders in current view are in "Case"}
  if vFiles.ItemCount = 0 then exit;

  for ii := 0 to vFiles.ItemCount - 1 do
    begin
    lctmp := path + vFiles.Items[ii].RealFileName;
    if l_case.Items.IndexOf(lctmp) <> -1 then
      vFiles.Items[ii].InCase := True;
    end;

Result := 0;

End;

//--work with "Case"-----
Procedure TMainForm.mVCaseAddAllOnClick (Sender: TObject);
var
  ii: LongInt;
Begin

  {add all from files list}
  if vFiles.ItemCount > 0 then
    for ii := 0 to vFiles.ItemCount - 1 do
    begin
    vFiles.Items[ii].InCase := True;

    if l_case.Items.IndexOf(path+vFiles.Items[ii].RealFileName) = -1 then
      l_case.Items.Add(path+vFiles.Items[ii].RealFileName);

    end;

  LoadList;

End;

Procedure TMainForm.mVCaseAddOnClick (Sender: TObject);
Begin

  {add selected in files list file/folder, or remove it}
  if vFiles.ItemCount > 0 then
    begin
    vFiles.Items[vFiles.ItemIndex].InCase := not (vFiles.Items[vFiles.ItemIndex].InCase);

    if vFiles.Items[vFiles.ItemIndex].InCase then
      l_case.Items.Add(path+vFiles.Items[vFiles.ItemIndex].RealFileName)
      else
      l_case.Items.Delete(l_case.Items.IndexOf(path+vFiles.Items[vFiles.ItemIndex].RealFileName));
    end;

End;

Procedure TMainForm.mVCasePasteInCurrentOnClick (Sender: TObject);
var
  ii: Integer;
Begin

  { paste (copy) "Case" content int ocurrent folder }
  if l_case.Items.Count = 0 then exit;

  if vFiles.ItemCount > 0 then
    for ii := 0 to vFiles.ItemCount - 1 do
      if vFiles.Items[ii].InCase then
        begin
        pdeMessageBoxC(''+chr(13)+chr(10)+
          pdeLoadNLS('dlgErrorUnknown', '⭠ 訡'),
          pdeLoadNLS('dlgErrorUnknown', '⭠ 訡'), bMove.Glyph);
        exit;
        end;

  l_case_dest := Path;
  OpComodo('0', pdeLoadNLS('dlgCopying', '஢'));

End;

Procedure TMainForm.mVCaseClearOnClick (Sender: TObject);
Begin

  {clear all records in "Case"}
  l_Case.Clear;
  mVCaseShow.Checked := False;
  l_Case.Visible := False;
  LoadList;

End;

Procedure TMainForm.mVCaseShowOnClick (Sender: TObject);
Begin

  mVCaseShow.Checked := not (mVCaseShow.Checked);
  l_Case.Visible := mVCaseShow.Checked;

End;

//------------------------------------------

Procedure TMainForm.mConvertToOnClick (Sender: TObject);
var
  src, dest: String;
  wfp: Integer;
Begin

  {convert image from one type to another}

  if vFiles.ItemCount = 0 then exit;

  src := path+vFiles.Items[vFiles.ItemIndex].RealFileName;
  dest := path+vFiles.Items[vFiles.ItemIndex].RealFileName;
  Delete(dest, pos('.', dest)-1, length(dest)-pos('.', dest));
  dest := dest + '.' + TMenuItem(Sender).Caption;
  _ShellExecute(ExtractFilePath(Application.ExeName)+'Utils\gbmsize.exe'
    , ExtractFilePath(Application.ExeName)+'Utils\'
    , src + ' '+ dest, True, SSF_FGBG_BACK
    , SSF_CONTROL_INVISIBLE, SSF_RELATED_CHILD);

  wfp := pdeLoadCfgIntD('filehalf.cfg', 'WaitForPreview', 1000);
  DosSleep(wfp);
  LoadList;

End;

Procedure TMainForm.mSavePreviewOnClick (Sender: TObject);
var
  pdebase, savename: String;
Begin

  {save preview mini-picture in file}
  //PDE home directory from config.sys
  pdebase := getenv('PDE_HOME');
  if pdebase = '' then
    pdebase := 'c:\pde';
  savename := pdedlgsdll.pdeOpenFileDialog(pdeLoadNLS('eD2Str32','࠭ 䠩')
    , pdebase+pdeLoadCfgStr('general.cfg', 'userhome')+'\'
    ,pdeLoadNLS('pdmcfgstr14', '㭪')+' (*.bmp)|'
    +pdeLoadNLS('eD2Str35',' 䠩')+' (*.*)|');
  if savename <> '' then
    begin
    InfoImage.Bitmap.SaveToFile(savename);
    end;

End;

Procedure TMainForm.mZoomMinusOnClick (Sender: TObject);
var
  acnrInfo:CNRINFO;
  Flags:LongWord;
Begin
  //zoom minus
vFiles.BitmapSize.CX := vFiles.BitmapSize.CX - iconsize div 2;
vFiles.BitmapSize.CY := vFiles.BitmapSize.CY - iconsize div 2;

  FillChar(acnrInfo,SizeOf(CNRINFO),0);
  Flags:=CMA_FLWINDOWATTR;
  With acnrInfo Do
     Begin
          cb:=SizeOf(CNRINFO);

          if mFlow.Checked then
            flWindowAttr:=CV_Name or CV_Flow
          else if mAsText.Checked then
            flWindowAttr:=CV_Text or CV_Flow
          else flWindowAttr:=CV_ICON;

          slBitmapOrIcon.CX:=vFiles.BitmapSize.CX;
          slBitmapOrIcon.CY:=vFiles.BitmapSize.CY;
          Flags:=Flags Or CMA_SLBITMAPORICON;
          flWindowAttr:=flWindowAttr Or CA_DRAWICON;
     End;
     WinSendMsg(vFiles.Handle,CM_SETCNRINFO,LongWord(@acnrInfo),Flags);

vFiles.Refresh;
LoadList;
End;

Procedure TMainForm.mZoomPlusOnClick (Sender: TObject);
var
  acnrInfo:CNRINFO;
  Flags:LongWord;
Begin
  //zoom plus
vFiles.BitmapSize.CX := vFiles.BitmapSize.CX + iconsize div 2;
vFiles.BitmapSize.CY := vFiles.BitmapSize.CY + iconsize div 2;

  FillChar(acnrInfo,SizeOf(CNRINFO),0);
  Flags:=CMA_FLWINDOWATTR;
  With acnrInfo Do
     Begin
          cb:=SizeOf(CNRINFO);

          if mFlow.Checked then
            flWindowAttr:=CV_Name or CV_Flow
          else if mAsText.Checked then
            flWindowAttr:=CV_Text or CV_Flow
          else flWindowAttr:=CV_ICON;

          slBitmapOrIcon.CX:=vFiles.BitmapSize.CX;
          slBitmapOrIcon.CY:=vFiles.BitmapSize.CY;
          Flags:=Flags Or CMA_SLBITMAPORICON;
          flWindowAttr:=flWindowAttr Or CA_DRAWICON;
     End;
     WinSendMsg(vFiles.Handle,CM_SETCNRINFO,LongWord(@acnrInfo),Flags);

vFiles.Refresh;
LoadList;
End;

Procedure TMainForm.mShowPreview2OnClick (Sender: TObject);
Begin
  //togle show preview for pictures
  mShowPreview2.Checked := not(mShowPreview2.Checked);

  resolved_preview := False;
  InfoScroll.Visible := False;
  InfoLabel.Visible := True;
  Image1.Visible := True;
  if FileExists(Path + pdeloadcfgstr('filehalf.cfg', 'id_diz')) then exit;
  Dirs.Height:=InfoPanel.Height-102;
  Dirs.Top := 102;
  l_case.height := Dirs.Height;
  l_case.top :=  Dirs.Top;
  Drives.Top := 85;

  Resolve_One_PreView;

End;

Procedure TMainForm.mShowPreviewOnClick (Sender: TObject);
Begin
  //togle show thumbails for pictures
//  mShowPreview.Checked := not(mShowPreview.Checked);
//  LoadList;
End;

Procedure TMainForm.mShowHiddenOnClick (Sender: TObject);
Begin
  //togle show hidden files
  mShowHidden.Checked := not(mShowHidden.Checked);
  LoadList;
End;

Procedure TMainForm.DirsOnClick (Sender: TObject);
Begin

End;

Procedure TMainForm.mShowHelpOnClick (Sender: TObject);
var
  t: string;
Begin
//Help? Help!!!!!
//since PDE v0.1 help files are in [PDE_HOME]\Help folder
  t := extractfilepath(application.exename);
  if FileExists(t+'Help\filehalf.inf') then
    MainForm.ShellExecute('view.exe', '', t+'Help\filehalf.inf', false)
  else if FileExists(t+'pde_help_en.inf') then
    MainForm.ShellExecute('view.exe', '', t+'pde_help_en.inf', false)
  else if FileExists(t+'pde_help_ru.inf') then
    MainForm.ShellExecute('view.exe', '', t+'pde_help_ru.inf', false)
  else if FileExists(t+'readme_ru.txt') then
    MainForm.ShellExecute('e.exe', '', t+'readme_ru.txt', false)
  else if FileExists(t+'readme_en.txt') then
    MainForm.ShellExecute('e.exe', '', t+'readme_en.txt', false)
  else mAboutOnClick( Sender );
End;

Procedure TMainForm.MainFormOnCloseQuery (Sender: TObject;
  Var CanClose: Boolean);
var
  cfgData: TStringList;
  tmpstr: String;
Begin

//save changes to configuration file
cfgData:= TStringList.Create;
cfgData.Add('//Configuration file of FileHalf (PDE desktop, 2003-2004)');
cfgData.Add('//Directory (Folder) description file');
cfgData.Add('id_diz='+ pdeLoadCfgStr('filehalf.cfg', 'id_diz'));
cfgData.Add('//Show InfoPanel 1/0');
tmpstr := '0';
if mInfopanel.Checked then tmpstr := '1';
cfgData.Add('ShowInfoPanel='+ tmpstr);
cfgData.Add('//Show Status 1/0');
tmpstr := '0';
if mStatus.Checked then tmpstr := '1';
cfgData.Add('ShowStatus='+ tmpstr);
cfgData.Add('//Show Buttons 1/0');
tmpstr := '0';
if mButtons.Checked then tmpstr := '1';
cfgData.Add('ShowButtons='+ tmpstr);
cfgData.Add('ShowButtonsText='+pdeLoadCfgStrD('filehalf.cfg', 'ShowButtonsText', '0'));
cfgData.Add('//preview wait time');
cfgData.Add('WaitForPreview='
  + pdeLoadCfgStrD('filehalf.cfg', 'WaitForPreview', '1000'));
cfgData.Add('//Type of View 0-pictograms, 1-tiles, 2-small icons, 3-columns, 4-text');
tmpstr := '0';
if mTile.Checked then tmpstr := '1'
else if mSmallIcons.Checked then tmpstr := '2'
else if mFlow.Checked then tmpstr := '3'
else if mAsText .Checked then tmpstr := '4';
cfgData.Add('ViewType='+ tmpstr);
cfgData.Add('//theme (pictures on tool-buttons, logo, colors)');
cfgData.Add('Theme='+Theme);
cfgData.Add('//pictograms for filetypes theme');
cfgData.Add('ITheme='+ITheme);
cfgData.Add('//additional utilities');
cfgData.Add('//Search');
cfgData.Add('FindUtil='+ pdeLoadCfgStr('filehalf.cfg', 'FindUtil'));
cfgData.Add('//text editor');
cfgData.Add('TextUtil='+ pdeLoadCfgStr('filehalf.cfg', 'TextUtil'));
cfgData.Add('//archiver');
cfgData.Add('Archiver='+ pdeLoadCfgStr('filehalf.cfg', 'Archiver'));

pdeSaveCfgFile('filehalf.cfg', cfgData);
cfgData.Free;

CanClose := True;
End;

Procedure TMainForm.MainFormOnSetupShow (Sender: TObject);
Begin

End;

function TMainForm.DeCC(corstr: String): String;
Begin
  corstr:=Trim(corstr);  //delete all non-need spaces
  if corstr[19]=chr(13) then Delete(corstr, 19, 1);
  if corstr[19]=chr(10) then Delete(corstr, 19, 1);
  if corstr[37]=chr(13) then Delete(corstr, 37, 1);
  if corstr[37]=chr(10) then Delete(corstr, 37, 1);
result:=corstr;
End;

function TMainForm.CorectCaption(corstr: String): String;
var
  exceed: String;
Begin
exceed:='';
//ࠢ  
if mTile.Checked then
  Begin

  While length(corstr)<17 do
    begin
    corstr:=corstr+' ';
    corstr:=' '+corstr;
    end;

  If length(corstr)<18 then
    corstr:=corstr+' ';

  If length(corstr)>18 then
    begin
    While length(corstr)>18 do
      begin
      exceed:=corstr[length(corstr)]+exceed;
      delete(corstr, length(corstr), 1);
      end;
    corstr:=corstr+chr(13)+chr(10)+exceed;
    exceed:='';
    end;

    If length(corstr)>38 then
    begin
    While length(corstr)>35{38} do
      begin
      exceed:=corstr[length(corstr)]+exceed;
      delete(corstr, length(corstr), 1);
      end;
    //corstr:=corstr+chr(13)+chr(10)+exceed;
    corstr := corstr + '...';
    end;

  End;

Result := Corstr;

End;

//-----------------------------------------
//c  㧪 ।ᬮ 㭪

Procedure TPreviewThread.Execute;
var
  ti: Integer;
  tmpPath: String;
  __tmp: TBitmap;
Begin
  {for ti := 0 to (prList.Count - 1) do
  begin
    try
    tmpPath := GetEnv('TEMP') + '\';
    MainForm._ShellExecute(ExtractFilePath(Application.ExeName)+'Utils\gbmsize.exe'
      , ExtractFilePath(Application.ExeName)+'Utils\'
      , '-w '+IntToStr(MainForm.vFiles.BitmapSize.CX)+' -h '
      +IntToStr(MainForm.vFiles.BitmapSize.CX)+' '
      + prList[ti] + ' '+ tmpPath + '~fh.bmp', True, SSF_FGBG_BACK
      , SSF_CONTROL_INVISIBLE, SSF_RELATED_CHILD);

    DosSleep(pdeLoadCfgIntD('filehalf.cfg', 'WaitForPreview', 1000));
    if not FileExists(tmpPath + '~fh.bmp') then DosSleep(500);
    if not FileExists(tmpPath + '~fh.bmp') then DosSleep(500);
    __tmp:= TBitmap.Create;
    __tmp.LoadFromFile(tmpPath + '~fh.bmp');
    MainForm.vFiles.AddFN(MainForm.CorectCaption(ExtractFileName(prList[ti]))
      , ExtractFileName(prList[ti]), nil, nil, TIcon(__tmp.copy));

    DeleteFile(tmpPath + '~fh.bmp');
    __tmp.free;
    except

    end;
  end;}
End;

//-----------------------------------------
// ⮪  䠩 権
Constructor TCMDThread.Create(Source, Dest, Operation: String);
Begin
  FSource:=Source;
  FDest:=Dest;
  FOperation:=Operation;

  inherited Create(False);
End;

Procedure TCMDThread.Execute;
var
  rc: apiret;
  option: ULong;
Begin
//ᯮ ⮪
option := 0;
if (FOperation='copy') then
  begin
  if pdeLoadCfgInt('general.cfg', 'overwritefiles') = 1 then
    option := DCPY_Existing;
  rc:=DosCopy(FSource, FDest, option);
  if rc<>0 then
    pdeMessageBoxC(pdeLoadNLS('dlgErrorCode', ' 訡:') + ' ' + IntToStr(rc),
      pdeLoadNLS('dlgCopyError' ,' ஢ ந諨 訡'), MainForm.bCopy.Glyph);
  end
else if (FOperation='move') then
  begin
  MainForm.ObjMove(FSource, FDest);
  end;
MainForm.LoadList;
End;
//-----------------------------------------

Procedure TMainForm.mDeskTop2OnClick (Sender: TObject);
Begin
//ᮧ 쥪  祬 ⮫

End;

Procedure TMainForm.FormShowHint(Var HintStr:String;Var CanShow:Boolean;Var HintInfo:THintInfo);
//var
//  hintWnd: THintWindow;
Begin

  CanShow := True;

End;

Procedure TMainForm.DirsOnItemFocus (Sender: TObject; Index: LongInt);
Begin

End;

function TMainForm.FStat: Integer;
var
  fsize: LongInt;
Begin

if vFiles.ItemIndex = -1 then exit;

if vFiles.ItemCount>0 then
  begin
    fsize:=LongInt(vFiles.Items[vFiles.ItemIndex].Data);

    if ToolBar1.Height > 0 then
    begin
    if (fsize<4096) then
        ToolBar1.Panels[1].Text:=IntToStr(fsize)+' '+pdeLoadNLS('statusBytes', '')
      else if (fsize>4096) and (fsize<2097152) then
        ToolBar1.Panels[1].Text:=IntToStr(fsize div 1204)+' '+pdeLoadNLS('statusKBytes', '')
      else
        ToolBar1.Panels[1].Text:=IntToStr(fsize div 1048576)+' '+pdeLoadNLS('statusMBytes', '');
    end;

  end;

  if this_is_this = vFiles.Items[vFiles.ItemIndex].RealFileName then
    exit;

  resolved_preview := False;
  Resolve_One_PreView;

  this_is_this := vFiles.Items[vFiles.ItemIndex].RealFileName;

Result := 0;

End;

Procedure TMainForm.vFilesOnMouseUp (Sender: TObject; Button: TMouseButton; Shift: TShiftState; X: LongInt; Y: LongInt);
{var
  rect: TRect;
  _i, _j: Integer;}
Begin
{rect:=vFiles.Items[vFiles.ItemIndex].ItemRect;
for _i:=rect.left to rect.right do
  for _j:=rect.top to rect.bottom do
    if (vFiles.Canvas.Pixels[_i, _j]=vFiles.Color) then
      vFiles.Canvas.Pixels[_i, _j]:=clBlue;
}
End;

Procedure TMainForm.vFilesOnMouseDown (Sender: TObject; Button: TMouseButton; Shift: TShiftState; X: LongInt; Y: LongInt);
Begin
if vFiles.NodeFromPoint(Point(x, y))<>nil then
  begin
  vFiles.ItemIndex:=TListViewNode(vFiles.NodeFromPoint(Point(x, y))).Index;
  FStat;
  end;
End;

Procedure TMainForm.mArchiveOnClick (Sender: TObject);
var
  a_index: Integer;
  src, newname: String;
Begin
////add file to archive <- in future :-)
if archiveUtil<>'' then
  if vFiles.ItemCount>0 then begin

    src := vFiles.Items[vFiles.ItemIndex].RealFileName;
    newname:=pdedlgsdll.pdePromptDialog(pdeLoadNLS('dlgAddingToArchiveName',' 娢:')
     , pdeLoadNLS('dlgAddingToArchive', '  娢')+' '+archiveUtil, 'new');
    if newname <> '' then
    begin
    ShellExecute(archiveUtil, '', path + newname + ' ' + path + src, true);
    a_index:=vFiles.ItemIndex;
    LoadList;
    vFiles.ItemIndex:=a_index;
    end;
    WinSetActiveWindow(HWND_DESKTOP, MainForm.Handle);
  end;
End;

Procedure TMainForm.mFilterOnClick (Sender: TObject);
var
  ext: string;
Begin
ext:='';
mFilter.Checked:=not(mFilter.Checked);
filter:='*.*';
if vFiles.ItemCount>0 then begin
  ext:=lowercase(extractfileext(vFiles.Items[vFiles.ItemIndex].RealFileName{Text}));
  if ext<>'' then
    if mFilter.Checked then
      filter:='*'+ext
  end;
LoadList;
ShowStatus;
End;

Procedure TMainForm.mShortcut2OnClick (Sender: TObject);
var
  fname, ext: String; // extension of file
  //lfile: String;
Begin

  if vFiles.ItemCount = 0 then exit;

  //뢠  ᮧ 몠
  fname := vFiles.Items[vFiles.ItemIndex].RealFileName;
  PropForm3.caption           := pdeLoadNLS('dlgCreateShortcut', 'New Shortcut properties');
  PropForm3.LDir.Caption      := path;

  ext := UpperCase(ExtractFileExt(fname));
  if (ext = '.EXE') or (ext = '.COM') or (ext = '.CMD') or (ext = '.BAT') then
    PropUnit3.LinkType := 'APP'
  else
    PropUnit3.LinkType := 'FOLDER';

  if PropUnit3.LinkType = 'APP' then
    begin
    PropForm3.edName.Text := fname;
    PropForm3.edPath.Text := path;
    delete(fname,  pos('.', fname), length(fname) - pos('.', fname) + 1);
    PropForm3.LName.Caption     := pdeLoadNLS('dlgCreateShortcutFor', 'Shortcut for')+' '+fname;
    end
  else if PropUnit3.LinkType = 'FOLDER' then
    begin
    PropForm3.LName.Caption     := pdeLoadNLS('dlgCreateShortcutFor', 'Shortcut for')+' '+fname;
    PropForm3.edName.Text := path+fname+'\';
    PropForm3.edPath.Text := PropForm3.edName.Text;
    end;
  PropForm3.edParams.Text := '';
  PropForm3.BtnCancel.Default := True;
  PropForm3.ShowModal;
  PropForm3.BringToFront;

//lfile := path + vFiles.Items[vFiles.ItemIndex].RealFileName;
//NewLink(lfile);

LoadList;

//WinSetActiveWindow(HWND_DESKTOP, MainForm.Handle);

End;

Procedure TMainForm.mHTMOnClick (Sender: TObject);
var
  afile: TextFile;
  ci: Integer;
Begin
ci:=0;
//ᮧ ⮣ .htm 䠩 (-࠭)
while (FileExists(path+'Empty web_page'+IntToStr(ci)+'.htm')) do
  inc(ci);

assignfile(afile, path+'Empty web_page'+IntToStr(ci)+'.htm');
rewrite(afile);
writeln(afile, '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">');
writeln(afile, '<HTML>');
writeln(afile, '<HEAD>');
writeln(afile, '<TITLE>Empty WWW page title</TITLE>');
writeln(afile, '<BODY>');
writeln(afile, 'Here will be your text');
writeln(afile, '<p>Text. Text. Text.');
writeln(afile, '</BODY>');
writeln(afile, '</HEAD>');
writeln(afile, '</HTML>');
closefile(afile);

LoadList;
End;

Procedure TMainForm.mDubleOnClick (Sender: TObject);
var
  ci: integer;
  src: String;
Begin

  {create copy in currnt directory}
  if vFiles.ItemCount=0 then exit;

  src := vFiles.Items[vFiles.ItemIndex].RealFileName;
  ci:=0;
  while (FileExists(path+'['+pdeLoadNLS('popupmenuDubleR', 'Copy')+' '+IntToStr(ci)+'] '+src)) do
    inc(ci);

  CopyFile(path + src, path+'['+pdeLoadNLS('popupmenuDubleR', 'Copy')+' '+IntToStr(ci)+'] '+src);

  LoadList;

End;

Procedure TMainForm.mIPFOnClick (Sender: TObject);
var
  afile: TextFile;
  ci: integer;
Begin

  {create template for IPF compiler}
ci:=0;
while (FileExists(path+'Empty Help '+IntToStr(ci)+'.ipf')) do
  inc(ci);

assignfile(afile, path+'Empty Help '+IntToStr(ci)+'.ipf');
rewrite(afile);
writeln(afile, ':userdoc.');
writeln(afile, ':title. Help title');
writeln(afile, ':h1. :p. Help topic 1');
writeln(afile, ':euserdoc.');
closefile(afile);
LoadList;

End;


Procedure TMainForm.mText2OnClick (Sender: TObject);
var
  afile: TextFile;
  ci: integer;
Begin
ci:=0;
//ᮧ ⮣ .txt 䠩
while (FileExists(path+'Empty Text '+IntToStr(ci)+'.txt')) do
  inc(ci);

assignfile(afile, path+'Empty Text '+IntToStr(ci)+'.txt');
rewrite(afile);
closefile(afile);
LoadList;
End;

Procedure TMainForm.MainFormOnTranslateShortCut (Sender: TObject; KeyCode: TKeyCode; Var ReceiveR: TForm);
Begin
if (keycode=kbEnter) and (ActiveControl=edPath) then
  begin
  path:=edPath.Text;
  LoadList;
  ShowStatus;
  end
else if (keycode=kbSpace) and (ActiveControl=vFiles) then
  begin {space togle Item in/out "Case"}
  if not mVCaseShow.Checked then //show Case contents for user
    begin
    mVCaseShow.Checked := True;
    l_Case.Visible := True;
    end;
  if vFiles.ItemCount > 0 then
    begin
    vFiles.Items[vFiles.ItemIndex].InCase := not (vFiles.Items[vFiles.ItemIndex].InCase);

    if vFiles.Items[vFiles.ItemIndex].InCase then
      l_case.Items.Add(path+vFiles.Items[vFiles.ItemIndex].RealFileName)
      else
      l_case.Items.Delete(l_case.Items.IndexOf(path+vFiles.Items[vFiles.ItemIndex].RealFileName));
    end;
  end
else {if (keycode=kbCLeft)or(keycode=kbCRight)or(keycode=kbCUp)or(keycode=kbCDown)or
  (keycode=kbEnd)or(keycode=kbHome) then}
  if (ActiveControl = vFiles) then
  begin
  {if vFiles.ItemCount > 0 then
  if vFiles.Items[prevNode].InCase then
       begin
       rc1 := vFiles.Items[prevNode].ItemRect;
       bms := vFiles.BitmapSize.CX;
       if bms = 0 then bms := 16;
       bms := bms div 4;
       vFiles.Canvas.Pen.Mode := pmNot;
       vFiles.Canvas.Pen.Width := 2;
       vFiles.Canvas.MoveTo(rc1.Left, rc1.Bottom + bms div 2);
       vFiles.Canvas.LineTo(rc1.Left + bms, rc1.Bottom + bms div 2);
       vFiles.Canvas.MoveTo(rc1.Left + bms div 2, rc1.Bottom + bms);
       vFiles.Canvas.LineTo(rc1.Left + bms div 2, rc1.Bottom);
       end;}
  FStat;
  end;

  prevNode := vFiles.ItemIndex;

End;

//-----------------------------------------
//஢ ।⢮ drag'n'drop

Procedure TMainForm.vFilesOnStartDrag (Sender: TObject; Var DragData: TDragDropData);
Var
    MemLen:LongWord;
    SharedMem:PDragDropInfo;
    Temp:^String;
//    ptrInfo: PointerInfo;
//    tmpbmp: TPointer;

Begin
{tmpbmp:=TPointer.Create;
tmpbmp.width:=vFiles.Items[vFiles.ItemIndex].Bitmap.width;
tmpbmp.height:=vFiles.Items[vFiles.ItemIndex].Bitmap.height;
tmpbmp.LoadFromBitmap(vFiles.Items[vFiles.ItemIndex].Bitmap);
tmpbmp.CreateMask(clWhite);
tmpbmp.CreateNew(tmpbmp.width, tmpbmp.height, 280);

with ptrInfo do
  begin
  fPointer:=ord(True);
  xHotSpot:=14;
  yHotSpot:=14;
  hbmPointer:=tmpbmp.MaskHandle;
  hbmColor:=tmpbmp.ColorHandle;
  hbmMiniPointer:=0;
  hbmMiniColor:=0;
  end;
hptr:=WinCreatePointerIndirect(HWND_DESKTOP, ptrInfo);

//hptr:=WinCreatePointer(HWND_DESKTOP, tmpbmp.ColorHandle, true, 15, 15);
//crs:=Screen.AddCursor(hptr);

{Screen.Cursors[1]:=hptr;
vFiles.DragCursor:=1;
tmpbmp.free;}
   //Look how much memory we need
   MemLen:=Sizeof(TDragDropInfo)-sizeof(TDragDropItem);
   inc(MemLen,length(path+vFiles.Items[vFiles.ItemIndex].RealFileName)+1);

   //allocate the memory. We need shared memory because we want to give
   //the information to another process
   //free the shared memory
   GetNamedSharedMem(SharedMemName,SharedMem,MemLen);

   SharedMem^.Count:=0;
   Temp:=@SharedMem^.Items;  //start of variable information
   Inc(SharedMem^.Count);
   Temp^:=path+vFiles.Items[vFiles.ItemIndex].RealFileName;

   //Fill up the DragData structure
   DragData.SourceWindow := Handle;
   DragData.SourceType := drtString;
   DragData.SourceString:=DragSourceId;
   DragData.RenderType := drmSibyl;
   DragData.ContainerName := '';
   DragData.SourceFileName := SharedMemName;
   DragData.TargetFileName := '';
   DragData.SupportedOps := [doCopyable];//, doMoveable];
   DragData.DragOperation := doDefault;//doCopy;
End;

Procedure TMainForm.vFilesOnEndDrag (Sender: TObject; target: TObject;
  X: LongInt; Y: LongInt);
//Var t:LongInt;
Begin
    //Look if the items were dropped successfully...
    If Target Is TExternalDragDropObject Then
    Begin
       // , ᫨ 䠩 ७ᨫ
       //remove the items dragged
    End;

    //each process must free the shared memory !!
    FreeNamedSharedMem(SharedMemName);
End;

Procedure TMainForm.vFilesOnDragOver (Sender: TObject; Source: TObject;
  X: LongInt; Y: LongInt; State: TDragState; Var Accept: Boolean);
Begin
Accept:=((Source Is TExternalDragDropObject)And
             (TExternalDragDropObject(Source).SourceWindow<>vFiles.Handle)And
             (TExternalDragDropObject(Source).SourceType=drtString)And
             (TExternalDragDropObject(Source).SourceString=DragSourceId));

End;

Procedure TMainForm.vFilesOnDragDrop (Sender: TObject; Source: TObject;
  X: LongInt; Y: LongInt);
Var SharedMem:PDragDropInfo;
    sh:Longint;
    Temp:^String;
    fsrc, fdest: cstring;
    src, dest: string;
    rc: apiret;
    cmdTr: TCMDThread;
    shortcutfile: TextFile;
    shsr: TSearchRec;
Begin
rc:=0;
//Look if the target is valid for us...
    If ((Source Is TExternalDragDropObject)And
        (TExternalDragDropObject(Source).SourceWindow<>vFiles.Handle)And
        (TExternalDragDropObject(Source).SourceType=drtString)And
        (TExternalDragDropObject(Source).SourceString=DragSourceId)) Then
    Begin  //accepted
       If not AccessNamedSharedMem(TExternalDragDropObject(Source).SourceFileName,
                                   SharedMem) Then exit;  //some error

       Temp:=@SharedMem^.Items;
       //   ஢-६饭
       fsrc:=Temp^;
       fdest:=path+extractfilename(Temp^);
       src:=fsrc;
       dest:=fdest;
       //MessageBox(src+' '+dest, mtInformation, [mbOk]);
       sh:=WinGetKeyState(HWND_DESKTOP, VK_SHIFT);
       if ((sh and $8000) <> 0) and
          ((WinGetKeyState(HWND_DESKTOP, VK_CTRL) and $8000) <> 0) then
         begin //Shift + Ctrl <- create shortcut
         if (FindFirst(src + '\*.*', faAnyFile, shsr)=0) then  // 䠩    㣨 䠩 :-)
           begin  //directory
           FindClose(shsr);
           AssignFile(shortcutfile, path+'['+ExtractFileName(dest)+']');
           Rewrite(shortcutfile);
           Writeln(shortcutfile, '[SHORTCUT]');
           Writeln(shortcutfile, '//link: type, object-name, path, parameters');
           Writeln(shortcutfile, 'FOLDER');
           Writeln(shortcutfile, src+'\');
           Writeln(shortcutfile, src+'\');
           Writeln(shortcutfile, '');
           end
           else
           begin
           FindClose(shsr);
           delete(dest,  pos('.', dest), length(dest) - pos('.', dest) + 1);
           AssignFile(shortcutfile, dest);
           Rewrite(shortcutfile);
           Writeln(shortcutfile, '[SHORTCUT]');
           Writeln(shortcutfile, '//link: type, object-name, path, parameters');
           Writeln(shortcutfile, 'APP');
           Writeln(shortcutfile, src);
           Writeln(shortcutfile, ExtractFilePath(src));
           Writeln(shortcutfile, '');
           end;
         CloseFile(shortcutfile);
         end
       else if (sh and $8000)<> 0 then //Shift
         begin //६饭
         l_case.Clear;
         l_case.Items.Add(src);
         l_case_dest := ExtractFilePath(dest);
         OpComodo('1', pdeLoadNLS('dlgMoving', '६饭'));
         end
       else
         begin //஢
         l_case.Clear;
         l_case.Items.Add(src);
         l_case_dest := ExtractFilePath(dest);
         OpComodo('0', pdeLoadNLS('dlgCopying', '஢'));
         end;
       MainForm.Activate;
       //LoadList;

       //each process must free the shared memory !!
       FreeNamedSharedMem(TExternalDragDropObject(Source).SourceFileName);
    End;
End;

Procedure TMainForm.vFilesOnCanDrag (Sender: TObject; X: LongInt; Y: LongInt;
  Var Accept: Boolean);
Begin
//  ࠣ?
Accept:=(vFiles.ItemCount>0);

End;
//-----------------------------------------

//--Favorites------------------------------
Procedure TMainForm.mAddFavorOnClick (Sender: TObject);
var
  afile: textfile;
  fname, basepath, cptn: string;
Begin
//add bookmark

fname:=path;
if length(fname)>3 then
  begin
  delete(fname, length(fname), 1);
  while pos('\', fname)<>0 do
    delete(fname, 1, 1);
  end;

cptn := mAddBookmark.Caption;
if pos('\t', cptn) <> 0 then
  delete(cptn, pos('\t', cptn), length(cptn)+1-pos('\t', cptn));

fname := pdedlgsdll.pdePromptDialog(cptn, mBookmarks.Caption, fname);

if fname = '' then exit;

  basepath := getenv('PDE_HOME');
  if basepath = '' then
    basepath := 'c:\pde';

  assignfile(afile, basepath+pdeLoadCfgStr('general.cfg', 'userbookmarks')+'\['+fname+']');
  rewrite(afile);
  writeln(afile, '[SHORTCUT]');
  writeln(afile, '//link: type, object-name, path, parameters');
  writeln(afile, 'FOLDER');
  writeln(afile, path);
  writeln(afile, path);
  writeln(afile);
  closefile(afile);

bookitem:=TMenuItem.Create(self);
bookitem.Caption:='['+fname+']';
bookitem.hint:=path;
bookitem.onclick:=BookMarkClick;
mBookmarks.add(bookitem);

End;

Procedure TMainForm.mBookmarksClearOnClick (Sender: TObject);
var
  basepath: String;
  tsr: TSearchRec;
  rez: Integer;
Begin
//clear all bookmarks
  basepath := getenv('PDE_HOME');
  if basepath = '' then
    basepath := 'c:\pde';

//at first - delete all files in "Bookmarks" folder
rez:=FindFirst(basepath+pdeLoadCfgStr('general.cfg', 'userbookmarks')+'\*.*', faAnyFile, tsr);
if rez<>0 then begin FindClose(tsr); exit; end;
  while rez=0 do
    begin
    rez:=FindNext(tsr);
    if rez<>0 then break;
    if (tsr.attr and faDirectory)=0 then //file
      begin
      DeleteFile(basepath+pdeLoadCfgStr('general.cfg', 'userbookmarks')+'\'+tsr.name);
      end;
    end;
FindClose(tsr);
//then we need to clear bookmarks from submenu mBookmarks
while mBookmarks.Count > 3 do
    mBookmarks.Items[3].Free;

End;
//--End Favorites--------------------------

//--go to the HOME directory---------------
Procedure TMainForm.mGotoHomeOnClick (Sender: TObject);
var
  basepath: string;
Begin
basepath := getenv('PDE_HOME');
  if basepath = '' then
    basepath := 'c:\pde';

path := basepath + pdeLoadCfgStr('general.cfg', 'userhome') + '\';
edPath.Text := Path;
LoadList;
ShowStatus;
End;
//-----------------------------------------

//go to the DRIVES directory
Procedure TMainForm.mGotoDisksOnClick (Sender: TObject);
var
  basepath: string;
Begin

basepath := getenv('PDE_HOME');
  if basepath = '' then
    basepath := 'c:\pde';

path:=basepath+pdeLoadCfgStr('general.cfg', 'userdrives')+'\';
edPath.Text:=Path;
LoadList;
ShowStatus;

End;
//-----------------------------------------

Procedure TMainForm.mDiskA2OnClick (Sender: TObject);
var
  fsrc, fdest: CString;
  needBytes, isBytes: LongInt;
Begin

//஢   :
{if vFiles.ItemCount>0 then begin
  needBytes:=CalcTreeSize(path + vFiles.Items[vFiles.ItemIndex].RealFileName);
  isBytes:=DiskFree(ord('a')-96);
  if (needBytes<isBytes) then
  begin
    cmdImage.Bitmap.LoadFromBitmap(bCopy.Glyph);
    cmdLabel.Caption:=pdeLoadNLS('dlgCopying', '஢')+' '+vFiles.Items[vFiles.ItemIndex].RealFileName+' '+
           IntToStr(needBytes div 1024)+pdeLoadNLS('statusKBytes', '')+
           ' '+pdeLoadNLS('statusIn', '')+' A:\'+vFiles.Items[vFiles.ItemIndex].RealFileName;
    cmdForm.Show;
    cmdForm.BringToFront;
    fsrc:=path+vFiles.Items[vFiles.ItemIndex].RealFileName;
    fdest:='A:\'+vFiles.Items[vFiles.ItemIndex].RealFileName;
    cmdForm.Refresh;
    DosCopy(fsrc, fdest, DCPY_Existing);
    cmdForm.Hide;
    LoadList;
    end
  else
    pdeMessageBox(pdeLoadNLS('dlgErrorDiskSpace', '筮   楫 ᪥.')
      +chr(10)+chr(13)+IntToStr(isBytes div 1024)+' '+pdeLoadNLS('dlgErrorVS', '⨢')+' '+
      +IntToStr(needBytes div 1024)+' '+pdeLoadNLS('statusKBytes', ''),
      pdeLoadNLS('dlgError', '訡'), bCopy.Glyph);
  end;
WinSetActiveWindow(HWND_DESKTOP, MainForm.Handle);
}
End;

Procedure TMainForm.mConfigPDEOnClick (Sender: TObject);
Begin
//// ணࠬ ன DE
//  ShellExecute(extractfilepath(application.exename)+'pdeConf.exe', extractfilepath(application.exename), '', false);
// ன FileHalf
//  DlgCmd.ShowModal;
  ThemeForm.ShowModal;

End;

Procedure TMainForm.mPrevDriveOnClick (Sender: TObject);
var
  ch: char;
  exPath: string;
Begin
// ।騩 
ch:=Drives.Drive;
dec(ch);
exPath:=ch+':\';
if FileExists(exPath) then
  Drives.Drive:=ch;
End;

Procedure TMainForm.mNextDriveOnClick (Sender: TObject);
var
  ch: char;
  exPath: string;
Begin
//᫥騩 
ch:=Drives.Drive;
inc(ch);
exPath:=ch+':\';
if FileExists(exPath) then
  Drives.Drive:=ch;
End;

Procedure TMainForm.bBackOnClick (Sender: TObject);
Begin
//  ""
  if prevDir<>'' then
  begin
  nextDir2 := nextDir;
  nextDir  := path;
  path     := prevDir;
  prevDir  := prevDir2;
  prevDir2 := '';
  edPath.Text := Path;
  LoadList;
  ShowStatus;
  end;
End;

Procedure TMainForm.bForwardOnClick (Sender: TObject);
Begin
//  ""
if nextDir<>'' then
  begin
  prevDir2 := prevDir;
  prevDir  := path;
  path     := nextDir;
  nextDir  := nextDir2;
  nextDir2 := '';
  edPath.Text := Path;
  LoadList;
  ShowStatus;
  end;
End;

Procedure TMainForm.Timer1OnTimer (Sender: TObject);
Begin
// ६  䮏
{DecodeDate(Date, Year, Month, Day);}
//InfoMemo.BeginUpdate;
//InfoMemo.Lines.Clear;
//InfoMemo.Lines.Add(IntToStr(day)+'/'+IntToStr(month)+'/'+IntToStr(year));
//InfoMemo.Lines.Add(Days[DayOfWeek(Date)]);
//InfoMemo.Lines.Add(TimeToStr(Time));
//InfoMemo.EndUpdate;
FStat;
{Infolabel.Caption:=IntToStr(day)+'/'+IntToStr(month)+'/'+IntToStr(year)+
  chr(13)+chr(10)+Days[DayOfWeek(Date)]+chr(13)+chr(10)+TimeToStr(Time);}
End;

Procedure TMainForm.mEditAssocOnClick (Sender: TObject);
var
  t: String;
  afile: TextFile;
  _t: Boolean;
Begin
  //।஢ 樠権 䠩 :-)
{if txtUtil<>'' then
  Begin
  if (txtUtil[2] = ':') then //full path
    ShellExecute(txtUtil, extractfilepath(txtUtil), extractfilepath(application.exename)+'PDEConf\Associations.cfg', false)
  else
    ShellExecute(extractfilepath(application.exename)+txtUtil, extractfilepath(application.exename), extractfilepath(application.exename)+'PDEConf\Associations.cfg', false);
  End;}

  if vFiles.ItemCount = 0 then exit;

  t := vFiles.Items[vFiles.ItemIndex].RealFileName;
  if ExtractFileExt(t) <> '' then //file have extension
    begin
    ChoosedType := LowerCase(ExtractFileExt(t));
    if TypesForm.ShowModal = cmOK then
      if ChoosedApp <> '' then
        begin
        _t := false;
        if assoccount > 0 then
          for i := 6 to assoccount do
            if LowerCase(assoc[i].flt) = ChoosedType then
            begin
            assoc[i].pgm := ChoosedApp;
            _t := true;
            break;
            end;
        if not _t then
          begin
          inc(assocCount);
          assoc[assocCount].flt := ChoosedType;
          assoc[assocCount].pgm := ChoosedApp;
          assoc[assocCount].bmp := 'unknown.ico';
          end;

        assignfile(afile, extractfilepath(application.exename)+'\PDEConf\Associations.cfg');
        rewrite(afile);
        writeln(afile, '//File associations for FileHalf of PDE ([PDE Team] 2003-2004)'); //header
        writeln(afile, '//file extension, program, pictogram. Base folder specified in "ITheme" variable in "filehalf.cfg"'); //header
        for i := 1 to assoccount do
          begin
          writeln(afile, assoc[i].flt);
          writeln(afile, assoc[i].pgm);
          writeln(afile, assoc[i].bmp);
          writeln(afile);
          end;
        closefile(afile);
        end;
    end;

End;

Procedure TMainForm.bNewWindowOnClick (Sender: TObject);
//var
//  hObj: HObject;
Begin
//  FileHalfa
  ShellExecute(application.exename, extractfilepath(application.exename), path, false);
End;

Procedure TMainForm.mAboutOnClick (Sender: TObject);
{var
  about, authors, thanks: TStringList;
  cptn, text, licensefile: String;
  logo: Pointer;}
var
  pdebase, about, authors, thanks: String;
  afile: TextFile;
  cptn, text, licensefile: String;
  logo: LongInt;
Begin

  //--ଠ  த--

  {about := TStringList.Create;
  about.Add(pdeLoadNLS('pdeName','  Desktop Environment')+' v.0.20');
  about.Add('');
  about.Add(pdeLoadNLS('pdeDescription1', '᪠ 窠 짮⥫ '));
  about.Add(pdeLoadNLS('pdeDescription2', '樮 ⥬ OS/2 Warp  eCS'));
  about.Add('');
  about.Add(pdeLoadNLS('pdeDescription3', '  㔠.'));
  about.Add(pdeLoadNLS('pdeDescription4', 'ணࠬ  ࠢ 䠩'));
  about.Add(pdeLoadNLS('pdeDescription5', ' .'));

  authors := TStringList.Create;
  authors.Add('Vladymyr Sergeyev, stVova');
  authors.Add('Sergey Sergeyev, SERG');
  authors.Add('e-Mail: stVova@ukrpost.com.ua or stVova@ukr.net');
  authors.Add('web: http://os2progg.by.ru');

  thanks := TStringList.Create;
  thanks.Add('Our mother Ludmyla Sergeyeva');
  thanks.Add('');
  thanks.Add('Sergey Posokhov');
  thanks.Add('Andy Key (Generalized Bitmap Module)');
  thanks.Add('Independent JPEG group (JPEG support)');
  thanks.Add('Salvador Parra Camacho');
  //thanks.Add('');
  thanks.Add('KDE Team for graphics and icons (www.kde.org)');
  thanks.Add('GNOME Team for graphics and icons (www.gnome.org)');
  thanks.Add('Aaron Lawrence (ACL Library)');
  thanks.Add('');
  thanks.Add('And all friends from native sity Lutsk (Ukraine, Volyn Region)');

  cptn := pdeLoadNLS('dlgAboutProgram', 'ଠ  த');
  text := pdeLoadNLS('pdeFileHalf', '㔠');
  licensefile := ExtractFilePath(Application.ExeName)+'copying';
  logo := MainForm.Icon;
  pdeAboutDialog(about, authors, thanks, cptn, text, licensefile, logo);}

  pdebase := ExtractFilePath(Application.ExeName);
  about := pdebase+'~ABOUT';
  AssignFile(afile, about);
  Rewrite(afile);
  Writeln(afile, '');
  Writeln(afile, pdeLoadNLS('pdeName','  Desktop Environment')+' v.0.2');
  Writeln(afile, '');
  Writeln(afile, pdeLoadNLS('pdeDescription1', '᪠ 窠 짮⥫ '));
  Writeln(afile, pdeLoadNLS('pdeDescription2', '樮 ⥬ OS/2 Warp  eCS'));
  Writeln(afile, '');
  Writeln(afile, pdeLoadNLS('pdeDescription3', '  㔠.'));
  Writeln(afile, pdeLoadNLS('pdeDescription4', 'ணࠬ  ࠢ 䠩'));
  Writeln(afile, pdeLoadNLS('pdeDescription5', ' .'));
  CloseFile(afile);

  authors := pdebase+'AUTHORS';
  thanks := pdebase+'THANKS';
  cptn := pdeLoadNLS('dlgAboutProgram', 'ଠ  த');
  text := pdeLoadNLS('pdeFileHalf', '㔠');
  licensefile := pdebase+'COPYING';
  logo := MainForm.Icon.Handle;
  pdeAboutDialogS(about, authors, thanks, cptn, text, licensefile, logo);

End;

//-----------------------------------------
// ।⠢ 䠩
Procedure TMainForm.mTileOnClick (Sender: TObject);
var
  acnrInfo:CNRINFO;
  Flags:LongWord;
Begin
//஢  䠩
if mTile.Checked then exit;

mSmallIcons.Checked:=False;
mIcons.Checked:=False;
mTile.Checked:=True;
mFlow.Checked:=False;
mAsText.Checked:=False;

vFiles.BitmapSize.CX:=iconsize;
vFiles.BitmapSize.CY:=iconsize;
vFiles.Font:=Screen.GetFontFromPointSize('Courier',8);

  FillChar(acnrInfo,SizeOf(CNRINFO),0);
  Flags:=CMA_FLWINDOWATTR;
  With acnrInfo Do
     Begin
          cb:=SizeOf(CNRINFO);
          flWindowAttr:=CV_ICON;
          slBitmapOrIcon.CX:=vFiles.BitmapSize.CX;
          slBitmapOrIcon.CY:=vFiles.BitmapSize.CY;
          Flags:=Flags Or CMA_SLBITMAPORICON;
          flWindowAttr:=flWindowAttr Or CA_DRAWICON;//Or CA_DRAWBITMAP;
     End;
     WinSendMsg(vFiles.Handle,CM_SETCNRINFO,LongWord(@acnrInfo),Flags);

vFiles.Refresh;
LoadList;
End;

Procedure TMainForm.mIconsOnClick (Sender: TObject);
var
  acnrInfo:CNRINFO;
  Flags:LongWord;
Begin
//ଠ 窨 䠩
if mIcons.Checked then exit;

mSmallIcons.Checked:=False;
mTile.Checked:=False;
mIcons.Checked:=True;
mFlow.Checked:=False;
mAsText.Checked:=False;

vFiles.BitmapSize.CX:=iconsize;
vFiles.BitmapSize.CY:=iconsize;
vFiles.Font:=Screen.GetFontFromPointSize('WarpSans',9);

  FillChar(acnrInfo,SizeOf(CNRINFO),0);
  Flags:=CMA_FLWINDOWATTR;
  With acnrInfo Do
     Begin
          cb:=SizeOf(CNRINFO);
          flWindowAttr:=CV_ICON;
          slBitmapOrIcon.CX:=vFiles.BitmapSize.CX;
          slBitmapOrIcon.CY:=vFiles.BitmapSize.CY;
          Flags:=Flags Or CMA_SLBITMAPORICON;
          flWindowAttr:=flWindowAttr Or CA_DRAWICON;//CA_DRAWBITMAP;
     End;
     WinSendMsg(vFiles.Handle,CM_SETCNRINFO,LongWord(@acnrInfo),Flags);

vFiles.Refresh;
LoadList;
End;

Procedure TMainForm.mSmallIconsOnClick (Sender: TObject);
var
  acnrInfo:CNRINFO;
  Flags:LongWord;
Begin
// 쪨 窨 䠩
if mSmallIcons.Checked then exit;

mTile.Checked:=False;
mIcons.Checked:=False;
mSmallIcons.Checked:=True;
mFlow.Checked:=False;
mAsText.Checked:=False;

vFiles.BitmapSize.CX:=iconsize div 2;
vFiles.BitmapSize.CY:=iconsize div 2;
vFiles.Font:=Screen.GetFontFromPointSize('WarpSans',9);

  FillChar(acnrInfo,SizeOf(CNRINFO),0);
  Flags:=CMA_FLWINDOWATTR;
  With acnrInfo Do
     Begin
          cb:=SizeOf(CNRINFO);
          flWindowAttr:=CV_NAME or CV_FLOW;//CV_ICON;
          slBitmapOrIcon.CX:=vFiles.BitmapSize.CX;
          slBitmapOrIcon.CY:=vFiles.BitmapSize.CY;
          Flags:=Flags Or CMA_SLBITMAPORICON;
          flWindowAttr:=flWindowAttr Or CA_DRAWICON;//Or CA_DRAWBITMAP;
     End;
     WinSendMsg(vFiles.Handle,CM_SETCNRINFO,LongWord(@acnrInfo),Flags);

vFiles.Refresh;
LoadList;
End;

Procedure TMainForm.mAsTextOnClick (Sender: TObject);
var
  acnrInfo:CNRINFO;
  Flags:LongWord;
Begin
//text only
if mAsText.Checked then exit;

mSmallIcons.Checked:=False;
mTile.Checked:=False;
mIcons.Checked:=False;
mFlow.Checked:=False;
mAsText.Checked:=True;

vFiles.BitmapSize.CX:=iconsize;
vFiles.BitmapSize.CY:=iconsize;
vFiles.Font:=Screen.GetFontFromPointSize('WarpSans',9);

  FillChar(acnrInfo,SizeOf(CNRINFO),0);
  Flags:=CMA_FLWINDOWATTR;
  With acnrInfo Do
     Begin
          cb:=SizeOf(CNRINFO);
          flWindowAttr:=CV_Text or CV_FLOW;
          slBitmapOrIcon.CX:=vFiles.BitmapSize.CX;
          slBitmapOrIcon.CY:=vFiles.BitmapSize.CY;
          Flags:=Flags Or CMA_SLBITMAPORICON;
          flWindowAttr:=flWindowAttr Or CA_DRAWICON;//Or CA_DRAWBITMAP;
     End;
     WinSendMsg(vFiles.Handle,CM_SETCNRINFO,LongWord(@acnrInfo),Flags);

vFiles.Refresh;
LoadList;
End;

Procedure TMainForm.mFlowOnClick (Sender: TObject);
var
  acnrInfo:CNRINFO;
  Flags:LongWord;
Begin
//flow columns
if mFlow.Checked then exit;

mSmallIcons.Checked:=False;
mTile.Checked:=False;
mIcons.Checked:=False;
mFlow.Checked:=True;
mAsText.Checked:=False;

vFiles.BitmapSize.CX:=iconsize;
vFiles.BitmapSize.CY:=iconsize;
vFiles.Font:=Screen.GetFontFromPointSize('WarpSans',9);

  FillChar(acnrInfo,SizeOf(CNRINFO),0);
  Flags:=CMA_FLWINDOWATTR;
  With acnrInfo Do
     Begin
          cb:=SizeOf(CNRINFO);
          flWindowAttr:=CV_Name or CV_FLOW;
          slBitmapOrIcon.CX:=vFiles.BitmapSize.CX;
          slBitmapOrIcon.CY:=vFiles.BitmapSize.CY;
          Flags:=Flags Or CMA_SLBITMAPORICON;
          flWindowAttr:=flWindowAttr Or CA_DRAWICON;//Or} CA_DRAWBITMAP;
     End;
     WinSendMsg(vFiles.Handle,CM_SETCNRINFO,LongWord(@acnrInfo),Flags);

vFiles.Refresh;
LoadList;
End;
//-----------------------------------------


Procedure TMainForm.mInfoPanelOnClick (Sender: TObject);
Begin
mInfoPanel.Checked:=not(mInfoPanel.Checked);
if mInfoPanel.Checked then
  begin
  InfoPanel.Width:=230;
  vFiles.Width:=MainForm.ClientWidth-InfoPanel.Width;
  end
  else
  begin
  InfoPanel.Width:=0;
  vFiles.Width:=MainForm.ClientWidth-InfoPanel.Width;
  end;
End;

Procedure TMainForm.mStatusOnClick (Sender: TObject);
Begin

mStatus.Checked:=not(mStatus.Checked);
if mStatus.Checked then
  ToolBar1.Height:=20
  else
  ToolBar1.Height:=0;
ToolBar3.Height:=ToolBar1.Height;

End;

Procedure TMainForm.mButtonsOnClick (Sender: TObject);
Begin
mButtons.Checked:=not(mButtons.Checked);
if mButtons.Checked then
  ToolBar2.Size:=bBack.Height+4
  else
  ToolBar2.Size:=0;
End;

Procedure TMainForm.mOpenAsTextOnClick (Sender: TObject);
Begin
//open as text
if vFiles.ItemCount = 0 then exit;

if txtUtil<>'' then
  Begin
  if (txtUtil[2] = ':') then //full path
    ShellExecute(txtUtil, path, path+{DeCC(}vFiles.Items[vFiles.ItemIndex].RealFileName{Text)}, false)
  else
    ShellExecute(extractfilepath(application.exename)+txtUtil, path, path+{DeCC(}vFiles.Items[vFiles.ItemIndex].RealFileName{Text)}, false);

  End;
End;

Procedure TMainForm.bPropertiesOnClick (Sender: TObject);
var
  rez: integer;   //for FindFirst()
  Year, Month, Day: Word;  //for file's date

  fname: string;  //cursored file name
  fsize: string;
  fdate: string;
  fprog: string;
  ch: array[1..4] of boolean; {attributes}
  drChar: Byte;

  ShortcutType: Integer; //for [SHORTCUT]s
  afile: TextFile;
  ts: String;
Begin

{show properties of cursored object}

if vFiles.ItemCount = 0 then exit;

ShortcutType := 0; //not shortcut

fname := path+vFiles.Items[vFiles.ItemIndex].RealFileName;

  If (FindFirst(fname+'\*.*', faAnyFile, sr)=0) then  // 䠩    㣨 䠩 :-)
    Begin  //this is directory
    FindClose(sr);
    fsize := pdeLoadNLS('dlgPropertiesSize', ':')
      +' ['+pdeLoadNLS('dlgPropertiesSize1', '।')+']';
    rez:=FindFirst(fname, faAnyFile, sr);
    if rez=0 then
      begin
      ch[1] := ((sr.attr and faSysFile)<>0);
      ch[2] := ((sr.attr and faHidden)<>0);
      ch[3] := ((sr.attr and faReadOnly)<>0);
      ch[4] := ((sr.attr and faArchive)<>0);
      end;
    fprog := pdeLoadNLS('dlgPropertiesProgram', 'ணࠬ')+': "FileHalf"';
    End
  Else
    Begin //this is file
    FindClose(sr);
    rez:=FindFirst(fname, faAnyFile, sr);
    if rez=0 then
      begin
      fsize := pdeLoadNLS('dlgPropertiesSize', ':')+' '+
        IntToStr(sr.size)+' '+pdeLoadNLS('statusBytes', '');
      ch[1] := ((sr.attr and faSysFile)<>0);
      ch[2] := ((sr.attr and faHidden)<>0);
      ch[3] := ((sr.attr and faReadOnly)<>0);
      ch[4] := ((sr.attr and faArchive)<>0);

      fprog := pdeLoadNLS('dlgPropertiesProgram', 'ணࠬ')+': '+
        pdeLoadNLS('dlgPropertiesProgramUnknown', '।');

      if (assocCount > 0) then
        for i:=1 to assocCount do
          if LowerCase(extractfileext(fname))=assoc[i].flt then
          begin //find associations
          fprog:=pdeLoadNLS('dlgPropertiesProgram', 'ணࠬ')+': '+assoc[i].pgm;
          if (assoc[i].pgm = 'TYPE') then
            fprog:=pdeLoadNLS('dlgPropertiesProgram', 'ணࠬ')+': '
              +pdeLoadNLS('dlgPropertiesProgram', 'ணࠬ');
          break;
          end;
      end
    else
      begin
      PropForm.LSize.Caption:='';

      end;

    //check if file is [SHORTCUT]
    try
      AssignFile(afile, fname);
      Reset(afile);
      Readln(afile, ts);
      if ts='[SHORTCUT]' then
       begin
       readln(afile);
       readln(afile, ts);
       if (ts='APP')or(ts='PDE') then
         begin
         ShortcutType := 1; //program
         end
       else if ts='FOLDER' then
         begin
         ShortcutType := 2; //folder
         end
       else if (ts='HDD') or (ts='FDD') or (ts='CD-ROM') then
         begin
         readln(afile, ts);
         drChar := ord(LowerCase(ts)[1])-96;
         ShortcutType := 3; //drive
         end;
       end;
      closefile(afile);
    except
      CloseFile(afile);
    end;

    End;

DecodeDate(FileDateToDateTime(sr.Time), Year, Month, Day);
PropForm.LChDate.Caption:=pdeLoadNLS('dlgPropertiesChanged', ':')+' '+
  IntToStr(Day)+'/'+IntToStr(Month)+'/'+IntToStr(Year);

FindClose(sr);

if (ShortcutType = 0) then
  begin //--simple file or folder--
  PropForm.LName.Caption     := vFiles.Items[vFiles.ItemIndex].RealFileName;
  PropForm.LDir.Caption      := path;
  PropForm.LSize.Caption     := fsize;
  PropForm.LProg.Caption     := fprog;
  PropForm.chSystem.Checked  := ch[1];
  PropForm.chHidden.Checked  := ch[2];
  PropForm.chReadOnly.Checked:= ch[3];
  PropForm.chArchiv.Checked  := ch[4];

  PropForm.BtnCancel.Default := True;
  PropForm.Show;
  PropForm.BringToFront;
  end
  else if (ShortcutType = 1) then
  begin //--shortcut of program--
  PropForm3.caption := pdeLoadNLS('dlgPropShortcut', 'Shortcut properties');
  PropForm3.LName.Caption     := vFiles.Items[vFiles.ItemIndex].RealFileName;
  PropForm3.LDir.Caption      := path;
  {now loading [SHORTCUT]'s data from file}
  try
    assignfile(afile, fname);
    Reset(afile);
    Readln(afile);
    Readln(afile);
    Readln(afile, ts);
    PropUnit3.LinkType := ts;
    Readln(afile, ts);
    PropForm3.edName.Text := ExtractFileName(ts);
    Readln(afile, ts);
    PropForm3.edPath.Text := ts;
    Readln(afile, ts);
    PropForm3.edParams.Text := ts;
    CloseFile(afile);
  except
    CloseFile(afile);
  end;
  PropForm3.BtnCancel.Default := True;
  PropForm3.ShowModal;
  PropForm3.BringToFront;
  end
  else if (ShortcutType = 2) then
  begin //--shortcut of folder--
  PropForm3.caption := pdeLoadNLS('dlgPropShortcut', 'Shortcut properties');
  PropForm3.LName.Caption     := vFiles.Items[vFiles.ItemIndex].RealFileName;
  PropForm3.LDir.Caption      := path;
  {now loading [SHORTCUT]'s data from file}
  try
    assignfile(afile, fname);
    Reset(afile);
    Readln(afile);
    Readln(afile);
    Readln(afile, ts);
    PropUnit3.LinkType := ts;
    Readln(afile, ts);
    PropForm3.edName.Text := ts;
    Readln(afile, ts);
    PropForm3.edPath.Text := ts;
    Readln(afile, ts);
    PropForm3.edParams.Text := ts;
    CloseFile(afile);
  except
    CloseFile(afile);
  end;
  PropForm3.BtnCancel.Default := True;
  PropForm3.ShowModal;
  PropForm3.BringToFront;
  end
  else if (ShortcutType = 3) then
  begin //--shortcut of drive--
  PropForm2.LName.Caption     := vFiles.Items[vFiles.ItemIndex].RealFileName;
  PropUnit2.drSize := DiskSizeKb(drChar);
  PropUnit2.drFree := DiskFreeKb(drChar);
  PropForm2.LSize.Caption     := pdeLoadNLS('dlgPropertiesSize', 'Size:');
  PropForm2.LUsed.Caption     := pdeLoadNLS('dlgPropertiesUsed', 'Used:');
  PropForm2.LFree.Caption     := pdeLoadNLS('dlgPropertiesFree', 'Free:');
  PropForm2.LSize1.Caption    := IntToStr(PropUnit2.drSize) +' '+ pdeLoadNLS('statusKBytes', '');
  PropForm2.LUsed1.Caption    := IntToStr(PropUnit2.drSize-PropUnit2.drFree) +' '+ pdeLoadNLS('statusKBytes', '');
  PropForm2.LFree1.Caption    := IntToStr(PropUnit2.drFree) +' '+ pdeLoadNLS('statusKBytes', '');
  PropForm2.BtnCancel.Default := True;
  PropForm2.ShowModal;
  PropForm2.BringToFront;
  end;

End;

Procedure TMainForm.bRefreshOnClick (Sender: TObject);
Begin

  //--refresh contents of ListView--
  LoadList;

End;

Procedure TMainForm.bNewOnClick (Sender: TObject);
var
  newname: String;
Begin

  {-- create new folder and, if succses, go into it --}
  newname := pdedlgsdll.pdePromptDialog(pdeLoadNLS('pdeDlgCreateFolder', '   ')
    , pdeLoadNLS('pdeDlgHint5', ' '), 'new');
  if newname <> '' then
    begin
    if DosCreateDir(Path + newname, nil) <> 0 then
      pdeMessageBoxC(pdeLoadNLS('dlgErrorOnFolderCreate', 'H 㤠 ᮧ .')
        +chr(13)+chr(10)+newname, pdeLoadNLS('dlgError', '訡'), bNew.Glyph)
      else
      begin
      //--add new folder item to ListView--
      //vFiles.AddFN(CorectCaption(newname), newname, Pointer(0), nil, aIc[1]);
      Path := Path+newname+'\';
      edPath.Text:=Path;
      LoadList;
      end;
    end

End;

Procedure TMainForm.bFindOnClick (Sender: TObject);
Begin

  {start file find utility}
  if findUtil<>'' then
  begin
  if findutil[2] <> ':' then // path from [PDE_HOME]\Utils\
    ShellExecute(ExtractFilePath(Application.Exename)+findUtil, path, path, false)
  else
    ShellExecute(findUtil, path, path, false);
  end;

End;

Procedure TMainForm.bRenameOnClick (Sender: TObject);
var
  a_index: Integer;
  prevname, newname: String;
Begin

  {rename}
  if vFiles.ItemCount>0 then
  begin
  prevname := vFiles.Items[vFiles.ItemIndex].RealFileName;
  newname := pdedlgsdll.pdePromptDialog(pdeLoadNLS('dlgDestName', ' :')
    , pdeLoadNLS('dlgRenaming', '२'), prevname);
  if newname <> '' then
    if ObjRename(path+prevname, path+newname) = 0 then
    begin
    //a_index:=vFiles.ItemIndex;
    //LoadList;
    //vFiles.ItemIndex:=a_index;
    vFiles.Items[vFiles.ItemIndex].RealFileName := newname;
    vFiles.Items[vFiles.ItemIndex].Text := CorectCaption(newname);
    end;
  WinSetActiveWindow(HWND_DESKTOP, MainForm.Handle);

end;

End;

Procedure TMainForm.bDeleteOnClick (Sender: TObject);
var
  fname: string;
//  a_index: integer;
  rez: Integer;
Begin

//-----delete button-----
if (vFiles.ItemCount=0) and (l_case.Items.Count = 0) then exit;

fname := mVCase.Caption;
if l_case.Items.Count = 0 then
  fname:=path+vFiles.Items[vFiles.ItemIndex].RealFileName;
rez := 0;

if (pdeLoadCfgInt('general.cfg', 'askfordelete') = 1) then
  begin
  if (pdeMessageBoxC(chr(13)+chr(10)+pdeLoadNLS('dlgDelete', ':')+' '+fname+'?',
    pdeLoadNLS('dlgAffirmate', '⢥न')+' '+
    pdeLoadNLS('dlgDeleting', ''), bDelete.Glyph) = 0) then
    rez := 1;
  end
  else
    begin
    rez := 1;
    if l_case.Items.Count > 0 then
      if (pdeMessageBoxC(chr(13)+chr(10)+pdeLoadNLS('dlgDelete', ':')+' '+fname+'?',
    pdeLoadNLS('dlgAffirmate', '⢥न')+' '+
    pdeLoadNLS('dlgDeleting', ''), bDelete.Glyph) <> 0) then
      rez := 0;

    end;

if (rez = 1) then
  begin
  //l_case.Clear;
  if l_case.Items.Count = 0 then
    l_case.Items.Add(fname);
  l_case_dest := '';
  OpComodo('2', pdeLoadNLS('dlgDeleting', ''));

  end;
WinSetActiveWindow(HWND_DESKTOP, MainForm.Handle);

End;

Procedure TMainForm.bMoveOnClick (Sender: TObject);
var
  src, dest: String;
  needBytes, isBytes: LongInt;
  //a_index: integer;
  cmdTr: TCMDThread;
Begin

//--move button--
if (vFiles.ItemCount=0) and (l_case.Items.Count = 0) then exit;

dest := pdeChooseDirDialog(pdeLoadNLS('dlgMoving', '६饭')
  , pdeLoadNLS('dlgChooseDest', 'Choose destination folder:'));
if dest <> '' then
  begin
  if l_case.Items.Count = 0 then
      l_case.Items.Add(path+vFiles.Items[vFiles.ItemIndex].RealFileName);
    l_case_dest := dest + '\';
    OpComodo('1', pdeLoadNLS('dlgMoving', '६饭'));
  end;

{
src := mVCase.Caption;
if l_case.Items.Count = 0 then
  src := path+vFiles.Items[vFiles.ItemIndex].RealFileName;
dest := pdeCopyDialog(ExtractFileName(src), pdeLoadNLS('dlgMoving', '६饭'));
if dest<>'' then
  begin
  needBytes := CalcTreeSize(src) div 1024;
  isBytes   := DiskFreeKb(ord(LowerCase(dest)[1])-96);
  if (needBytes<isBytes) then
    begin
    //l_case.Clear;
    if l_case.Items.Count = 0 then
      l_case.Items.Add(path+vFiles.Items[vFiles.ItemIndex].RealFileName);
    l_case_dest := ExtractFilePath(dest);
    OpComodo('1', pdeLoadNLS('dlgMoving', '६饭'));
    end
  else
  pdeMessageBoxC(pdeLoadNLS('dlgErrorDiskSpace', '筮   楫 ᪥.')
    +chr(10)+chr(13)+IntToStr(isBytes)+pdeLoadNLS('statusKBytes', 'Kb')
    +' '+pdeLoadNLS('dlgErrorVS', '⨢')+' '
    +IntToStr(needBytes)+pdeLoadNLS('statusKBytes', 'Kb'), pdeLoadNLS('dlgError', '訡')
    , bCopy.Glyph);
  end;
}
WinSetActiveWindow(HWND_DESKTOP, MainForm.Handle);

End;

Procedure TMainForm.bCopyOnClick (Sender: TObject);
var
  src, dest: String;
  needBytes, isBytes: LongInt;
Begin

//--copy button--
if (vFiles.ItemCount=0) and (l_case.Items.Count = 0) then exit;

dest := pdeChooseDirDialog(pdeLoadNLS('dlgCopying', '஢')
  , pdeLoadNLS('dlgChooseDest', 'Choose destination folder:'));
if dest <> '' then
  begin
  if l_case.Items.Count = 0 then
      l_case.Items.Add(path+vFiles.Items[vFiles.ItemIndex].RealFileName);
    l_case_dest := dest + '\';
    OpComodo('0', pdeLoadNLS('dlgCopying', '஢'));
  end;

{
src := mVCase.Caption;
if l_case.Items.Count = 0 then
  src := path+vFiles.Items[vFiles.ItemIndex].RealFileName;

dest := pdeCopyDialog(ExtractFileName(src), pdeLoadNLS('dlgCopying', '஢'));
if dest<>'' then
  begin
  needBytes := CalcTreeSize(src) div 1024;
  isBytes   := DiskFreeKb(ord(LowerCase(dest)[1])-96);
  if (needBytes<isBytes) then
    begin
    //l_case.Clear;
    if l_case.Items.Count = 0 then
      l_case.Items.Add(path+vFiles.Items[vFiles.ItemIndex].RealFileName);
    l_case_dest := ExtractFilePath(dest);
    OpComodo('0', pdeLoadNLS('dlgCopying', '஢'));

    end
  else
  pdeMessageBoxC(pdeLoadNLS('dlgErrorDiskSpace', '筮   楫 ᪥.')
    +chr(10)+chr(13)+IntToStr(isBytes)+pdeLoadNLS('statusKBytes', 'Kb')
    +' '+pdeLoadNLS('dlgErrorVS', '⨢')+' '+IntToStr(needBytes)
    +pdeLoadNLS('statusKBytes', 'Kb'), pdeLoadNLS('dlgError', '訡')
    , bCopy.Glyph);
  end;
}
WinSetActiveWindow(HWND_DESKTOP, MainForm.Handle);

End;

Procedure TMainForm.DirsOnItemSelect (Sender: TObject; Index: LongInt);
Begin

prevDir2 := prevDir;
prevDir:=path;
path:=Dirs.Directory;
if (Path[length(Path)]<>'\') then
  path:=Path+'\';

MainForm.Caption:=path;
ShowStatus;
LoadList;

End;

Procedure TMainForm.DrivesOnChange (Sender: TObject);
Begin

End;

function TMainForm.GoInto: integer;
var
  fname: string;
Begin

  nextDir := '';
  prevDir2 := prevDir;
  prevDir := path;
  fname:=path+vFiles.Items[vFiles.ItemIndex].RealFileName;
  if (FindFirst(fname+'\*.*', faAnyFile, sr)=0) then  // 䠩    㣨 䠩 :-)
    begin  //directory
    FindClose(sr);
    path:=fname;
    Dirs.Directory:=path;
    if (Path[length(Path)]<>'\') then
      path:=Path+'\';
    edPath.Text:=Path;
    LoadList;
    end
  else
    begin
    FindClose(sr);

    if (pos('.EXE', ansiuppercase(fname))<>0)or(pos('.COM', ansiuppercase(fname))<>0)
       or(pos('.BAT', ansiuppercase(fname))<>0) then
      ShellExecute(fname, ExtractFilePath(fname), '', true)
      //StartApp(fname, ExtractFilePath(fname), '', false)
    else if (pos('.CMD', ansiuppercase(fname))<>0) then
      ShellExecute('cmd.exe', ExtractFilePath(fname), '/c "'+fname+'"', true)
    else
      ResolveAssociation(fname);
      //MessageBox('error: '+fname, mtInformation, [mbOK]);
    end;

  Result := 0;

End;

Procedure TMainForm.MainFormOnDestroy (Sender: TObject);
Begin
  for i := 1 to assocCount do
    WinFreeFileIcon(aIc[i]);  //aIc[i].Free;

End;

function TMainForm.ShowStatus: integer;
begin
//InfoMemo.Text:='';
DecodeDate(Date, Year, Month, Day);
{Infolabel.Caption:=IntToStr(day)+'/'+IntToStr(month)+'/'+IntToStr(year)+chr(13)+chr(10)+
                   Days[DayOfWeek(Date)]+chr(13)+chr(10)+TimeToStr(Time);}
//InfoMemo.Lines.Add(IntToStr(day)+'/'+IntToStr(month)+'/'+IntToStr(year));
//InfoMemo.Lines.Add(Days[DayOfWeek(Date)]);
//InfoMemo.Lines.Add(TimeToStr(Time));

{for i:=0 to vFiles.ItemCount-1 do
  if vFiles.Selected[i] then
  begin
  InfoMemo.Lines.Add(ANSIUpperCase(vFiles.Items[i].Text));
  end;
}

Result := 0;

end;

Procedure TMainForm.mOpenOnClick (Sender: TObject);
Begin
//menu Open
//vFilesOnMouseDblClick (Sender, mbLeft, [],  0, 0);
GoInto;
End;

Procedure TMainForm.vFilesOnItemSelect (Sender: TObject; Index: LongInt);
Begin
  ShowStatus;
  GoInto;
End;

Procedure TMainForm.bUpOnClick (Sender: TObject);
var
  basepath: String;
Begin

  if length(path)>3 then
  begin
  nextDir2 := nextDir;
  nextDir := path;
  delete(path, length(path), 1);
  while path[length(path)]<>'\' do
    delete(path, length(path), 1);
  path:=path;
  edPath.Text:=Path;
  LoadList;
  end
  else
  begin
  //you want to go to the Drives folder, ya :-)
  nextDir2 := nextDir;
  nextDir := path;
  basepath := getenv('PDE_HOME');
  if basepath = '' then
    basepath := 'c:\pde';
  Path := basepath + pdeLoadCfgStr('general.cfg', 'userdrives')+'\';
  edPath.Text:=Path;
  LoadList;
  end;
ShowStatus;

End;

Procedure TMainForm.MainFormOnResize (Sender: TObject);
Begin

if MainForm.ClientWidth>450 then
  begin
  if mInfoPanel.Checked then
    InfoPanel.Width:=230;//200;
  vFiles.Width:=MainForm.ClientWidth-InfoPanel.Width
  end
else
  begin
  InfoPanel.Width:=0;
  vFiles.Width:=MainForm.ClientWidth;
  end;

if id_diz_file = '' then
  begin
    Dirs.Height:=InfoPanel.Height-102;
    Dirs.Top := 102;
    l_case.height := Dirs.Height;
    l_case.top :=  Dirs.Top;
    Drives.Top := 85;
  end
  else
  begin
    Dirs.Height:=InfoPanel.Height-207;
    Dirs.Top := 207;
    l_case.height := Dirs.Height;
    l_case.top :=  Dirs.Top;
    Drives.Top := 190;
  end;

  //l_Case.Height:=InfoPanel.Height-84;
  //l_Case.Top := 84;

if resolved_preview then
  begin
    Dirs.Height:=InfoPanel.Height-207;
    Dirs.Top := 207;
    l_case.height := Dirs.Height;
    l_case.top :=  Dirs.Top;
    Drives.Top := 190;
  end;
//Resolve_One_PreView;

End;

Procedure TMainForm.MainFormOnCreate (Sender: TObject);
var
  afile: TextFile;
  itext, ihint{, ftype, fbmp, fprg}: string;
  tsr: TSearchRec;
  rez: Integer;
  basepath: String;
Begin
//Application.OnShowHint:=FormShowHint;
Application.HintPause:=0;
Days[1]:=pdeLoadNLS('daySundayLong', 'ᥭ');
Days[2]:=pdeLoadNLS('dayMondayLong', '쭨');
Days[3]:=pdeLoadNLS('dayTuesdayLong', '୨');
Days[4]:=pdeLoadNLS('dayWednesdayLong', '।');
Days[5]:=pdeLoadNLS('dayThursdayLong', '⢥');
Days[6]:=pdeLoadNLS('dayFridayLong', '⭨');
Days[7]:=pdeLoadNLS('daySaturdayLong', '㡮');

//--current FileHalfs' THEME and pIctograms ITHEME
Theme := pdeLoadCfgStrD('filehalf.cfg', 'Theme', 'Default_theme');
ITheme := pdeLoadCfgStrD('filehalf.cfg', 'ITheme', 'Default_theme');

//㧪 樠権
if FileExists(extractfilepath(application.exename)+'\PDEConf\Associations.cfg') then
begin
assignfile(afile, extractfilepath(application.exename)+'\PDEConf\Associations.cfg');
reset(afile);
readln(afile); //header
readln(afile); //header
assocCount:=0;
while not(eof(afile)) do
  begin
  inc(assocCount);
  readln(afile, assoc[assocCount].flt);
  readln(afile, assoc[assocCount].pgm);
  readln(afile, assoc[assocCount].bmp);
  readln(afile);
  end;
closefile(afile);
end;

//--loading "Quick Run" list--
mQuickRun.submenu:=true;
if FileExists(extractfilepath(application.exename)+'\PDEConf\quickrun.cfg') then begin
assignfile(afile, extractfilepath(application.exename)+'\PDEConf\quickrun.cfg');
reset(afile);
while not(eof(afile)) do
  begin
  quickmitem:=TMenuItem.Create(self);
  readln(afile, itext);
  readln(afile, ihint);
  quickmitem.Caption:=itext;
  quickmitem.hint:=ihint;
  quickmitem.onclick:=QuickMenuClick;
  mQuickRun.add(quickmitem);
  end;
closefile(afile);
end;

//--loading submenu "Open with"--
mOpenWith.submenu:=true;
if FileExists(extractfilepath(application.exename)+'\PDEConf\openwith.cfg') then
begin
  assignfile(afile, extractfilepath(application.exename)+'\PDEConf\openwith.cfg');
  reset(afile);
  while not(eof(afile)) do
    begin
    openwithitem := TMenuItem.Create(self);
    readln(afile, itext);
    readln(afile, ihint);
    openwithitem.Caption:=itext;
    openwithitem.hint:=ihint;
    openwithitem.onclick := OpenWithMenuClick;
    //mOpenWith.add(openwithitem);
    mOpenWith.Insert(0, openwithitem);
    end;
  closefile(afile);
end;

//--loading "Bookmarks"--
mBookmarks.Submenu:=true;

basepath := getenv('PDE_HOME');
  if basepath = '' then
    basepath := 'c:\pde';

rez:=FindFirst(basepath+pdeLoadCfgStr('general.cfg', 'userbookmarks')+'\*.*', faAnyFile, tsr);
if rez<>0 then exit;
  while rez=0 do
    begin
    rez:=FindNext(tsr);
    if rez<>0 then break;
    if (tsr.attr and faDirectory)=0 then //file
      begin
      assignfile(afile, basepath+pdeLoadCfgStr('general.cfg', 'userbookmarks')+'\'+tsr.name);
      reset(afile);
      readln(afile); readln(afile); readln(afile);
      readln(afile, itext);

      bookitem:=TMenuItem.Create(self);
      bookitem.Caption:=tsr.name;
      bookitem.hint:=itext;
      bookitem.onclick:=BookMarkClick;
      mBookmarks.add(bookitem);

      closefile(afile);
      end;
    end;
FindClose(tsr);

//--Some another config loading--
FileHalfCfg;

//"BRIEFCASE" for copy/move/delete
//l_case := TStringList.Create;
l_case2 := TStringList.Create;

End;

Procedure TMainForm.bGoOnClick (Sender: TObject);
Begin
  path:=edPath.Text;
  LoadList;
  ShowStatus;
End;

Procedure TMainForm.Form1OnShow (Sender: TObject);
var
  col: Integer;
Begin
//--This event occur just before forms' window will appear on the screen--
filter:='*.*';

if assocCount>0 then
  for i:=1 to assocCount do
    begin
    //aIc[i].create;
    //if FileExists(extractfilepath(application.exename)+'Bitmaps\'+ITheme+'\FileTypes\'+assoc[i].bmp) then
      //aIc[i].LoadFromFile(extractfilepath(application.exename)+'Bitmaps\'+ITheme+'\FileTypes\'+assoc[i].bmp);
    aIc[i] := WinLoadFileIcon(extractfilepath(application.exename)+'Bitmaps\'+ITheme+'\FileTypes\'+assoc[i].bmp, false);
    end;
//--look, if we have parameters--
if ParamStr(1)<>'' then
  begin
  path:='';
  for i:=1 to paramcount do
    path:=path+ParamStr(i)+' ';
  Delete(path, length(path), 1);
  end
else
  begin
  path:='c:\';
  end;

MainForm.ActiveControl:=vFiles;
LoadList;

//--set type of view, found in config file--
col := pdeLoadCfgInt('filehalf.cfg', 'ViewType');
  if col = 1 then mTileOnClick(mainform)
  else if col = 2 then mSmallIconsOnClick(mainform)
  else if col = 3 then mFlowOnClick(mainform)
  else if col = 4 then mAsTextOnClick(mainform);

Dirs.Directory:=path;
ShowStatus;
Drives.Drive := path[1];

End;

//--loading folders and files to the ListView--
function TMainForm.LoadList: integer;
var
  rez: integer;
  attr: byte;
  afile: TextFile;
  ftype: string;
  dfree: LongInt;
  basepath: String;
  dirList: TStringList;
  sortCount: Integer;
  prExt: String;
  loaded: Integer;
Begin

loaded := 0;
rez:=0;
count:=0;
MainForm.Caption:=path;
prList.Free;
prList2.Free;
prList := TStringList.Create;
prList2 := TStringList.Create;

basepath := getenv('PDE_HOME');
  if basepath = '' then
    basepath := 'c:\pde';

if (ansiuppercase(MainForm.Caption)=ansiuppercase(basepath+pdeLoadCfgStr('general.cfg', 'userdrives')+'\')) then
  MainForm.Caption:='/';
if (Path<>'') then
  begin
  LoadListProgress.Position := 0;
  LoadListProgress.Caption := '0';
  LoadListProgress.Visible := True;
  vFiles.BeginUpdate;
  vFiles.Clear;
  LoadListProgress.Position := 20;
  attr:=faReadOnly Or faSysFile Or faDirectory Or faArchive;
  if mShowHidden.Checked then attr := attr Or faHidden;
  rez:=FindFirst(Path+'*.*'{filter}, attr{faAnyFile}, sr);
  if rez<>0 then begin FindClose(sr); vFiles.EndUpdate; LoadListProgress.Visible:=False; exit; end;

  dirList := TStringList.Create;

  while rez=0 do
    begin
    rez:=FindNext(sr);
    if rez<>0 then break;
    if (sr.attr and faDirectory)<>0 then
      if sr.name<>'..' then
      begin
      inc(count);
      dirList.Add(sr.name);
      LoadListProgress.Caption := IntToStr(count); //already loaded indicator
      end;
    end;
  FindClose(sr);

  //tmpEx := TIcon.Create; {for bitmaps with the same name as Folders}
  dirList.Sort;
  if dirList.Count > 0 then
  for sortCount := 0 to dirList.Count - 1 do
    begin
    {tmpExStr := pdeLoadCfgStr(path + 'folder.pde', dirList.Strings[sortCount]);
    if (tmpExStr <> '') and FileExists(tmpExStr) then
      begin
        try
        tmpEx.LoadFromFile(tmpExStr);
        except
        tmpEx.Free;
        tmpEx := TIcon.Create;
        tmpEx := TIcon(tmp.Copy);
        end;
      vFiles.AddFN(CorectCaption(dirList.Strings[sortCount]), dirList.Strings[sortCount], Pointer(0), nil, tmpEx);
      end
    else}
      //vFiles.AddFN(CorectCaption(dirList.Strings[sortCount]), dirList.Strings[sortCount], Pointer(0), nil, tmp);
      vFiles.AddFN(CorectCaption(dirList.Strings[sortCount]), dirList.Strings[sortCount], Pointer(0), nil, aIc[1]);
    end;
  //tmpEx.Free;
  dirList.Free;

  LoadListProgress.Position := 60;

  rez:=FindFirst(Path+filter, attr{faAnyFile}, sr);
  if rez<>0 then begin FindClose(sr); vFiles.EndUpdate; LoadListProgress.Visible:=False; exit; end;

  // ⮣     ⠫
  //⮫쪮  FAT32, FAT16 ᪠
  if sr.name<>'.' then
    begin
    inc(count);
    if (sr.attr and faDirectory)<>0 then
      //vFiles.AddFN(CorectCaption(sr.name), sr.name, Pointer(sr.size), nil, tmp)
      vFiles.AddFN(CorectCaption(sr.name), sr.name, Pointer(sr.size), nil, aIc[1])
    else
      begin
      prExt := UpperCase(ExtractFileExt(sr.name));
      {if (mShowPreview.Checked) and ((prExt = '.PCX') or (prExt = '.GIF')
        or (prExt = '.JPEG') or (prExt = '.JPG') or (prExt = '.JPE') or
        (prExt = '.RLE') or (prExt = '.TIF') or (prExt = '.TIFF') or
        (prExt = '.TGA') or (prExt = '.DIB') or (prExt = '.IFF') or
        (prExt = '.XBM') or (prExt = '.IMG') or (prExt = '.VGA')) then
                begin
                  prList.Add(path + sr.name);
                  prList2.Add(IntToStr(vFiles.ItemCount));
                end
      else if (mShowPreview.Checked) and}
      {28.05.04 commented due to TIcon -> changed to LongWord
       if (prExt = '.ICO') or (prExt = '.PTR') then
        begin
          try
          _tmp := TIcon.Create;
          _tmp.LoadFromFile(path + sr.name);
          except
          _tmp.free;
          _tmp := TIcon(aIc[5].Copy);
          end;
          vFiles.AddFN(CorectCaption(sr.name), sr.name, Pointer(sr.size), nil, _tmp);
          _tmp.free;
        end
      else
        begin}
        if assocCount>0 then
          for i:=1 to assocCount do
            if (pos(assoc[i].flt, lowercase(sr.name))=(length(sr.name)-length(assoc[i].flt)+1)) then
              begin
              vFiles.AddFN(CorectCaption(sr.name), sr.name, Pointer(sr.size), nil, aIc[i]);
              break;
              end;
        //end;
      i:=0;
      end;
    end;
  //-----------------------------------------

  while rez=0 do
    begin
    Application.ProcessMessages;
    rez:=FindNext(sr);
    if rez<>0 then break;
    if (sr.attr and faDirectory)=0 then
    begin
      inc(count);
      LoadListProgress.Caption := IntToStr(count); //already loaded indicator

      prExt := UpperCase(ExtractFileExt(sr.name));
      {if (mShowPreview.Checked) and ((prExt = '.PCX') or (prExt = '.GIF')
        or (prExt = '.JPEG') or (prExt = '.JPG') or (prExt = '.JPE') or
        (prExt = '.RLE') or (prExt = '.TIF') or (prExt = '.TIFF') or
        (prExt = '.TGA') or (prExt = '.DIB') or (prExt = '.IFF') or
        (prExt = '.XBM') or (prExt = '.IMG') or (prExt = '.VGA')) then
                begin
                  prList.Add(path + sr.name);
                  prList2.Add(IntToStr(vFiles.ItemCount));
                  i := 0;
                end
        else if (mShowPreview.Checked) and}
        {28.05.04 commented due to TIcon -> changed to LongWord
        if (prExt = '.ICO') or (prExt = '.PTR') then
        begin
          try
          _tmp := TIcon.Create;
          _tmp.LoadFromFile(path + sr.name);
          except
          _tmp.free;
          _tmp := TIcon(aIc[5].Copy);
          end;
          vFiles.AddFN(CorectCaption(sr.name), sr.name, Pointer(sr.size), nil, _tmp);
          _tmp.free;
          i := 0;
        end
      else
        begin}
        if assocCount>0 then
          for i:=1 to assocCount do
            if (pos(assoc[i].flt, lowercase(sr.name))=(length(sr.name)-length(assoc[i].flt)+1)) then
              begin
              vFiles.AddFN(CorectCaption(sr.name), sr.name, Pointer(sr.size), nil, aIc[i]);
              i:=0;
              break;
              end;
        //end;

     //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

     if (i<>0) and (pos('.', sr.name)=0) then
     begin
     i:=1;
     assignfile(afile, path+sr.name);
     reset(afile);
     readln(afile, ftype);
     if ftype='[SHORTCUT]' then
       begin
       i:=0;
       readln(afile);
       readln(afile, ftype);
       if (ftype='APP')or(ftype='PDE') then
         vFiles.AddFN(CorectCaption(sr.name), sr.name, Pointer(sr.size), nil, aIc[6])
       else if ftype='FOLDER' then
         vFiles.AddFN(CorectCaption(sr.name), sr.name, Pointer(sr.size), nil, aIc[1])
       else if ftype='HDD' then
         vFiles.AddFN(CorectCaption(sr.name), sr.name, Pointer(sr.size), nil, aIc[2])
       else if ftype='FDD' then
         vFiles.AddFN(CorectCaption(sr.name), sr.name, Pointer(sr.size), nil, aIc[3])
       else if ftype='CD-ROM' then
         vFiles.AddFN(CorectCaption(sr.name), sr.name, Pointer(sr.size), nil, aIc[4]);
       end;
     closefile(afile);
     end;

    if i<>0 then //unknown file type
      vFiles.AddFN(CorectCaption(sr.name), sr.name, Pointer(sr.size), nil, aIc[5]);

    end;
    end;
  FindClose(sr);
  LoadListProgress.Position := 80;

  dfree := DiskFreeKb(ord(LowerCase(path)[1])-96);
  ToolBar1.Panels[2].Text:=IntToStr(count)+pdeLoadNLS('statusObjects', '.');
  ToolBar1.Panels[3].Text:='';
  if dfree < 1024 then
    ToolBar1.Panels[3].Text:=pdeLoadNLS('statusAvaible', '㯭')+' '+IntToStr(dfree)+
      pdeLoadNLS('statusKBytes', '')+' '+pdeLoadNLS('statusOf', '')+' '+
      FloatToStrF(DiskSizeKb(ord(LowerCase(path)[1])-96)/1024, ffFixed, 2, 2)+pdeLoadNLS('statusMBytes', '')
  else
    ToolBar1.Panels[3].Text:=pdeLoadNLS('statusAvaible', '㯭')+' '+FloatToStrF(dfree/1024, ffFixed, 2, 2)+
      pdeLoadNLS('statusMBytes', '')+' '+pdeLoadNLS('statusOf', '')+' '+
      FloatToStrF(DiskSizeKb(ord(LowerCase(path)[1])-96)/1024, ffFixed, 2, 2)+pdeLoadNLS('statusMBytes', '');

  ToolBar1.Update;
  edPath.Text:=path;
  LoadListProgress.Position := 90;
  vFiles.EndUpdate;
  LoadListProgress.Visible := False;
  end;

Check_L_Case;

Resolve_Id_diz;

//if (mShowPreview.Checked) then LoadToPreview;

Result := 0;

End;

function TMainForm.ShellExecute(fname, fdir, fparam: string; shortcut: boolean): Boolean;
begin
  Result := _ShellExecute(fname, fdir, fparam, shortcut, ssf_Fgbg_Fore
    , ssf_Control_Visible, ssf_Related_Independent);
end;

function TMainForm._ShellExecute(fname, fdir, fparam: string; shortcut: boolean; fg, pgmCntr, rel: ULong): Boolean;
var
  sd: StartData;
  idSession: ULong;
  apid: PID;
  fname2, fparam2: pchar;
  rc, rc2: APIRET;
begin
if not(shortcut) and (fparam <> '') then
  fparam:='"'+fparam+'"';  //<-  ஡    䠩
new(fname2);
new(fparam2);
StrPCopy(fname2, fname);
StrPCopy(fparam2, fparam);

//fparam2:=StrCat(fname2, fparam2);

with sd do
  begin
      Length   := sizeof(StartData);
      Related  := rel;//ssf_Related_Independent; // start an independent session
      FgBg     := fg;//ssf_Fgbg_Fore;           // start session in foreground
      TraceOpt := ssf_TraceOpt_None;       // No trace
      PgmTitle := fname2;
      PgmName := fname2;
      PgmInputs :=fparam2;
      TermQ := nil;                        // No termination queue
      Environment := nil;                  // No environment string
      InheritOpt := ssf_InhertOpt_Parent;
      SessionType := ssf_Type_Default;
      IconFile := nil;                     // No icon association
      PgmHandle := 0;
      PgmControl := pgmCntr;//ssf_Control_Visible;
      InitXPos  := 0;     // Initial window coordinates
      InitYPos  := 0;
      InitXSize := 200;    // Initial window size
      InitYSize := 140;
      Reserved := 0;
      ObjectBuffer  := nil;
      ObjectBuffLen := 0;
  end;

if length(fdir)>3 then
  Delete(fdir, length(fdir), 1); //delete "\"

//rc:=DosSetCurrentDir(fdir);
SysDirSetCurrent(fdir);

rc2:=DosStartSession(sd, idSession, apid);
if (rc2 = 2) then
  //--30.05.04 stVova--
  // ⮫  ﬨ,     ⢥ ⥪饩 ४ਨ
  //⮩,  ன 室 FileHalf,  ணࠬ (... ᪠  吝 ᫮...)
  // 室 ᢮  (Qu/2, SysInfo, VP/2, ...) (,  ࠧ 㤭 㧭 ,   EXE ,  ???)
  // ᮮ Error 2 = FILE_NOT_FOUND.
  // ,   ⠭   
  begin
  fdir := ExtractFilePath(fname);
  Delete(fdir, length(fdir), 1);
  SysDirSetCurrent(fdir);
  rc2:=DosStartSession(sd, idSession, apid);
  end;
  //-------------------------------

freemem(fname2, sizeof(fname2));
freemem(fparam2, sizeof(fparam2));

if rc2 <> 0 then //ERROR!!!
  if ExtractFileName(fname) <> 'comodo.exe' then
  if pdeloadcfgint('general.cfg', 'execerrors') = 1 then
  pdeMessageBoxC(pdeLoadNLS('dlgRunErrorProgram', 'ணࠬ:')+' '+fname+chr(13)+
    chr(10)+pdeLoadNLS('dlgErrorCode', ' 訡:')+' '+IntToStr(rc2)
  , pdeLoadNLS('dlgRunErrorCaption', '訡 ᪠'), bNewWindow.Glyph);

  Result := True;

end;

function TMainForm.ResolveAssociation(fname: string): integer;
var
  afile: textfile;
  ftype, aname, apath, aparams: string;
Begin
//।塞  ७ 䠩,  ணࠬ 
if assocCount>0 then
  for i:=1 to assocCount do
    begin
    if (pos(assoc[i].flt, LowerCase(fname))<>0) then
      begin
      if lowercase(ExtractFileExt(assoc[i].pgm)) = '.cmd' then
        shellexecute('cmd.exe', Path, '/c "'+assoc[i].pgm+' "'+fname+'""', true)
        //shellexecute('cmd.exe', Path, '/c ""'+assoc[i].pgm+'" '+fname+'"', true)
      else
        shellexecute(assoc[i].pgm, Path, fname, false);
        //shellexecute(assoc[i].pgm, ExtractFilePath(assoc[i].pgm), fname, false);
      exit;
      end;
    end;

//is this shortcut?
     assignfile(afile, fname);
     reset(afile);
     readln(afile, ftype);
     if ftype='[SHORTCUT]' then
       begin
       i:=0;
       readln(afile);
       readln(afile, ftype);
       if ftype='APP' then
         begin
         readln(afile, aname);
         readln(afile, apath);
         readln(afile, aparams);
         ShellExecute(aname, apath, aparams, true);
         end
       else if ftype='FOLDER' then
         begin
         readln(afile, aname);
         //ShellExecute(extractfilepath(application.exename)+'FileHalf.exe', '', aname);
         path:=aname;
         Dirs.Directory:=path;
         edPath.Text:=Path;
         LoadList;
         end
       else if ftype='HDD' then
         begin
         readln(afile, aname);
         //ShellExecute(extractfilepath(application.exename)+'FileHalf.exe', '', aname);
         path:=aname;
         Dirs.Directory:=path;
         edPath.Text:=Path;
         LoadList;
         end
       else if ftype='FDD' then
         begin
         readln(afile, aname);
         //ShellExecute(extractfilepath(application.exename)+'FileHalf.exe', '', aname);
         path:=aname;
         Dirs.Directory:=path;
         edPath.Text:=Path;
         LoadList;
         end
       else if ftype='CD-ROM' then
         begin
         readln(afile, aname);
         //ShellExecute(extractfilepath(application.exename)+'FileHalf.exe', '', aname);
         path:=aname;
         Dirs.Directory:=path;
         edPath.Text:=Path;
         LoadList;
         end;
       end;
     closefile(afile);

  Result := 0;

End;

Procedure TMainForm.QuickMenuClick(Sender: TObject);
begin

  {QuickRun menu item}
  //--work dir = program path--
  //ShellExecute(TMenuItem(Sender).Hint, ExtractFilePath(TMenuItem(Sender).Hint), '', false);
  //--work dir = current path--
  ShellExecute(TMenuItem(Sender).Hint, Path, '', false);

end;

Procedure TMainForm.OpenWithMenuClick(Sender: TObject);
var
  t: string;
begin

  {Open With... menu item}
  if (vFiles.ItemCount > 0) then
    begin
    t := TMenuItem(Sender).Hint;
    //--check, if this program from [PDE_HOME] folder--
    if FileExists(ExtractFilePath(Application.ExeName)+t) then
      t := ExtractFilePath(Application.ExeName)+t;

    if (pos('.CMD', ansiuppercase(t))<>0) then
      //ShellExecute('cmd.exe', Path, '/c ""'+t+'" '+vFiles.Items[vFiles.ItemIndex].RealFileName+'"', true)
      ShellExecute('cmd.exe', Path, '/c "'+t+' "'+vFiles.Items[vFiles.ItemIndex].RealFileName+'""', true)
      ////shellexecute('cmd.exe', Path, '/c "'+assoc[i].pgm+' "'+fname+'""', true)
    else
      ShellExecute(t, Path, path+vFiles.Items[vFiles.ItemIndex].RealFileName, false);
    end;

end;

Procedure TMainForm.BookMarkClick(Sender: TObject);
begin

  //ShellExecute(extractfilepath(application.exename)+'FileHalf.exe', '',TMenuItem(Sender).Hint, false);
  path:=TMenuItem(Sender).Hint;
  edPath.Text:=Path;
  LoadList;
  ShowStatus;

end;

function TMainForm.FileHalfCfg: Integer;
var
  fbase{, fbtn}, fbmp, fupbmp: String;
  tbmp: TPicture;
//  keym: String;
//  keyc: TKeyCode;
  col: Integer;
Begin

//fbase := ExtractFilePath(application.exename)+'\Bitmaps\FileHalf\';
fbase := ExtractFilePath(application.exename)+'\Bitmaps\'+Theme+'\FileHalf\';

tbmp:=TPicture.Create(Self);

//vFiles.Color:=pdeLoadCfgColor('filehalf.cfg', 'FileListColor');
MainForm.Color:=pdeLoadThemeColor(Theme, 'ToolbarColor');
vFiles.Color:=pdeLoadThemeColor(Theme, 'FileListColor');
vFiles.PenColor:=pdeLoadThemeColor(Theme, 'FileListTextColor');

//iconsize:=pdeLoadCfgIntD('filehalf.cfg', 'FilelistIconSize', 32);
//iconsize:=pdeLoadThemeIntD(Theme, 'FilelistIconSize', 32);
iconsize := WinQuerySysValue(HWND_DESKTOP, SV_CXICON);
vFiles.BitmapSize.CX:=iconsize;
vFiles.BitmapSize.CY:=iconsize;

//Toolbar2.Color:=pdeLoadCfgColor('filehalf.cfg', 'ToolbarColor');
Toolbar1.Color:=pdeLoadThemeColor(Theme, 'ToolbarColor');
  bGo.Color:=Toolbar1.Color;
  bGo.PenColor:=pdeLoadThemeColor(Theme, 'ToolbarTextColor');
  edPath.Color:=Toolbar1.Color;
  edPath.PenColor:=bGo.PenColor;
Toolbar2.Color:=Toolbar1.Color;

Drives.Color:=pdeLoadThemeColor(Theme, 'InfobarColor');
Drives.PenColor:=pdeLoadThemeColor(Theme, 'InfobarTextColor');
Dirs.Color:=Drives.Color;
Dirs.PenColor:=Drives.PenColor;
l_case.Color:=Drives.Color;
l_case.PenColor:=Drives.PenColor;
InfoPanel.Color:=Drives.Color;
InfoLabel.Color:=Drives.Color;
InfoLabel.PenColor:=Drives.PenColor;
InfoScroll.Color:=Drives.Color;

//col := pdeLoadCfgIntD('filehalf.cfg', 'ToolbarSize', 32) + 4;
col :=pdeLoadThemeIntD(Theme, 'ToolbarSize', 36);
fbmp := '';
//fbmp := pdeLoadCfgStr('filehalf.cfg', 'ToolBarImage');
fbmp:=pdeLoadThemeStr(Theme, 'ToolBarImage');
if fbmp <> '' then
  begin
  if fileexists(fbase+fbmp) then
  PanImage.Bitmap.LoadFromFile(fbase+fbmp);
  PanImage.Visible := True;
  end;

if fileexists(fbase+'OS2Logo.bmp') then
  Image1.Bitmap.LoadFromFile(fbase+'OS2Logo.bmp');

SetButtonsTextNPos(col);

ToolBar2.Height:=bBack.Height+4;

col := pdeLoadCfgInt('filehalf.cfg', 'ShowInfoPanel'); //show InfoPanel
if col=0 then mInfoPanelOnClick(mainform);
col := pdeLoadCfgInt('filehalf.cfg', 'ShowStatus'); //show StatusBar
if col=0 then mStatusOnClick(mainform);
col := pdeLoadCfgInt('filehalf.cfg', 'ShowButtons'); //show Buttons
if col=0 then mButtonsOnClick(mainform);

//--backward---
fbmp := 'backward.bmp';
fupbmp := 'backward2.bmp';
if fileexists(fbase+fbmp) then begin
  tbmp.LoadFromFile(fbase+fbmp);
  bBack.Glyph.LoadFromBitmap(tbmp.Bitmap); end;
if fileexists(fbase+fupbmp) then begin
  tbmp.LoadFromFile(fbase+fupbmp);
  bBack.GlyphUp.LoadFromBitmap(tbmp.Bitmap); end;
bBack.Hint:=pdeLoadNLS('BackwardButton', '');
//--forward---
fbmp := 'forward.bmp';
fupbmp := 'forward2.bmp';
if fileexists(fbase+fbmp) then begin
  tbmp.LoadFromFile(fbase+fbmp);
  bForward.Glyph.LoadFromBitmap(tbmp.Bitmap); end;
if fileexists(fbase+fupbmp) then begin
  tbmp.LoadFromFile(fbase+fupbmp);
  bForward.GlyphUp.LoadFromBitmap(tbmp.Bitmap); end;
bForward.Hint:=pdeLoadNLS('ForwardButton', '।');
//updir
fbmp := 'goup.bmp';
fupbmp := 'goup2.bmp';
if fileexists(fbase+fbmp) then begin
  tbmp.LoadFromFile(fbase+fbmp);
  bUp.Glyph.LoadFromBitmap(tbmp.Bitmap); end;
if fileexists(fbase+fupbmp) then begin
  tbmp.LoadFromFile(fbase+fupbmp);
  bUp.GlyphUp.LoadFromBitmap(tbmp.Bitmap); end;
bUp.Hint:=pdeLoadNLS('UpDirButton', ' ஢ ');
//refresh
fbmp := 'refresh.bmp';
fupbmp := 'refresh2.bmp';
if fileexists(fbase+fbmp) then begin
  tbmp.LoadFromFile(fbase+fbmp);
  bRefresh.Glyph.LoadFromBitmap(tbmp.Bitmap); end;
if fileexists(fbase+fupbmp) then begin
  tbmp.LoadFromFile(fbase+fupbmp);
  bRefresh.GlyphUp.LoadFromBitmap(tbmp.Bitmap); end;
bRefresh.Hint:=pdeLoadNLS('RefreshButton', '');
//copy
fbmp := 'copy.bmp';
fupbmp := 'copy2.bmp';
if fileexists(fbase+fbmp) then begin
  tbmp.LoadFromFile(fbase+fbmp);
  bCopy.Glyph.LoadFromBitmap(tbmp.Bitmap); end;
if fileexists(fbase+fupbmp) then begin
  tbmp.LoadFromFile(fbase+fupbmp);
  bCopy.GlyphUp.LoadFromBitmap(tbmp.Bitmap); end;
bCopy.Hint:=pdeLoadNLS('CopyButton', '஢...');
//move
fbmp := 'move.bmp';
fupbmp := 'move2.bmp';
if fileexists(fbase+fbmp) then begin
  tbmp.LoadFromFile(fbase+fbmp);
  bMove.Glyph.LoadFromBitmap(tbmp.Bitmap); end;
if fileexists(fbase+fupbmp) then begin
  tbmp.LoadFromFile(fbase+fupbmp);
  bMove.GlyphUp.LoadFromBitmap(tbmp.Bitmap); end;
bMove.Hint:=pdeLoadNLS('MoveButton', '६...');
//delete
fbmp := 'delete.bmp';
fupbmp := 'delete2.bmp';
if fileexists(fbase+fbmp) then begin
  tbmp.LoadFromFile(fbase+fbmp);
  bDelete.Glyph.LoadFromBitmap(tbmp.Bitmap); end;
if fileexists(fbase+fupbmp) then begin
  tbmp.LoadFromFile(fbase+fupbmp);
  bDelete.GlyphUp.LoadFromBitmap(tbmp.Bitmap); end;
bDelete.Hint:=pdeLoadNLS('DeleteButton', '...');
//rename
fbmp := 'rename.bmp';
fupbmp := 'rename2.bmp';
if fileexists(fbase+fbmp) then begin
  tbmp.LoadFromFile(fbase+fbmp);
  bRename.Glyph.LoadFromBitmap(tbmp.Bitmap); end;
if fileexists(fbase+fupbmp) then begin
  tbmp.LoadFromFile(fbase+fupbmp);
  bRename.GlyphUp.LoadFromBitmap(tbmp.Bitmap); end;
bRename.Hint:=pdeLoadNLS('RenameButton', '२...');
//find
fbmp := 'find.bmp';
fupbmp := 'find2.bmp';
if fileexists(fbase+fbmp) then begin
  tbmp.LoadFromFile(fbase+fbmp);
  bFind.Glyph.LoadFromBitmap(tbmp.Bitmap); end;
if fileexists(fbase+fupbmp) then begin
  tbmp.LoadFromFile(fbase+fupbmp);
  bFind.GlyphUp.LoadFromBitmap(tbmp.Bitmap); end;
bFind.Hint:=pdeLoadNLS('FindButton', '');
//new folder
fbmp := 'newfolder.bmp';
fupbmp := 'newfolder2.bmp';
if fileexists(fbase+fbmp) then begin
  tbmp.LoadFromFile(fbase+fbmp);
  bNew.Glyph.LoadFromBitmap(tbmp.Bitmap); end;
if fileexists(fbase+fupbmp) then begin
  tbmp.LoadFromFile(fbase+fupbmp);
  bNew.GlyphUp.LoadFromBitmap(tbmp.Bitmap); end;
bNew.Hint:=pdeLoadNLS('NewFolderButton', ' ');
//properties
fbmp := 'properties.bmp';
fupbmp := 'properties2.bmp';
if fileexists(fbase+fbmp) then begin
  tbmp.LoadFromFile(fbase+fbmp);
  bProperties.Glyph.LoadFromBitmap(tbmp.Bitmap); end;
if fileexists(fbase+fupbmp) then begin
  tbmp.LoadFromFile(fbase+fupbmp);
  bProperties.GlyphUp.LoadFromBitmap(tbmp.Bitmap); end;
bProperties.Hint:=pdeLoadNLS('PropertiesButton', '⢠');
//newwindow
fbmp := 'newwindow.bmp';
fupbmp := 'newwindow2.bmp';
if fileexists(fbase+fbmp) then begin
  tbmp.LoadFromFile(fbase+fbmp);
  bNewWindow.Glyph.LoadFromBitmap(tbmp.Bitmap); end;
if fileexists(fbase+fupbmp) then begin
  tbmp.LoadFromFile(fbase+fupbmp);
  bNewWindow.GlyphUp.LoadFromBitmap(tbmp.Bitmap); end;
bNewWindow.Hint:=pdeLoadNLS('NewWindowButton', ' ');

findUtil:=pdeLoadCfgStr('filehalf.cfg', 'FindUtil');  // find utility
txtUtil:=pdeLoadCfgStr('filehalf.cfg', 'TextUtil');  //text editor
archiveUtil:=pdeLoadCfgStr('filehalf.cfg', 'Archiver');  //archiving program

tbmp.free;

//--FileHalf menu--
mFile.Caption := pdeLoadNLS('menuFile', '');
  mNewWindow.Caption := pdeLoadNLS('menunewwindow', ' \tCtrl+N');
  mOpen2.Caption := pdeLoadNLS('menuOpen', '\tEnter');
  mFind2.Caption := pdeLoadNLS('menuFind', '\tCtrl+F');
  mCopy2.Caption := pdeLoadNLS('menuCopy', 'p...\tCtrl+C');
  mmove2.Caption := pdeLoadNLS('menuMove', 'p...\tCtrl+X');
  mDel2.Caption := pdeLoadNLS('menuDelete', '...\tF8');
  mShortcut2.Caption := pdeLoadNLS('menuShortcut', ' p');
  mRename2.Caption := pdeLoadNLS('menuRename', '२\tF2');
  mCreateNew2.Caption := pdeLoadNLS('menuCreateNew', ' ');
  mFolder2.Caption := pdeLoadNLS('menuFolder', '\tF7');
  mText2.Caption := pdeLoadNLS('menuText', 'Text.txt');
  mHTM.Caption := pdeLoadNLS('menuHTM', 'Www.htm');
  mProperties2.Caption := pdeLoadNLS('menuProperties', '⢠\tCtrl+S');
mEdit.Caption := pdeLoadNLS('menuEdit', 'ࠢ');
  mFilter.Caption := pdeLoadNLS('menuFilter', '  뤥');
  mViewFile.Caption := pdeLoadNLS('menuViewFile', 'ᬮ 䠩\tF3');
  mArchive.Caption := pdeLoadNLS('menuArchive', '  娢');
  mConvertImage.Caption := pdeLoadNLS('menuConvertImage', '८ࠧ 㭮');
  mVCase.Caption := pdeLoadNLS('menuVCase', '""');
    mVCaseShow.Caption := pdeLoadNLS('menuVCaseShow', '/');
    mVCaseAddAll.Caption := pdeLoadNLS('menuVCaseAddAll', ' ');
    mVCaseAdd.Caption := pdeLoadNLS('menuVCaseAdd', '/ \tSpace');
    mVCaseClear.Caption := pdeLoadNLS('menuVCaseClear', ' ᮤন');
    mVCasePasteInCurrent.Caption := pdeLoadNLS('menuVCasePaste', '⠢ ᮤন  ⥪ ');
  mEditAssoc.Caption := pdeLoadNLS('menuEditAssoc', 'ࠢ 樠樨');

  mConfigPDE.Caption := pdeLoadNLS('menuConfigPDE', 'ன');
mView.Caption := pdeLoadNLS('menuView', '');
  mRefresh.Caption := pdeLoadNLS('menuRefresh', '\F5');
  mButtons.Caption := pdeLoadNLS('menuButtons', '');
  mStatus.Caption := pdeLoadNLS('menuStatus', 'ப ');
  mInfopanel.Caption := pdeLoadNLS('menuInfoPanel', '-');
  mShowHidden.Caption := pdeLoadNLS('menuShowHidden', ' 䠩');
  mShowPreview2.Caption := pdeLoadNLS('menuShowPreview', '।ᬮ');
//  mShowPreview.Caption := pdeLoadNLS('menuThumbails', '');
  mSavePreview.Caption := pdeLoadNLS('eD2Str4', '࠭');
  mZoomPlus.Caption := pdeLoadNLS('menuZoomPlus', '⠡ +');
  mZoomMinus.Caption := pdeLoadNLS('menuZoomMinus', '⠡ -');
  mPresent.Caption := pdeLoadNLS('menuPresent', '।⠢');
    mIcons.Caption := pdeLoadNLS('menuIcons', '⮣ࠬ');
    mFlow.Caption := pdeLoadNLS('menuFlow', '');
    mTile.Caption := pdeLoadNLS('menuTile', ' ⪠');
    mSmallIcons.Caption := pdeLoadNLS('menuSmallIcons', '쪨 窨');
    mAsText.Caption := pdeLoadNLS('menuAsNorton', '쪮 ⥪');
mGoto.Caption := pdeLoadNLS('menuGoto', '室');
  mGoup.Caption := pdeLoadNLS('menuGoUp', '\tBkSp');
  mGoback.Caption := pdeLoadNLS('menuGoBack', '<- \tShift+Left');
  mGoforv.Caption := pdeLoadNLS('menuGoForv', ' ->\tShift+Right');
  mNextdrive.Caption := pdeLoadNLS('menuNextDrive', '騩 \tCtrl+Right');
  mPrevdrive.Caption := pdeLoadNLS('menuPrevDrive', '।騩 \tCtrl+Left');
  mGotoDisks.Caption := pdeLoadNLS('menuGotoDrives', '᪨');
  mGotoHome.Caption := pdeLoadNLS('menuGotoHome', ' ');
mHelp.Caption := pdeLoadNLS('menuHelp', 'ࠢ');
  mShowhelp.Caption := pdeLoadNLS('menuShowHelp', '맮 ࠢ');
  mAbout.Caption := pdeLoadNLS('menuAbout', 'ଠ  த');
mQuickRun.Caption := pdeLoadNLS('menuQuickRun', ' ');
  mQuickRunAdd.Caption := pdeLoadNLS('menuQuickRunAdd', ' ணࠬ');
  mQuickRunClear.Caption := pdeLoadNLS('menuVCaseClear', ' ᮤন');
mBookmarks.Caption := pdeLoadNLS('menuBookmarks', '');
  mAddbookmark.Caption := pdeLoadNLS('menuAddBookmark', ' \tCtrl+B');
  mBookmarksClear.Caption := pdeLoadNLS('menuVCaseClear', ' ᮤন');
//--FileHalf popupmenu--
mOpen.Caption := pdeLoadNLS('popupmenuOpen', '');
mOpenWith.Caption := pdeLoadNLS('popupmenuOpenWith', ' c');
  mEditAssoc2.Caption := pdeLoadNLS('menuEditAssoc2', ' ணࠬ');
mFind.Caption := pdeLoadNLS('popupmenuFind', '...');
mDuble.Caption := pdeLoadNLS('popupmenuDuble', '㡫஢');
mCopy.Caption := pdeLoadNLS('popupmenuCopy', '஢...');
mMove.Caption := pdeLoadNLS('popupmenuMove', '६...');
mDel.Caption := pdeLoadNLS('popupmenuDelete', '...');
mShortcut.Caption := pdeLoadNLS('popupmenuShortcut', ' ');
mRename.Caption := pdeLoadNLS('popupmenuRename', '२');
mCreateNew.Caption := pdeLoadNLS('popupmenuCreateNew', ' ');
mFolder.Caption := pdeLoadNLS('popupmenuFolder', '');
mText.Caption := pdeLoadNLS('popupmenuText', 'T.txt');
mHTM2.Caption := pdeLoadNLS('popupmenuHTM2', 'W-࠭.htm');
mProperies.Caption := pdeLoadNLS('popupmenuProperies', '⢠');

Result := 0;

End;

//file handling routines
function TMainForm.ObjMove(source, dest: cstring): integer;
var
  rc: apiret;
  fsrc, fdest: CString;
  option: ULong;
Begin
option := 0;
if pdeLoadCfgInt('general.cfg', 'overwritefiles') = 1 then
    option := DCPY_Existing;
fsrc:=source;
fdest:=dest;
rc:=DosCopy(fsrc, fdest, option);
if rc<>0 then
  begin
  pdeMessageBoxC(pdeLoadNLS('dlgErrorDeleteCanceled', ' ⬥.')
  , pdeLoadNLS('dlgErrorOnCopy', '訡  ஢'), bCopy.Glyph);
  exit;
  end;

  ObjDel(source);

  Result := 0;

End;

function TMainForm.ObjDel(source: string): integer;
var
  rc: boolean;
  rez: integer;
  rc2, rc3: APIRET;
  sr2: TSearchRec;
  cdir: string;
  curdir: cstring;
Begin
if (FindFirst(source+'\*.*', faAnyFile, sr2)=0) then  // 䠩    㣨 䠩 :-)
  begin  //directory
  rez:=0;
  while rez=0 do
    begin
    rez:=FindNext(sr2);
    if rez<>0 then break;
    if (sr2.name<>'..')and(sr2.name<>'.') then
      begin
      curdir:=source[1]+source[2]+source[3];

      //DosSetCurrentDir(curdir);
      SysDirSetCurrent(curdir);

      ObjDel(source+'\'+sr2.name);
      end;
    end;
  FindClose(sr2);
  FileSetAttr(source, 0);
  cdir:=source[1]+source[2]+source[3];
  curdir:=cdir;

  //rc3:=DosSetCurrentDir(curdir);
  SysDirSetCurrent(curdir);

  rc2:=DosDeleteDir(source);
  if rc2<>0 then
    pdeMessageBoxC(pdeLoadNLS('dlgErrorCode', ' 訡:')+' '+IntToStr(rc2)+
      chr(13)+chr(10)+source,
      pdeLoadNLS('dlgErrorOnFolderDelete', '訡  㤠 '), bDelete.Glyph);

  end
else
  begin  //file
  FindClose(sr2);
  FileSetAttr(source, 0);
  DosSleep(0);
  rc:=DeleteFile(source);
  if rc=false then
    pdeMessageBoxC(source, pdeLoadNLS('dlgErrorOnFileDelete', '訡  㤠 䠩'), bDelete.Glyph);
  end;

Result := 0;

End;

function TMainForm.ObjRename(source, dest: string): integer;
var
  rc: APIRET;
  s, d: cstring;
Begin
//२
s:=source;
d:=dest;
rc:=DosMove(s, d); //move files and subdirectories (in same drive)
Result := 0;
if rc<>0 then
  Begin
  Result := 1;
  pdeMessageBoxC(''+chr(13)+chr(10)+
    pdeLoadNLS('dlgErrorFileAllreadyExists', ' 䠩    㦥 .')
    +chr(13)+chr(10)+pdeLoadNLS('dlgErrorCode', ' 訡:')+' '+IntToStr(rc),
    pdeLoadNLS('dlgErrorOnRename', '訡 ६饭'), bMove.Glyph);
  End;
End;

//-----------------------------------------

function TMainForm.CalcTreeSize(tpath: String): ULong;
var
  files, folders: LongInt;
begin

  Result := CalcTreeSizeA(tpath, files, folders);

end;

function TMainForm.CalcTreeSizeS(tpath: String): String;
var
  size: ULong;
  files, folders: LongInt;
begin

  {Calc tree size and number of files/folders in the tree}
  files := 0;
  folders := 0;
  size := CalcTreeSizeA(tpath, files, folders);
  Result := IntToStr(size div 1024) + ' ' + pdeLoadNLS('statusKBytes', '')
    +' ('+pdeLoadNLS('dlgPropertiesSize2', '䠩')+': '+IntToStr(files)+'; '
    +pdeLoadNLS('dlgPropertiesSize3', '')+': '+IntToStr(folders)+')';

end;

function TMainForm.CalcTreeSizeA(tpath: String; var files, folders: LongInt): ULong;
var
  rez: integer;
  sr2: TSearchRec;
  size: ULong;
  files2, folders2, files3, folders3: LongInt;
Begin
// ࠧ ॢ ⠫
Cursor := crHourGlass;
files2 := 0;
folders2 := 0;
files3 := 0;
folders3 := 0;
try
size:=0;
if (FindFirst(tpath+'\*.*', faAnyFile, sr2)=0) then  // 䠩    㣨 䠩 :-)
  begin  //directory
  rez:=0;
  inc(folders2);
  while rez=0 do
    begin
    Application.ProcessMessages;
    rez:=FindNext(sr2);
    if rez<>0 then break;
    if (sr2.name<>'..')and(sr2.name<>'.') then
      begin
      files3 := 0;
      folders3 := 0;
      size:=size+CalcTreeSizeA(tpath+'\'+sr2.name, files3, folders3);
      folders2 := folders2 + folders3;
      files2 := files2 + files3;
      end;

    end;
  FindClose(sr2);
  end
else
  begin  //file
  FindClose(sr2);
  FindFirst(tpath, faAnyFile, sr2);
    size:=size+sr2.size;
  FindClose(sr2);
  inc(files2);
  end;

files := files2;
folders := folders2;
CalcTreeSizeA:=size;
  finally
  Cursor := crDefault;
  end;
End;

//-----------------------------------------
function TMainForm.Resolve_Id_diz: Integer;
var
  id_diz: String;
  id_file: TextFile;
Begin

  id_diz{s} := pdeloadcfgstr('filehalf.cfg', 'id_diz');

  if id_diz{s} <> '' then

    if FileExists(Path + id_diz) then
      begin //file_id.diz exists in current directory!!! :-)

      if id_diz_file = '' then
        begin
        Dirs.Height:=InfoPanel.Height-102;
        Dirs.Top := 207;
        l_case.height := Dirs.Height;
        l_case.top :=  Dirs.Top;
        Drives.Top :=  190;
        Bevel3.ZOrder := zoTop;
        end;

      id_diz_file := Path + id_diz;
      InfoLabel.Clear;
      InfoLabel.Visible := True;
      FileMode := fmInput;
      AssignFile(id_file, id_diz_file);
      Reset(id_file);
      While (FilePos(id_file) < FileSize(id_file)) do
        begin
        Readln(id_file, id_diz);
        InfoLabel.Lines.Add(id_diz);
        end;
      CloseFile(id_file);
      FileMode := fmInOut;
      end
      else
      begin

      if id_diz_file <> '' then
        begin
        Dirs.Height:=InfoPanel.Height-207;
        Dirs.Top := 102;
        l_case.height := Dirs.Height;
        l_case.top :=  Dirs.Top;
        Drives.Top := 85;
        Bevel3.ZOrder := zoBottom;
        end;
      InfoLabel.Visible := False;
      id_diz_file := '';

      end;

  MainFormOnResize(Self);
  Result := 0;

End;
//-----------------------------------------

function TMainForm.Resolve_One_PreView: integer;
var
  sel, prExt: String;
  tmpPath: String;
  __tmp: TBitmap;
Begin

  {show preview for selected picture}
  if vFiles.ItemCount = 0 then exit;
if not mShowPreview2.Checked then exit;
  if (InfoPanel.Width = 0) then exit;

  sel := vFiles.Items[vFiles.ItemIndex].RealFileName;
  prExt := UpperCase(ExtractFileExt(sel));
  if (prExt = '.PCX') or (prExt = '.GIF') or
    (prExt = '.JPEG') or (prExt = '.JPG') or (prExt = '.JPE') or
     (prExt = '.RLE') or (prExt = '.TIF') or (prExt = '.TIFF') or
     (prExt = '.TGA') or (prExt = '.DIB') or (prExt = '.IFF') or
     (prExt = '.XBM') or (prExt = '.IMG') or (prExt = '.VGA') then
    begin
    if not resolved_preview then begin
    resolved_preview :=True;
    tmpPath := GetEnv('TEMP') + '\';
    _ShellExecute(ExtractFilePath(Application.ExeName)+'Utils\gbmsize.exe'
      , ExtractFilePath(Application.ExeName)+'Utils\', '-w 230  -a '
      + Path + sel + ' '+ tmpPath + '~fhview.bmp', True, SSF_FGBG_BACK
      , SSF_CONTROL_INVISIBLE, SSF_RELATED_CHILD);

    DosSleep(pdeLoadCfgIntD('filehalf.cfg', 'WaitForPreview', 1000));
    if not FileExists(tmpPath + '~fhview.bmp') then DosSleep(300);
    if not FileExists(tmpPath + '~fhview.bmp') then DosSleep(300);
    if not FileExists(tmpPath + '~fhview.bmp') then DosSleep(300);
    if not FileExists(tmpPath + '~fhview.bmp') then DosSleep(300);
    if not FileExists(tmpPath + '~fhview.bmp') then DosSleep(300);

    __tmp := TBitmap.Create;
    try
      __tmp.LoadFromFile(tmpPath + '~fhview.bmp');
      except
      __tmp.Free;
      __tmp := TBitmap.Create;
      //iBitmaps.GetBitmap(4, __tmp);
      end;
    DeleteFile(tmpPath + '~fhview.bmp');
    InfoImage.Bitmap := __tmp;
    __tmp.Free;
    if InfoImage.Bitmap.Width > InfoImage.Bitmap.Height then
      begin
      InfoImage.Width := 226;
      InfoImage.Left := 2;
      InfoImage.Height := Round((InfoImage.Width / InfoImage.Bitmap.Width) * InfoImage.Bitmap.Height);
      InfoImage.Top := 95 - InfoImage.Height div 2;
      if InfoImage.Top < 0 then InfoImage.Top := 0;
      end
      else
      begin
      InfoImage.Height := 186;
      InfoImage.Width := Round((InfoImage.Height / InfoImage.Bitmap.Height) * InfoImage.Bitmap.Width);
      InfoImage.Top := 2;
      InfoImage.Left := 115 - InfoImage.Width div 2;
      if InfoImage.Left < 0 then InfoImage.Left := 0;
      end;
            end;

    Image1.Visible := False;
    InfoLabel.Visible := False;
    InfoScroll.Visible := True;
    Dirs.Height:=InfoPanel.Height-205;
    Dirs.Top := 207;
    l_case.height := Dirs.Height;
    l_case.top :=  Dirs.Top;
    Drives.Top :=  190;
    end
  else if (prExt = '.BMP') then
    begin
    if not resolved_preview then begin
    resolved_preview := True;

    try
      InfoImage.Bitmap.LoadFromFile(path + sel);
    except
      __tmp := TBitmap.Create;
      //iBitmaps.GetBitmap(4, __tmp);
      InfoImage.Bitmap := __tmp;
      __tmp.Free;
    end;

    if InfoImage.Bitmap.Width > InfoImage.Bitmap.Height then
      begin
      InfoImage.Width := 226;
      InfoImage.Left := 2;
      InfoImage.Height := Round((InfoImage.Width / InfoImage.Bitmap.Width) * InfoImage.Bitmap.Height);
      InfoImage.Top := 95 - InfoImage.Height div 2;
      if InfoImage.Top < 0 then InfoImage.Top := 0;
      end
      else
      begin
      InfoImage.Height := 186;
      InfoImage.Width := Round((InfoImage.Height / InfoImage.Bitmap.Height) * InfoImage.Bitmap.Width);
      InfoImage.Top := 2;
      InfoImage.Left := 115 - InfoImage.Width div 2;
      if InfoImage.Left < 0 then InfoImage.Left := 0;
      end;
            end;

    Dirs.Height:=InfoPanel.Height-207;
    Dirs.Top := 207;
    l_case.height := Dirs.Height;
    l_case.top :=  Dirs.Top;
    Drives.Top :=  190;
    Image1.Visible := False;
    InfoLabel.Visible := False;
    InfoScroll.Visible := True;
    end
  else
    begin
    resolved_preview := False;
    InfoScroll.Visible := False;
    InfoLabel.Visible := True;
    Image1.Visible := True;
    if FileExists(Path + pdeloadcfgstr('filehalf.cfg', 'id_diz')) then exit;
    Dirs.Height:=InfoPanel.Height-102;
    Dirs.Top := 102;
    l_case.height := Dirs.Height;
    l_case.top :=  Dirs.Top;
    Drives.Top := 85;
    end;

  Result := 0;

End;

//-----------------------------------------

function TMainForm.LoadToPreview: Integer;
var
  vt: TPreviewThread;
begin
  {load preview for pictures}
  if prList.Count = 0 then exit;
  vt := TPreviewThread.Create(False);
  Result := 0;
end;

//-----------------------------------------

Initialization
  RegisterClasses ([TMainForm, TListView, TEdit,
    TMenuItem, TButton, TToolbar, TMainMenu, TPanel
    , TExplorerButton, TImage, TPopupMenu, TBevel
    , TCustomDirectoryListBox, TCustomDriveComboBox, TProgressBar
    , TMemo, TScrollBox, TListBox, TStatusBar]);
End.
