//----------------------------------------//
//                                        //
//  PDE Desktop Environment (OS/2)        //
//  http://os2progg.by.ru/pde             //
//                                        //
//  PDE common dialogs DLL                //
//  Copyleft [PDE Team] 2004              //
//                                        //
//  Saper game ("Mine")                   //
//                                        //
//----------------------------------------//

Unit Unit13;

Interface

Uses
  Classes, Forms, Graphics, SysUTils, ExtCtrls, XplorBtn
  , StdCtrls, pdeNLS
  , Unit1, Unit9;

Type
  TSaperForm = Class (TForm)
    MainMenu1: TMainMenu;
    mGame: TMenuItem;
    mHelp: TMenuItem;
    mNewGame: TMenuItem;
    MenuItem4: TMenuItem;
    mNovice: TMenuItem;
    mAdvanced: TMenuItem;
    mExpert: TMenuItem;
    MenuItem8: TMenuItem;
    mLarge: TMenuItem;
    MenuItem12: TMenuItem;
    mExit: TMenuItem;
    MenuItem15: TMenuItem;
    mAbout: TMenuItem;
    img1: TImage;
    img2: TImage;
    img3: TImage;
    img: TImage;
    Bevel1: TBevel;
    Bevel2: TBevel;
    bSmile: TExplorerButton;
    Image1: TImage;
    Image2: TImage;
    Image3: TImage;
    Timer1: TTimer;
    mLabel: TLabel;
    tLabel: TLabel;
    mShowHelp: TMenuItem;
    Procedure mShowHelpOnClick (Sender: TObject);
    Procedure mAboutOnClick (Sender: TObject);
    Procedure SaperFormOnShow (Sender: TObject);
    Procedure Timer1OnTimer (Sender: TObject);
    Procedure SaperFormOnMouseUp (Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X: LongInt; Y: LongInt);
    Procedure mExpertOnClick (Sender: TObject);
    Procedure mAdvancedOnClick (Sender: TObject);
    Procedure mNoviceOnClick (Sender: TObject);
    Procedure mLargeOnClick (Sender: TObject);
    Procedure mNewGameClick (Sender: TObject);
    Procedure mExitClick (Sender: TObject);
    Procedure SaperFormOnMouseDown (Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X: LongInt; Y: LongInt);
    Procedure SaperFormOnPaint (Sender: TObject; Const rec: TRect);
    Procedure SaperFormOnCreate (Sender: TObject);
  Private
    {Insert private declarations here}
  Public
    {Insert public declarations here}
  End;

Var
  SaperForm: TSaperForm;

  MR: Integer = 10; {rows count}
  MC: Integer = 10; {columns count}
  NM: Integer = 10; {mines count}
  W: Integer  = 16; {width of cell}
  H: Integer  = 16; {height of cell}

  Pole: array[0..16+1, 0..30+1] of Integer; {mines}
  //values of cells:
  //0..8 - number of neighbour mines
  //9 - mine in cell
  //100..109 - cell opened
  //200..209 - cell is flaged

  nMin: Integer; {number of mines found}
  nFlag: Integer; {number of flags}

  status : integer; // 0 - 砫 ; 1- ; 2 -१
  uTime: LongInt;

function Rectangle(left, bottom, right, top: Integer): TRect;
procedure NewGame;
procedure ShowPole(Canvas: TCanvas; status: Integer);
procedure Kletka(Canvas: TCanvas; row, col, status: Integer);
procedure Open(row, col: Integer);
procedure SetupG;

procedure ShowSaper;

Implementation

procedure ShowSaper;
begin

  {Mine game}
//  Application.Create;
  SaperForm := TSaperForm.Create(nil);
  SaperForm.ShowModal;
//  Application.Destroy;

end;

function Rectangle(left, bottom, right, top: Integer): TRect;
begin
  Result.left := left;
  Result.bottom := bottom;
  Result.right := right;
  Result.top := top;
end;

Procedure Kletka(Canvas : TCanvas; row, col, status : integer);
var
  x,y : integer; // न  뢮
  rec: TRect;
begin

x := (col-1)* W + 1;
y := (row-1)* H + 1;

if status = 0 then
  begin
  Canvas.StretchDraw(x, y, W, H, saperform.img1.graphic);
  exit;
  end;

if Pole[row,col] < 100 then
  begin
  Canvas.StretchDraw(x, y, W, H, saperform.img1.graphic);
  // ᫨  襭 (status = 2),   
  if (status = 2) and (Pole[row,col] = 9) then
    begin
    Canvas.StretchDraw(x, y, W, H, saperform.img3.graphic);
    end;
  exit;
  end;

// 뢠 
Canvas.StretchDraw(x, y, W, H, saperform.img.graphic);
if ( Pole[row,col] = 100 ) then exit; // ⪠ ,   

if ( Pole[row,col] >= 101) and ( Pole[row,col] < 109) then
begin
if ( Pole[row,col] = 101) then
  Canvas.Pen.Color := clBlue
  else if ( Pole[row,col] = 102) then
  Canvas.Pen.Color := clGreen
  else if ( Pole[row,col] = 103) then
  Canvas.Pen.Color := clRed
  else if ( Pole[row,col] = 104) then
  Canvas.Pen.Color := clNavy
  else if ( Pole[row,col] = 105) then
  Canvas.Pen.Color := clGray
  else if ( Pole[row,col] = 106) then
  Canvas.Pen.Color := clBlack
  else if ( Pole[row,col] = 107) then
  Canvas.Pen.Color := clPurple
  else if ( Pole[row,col] = 108) then
  Canvas.Pen.Color := clFuchsia;

  Canvas.Brush.Color := clLtGray;
  Canvas.TextOut(x+3,y+2,IntToStr(Pole[row,col] -100 ));
  exit;
  end;

if ( Pole[row,col] >= 200 ) then
  Canvas.StretchDraw(x, y, W, H, saperform.img2.graphic);

if (Pole[row,col] = 109 ) then //  ⮩  ࢠ!
  begin
  //Canvas.Brush.Color := clRed;
  //rec := Rectangle(x-1,y-1,x+W,y-H);
  //Canvas.Rectangle(rec);
  end;

if ( (Pole[row,col] mod 10) = 9) and (status = 2) then
  Canvas.StretchDraw(x, y, W, H, saperform.img3.graphic);

end;

// 뢠 
Procedure ShowPole(Canvas : TCanvas; status : integer);
var
  row,col : integer;
begin

for row := 1 to MR do
  for col := 1 to MC do
    Kletka(Canvas, row, col, status);
end;

// ४ᨢ 㭪 뢠 ⥪   ᥤ
// ⪨,    
Procedure Open( row, col : integer);
begin

if Pole[row,col] = 0 then
  begin
  Pole[row,col] := 100;
  Kletka(SaperForm.Canvas, row,col, 1);
  Open(row,col-1);
  Open(row-1,col);
  Open(row,col+1);
  Open(row+1,col);
  //ਬ몠騥 쭮
  Open(row-1,col-1);
  Open(row-1,col+1);
  Open(row+1,col-1);
  Open(row+1,col+1);
  end
else if (Pole[row,col] < 100) and ( Pole[row,col] <> -3 ) then
  begin
  Pole[row,col] := Pole[row,col] + 100;
  Kletka(SaperForm.Canvas, row, col, 1);
  end;

end;

//   -   
procedure NewGame;
var
  row,col : integer; // न ⪨
  n : integer; // ⢮ ⠢ 
  k : integer; // -   ᥤ ⪠
  t: Integer;
begin

// ⨬ - ᨢ, ᮮ⢥騥 ⪠
// ஢ .
for row :=1 to MR do
  for col :=1 to MC do
    Pole[row,col] := 0;

// ⠢ 
Randomize; // 樠 
n := 0; // - 
repeat
  row := Random(MR) + 1;
  col := Random(MC) + 1;
  if ( Pole[row,col] <> 9) then
    begin
    Pole[row,col] := 9;
    n := n+1;
    end;
until ( n = NM );

//   ⪨ ᫨
// -   ᥤ ⪠
for row := 1 to MR do
  for col := 1 to MC do
    if ( Pole[row,col] <> 9 ) then
      begin
      k :=0 ;
      if Pole[row-1,col-1] = 9 then k := k + 1;
      if Pole[row-1,col] = 9 then k := k + 1;
      if Pole[row-1,col+1] = 9 then k := k + 1;
      if Pole[row,col-1] = 9 then k := k + 1;
      if Pole[row,col+1] = 9 then k := k + 1;
      if Pole[row+1,col-1] = 9 then k := k + 1;
      if Pole[row+1,col] = 9 then k := k + 1;
      if Pole[row+1,col+1] = 9 then k := k + 1;
      Pole[row,col] := k;
      end;
status := 0; // 砫 
nMin := 0; //  㦥 
nFlag := 0; //  䫠
uTime := 0;

SaperForm.tLabel.Caption := '000';
SaperForm.Timer1.Stop;

t := NM-nFlag;
if t < 10 then
  SaperForm.mLabel.Caption := '00'+IntToStr(t)
else SaperForm.mLabel.Caption := '0'+IntToStr(t);

end;

procedure SetupG;
var
  row,col : integer;
begin

  //setup game
  for row := 0 to MR+1 do
    for col := 0 to MC+1 do
      Pole[row,col] := -3;

   NewGame; // "ࠧ" 
   SaperForm.ClientHeight := H*MR + 1 + 34;
   SaperForm.ClientWidth := W*MC + 1;
   SaperForm.Bevel2.Left := SaperForm.ClientWidth div 2 - 12;
   SaperForm.Bevel2.Top := 4;
   SaperForm.Invalidate;
   SaperForm.bSmile.Glyph := SaperForm.bSmile.GlyphDown;

end;

Procedure TSaperForm.mShowHelpOnClick (Sender: TObject);
Begin

  {show help}
  ShellExecute('view.exe', '', PDEFolder+'\Help\saper.inf', false);

End;

Procedure TSaperForm.mAboutOnClick (Sender: TObject);
Begin

  {about ...}
  pdeMessageBoxOK(pdeLoadNLS('pdeName','  Desktop Environment')+' v.0.20'
    + chr(13) + chr(10) + pdeLoadNLS('Saper1','"Miner" game')
    + chr(13) + chr(10) + 'SERG'
    , pdeLoadNLS('menuAbout', 'Product information'), Icon.Handle);

End;

Procedure TSaperForm.SaperFormOnShow (Sender: TObject);
Begin
  NewGame; // "ࠧ" 
End;

Procedure TSaperForm.mExpertOnClick (Sender: TObject);
Begin

  {Expert mode on}
  mExpert.Checked := True;
  mAdvanced.Checked := False;
  mNovice.Checked := False;

  MR := 16; {rows count}
  MC := 30; {columns count}
  NM := 99; {mines count}
  SetupG;

End;

Procedure TSaperForm.mAdvancedOnClick (Sender: TObject);
Begin

  {Advanced mode on}
  mExpert.Checked := False;
  mAdvanced.Checked := True;
  mNovice.Checked := False;

  MR := 16; {rows count}
  MC := 16; {columns count}
  NM := 40; {mines count}
  SetupG;

End;

Procedure TSaperForm.mNoviceOnClick (Sender: TObject);
Begin

  {Novice mode on}
  mExpert.Checked := False;
  mAdvanced.Checked := False;
  mNovice.Checked := True;

  MR := 10; {rows count}
  MC := 10; {columns count}
  NM := 10; {mines count}
  SetupG;

End;

Procedure TSaperForm.mLargeOnClick (Sender: TObject);
Begin

  {switch on/off large cells}
  mLarge.Checked := not (mLarge.Checked);
  if mLarge.Checked then
    begin
    W := 24;
    H := 24;
    end
    else
    begin
    W := 16;
    H := 16;
    end;
  ClientHeight := H*MR + 1 + 34;
  ClientWidth := W*MC + 1;
  Bevel2.Left := ClientWidth div 2 - 12;
  Invalidate;

End;

Procedure TSaperForm.mNewGameClick (Sender: TObject);
Begin

  {menu item "new game"}
  NewGame;
  Invalidate;
  bSmile.Glyph := bSmile.GlyphDown;

End;

Procedure TSaperForm.mExitClick (Sender: TObject);
Begin
  Close;
End;

Procedure TSaperForm.SaperFormOnMouseUp (Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X: LongInt; Y: LongInt);
Begin

if status = 1 then
  bSmile.Glyph := bSmile.GlyphDown;

// := IntToStr(NM);

End;

Procedure TSaperForm.SaperFormOnMouseDown (Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X: LongInt; Y: LongInt);
var
  row, col : integer;
  rec: TRect;
  t: Integer;
Begin

if status = 2 //  襭
  then exit;

if status = 0 then //  饫箪
  begin
  status := 1;
  Timer1.Start;
  end;

bSmile.Glyph := Image3.Bitmap;
// ८ࠧ㥬 न   
// ⪨ 
row := Trunc(y/H) + 1;
col := Trunc(x/W) + 1;

if Button = mbLeft then
  begin
  if Pole[row,col] = 9 then
    begin //  ⪠,  ன  
    Pole[row,col] := Pole[row,col] + 100;
    status := 2; //  祭
    ShowPole(SaperForm.Canvas, status);
    //pdeMessageBoxOK(' 祭 :-(', '', SaperForm.Icon.Handle);
    bSmile.Glyph := Image1.Bitmap;
    Timer1.Stop;

    end
  else if Pole[row,col] < 9 then
    Open(row,col);
  end
else if Button = mbRight then
  if Pole[row,col] > 200 then
    begin
    // 㡥६ 䫠  ஥ 
    nFlag := nFlag - 1;
    Pole[row,col] := Pole[row,col] - 200; // 㡥६ 䫠
    x := (col-1)* W + 1;
    y := (row-1)* H + 1;
    Canvas.StretchDraw(x, y, W, H, saperform.img1.graphic);
    end
  else if Pole[row, col] < 100 then
    begin // ⠢   䫠
    nFlag := nFlag + 1;
    if Pole[row,col] = 9 then
      nMin := nMin + 1;

    Pole[row,col] := Pole[row,col]+ 200; // ⠢ 䫠
    if (nMin = NM) and (nFlag = NM) then
      begin
      status := 2; //  祭
      ShowPole(SaperForm.Canvas, status);
      //pdeMessageBoxOK('ࠢ塞,  먣ࠫ :-)', '', SaperForm.Icon.Handle);
      bSmile.Glyph := Image2.Bitmap;
      Timer1.Stop;

      end
      else Kletka(SaperForm.Canvas, row, col, status);
    end;

t := NM-nFlag;
if t < 0 then
  mLabel.Caption := '---'
else if t < 10 then
  mLabel.Caption := '00'+IntToStr(t)
else mLabel.Caption := '0'+IntToStr(t);

End;

Procedure TSaperForm.SaperFormOnPaint (Sender: TObject; Const rec: TRect);
Begin

  ShowPole(SaperForm.Canvas, status);

End;

Procedure TSaperForm.SaperFormOnCreate (Sender: TObject);
var
  row, col: Integer;
Begin

  BorderStyle := bsDialog;

  Caption := pdeLoadNLS('Saper1','"Miner" game');
  mGame.Caption := pdeLoadNLS('Saper2', 'Game');
    mNewGame.Caption := pdeLoadNLS('Saper3', 'New game\tF2');
    mNovice.Caption := pdeLoadNLS('Saper4', 'Novice');
    mAdvanced.Caption := pdeLoadNLS('Saper5', 'Advanced');
    mExpert.Caption := pdeLoadNLS('Saper6', 'Expert');
    mLarge.Caption := pdeLoadNLS('Saper7', 'Large squares');
    mExit.Caption := pdeLoadNLS('eD2Str6', 'Exit\tAlt+X');
  mHelp.Caption := pdeLoadNLS('menuHelp', 'Help');
    mShowhelp.Caption := pdeLoadNLS('menuShowHelp', 'Show help');
    mAbout.Caption := pdeLoadNLS('menuAbout', 'Product information');

   //  ⮡ࠦ - ᨢ,  ᮮ⢥
   // ⪠  ࠭ ஢  襬 ᫮ -3.
   //  祭 ᯮ 㭪樥 Open  襭
   // ४ᨢ   ᥤ  ⮪.
   //SetupG;
   for row := 0 to 16+1 do
    for col := 0 to 30+1 do
      Pole[row,col] := -3;

   //NewGame; // "ࠧ" 
   ClientHeight := H*MR + 1 + 34;
   ClientWidth := W*MC + 1;
   Bevel2.Left := ClientWidth div 2 - 12;
   Bevel2.Top := 4;

End;

Procedure TSaperForm.Timer1OnTimer (Sender: TObject);
Begin

  uTime := uTime + 1;

  if uTime = 999 then Timer1.Stop;

  if uTime < 10 then
    tLabel.Caption := '00' + IntToStr(uTime)
  else if uTime < 100 then
    tLabel.Caption := '0' + IntToStr(uTime)
  else tLabel.Caption := IntToStr(uTime);

End;

Initialization
  RegisterClasses ([TSaperForm, TMainMenu, TMenuItem, TImage, TBevel,
    TExplorerButton, TTimer, TLabel]);
End.
