Unit Unit5;

Interface

Uses
  Classes, Forms, Graphics, pdeNLS, SysUtils, Buttons, StdCtrls
  , TabCtrls, CustomFileControls, DOS, ExtCtrls, BmpList;

Type
  TTempForm = Class (TForm)
    Label1: TLabel;
    Label2: TLabel;
    srcName: TEdit;
    destName: TEdit;
    bCopy: TButton;
    bCancel: TButton;
    Tabs: TTabSet;
    GroupBox1: TBevel;
    DirLab: TLabel;
    Dir: TCustomDirectoryListBox;
    Drive: TCustomDriveComboBox;
    GroupBox2: TBevel;
    DirLab2: TLabel;
    Label3: TLabel;
    ListBox1: TBitmapListBox;
    Procedure ListBox1OnItemFocus (Sender: TObject; Index: LongInt);
    Procedure ListBox1OnItemSelect (Sender: TObject; Index: LongInt);
    Procedure TabsOnChange (Sender: TObject; NewTab: LongInt;
      Var AllowChange: Boolean);
    Procedure TempFormOnCreate (Sender: TObject);
  Private
    {Insert private declarations here}
  Public
    {Insert public declarations here}
  End;

Var
  TempForm: TTempForm;

function pdeCopyDialog(src, text: String): String;

Implementation

function pdeCopyDialog(src, text: String): String;
begin

  //Application.Create;
  TempForm := TTempForm.Create(nil);

  TempForm.Caption := text;//'஢';
  TempForm.SrcName.Text := src;
  TempForm.DestName.Text := src;
  TempForm.bCopy.Caption := text;

  Result := '';

  //TempForm.ShowModal;

  if TempForm.ShowModal = cmOK then
  begin
  if TempForm.Tabs.TabIndex = 0 then
    Result := TempForm.DirLab.Caption+'\'+TempForm.DestName.Text
    else
    Result := TempForm.DirLab2.Caption+TempForm.DestName.Text;
  end;

  TempForm.Free;
  //Application.Destroy;

end;

function LoadBookmarks(Box: TBitmapListBox): Integer;
var
  basepath: String;
  pclr: TColor;
  afile: TextFile;
  tsr: TSearchRec;
  itext: String;
  rez: Integer;
  img: TBitmap;
begin
//-----㧪 -------------------
basepath := getenv('PDE_HOME');
  if basepath = '' then
    basepath := 'c:\pde';

img := TBitmap.Create;
img.LoadFromFile(basepath+'\Bitmaps\Dialogs\folder.bmp');

rez:=FindFirst(basepath+pdeLoadCfgStrD('general.cfg', 'userbookmarks', '\root\Bookmarks')+'\*.*',
  faAnyFile, tsr);
  while rez=0 do
    begin
    rez:=FindNext(tsr);
    if rez<>0 then break;
    if (tsr.attr and faDirectory)=0 then //file
      begin
      assignfile(afile, basepath+pdeLoadCfgStrD('general.cfg', 'userbookmarks', '\root\Bookmarks')+
        '\'+tsr.name);
      reset(afile);
      readln(afile); readln(afile); readln(afile);
      readln(afile, itext);
      //Box.Items.Add(itext);
      Box.AddBitmap(itext, img);
      closefile(afile);
      end;
    end;
FindClose(tsr);
img.free;

end;

Procedure TTempForm.TempFormOnCreate (Sender: TObject);
Begin

BorderStyle := bsDialog;
Label1.Caption := pdeLoadNLS('dlgSourceName', '室 :');
Label2.Caption := pdeLoadNLS('dlgDestName', ' :');
Label3.Caption := pdeLoadNLS('dlgChooseDest', '롥  祭');
bCopy.Caption := pdeLoadNLS('dlgCopyButton', '஢');
bCancel.Caption := pdeLoadNLS('dlgCancelButton', '⬥');
Tabs.Tabs.Add(pdeLoadNLS('menuGotoDrives', '᪨'));
Tabs.Tabs.Add(pdeLoadNLS('menuBookmarks', ''));
Tabs.TabIndex := 0;

LoadBookmarks(ListBox1);

End;

//-----------------------------------------

Procedure TTempForm.ListBox1OnItemSelect (Sender: TObject; Index: LongInt);
Begin

  DirLab2.Caption := ListBox1.Items[Index];

End;

Procedure TTempForm.ListBox1OnItemFocus (Sender: TObject; Index: LongInt);
Begin

  DirLab2.Caption := ListBox1.Items[Index];

End;


Procedure TTempForm.TabsOnChange (Sender: TObject; NewTab: LongInt;
  Var AllowChange: Boolean);
Begin

  if NewTab = 0 then
    begin
    GroupBox1.Visible := True;
    GroupBox2.Visible := False;
    end
  else
    begin
    GroupBox2.Visible := True;
    GroupBox1.Visible := False;
    end;
  AllowChange := True;

End;

Initialization
  RegisterClasses ([TTempForm, TLabel, TEdit, TCustomDriveComboBox,
    TCustomDirectoryListBox, TButton, TTabSet, TBevel, TBitmapListBox]);
End.
