{==========================================}
{  User shell switcher for  PDE OS/2       }
{  Copyleft stVova, 2003 - 2004            }
{  mailto://stVova@ukrpost.com.ua          }
{  http://os2progg.by.ru/pde               }
{  This is free OS/2 software :-)          }
{   8.12.2003 -  15.05.2004                }
{==========================================}

Unit Unit1;

Interface

Uses
  Classes, Forms, Graphics, StdCtrls, Buttons, ExtCtrls, ListView2
  , SysUtils, os2def, bsedos;

Type
  TMainForm = Class (TForm)
    lbHallo: TLabel;
    bChoose: TButton;
    bShutdown: TButton;
    vBox: TListView;
    iDefault: TImage;
    bvBox: TBevel;
    bHide: TButton;
    mText: TMemo;
    Procedure bHideOnClick (Sender: TObject);
    Procedure vBoxOnItemSelect (Sender: TObject; Index: LongInt);
    Procedure bChooseOnClick (Sender: TObject);
    Procedure bShutdownOnClick (Sender: TObject);
    Procedure MainFormOnShow (Sender: TObject);
  Private
    {Insert private declarations here}
  Public
    {Insert public declarations here}
    function ShellExecute(fname, fdir: string): Boolean;
  End;

Var
  MainForm: TMainForm;

Implementation

Procedure TMainForm.bHideOnClick (Sender: TObject);
Begin

  MainForm.Hide;

End;

Procedure TMainForm.vBoxOnItemSelect (Sender: TObject; Index: LongInt);
Begin

  ShellExecute(vBox.Items[Index].RealFileName
    , ExtractFilePath(vBox.Items[Index].RealFileName));

  MainForm.Hide;

End;

Procedure TMainForm.bChooseOnClick (Sender: TObject);
Begin

  if vBox.ItemIndex = -1 then exit;

  ShellExecute(vBox.Items[vBox.ItemIndex].RealFileName
    , ExtractFilePath(vBox.Items[vBox.ItemIndex].RealFileName));

  MainForm.Hide;

End;

Procedure TMainForm.bShutdownOnClick (Sender: TObject);
Begin

  ShellExecute('shutdown.exe', '');
  //Application.Terminate;

End;

Procedure TMainForm.MainFormOnShow (Sender: TObject);
var
  afile: TextFile;
  tmp, tmp2, tmp3: String;
  abmp: TBitmap;
Begin

  if FileExists(ExtractFilePath(Application.ExeName)+'pSwitch.cfg') then
    begin
    AssignFile(afile, ExtractFilePath(Application.ExeName)+'pSwitch.cfg');
    Reset(afile);
    Readln(afile, tmp); //header
    Readln(afile, tmp);
    MainForm.Caption := tmp;
    Readln(afile, tmp);
    lbHallo.Caption := tmp;
    Readln(afile, tmp);
    bChoose.Caption := tmp;
    Readln(afile, tmp);
    bShutdown.Caption := tmp;
    Readln(afile, tmp);
    bHide.Caption := tmp;
    abmp := TBitmap.Create;

    while not eof(afile) do
      begin
      Readln(afile, tmp);
      Readln(afile, tmp2);
      Readln(afile, tmp3);
      if FileExists(ExtractFilePath(Application.ExeName)+tmp3) then
        abmp.LoadFromFile(ExtractFilePath(Application.ExeName)+tmp3)
        else
        abmp := iDefault.Bitmap;
      vBox.AddFN(tmp, tmp2, nil, abmp);
      end;

    abmp.Free;
    CloseFile(afile);
    end
  else
    begin
    mText.Visible := True;
    vBox.Visible := False;
    end;

End;

function TMainForm.ShellExecute(fname, fdir: string): Boolean;
var
  sd: StartData;
  idSession: ULong;
  apid: PID;
  fname2, fdir2: pchar;
  rc, rc2: APIRET;
begin
new(fname2);
new(fdir2);
StrPCopy(fname2, fname);
StrPCopy(fdir2, fdir);
with sd do
  begin
      Length   := sizeof(StartData);
      Related  := ssf_Related_Independent; // start an independent session
      FgBg     := ssf_Fgbg_Fore;           // start session in foreground
      TraceOpt := ssf_TraceOpt_None;       // No trace
      PgmTitle := fname2;
      PgmName := fname2;
      PgmInputs := '';
      TermQ := nil;                        // No termination queue
      Environment := nil;                  // No environment string
      InheritOpt := ssf_InhertOpt_Parent;
      SessionType := ssf_Type_Default;
      IconFile := nil;                     // No icon association
      PgmHandle := 0;
      PgmControl := ssf_Control_Visible;
      InitXPos  := 0;     // Initial window coordinates
      InitYPos  := 0;
      InitXSize := 200;    // Initial window size
      InitYSize := 140;
      Reserved := 0;
      ObjectBuffer  := nil;
      ObjectBuffLen := 0;
  end;

if length(fdir)>3 then
  Delete(fdir, length(fdir), 1); //delete "\"
rc:=DosSetCurrentDir(fdir);
rc2:=DosStartSession(sd, idSession, apid);

freemem(fname2, sizeof(fname2));
freemem(fdir2, sizeof(fdir2));

result:=true;
end;
//--ShellExecute----------------------------

Initialization
  RegisterClasses ([TMainForm, TLabel, TButton, TListView, TImage, TBevel, TMemo]);
End.
