/****************************************************************************
 *                             S Y S T R A Y / 2                            *
 *                                                                          *
 * (C) 2001-2, OS2.Ru DevTeam              http://devcenter.os2.ru/systray  *
 * Written by Dmitry Zaharov                                 madint@os2.ru  *
 ****************************************************************************/

/****************************************************************************
 *
 *  This is an "Pulse" unit (CPU load monitor). Very simple and buggy ;-)
 *
 ****************************************************************************
                                                                            *
    Two different methods are used:                                         *
                                                                            *  
    1) Detecting process threads user/system delta-times                    *
       Well described in EDM2 article by Sergey Yevtushenko                 *
       I use its simplified version (C instead of C++)                      *
                                                                            *
    2) Performance call kernel API (absent in Warp3 FP's < 37)              *
       Documented in Warp 4.5 toolkit (DosPerfSysCall)                      *
       Used by WarpCenter                                                   *
                                                                            *
 ****************************************************************************/


#include "perfplug.h"
#include "dosqss.h"
#include <math.h> // FP used...

#ifndef QSV_NUMPROCESSORS
#define QSV_NUMPROCESSORS 26
#endif

/*
<Intel4004>  "native DosPerfSysCall API"     perfdll ?
<[MadInt]> 
<Intel4004> 饬 ஬ DosPerfSysCall(0x63, 㣨 맮 DosPerfSysCall  ⥡ ?
<[MadInt]> ⠬  祣- 易  ஢
<[MadInt]>    筮 
<Intel4004>  ᥬ scenter.dll, ᬮ५    - 饬 ⠬    ࠧ
            뢠  DosPerfSysCall(0x60,  ⮬  横  DosPerfSysCall(0x63,  
            ࠡ⠥  .    jjs   ⥬ 稫 -  DLL ⮦ ⠫
            ⥫쭮 ࠡ.
<[MadInt]>    !
<[MadInt]>   室?
<Intel4004>   ࠡ ;)   - ᨢ稪 ,   0x63 ਣ⮢
            -  ࠯ ;)
<[MadInt]> 
<[MadInt]> ᭮
*/
// Globals

extern HMODULE	hmod;
extern HAB	hab;

HPOINTER	hptrPulse;
char	        chDecimal = '.';

// 0.3.2 - old robust cpu load detection method
// (simplified to plain C Sergey Evtushenko's C++ code from EDM2 or SysBar/2)

#define PQ_BUFSIZE 0x20000 // critical. may be needed to increase in future
#define MAXPROC    1024 // see above...

char	        qssbuf[PQ_BUFSIZE];


struct  PROCLIST
{
   USHORT pid;
   USHORT touch;
   LONG   lDeltaUsr;
   LONG   lDeltaSys;
   ULONG  ulOldUsr;
   ULONG  ulOldSys;
} proclist[MAXPROC];

void proc2list(PQPROCESS pProcRecord, ULONG ulSys, ULONG ulUsr)
{
   int i;

   if(!pProcRecord->pid) return;

   for(i = 0; i < MAXPROC; i ++)
   {

      if(proclist[i].pid == pProcRecord->pid)
      {
         proclist[i].touch = 1;
         proclist[i].lDeltaUsr = ulUsr-proclist[i].ulOldUsr;
         proclist[i].lDeltaSys = ulSys-proclist[i].ulOldSys;
         proclist[i].ulOldUsr = ulUsr;
         proclist[i].ulOldSys = ulSys;
         break;
      }
   }

   if(i == MAXPROC)
   {

      for(i = 0; i < MAXPROC; i ++)
         if(!proclist[i].pid) break;

      proclist[i].touch = 1;
      proclist[i].pid = pProcRecord->pid;
      proclist[i].lDeltaUsr = 0L; // new process
      proclist[i].lDeltaSys = 0L;
      proclist[i].ulOldUsr = ulUsr;
      proclist[i].ulOldSys = ulSys;
   }
}

void cleanlist()
{
   int i;

   for(i = 0; i < MAXPROC; i ++)
      proclist[i].touch = 0; // reset "touch" flag
}

void initlist()
{
   int i;

   for(i = 0; i < MAXPROC; i ++)
      proclist[i].pid = 0; // clean our process list
}

int GetCPULoad()
{
   APIRET rc;
   PQPROCESS pProcRecord;
   PQTHREAD pThread;
   PQTOPLEVEL pqData = 0;

   int i, j, lSys, lUsr;

   static BOOL fInitList = FALSE;
   static BOOL fFirst = TRUE;
   ULONG ulSys = 0L, ulUsr = 0L;


   if(!fInitList)
   {
      initlist();
      fInitList = TRUE;
   }

   pqData = (PQTOPLEVEL) qssbuf;
   memset(pqData, 0, PQ_BUFSIZE);

   if(DosQuerySysState(0x1F, 0, 0, 0, pqData, PQ_BUFSIZE)) return 0; // error, return 0%

   pProcRecord = pqData->procdata;
   cleanlist(); // reset "touched" flag for all processes

   while(pProcRecord->rectype != 3) // slide through each process and thread
   {
      pThread = pProcRecord->threads;
      ulSys = ulUsr = 0L;

      if(pThread)
      {
         for(j = 0; j < pProcRecord->threadcnt; j++)
         {
            ulSys += pThread->systime;
            ulUsr += pThread->usertime;
            pThread++;
         }

         proc2list(pProcRecord, ulSys, ulUsr); // "touch" or add process
         pProcRecord = (PQPROCESS)(pThread);
      } else pProcRecord++;
   }

   if(fFirst)
   {
      fFirst = FALSE;
      return 0; // at first, we only fill list and return
   }

   lSys = lUsr = 0; // possible?

   for(i = 0; i < MAXPROC; i ++)
   {
      if(!proclist[i].touch) proclist[i].pid = 0;
      else if(proclist[i].pid)
      {
         lSys += proclist[i].lDeltaSys;
         lUsr += proclist[i].lDeltaUsr;
      }
   }

   if((lSys + lUsr) <= 0)
   {
      lSys = 1; lUsr = 0;
   }

return (int)(((double)lUsr * 1000.0) / (lSys + lUsr));
}

double ll2d(ULONG high, ULONG low)
{
   double t;

   t = ((double)low)/65536.0;
   t += ((double)high)*65536.0;

return t;
}

void ResetPerfCounters(PUNITCM pUnit)
{
   int i;

   DosPerfSysCall(0x60, (ULONG)0, (ULONG)0, (ULONG)0); // 10x to Intel4004
                                                      // from #os2russian
                                                     // (Yaroslav Komarov)

   for(i = 0; i < MAXPROCESSORS; i ++)
      pUnit->priv.dIdleTime[i] = pUnit->priv.dBusyTime[i] = 0.0;
}

void GetPerfCounters(PUNITCM pUnit)
{
   int i;
   PCPUUTIL pCPUUtil;
   double dIdleTimeOld[MAXPROCESSORS],
          dBusyTimeOld[MAXPROCESSORS];

   pCPUUtil = pUnit->priv.aCPUUtil;

   // save old times here.

   for(i = 0; i < MAXPROCESSORS; i ++)
   {
      dIdleTimeOld[i] = (ll2d(pCPUUtil->ulIdleHigh, pCPUUtil->ulIdleLow));
      dBusyTimeOld[i] = (ll2d(pCPUUtil->ulBusyHigh, pCPUUtil->ulBusyLow));
   }

   DosPerfSysCall(CMD_KI_RDCNT, (ULONG)&pUnit->priv.aCPUUtil[0], (ULONG)0, (ULONG)0); // read new 

   pCPUUtil = pUnit->priv.aCPUUtil;

   for(i = 0; i < MAXPROCESSORS; i ++)
   {
      pUnit->priv.dIdleTime[i] = (ll2d(pCPUUtil->ulIdleHigh, pCPUUtil->ulIdleLow)) - dIdleTimeOld[i];
      pUnit->priv.dBusyTime[i] = (ll2d(pCPUUtil->ulBusyHigh, pCPUUtil->ulBusyLow)) - dBusyTimeOld[i];
   }
}

int GetPulse(PUNITCM pUnit, USHORT usCPU)
{

    GetPerfCounters(pUnit);

return (pUnit->ulFlags & CMF_OVERALL) ? GetCPULoad() :
        (int)((pUnit->priv.dBusyTime[usCPU] * 1000.0) /
              (pUnit->priv.dBusyTime[usCPU] + pUnit->priv.dIdleTime[usCPU]));
}

void UpdatePulse(PUNITCM pUnit)
{
   int load = GetPulse(pUnit, pUnit->usCPUNum);

   if(load < 0) load = 0;
   if(load > 1000) load = 1000; // wrap if overflow

   if(pUnit->priv.i >= pUnit->priv.iCount)
   {
      pUnit->priv.i = pUnit->priv.iCount;
      // shift graph items
      memcpy(&pUnit->priv.samples[0], &pUnit->priv.samples[1], (MAXSAMPLES - 1) * sizeof(INT));
      pUnit->priv.samples[pUnit->priv.i - 1] = load;
   } else
   {
      pUnit->priv.samples[pUnit->priv.i] = load;
      pUnit->priv.i ++;
   }
}

MRESULT	EXPENTRY CpuMonDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   PUNITCM pUnit = (PUNITCM)WinQueryWindowULong(hwnd, QWL_USER);
   ULONG ulNumCPUs = 1L;

   switch(msg)
   {
      case WM_INITDLG:
      pUnit = (PUNITCM)mp2;
      WinSetWindowULong(hwnd, QWL_USER, (ULONG)mp2);

      DosQuerySysInfo(QSV_NUMPROCESSORS, QSV_NUMPROCESSORS, &ulNumCPUs, sizeof(ULONG));

      WinSendDlgItemMsg(hwnd, IDR_CPUSPIN, SPBM_SETLIMITS, (MPARAM)ulNumCPUs, (MPARAM)1L);
      WinSendDlgItemMsg(hwnd, IDR_CPUSPIN, SPBM_SETCURRENTVALUE,
                        (MPARAM)(pUnit->usCPUNum + 1), (MPARAM)0L);

      WinCheckButton(hwnd, IDR_SHOWPERCENT, ((pUnit->ulFlags & CMF_SHOWPERCENT) != 0));
      WinCheckButton(hwnd, IDR_SHOWICON, ((pUnit->ulFlags & CMF_SHOWICON) != 0));

      if(pUnit->ulFlags & CMF_OVERALL) WinCheckButton(hwnd, IDR_ALLCPUS, TRUE);
      else                             WinCheckButton(hwnd, IDR_CPUN, TRUE);

      break;

      case WM_COMMAND:
      return (MRESULT)0L;

      case WM_DESTROY:

      pUnit->ulFlags = 0L;

      WinSendDlgItemMsg(hwnd, IDR_CPUSPIN, SPBM_QUERYVALUE,
                        (MPARAM)&ulNumCPUs, MPFROM2SHORT(0, SPBQ_UPDATEIFVALID));

      if(WinQueryButtonCheckstate(hwnd, IDR_ALLCPUS)) pUnit->ulFlags |= CMF_OVERALL;

      if(WinQueryButtonCheckstate(hwnd, IDR_SHOWPERCENT)) pUnit->ulFlags |= CMF_SHOWPERCENT;

      if(WinQueryButtonCheckstate(hwnd, IDR_SHOWICON)) pUnit->ulFlags |= CMF_SHOWICON;

      pUnit->usCPUNum = (USHORT)ulNumCPUs - 1;
      break;
   }

return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

BOOL CpuMonPaint(HWND hwnd, PUNITCM pUnit)
{
   HPS hps;
   RECTL rcl, rclReg, rclPaint;
   CHAR szText[40];
   INT i, n, cxIcon = WinQuerySysValue(HWND_DESKTOP, SV_CXICON)/2;

   n = max(0, (pUnit->priv.i - 1));

   sprintf(szText,"%d%c%d %%", pUnit->priv.samples[n]/10, chDecimal, pUnit->priv.samples[n]%10);

   WinQueryWindowRect(hwnd, &rcl);

   hps = WinBeginPaint(hwnd, 0L, &rclPaint);
   GpiCreateLogColorTable(hps, 0L, LCOLF_RGB, 0L, 0L, (PLONG) NULL);
//   if(!pUnit->priv.hpsBuffer)
//      CreateGraphicsBuffer(&rcl, hps, &pUnit->priv.hpsBuffer, &pUnit->priv.hdcBuffer);

   WinFillRect(pUnit->priv.hpsBuffer, &rcl, pUnit->fcInfo[0].lBackColor);

   if(pUnit->ulFlags & CMF_SHOWICON) // draw icon if supposed
   {
      rclReg = rcl; rclReg.xRight = cxIcon + 2;
      rcl.xLeft += cxIcon + 2;

      WinDrawPointer(pUnit->priv.hpsBuffer, rclReg.xLeft + (rclReg.yTop - cxIcon)/2,
                     rclReg.yBottom + (rclReg.yTop - cxIcon)/2, hptrPulse, DP_MINI);
   }

   GpiSetColor(pUnit->priv.hpsBuffer, pUnit->fcInfo[1].lBackColor);

   for(i = rcl.xLeft; i < rcl.xRight; i ++) // draw graph...
   {
      POINTL ptl;
      INT iBeg = max(0, (pUnit->priv.i - (rcl.xRight - rcl.xLeft))),

      iNum = min((rcl.xRight - rcl.xLeft), pUnit->priv.i);

      if((i - rcl.xLeft) >= iNum) break;

      ptl.x = i; ptl.y = 0;
      GpiMove(pUnit->priv.hpsBuffer, &ptl);

      ptl.y += (pUnit->priv.samples[i - rcl.xLeft + iBeg] * (rcl.yTop - 1)) / 1000;
      GpiLine(pUnit->priv.hpsBuffer, &ptl);
   }


   if(pUnit->ulFlags & CMF_SHOWPERCENT)
      WinDrawText(pUnit->priv.hpsBuffer, -1, szText, &rcl, pUnit->fcInfo[0].lTextColor, 
                  pUnit->fcInfo[0].lBackColor, DT_CENTER | DT_VCENTER);

   BlitGraphicsBuffer(hps, pUnit->priv.hpsBuffer, &rclPaint); // blit image
   WinEndPaint(hps);

return TRUE;
}

MRESULT	CpuMonPresParam(HWND hwnd, INT idAttr, PUNITCM pUnit)
{
   HPS hps;
   BOOL fRepaint = TRUE;

   switch(idAttr)
   {
      case PP_FOREGROUNDCOLOR:
      pUnit->fcInfo[0].lTextColor = GetItemTextColor(hwnd);
      break;

      case PP_BACKGROUNDCOLOR:
      pUnit->fcInfo[0].lBackColor = GetItemBackColor(hwnd);
      break;

      case 0: // Scheme palette dropped
      pUnit->fcInfo[0].lTextColor = GetItemTextColor(hwnd);
      pUnit->fcInfo[0].lBackColor = GetItemBackColor(hwnd);

      // fallthrough

      case PP_FONTNAMESIZE:
      GetItemFont(hwnd, pUnit->fcInfo[0].szFont);
      hps = WinGetPS(hwnd);
      CopyFontSettings(hps, pUnit->priv.hpsBuffer);
      WinReleasePS(hps);
      break;

      default: fRepaint = FALSE;
   }

   if(fRepaint)
   {
      WinInvalidateRect(hwnd, NULL, FALSE);
   }

return (MRESULT)fRepaint;
}

MRESULT	EXPENTRY CpuMonWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   RECTL rcl;
   PUNITCM pUnit;
   HPS hps;

   pUnit = (PUNITCM)WinQueryWindowULong(hwnd, 0L); // get unit instance data and settings

   switch(msg)
   {
      case WM_CREATE:
      // Setup Unit instance data
      pUnit = (PUNITCM)mp1;
      pUnit->Unit.ulRefresh = 1L;
      pUnit->Unit.ulCounter = 0L;
      WinSetWindowULong(hwnd, 0L, (ULONG)pUnit);

      if(pUnit->Unit.fJustCreated)
      {
         pUnit->fcInfo[0].lTextColor = WinQuerySysColor(HWND_DESKTOP, SYSCLR_WINDOWSTATICTEXT, 0L);
         pUnit->fcInfo[0].lBackColor = WinQuerySysColor(HWND_DESKTOP, SYSCLR_BUTTONMIDDLE, 0L);
         pUnit->fcInfo[1].lTextColor = 0x00000000;
         pUnit->fcInfo[1].lBackColor = 0x000000FF;
         strcpy(pUnit->fcInfo[0].szFont, "9.WarpSans");
         strcpy(pUnit->fcInfo[1].szFont, "");
         pUnit->Unit.fJustCreated = FALSE;
         pUnit->ulFlags = CMF_OVERALL | CMF_SHOWPERCENT;
         pUnit->usCPUNum = 0;
      }

      SetItemFont(hwnd, pUnit->fcInfo[0].szFont);
      SetItemTextColor(hwnd, pUnit->fcInfo[0].lTextColor);
      SetItemBackColor(hwnd, pUnit->fcInfo[0].lBackColor);

      memset(&pUnit->priv, 0, sizeof(pUnit->priv));
      pUnit->priv.i = 0;
      pUnit->priv.iCount = 1;
      ResetPerfCounters(pUnit);
      break;

      case WM_SIZE: // recreate graphics buffer
//      if(pUnit->priv.hpsBuffer && pUnit->priv.hdcBuffer)
//      {
         DestroyGraphicsBuffer(pUnit->priv.hpsBuffer, pUnit->priv.hdcBuffer);

         WinQueryWindowRect(hwnd, &rcl);
         hps = WinGetPS(hwnd);
         CreateGraphicsBuffer(&rcl, hps, &pUnit->priv.hpsBuffer, &pUnit->priv.hdcBuffer);
         WinReleasePS(hps);
//      }
      pUnit->priv.iCount = rcl.xRight - rcl.xLeft;
      break;

      case WM_DESTROY:
      DestroyGraphicsBuffer(pUnit->priv.hpsBuffer, pUnit->priv.hdcBuffer);
      break;

      case USTM_REFRESHTIMER:  
      //WinQueryWindowRect(hwnd, &rcl);
      //pUnit->priv.iCount = rcl.xRight - rcl.xLeft;
      UpdatePulse(pUnit);
      WinInvalidateRect(hwnd, NULL, FALSE);
      break;

      case USTM_QUERYWIDTH:
      // Return default unit width
      return (MRESULT) 40L; // 40 pixels wide (default)

      case USTM_QUERYICON:
      return (MRESULT)hptrPulse;

      case USTM_QUERYNBINFO:
      {
         PUNITNBINFO punbInfo = (PUNITNBINFO)mp1;
         static PSZ ppszfcInfo[] = {"Monitor text", "Pulse graph"};
         static UNITPGINFO upgInfo;

         upgInfo.pszTabText = "Monitor";
         upgInfo.pszStatusText = "Pulse";
         upgInfo.res = hmod;
         upgInfo.id = IDR_PULSEDLG;
         upgInfo.mp2InsertFlags =  MPFROM2SHORT((BKA_STATUSTEXTON |
                                                 BKA_AUTOPAGESIZE |
                                                 BKA_MAJOR), BKA_FIRST);
         upgInfo.pfnDlgProc = (PFNWP)CpuMonDlgProc;
         upgInfo.pCreateParams = (PVOID)pUnit;
         upgInfo.hwnd = NULLHANDLE;
         upgInfo.pupgInfoNext = NULL;
         upgInfo.ulPageFlags = NPF_ALL;

         punbInfo->sNumfcInfo = 2;
         punbInfo->ppszfcInfo = (PSZ*)ppszfcInfo;
         punbInfo->pfcInfo = &pUnit->fcInfo[0];
         punbInfo->pupgInfo = &upgInfo;
         punbInfo->idTurnTo = IDR_PULSEDLG;
         punbInfo->hptrWindowIcon = hptrPulse;

      return (MRESULT) TRUE;
      }

      case WM_PAINT:
      CpuMonPaint(hwnd, pUnit);
      return (MRESULT)TRUE;

      case WM_PRESPARAMCHANGED:
      return CpuMonPresParam(hwnd, (INT)mp1, pUnit);
   }

return WinDefWindowProc(hwnd, msg, mp1, mp2);
}

BOOL	CpuMonRegister(HAB _hab, HMODULE _hmod, PWCLASS _pwc)
{
   _pwc->pszName = "SPLG_CpuMon";
   _pwc->pszViewName = "Pulse";
   _pwc->pszHelpFileName = "perfplug.hlp";
   _pwc->ulHelpPanelID = 100;

   _pwc->usMaxUnits = 0; // unlimited
   _pwc->usFlags = STUF_MANUAL | STUF_STATIC;

   _pwc->ulFix = sizeof(UNITCM) - sizeof(PULSEPRIVATE);
   _pwc->ulSafeAlloc = sizeof(UNITCM);

    WinRegisterClass(_hab, _pwc->pszName, (PFNWP)CpuMonWndProc, CS_SIZEREDRAW, sizeof(PVOID));

    hptrPulse = WinLoadPointer(HWND_DESKTOP, _hmod, IDR_CPUICON);

return TRUE;
}

BOOL	CpuMonDeregister(HAB _hab, HMODULE _hmod)
{

   if(hptrPulse) WinDestroyPointer(hptrPulse);

return TRUE;
}
