/****************************************************************************
 *                             S Y S T R A Y / 2                            *
 *                                                                          *
 * (C) 2001-2, OS2.Ru DevTeam              http://devcenter.os2.ru/systray  *
 * Written by Dmitry Zaharov                                 madint@os2.ru  *
 ****************************************************************************/

#ifndef _SYSTRAY_H_
#define _SYSTRAY_H_             // mutex protection

#define ST_VERSION              "Workplace Systray, v0.3.7"
#define ST_VERSION_NUMBER       307
#define ST_COMPILED		("Compiled at " __DATE__ " " __TIME__)

#define INCL_WIN
#define INCL_GPI
#define INCL_DOS

#ifndef SOMDLINK
#define SOMDLINK        SOMLINK         // Watcom?
#endif

#ifndef somMethodTabs
#define somMethodTabs   somMethodTab    // Watcom?
#endif

#include <os2.h>

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <malloc.h>

//#include <sys\stat.h>

#include <wpfolder.h>

#ifndef  _NO_PMWIN_UNDOC        // for RC error-protection
#include "_pmwin.h" // undocumented stuff from E.Evstigneev (thanks a lot)
#endif

#ifndef BKN_PAGESELECTEDPENDING
#define BKN_PAGESELECTEDPENDING  134     /* New page selected by user */
#endif
// Core constants...

#define CBMAXSTRING             250 // DO NOT CHANGE!!! MANY TYPES DEPENDS ON IT!
#define CBRESERVE               32
#define CB_CLASS		150
#define CB_UNITTITLE		100
#define MAXVIEWS                16
#define MAXUNITS                256
#define MAXCLASSES              1024
#define VIEWTHREADSTACK         81920

//

#ifndef BS_MINIICON
#define BS_MINIICON             0x0020
#endif

/* Plugin */

typedef struct _WCLASS {
PSZ     pszName;                // Internal unit window class name
PSZ     pszViewName;            // Name displayed in "Add unit" menu
PSZ     pszHelpFileName;        // Help library file name (without path)
ULONG   ulHelpPanelID;          // Help panel id for this unit class

USHORT  usMaxUnits;             // 0-unlimited
USHORT  usFlags;                // Unit class flags

USHORT  usAlignWord;
ULONG   ulReserved;

ULONG   ulFix;                  // Set in UNIT.cbFix
ULONG   ulSafeAlloc;            // Allocated memory for UNIT
} WCLASS;

typedef WCLASS *PWCLASS;

typedef BOOL (APIENTRY _REGISTERPLUGIN) (HMODULE hm,HAB hab,PWCLASS pwc,PUSHORT n);
typedef _REGISTERPLUGIN   *P_REGISTERPLUGIN;

typedef BOOL (APIENTRY _DEREGISTERPLUGIN) (HMODULE hm,HAB hab);
typedef _DEREGISTERPLUGIN *P_DEREGISTERPLUGIN;

typedef struct _PLUGIN {
CHAR    szModule[CBMAXSTRING]; /* Full plugin module path */
HMODULE hmod;
PWCLASS pwc;
USHORT  usNumClasses;
P_REGISTERPLUGIN
        RegisterPlugin;
P_DEREGISTERPLUGIN
        DeregisterPlugin;
} PLUGIN;

typedef PLUGIN *PPLUGIN;

typedef struct _UNIT {
ULONG   cbFix;                  // From WCLASS.ulFix, but can be changed by
                                // unit at run-time
HWND    hwnd;                   // Window handle (valid AFTER WM_CREATE)
HWND    hwnd_Menu;              // Popup menu (always valid)
CHAR    szClass[CB_CLASS];	// Window class
CHAR    szUnitTitle[CB_UNITTITLE];
USHORT  usFlags;                // Unit flags
INT     iWidth, iRow;
BOOL    fGrpNext;               // Followed with group?
BOOL    fJustCreated;           // Just created?
ULONG   ulRefresh;              // Refresh period
ULONG   ulCounter;              // Refresh counter
PVOID   pViewData;              // Pointer to Systray view data
PFNWP   pfnSubclUnitProc;       // Subclassing window proc adress
PFNWP   pfnOldUnitProc;         // Saved window proc address
ULONG	ulGroupFlags;		// Group flags
ULONG   ulReserved[7];
} UNIT, *PUNIT;

typedef struct _PICKEDUNITS {
USHORT  usUnits;
PUNIT   pUnits[1];
} PICKEDUNITS, *PPICKEDUNITS;

typedef struct _VIEW_CONFIG {
// --- "Systray" Page #1 ---
struct
  {
// [Popup]
  BYTE    bOntopMethod;
// [Hide delay]
  BYTE	  bHideDelay;
// [Position]
  BOOL    fBottom;
  BOOL    fResizeDesktop;

  } page1;

// --- "Style" Page #2 ---
struct
  {
// [Draw controls]
  BOOL    fFramedUnits;
  BOOL    fFramedAll;
  BOOL    fHideSpacebars;
  BOOL	  fDrawVertbars;
// [Hints]
  BOOL    fDisableHint;
  BOOL    fFastHints;
// [Dimensions]
  BYTE    bRowHeight;
  BYTE    bBorderWidth;
  BYTE    bViewSpacing;
  BYTE    bUnitSpacing;
  } page2;

BYTE    bRows;
ULONG   ulBackColor;
BOOL	fFirstRun;
} VIEWCONFIG, *PVIEWCONFIG;

#define ONTOP_NONE      0
#define ONTOP_ALWAYS    1
#define ONTOP_POPUP     2
#define ONTOP_POPHIDE   3

typedef struct _VIEW_DATA {
RECTL   rclView;
VIEWCONFIG
        viewConfig;
USHORT  usUnits;
PUNIT   pUnits[MAXUNITS];
PVOID   somSelf;
HMQ     hmq;
HAB     hab;
HWND    hwnd;
HWND    hwnd_Frame;
HWND    hwnd_Popup;
ULONG   hev;
CHAR    szIniFile[CBMAXSTRING];
CHAR    szIniApp[CBMAXSTRING];

USEITEM UseItem;
VIEWITEM
        ViewItem;

INT     iRow, iGrpClicked;
BOOL    fGrpClicked, fHidden, fUpdateDesktop;
ULONG	tid;
INT	iHideTemp;
} VIEWDATA, *PVIEWDATA;

typedef struct _UNITFORMAT
{
ULONG	ulFormatFlags; // UFF_*
ULONG	ulGreaterMB, ulGreaterKB, ulGreaterBytes;
} UNITFORMAT, *PUNITFORMAT;

typedef struct _FNTCLRINFO
{
LONG    lTextColor;
LONG    lBackColor;
CHAR    szFont[56];
} FNTCLRINFO, *PFNTCLRINFO;

typedef struct _UNITPGINFO
{
PSZ     pszTabText;
PSZ     pszStatusText;
HMODULE res;
ULONG   id;
MPARAM  mp2InsertFlags;
PFNWP   pfnDlgProc;
PVOID   pCreateParams;
HWND    hwnd;           // must be NULLHANDLE on startup
ULONG   ulNBPageID,     // must be 0L on startup
        ulPageFlags;    //

struct _UNITPGINFO * pupgInfoNext;
} UNITPGINFO, *PUNITPGINFO;

typedef struct _UNITNBINFO
{
PUNIT           pUnit;
PVOID           pUserData;
PFNTCLRINFO     pfcInfo;
PSZ             *ppszfcInfo;
SHORT           sNumfcInfo;
PUNITPGINFO     pupgInfo;
ULONG           idTurnTo;
HPOINTER        hptrWindowIcon;
PVIEWDATA       pvd;
PUNITPGINFO     pupgCurrent;
ULONG		ulUFEnabled;	// UFE_*
PUNITFORMAT	pufInfo;	// May be null.
} UNITNBINFO, *PUNITNBINFO;

// group flags

#define GF_SHOWICON		0x00000001
#define GF_AUTOPOPUP		0x00000002
#define	GF_SWITCHBYCLICK	0x00000004

// Unit format flags enabled

#define UFE_SHOWICON		0x00000001
#define UFE_SHOWTITLEINUNIT	0x00000002
#define UFE_FORMATINGB		0x00000004
#define UFE_FORMATINMB		0x00000008
#define UFE_FORMATINKB		0x00000010
#define UFE_TITLE		0x00000020	// ignored, always enabled

// Unit format flags

#define UFF_SHOWICON		UFE_SHOWICON
#define UFF_SHOWTITLEINUNIT	UFE_SHOWTITLEINUNIT
#define UFF_FORMATINGB		UFE_FORMATINGB
#define UFF_FORMATINMB		UFE_FORMATINMB
#define UFF_FORMATINKB		UFE_FORMATINKB

//

// Flags (Notebook page)

#define NPF_UNDO                0x00000001
#define NPF_DEFAULT             0x00000002
#define NPF_HELP                0x00000004
#define NPF_BYPASSHELP          0x00000008

#define NPF_ALL                 0x00000007      // Except NPF_BYPASSHELP!

// Flags (WCLASS)

#define STUF_FIXED              0x0001          // [!]
#define STUF_STATIC             0x0002
#define STUF_MANUAL             0x0004          // [!]
#define STUF_FRAMED             0x0008          //
#define STUF_FULLWIDTH          0x0010          // [!]
#define STUF_NOHINT             0x0020
#define STUF_HIRESTIMER         0x0040          // 1/10 sec instead of 1
#define STUF_NONEXTHANDLER      0x0080

// timers

#define TMR_MAINTIMER           1000
#define TMR_HIRESTIMER          1001
#define TMR_HIDEDELAY		1002

#define TMR_HINTSHOW            2001
#define TMR_HINTHIDE            2002

// [!] = Incompatible flags

// Other definitions

#define STDEF_BYTES2RESERVE     4L
#define STDEF_UNITDATAOFFSET    0L
#define STDEF_VIEWSYSTRAY       (WPMENUID_USER+0x00FF)

// Unit messages

#define USTM_REFRESHTIMER    (WM_USER + 0x1000)
#define USTM_QUERYNBINFO     (WM_USER + 0x1001)
#define USTM_QUERYHINT       (WM_USER + 0x1002)
#define USTM_QUERYWIDTH      (WM_USER + 0x1003)
#define USTM_MOVED           (WM_USER + 0x1004)
#define USTM_GROUPED         (WM_USER + 0x1005)
#define USTM_SAVING          (WM_USER + 0x1006)
#define USTM_REMOVED         (WM_USER + 0x1007)
#define USTM_SELFCONTROLMENU (WM_USER + 0x1008)
#define USTM_FORCEHINT       (WM_USER + 0x1009)
#define USTM_RESIZE          (WM_USER + 0x100A)
#define USTM_FILLGROUPTITLE  (WM_USER + 0x100B)
#define USTM_QUERYICON       (WM_USER + 0x100C)
#define USTM_NEXTUNIT        (WM_USER + 0x100D)
#define USTM_NEXTUNITNOTIFY  (WM_USER + 0x100E)
#define USTM_MENUSHOWING     (WM_USER + 0x100F)
#define USTM_QUERYTEXT       (WM_USER + 0x1010)

#define USTM_UPDATE             WM_PRESPARAMCHANGED
#define STM_UPDATE              USTM_UPDATE


#ifndef _NO_ST_TWEAK
#include "lang\st_tweak.h"
#endif

// Systray messages (unused currently)

#define STM_POPUPMENU           (WM_USER + 0x200)
#define STM_RESIZE              (WM_USER + 0x201)
#define STM_FORCEHINT           (WM_USER + 0x202)
#define STM_UPDATEFLAGS         (WM_USER + 0x203)

// View Thread Messages

#define VTM_CREATEVIEW      (WM_USER + 0x100)
#define VTM_POPUP           (WM_USER + 0x101)
#define VTM_RESTORE         (WM_USER + 0x102)
#define VTM_SAVECONFIG      (WM_USER + 0x103)
#define VTM_IMPORTVC        (WM_USER + 0x104)
#define VTM_EXPORTVC        (WM_USER + 0x105)

// Hack :((( we use some of old Toolkit 2.x headers :(((((((((

#ifndef MENU_OBJECTPOPUP
#define MENU_OBJECTPOPUP          0x00000001
#define MENU_OPENVIEWPOPUP        0x00000002
#define MENU_TITLEBARPULLDOWN     0x00000003
#define MENU_TITLEBARPULLDOWNINT  0x00000004
#define MENU_FOLDERPULLDOWN       0x00000005
#define MENU_VIEWPULLDOWN         0x00000006
#define MENU_HELPPULLDOWN         0x00000007
#define MENU_EDITPULLDOWN         0x00000008
#define MENU_SELECTEDPULLDOWN     0x00000009
#define MENU_FOLDERMENUBAR        0x0000000A
#define MENU_NODISPLAY            0x40000000
#define MENU_USER                 0x80000000
#endif

// Configuration

typedef struct _SETTINGS_DATA {
VIEWCONFIG
        vc, vcBak;
PVOID   somSelf;
BOOL    fSpinDone;              // safe PM flag
} SETTINGSDATA, *PSETTINGSDATA;

/* Found at PMMERGE.5468 */

//BOOL APIENTRY WinSetDesktopWorkArea(HWND hwndDesktop, PRECTL prclWorkArea);
typedef BOOL APIENTRY _WINSETDESKTOPWORKAREA(HWND hwndDesktop, PRECTL prclWorkArea);
typedef _WINSETDESKTOPWORKAREA *P_WINSETDESKTOPWORKAREA;

/* Found at PMMERGE.5469 */

//BOOL APIENTRY WinQueryDesktopWorkArea(HWND hwndDesktop, PRECTL prclWorkArea);
typedef BOOL APIENTRY _WINQUERYDESKTOPWORKAREA(HWND hwndDesktop, PRECTL prclWorkArea);
typedef _WINQUERYDESKTOPWORKAREA *P_WINQUERYDESKTOPWORKAREA;

// Internal protos

// PROFILE.C

void    profile_close();
void    profile_open(HAB hab, char *inifile);
void    profile_setapp(char *iniapp);
void    profile_loadint(char *key,int *i);
void    profile_loadushort(char *key,PUSHORT u);
void    profile_loadblob(char *key,PVOID blob,ULONG ulSize);
void    profile_loadstring(char *key,PSZ pszData);
void    profile_saveint(char *key,int *i);
void    profile_saveushort(char *key,PUSHORT u);
void    profile_saveblob(char *key,PVOID blob,ULONG ulSize);
void    profile_savestring(char *key,PSZ pszData);

// SYSTRAY.C

void    GenLoadPlugins(PSZ pszSearchPath);
void    GenUnloadPlugins(HAB hab);
void    GenLoadClasses(HAB hab);
void    GenSystrayClassInit(PVOID somSelf);
void    GenSystrayClassUnInit(PVOID somSelf);
BOOL    GenSwitchToSystrayView(PVOID somSelf);
BOOL    GenSaveView(PVOID somSelf);
HWND    GenCreateAnotherSystrayView(PVOID somSelf);
void    GenMainViewThread(PVIEWDATA pViewData);
PWCLASS GenSearchClass(PSZ pszName);

VOID    GenImportViewConfig(HAB hab, PVOID somSelf, PVIEWCONFIG vc, ULONG ulPages);
VOID    GenExportViewConfig(HAB hab, PVOID somSelf, PVIEWCONFIG vc, BOOL fSave, ULONG ulPages);
BOOL    GenUpdateDesktopArea();

// CONFIG.C

VOID    CnfSaveUnits(PVIEWDATA pViewData);
VOID    CnfLoadUnits(PVIEWDATA pViewData);
VOID    CnfConfigLoad(char *inifile, char *iniapp, PVIEWDATA pViewData);
VOID    CnfConfigSave(char *inifile, char *iniapp, PVIEWDATA pViewData);
VOID    CnfViewConfigLoad(HAB hab, char *inifile, char *iniapp, PVIEWCONFIG pvc, ULONG ulPages);
VOID    CnfViewConfigSave(HAB hab, char *inifile, char *iniapp, PVIEWCONFIG pvc, ULONG ulPages);
VOID    DefaultViewConfig(PVIEWCONFIG pvc, ULONG ulPages);

// SYSTRAY.C again...

MPARAM EXPENTRY ObjectWindowProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
void	DbgPrintf(char *fmt, ...);
char	*GenLoadNls(char *dest, int id, char *def);

// VIEWCTL.C

HWND    ViewNewView(PVIEWDATA pViewData);
void    ViewUpdateView(PVIEWDATA pViewData);
void    ViewPaint(PVIEWDATA pvd, BOOL fFenced, BOOL fDragged);
void    ViewMakeDefaultUnits(PVIEWDATA pViewData);
BOOL    ViewContextMenu(PVIEWDATA pvd, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY ViewSubclFrameProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY ViewWindowProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY HintWindowProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY LogoWindowProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
BOOL    ViewDisplayHint(HWND hwnd, PSZ pszText);

// UNITCTL.C

BOOL    UctInsertUnit(PUNIT pNewUnit, PVIEWDATA pViewData, INT iIndex, BOOL fJustCreated);
BOOL    UctCreateSavedUnits(PVIEWDATA pViewData);
BOOL    UctUpdateUnitsView(PVIEWDATA pViewData);
VOID    UctReleaseAll(PVIEWDATA pViewData);
BOOL    UctAddUnit(PVIEWDATA pvd, PSZ pszName, /*INT iRow,*/ INT iIndex);
BOOL    UctTimerUpdate(PVIEWDATA pvd);
INT     UctGetLastInGroup(PVIEWDATA pvd, INT iIndex);
BOOL    UctSwapGroup(PVIEWDATA pvd, INT iFirstIndex, INT iLastIndex);
BOOL    UctBeginDrag(HWND hwnd, MPARAM mp1, MPARAM mp2, PUNIT pUnit);
INT     UctUnitFromPoint(PVIEWDATA pvd, PPOINTL pptl, PRECTL prcl);
BOOL    UctDropUnits(PVIEWDATA pvd, INT iBefore, PPICKEDUNITS ppu);
PPICKEDUNITS    UctPickupUnits(PVIEWDATA pvd, INT iIndex);

MRESULT EXPENTRY SubclUnitProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);

// VIEWCTL.C again...

void    DrawFence(HPS hps, PRECTL prcl, ULONG ulRadius);
VOID    BuildMenuClassList(HWND hwndMenu);
VOID    EnableMenuClassList(HWND hwndMenu, PVIEWDATA pvd);

// NOTEBOOK.C? and some useful stuff...

BOOL    NtbAddSettingsPage(PVOID somSelf, HWND hwndNotebook);

// 0.3.6 PMTOOLS.C

LONG    GetItemTextColor(HWND hwnd);
LONG    GetItemBackColor(HWND hwnd);
LONG    GetItemFont(HWND hwnd, PSZ pszFont);
VOID    SetItemTextColor(HWND hwnd, LONG lColor);
VOID    SetItemBackColor(HWND hwnd, LONG lColor);
VOID    SetItemFont(HWND hwnd, PSZ pszFont);
INT     GetSliderPos(HWND hwnd, ULONG id);
VOID    SetSliderPos(HWND hwnd, ULONG id, ULONG value);

#endif // _SYSTRAY_H_
