/****************************************************************************
 *                             S Y S T R A Y / 2                            *
 *                                                                          *
 * (C) 2001-2, OS2.Ru DevTeam              http://devcenter.os2.ru/systray  *
 * Written by Dmitry Zaharov                                 madint@os2.ru  *
 ****************************************************************************/

#include "systray.h"
#include "settings.h" // for unit settings resources
#include "lang\str_ids.h" // string resources

/*
 *  This file perform general unit controlling: updating, resizing, etc.
 *
 */

/****************************************************************************
   Unit sizing strategy based on Eugene Evstigneev scheme (pseudocode):     *
 ****************************************************************************
 *
 * > > ,    ⥣ 뤥   쪥.
 * > , ࠭ ⮩    :(
 * ࠧ  । ⠪ 奬:
 *
 * ᪨ fixed ;
 * ᫨(  쪥    䫠 full width )
 * {
 *   ⠬ manual   ਭ,    ᮣ;
 *   ᫨( full width  )
 *   {
 *     ⤠  ⠢襥 ;
 *   }
 *   
 *   {
 *     ࠧ  ஢;
 *   }
 * }
 * 
 * {
 *
 *   ᫨(    䫠 manual )
 *   {
 *       ஢;
 *   }
 *   
 *   {
 *     㬠, ⭮ ;-)
 *   }
 * }
 ***************************************************************************/

/*
 */

extern HMODULE hmSystrayRes;
extern PWCLASS pWClasses;
extern ULONG   ulClasses;
extern CHAR    szCommonPath[];
extern HPOINTER
               hptrHand;
extern BOOL    fMenuWork;

/*
 * Unit sizing divided into 2 steps:
 * 1) Determining unit size (since there are 3 unit types)
 * 2) Moving units to calculated position on Systray bar
 */

BOOL    UctInsertUnit(PUNIT pNewUnit, PVIEWDATA pViewData, INT iIndex, BOOL fJustCreated)
{
INT i;

// Failrue check
if(!pNewUnit) return FALSE;

// Shift down unit list
if(iIndex<pViewData->usUnits)
  for(i=pViewData->usUnits; i>iIndex; i--)
    pViewData->pUnits[i]=pViewData->pUnits[i-1];

pViewData->usUnits++;
pViewData->pUnits[iIndex]=pNewUnit;
pNewUnit->fJustCreated=fJustCreated;
pNewUnit->iWidth=-1;

pNewUnit->pViewData = (PVOID)pViewData;
pNewUnit->hwnd_Menu = WinLoadMenu(HWND_DESKTOP, hmSystrayRes, IDR_STANDARTMENU);
if(pNewUnit->hwnd_Menu) BuildMenuClassList(pNewUnit->hwnd_Menu); // Create from scratch
// create unit window
DbgPrintf("Inserting new unit %s\n", pNewUnit->szClass);
pNewUnit->hwnd = WinCreateWindow(pViewData->hwnd, pNewUnit->szClass, "", 0L, 0L, 0L, 0L, 0L,
                                 pViewData->hwnd, HWND_TOP, 0L, (PVOID)pNewUnit, (PVOID)NULL);

if(!pNewUnit->hwnd)
  {
  char msg[CBMAXSTRING];
  int PMerror = (int)WinGetLastError(pViewData->hab);
  if(pNewUnit->hwnd_Menu) WinDestroyWindow(pNewUnit->hwnd_Menu);
// 0.3.3
//    free(pNewUnit); // @#$%^ Whats happened, Dude?
  DbgPrintf("FAILED (PM error %d)\n", PMerror);
  sprintf(msg, GenLoadNls(NULL, IDS_UNITERROR1,
                 "Unit %s could not be created (PM error %d)"),
            pNewUnit->szClass, PMerror);

  WinMessageBox(HWND_DESKTOP, pViewData->hwnd, msg,
                GenLoadNls(NULL, IDS_ERROR, "Error"),
                0, MB_MOVEABLE | MB_ENTER | MB_ERROR);

  return FALSE;
  }

DbgPrintf("Successfull (hwnd=%d, pNewUnit=%p)\n", pNewUnit->hwnd, pNewUnit);

WinSetWindowULong(pNewUnit->hwnd, 0L, (ULONG)pNewUnit);

pNewUnit->pfnSubclUnitProc = (PFNWP)SubclUnitProc;

pNewUnit->pfnOldUnitProc = WinSubclassWindow(pNewUnit->hwnd,
                                             (PFNWP)SubclUnitProc);

return TRUE;
}

BOOL    UctCreateSavedUnits(PVIEWDATA pViewData)
{
INT i, j=0;
PUNIT pNewUnit;

for(i=0; i<pViewData->usUnits; i++)
  {
  pNewUnit = pViewData->pUnits[i];
  if(!pNewUnit) continue; // 0.3.3 extra check for corruption
  pNewUnit->fJustCreated = FALSE;
  pNewUnit->pViewData = (PVOID)pViewData;
  pNewUnit->hwnd_Menu = WinLoadMenu(HWND_DESKTOP, hmSystrayRes, IDR_STANDARTMENU);
  if(pNewUnit->hwnd_Menu) BuildMenuClassList(pNewUnit->hwnd_Menu); // Create from scratch
  // create unit window
  DbgPrintf("Creating saved unit %s\n", pNewUnit->szClass);

  pNewUnit->hwnd = WinCreateWindow(pViewData->hwnd, pNewUnit->szClass, "", 0L, 0L, 0L, 0L, 0L,
                                   pViewData->hwnd, HWND_TOP, 0L, (PVOID)pNewUnit, (PVOID)NULL);

  if(pNewUnit->hwnd)
    {
    WinSetWindowPtr(pNewUnit->hwnd, 0L, (PVOID)pNewUnit);
    pNewUnit->pfnSubclUnitProc = SubclUnitProc;

    pNewUnit->pfnOldUnitProc = WinSubclassWindow(pNewUnit->hwnd,
                                             (PFNWP)SubclUnitProc);
    DbgPrintf("Successfull (hwnd=%d)\n", pNewUnit->hwnd);
    pViewData->pUnits[j] = pNewUnit; // 0.3.3
    j ++;
    }
  else
    {
    char msg[CBMAXSTRING];
    int PMerror = (int)WinGetLastError(pViewData->hab);
    if(pNewUnit->hwnd_Menu) WinDestroyWindow(pNewUnit->hwnd_Menu);
// 0.3.3
//    free(pNewUnit); // @#$%^ Whats happened, Dude?
    DbgPrintf("FAILED (PM error %d)\n", PMerror);
    sprintf(msg, GenLoadNls(NULL, IDS_UNITERROR1,
                 "Unit %s could not be created (PM error %d)"),
            pNewUnit->szClass, PMerror);

    WinMessageBox(HWND_DESKTOP, pViewData->hwnd, msg,
                  GenLoadNls(NULL, IDS_ERROR, "Error"),
                  0, MB_MOVEABLE | MB_ENTER | MB_ERROR);

    }
  }

pViewData->usUnits = j;

return TRUE;
}

BOOL    UctUpdateUnitsView(PVIEWDATA pViewData)
{
INT i, r, iPixelsLeft, iNumFullWidth, iBarWidth, iNumManual;
RECTL rcl;
BOOL fPrevGrp;
BYTE bSizeWidth;

bSizeWidth = (!pViewData->viewConfig.page2.fHideSpacebars)            ?
             (2 +
              WinQuerySysValue(HWND_DESKTOP, SV_CXBORDER))            : 0;

WinQueryWindowRect(pViewData->hwnd, &rcl);
iBarWidth = abs(rcl.xRight-rcl.xLeft) - (pViewData->viewConfig.page2.bBorderWidth +
            pViewData->viewConfig.page2.bViewSpacing)*2;


for(r=0; r<pViewData->viewConfig.bRows; r++) // loop on all rows
  {
  iPixelsLeft = iNumManual = iNumFullWidth = 0;
  fPrevGrp = FALSE;
  for(i=0; i<pViewData->usUnits; i++)
    {
    if(pViewData->pUnits[i]->iRow != r) continue;
    if(fPrevGrp)
      {
      fPrevGrp = pViewData->pUnits[i]->fGrpNext; // FIX 0.1.4
      continue; // skip grouped units
      }
    if(pViewData->pUnits[i]->usFlags & STUF_FIXED) // query width for fixed units
      {
      if(!pViewData->pUnits[i]->fGrpNext || (pViewData->pUnits[i]->iWidth==-1))
        pViewData->pUnits[i]->iWidth = (INT)WinSendMsg(pViewData->pUnits[i]->hwnd,
                                                       USTM_QUERYWIDTH,
                                                       (MPARAM)0L, (MPARAM)0L);

      iPixelsLeft += pViewData->pUnits[i]->iWidth +
                     pViewData->viewConfig.page2.bUnitSpacing +
                     (pViewData->viewConfig.page2.fDrawVertbars ? 2 : 0);

      // include sizing border and icon for grouped units
      if(pViewData->pUnits[i]->fGrpNext) iPixelsLeft += bSizeWidth
                       + pViewData->viewConfig.page2.bRowHeight;
      }

    if(pViewData->pUnits[i]->usFlags & STUF_FULLWIDTH)
// OLD 0.1.4       !pViewData->pUnits[i]->fGrpNext) // increase fullwidth units count
      iNumFullWidth++;
// OLD 0.1.4      else if(pViewData->pUnits[i]->fGrpNext)
// OLD 0.1.4             iPixelsLeft += WinQuerySysValue (HWND_DESKTOP, SV_CXSIZEBORDER)
// OLD 0.1.4                          + WinQuerySysValue (HWND_DESKTOP, SV_CXBORDER)
// OLD 0.1.4                          + pViewData->viewConfig.page2.bRowHeight;

    if(pViewData->pUnits[i]->usFlags & STUF_MANUAL)
      {
      if(pViewData->pUnits[i]->iWidth == -1)
        pViewData->pUnits[i]->iWidth = (INT)WinSendMsg(pViewData->pUnits[i]->hwnd,
                                                       USTM_QUERYWIDTH,
                                                       (MPARAM)0L, (MPARAM)0L);

// OLD 0.1.4        iNumManual++; // increase manual units counter
// OLD 0.1.4     else
// OLD 0.1.4       {
        iPixelsLeft += pViewData->pUnits[i]->iWidth +
                       pViewData->viewConfig.page2.bUnitSpacing +
                       bSizeWidth + (pViewData->viewConfig.page2.fDrawVertbars ? 2 : 0); // NEW 0.1.8
      if(pViewData->pUnits[i]->fGrpNext) iPixelsLeft +=
                                         pViewData->viewConfig.page2.bRowHeight;
// OLD 0.1.4       }
      }

    fPrevGrp = pViewData->pUnits[i]->fGrpNext;
    }

  fPrevGrp = FALSE;

  if(iNumFullWidth>0)
    {
//  OLD 0.1.4    for(i=0; i<pViewData->usUnits; i++)
//  OLD 0.1.4      {
//  OLD 0.1.4      if(pViewData->pUnits[i]->iRow != r) continue;
//  OLD 0.1.4      if(fPrevGrp) continue;
//  OLD 0.1.4      if(pViewData->pUnits[i]->usFlags & STUF_MANUAL)
//  OLD 0.1.4        {
//  OLD 0.1.4        if(pViewData->pUnits[i]->iWidth == -1)
//  OLD 0.1.4          pViewData->pUnits[i]->iWidth = (INT)WinSendMsg(pViewData->pUnits[i]->hwnd,
//  OLD 0.1.4                                                         USTM_QUERYWIDTH,
//  OLD 0.1.4                                                         (MPARAM)0L, (MPARAM)0L);
//        iPixelsLeft += pViewData->pUnits[i]->iWidth + WinQuerySysValue (HWND_DESKTOP,
//                       SV_CXSIZEBORDER) + WinQuerySysValue (HWND_DESKTOP, SV_CXBORDER) +
//                       pViewData->viewConfig.bUnitSpacing; // reserve space for sizing hand

//        if(pViewData->pUnits[i]->fGrpNext) iPixelsLeft += pViewData->viewConfig.bRowHeight;
//  OLD 0.1.4        }
//  OLD 0.1.4      fPrevGrp = pViewData->pUnits[i]->fGrpNext;
//  OLD 0.1.4      }
    fPrevGrp = FALSE;
    for(i=0; i<pViewData->usUnits; i++)
      {
      if(pViewData->pUnits[i]->iRow != r) continue;
      if(fPrevGrp) // FIX 0.1.4
        {
        fPrevGrp = pViewData->pUnits[i]->fGrpNext;
        continue;
        }

      if(pViewData->pUnits[i]->usFlags & STUF_FULLWIDTH)
        {
        pViewData->pUnits[i]->iWidth = (iBarWidth - iPixelsLeft) / iNumFullWidth
                                       - pViewData->viewConfig.page2.bUnitSpacing;

        if(pViewData->pUnits[i]->fGrpNext) // NEW 0.1.4
          pViewData->pUnits[i]->iWidth -= pViewData->viewConfig.page2.bRowHeight +
                                          bSizeWidth; // NEW 0.1.8


        if(pViewData->pUnits[i]->iWidth < 0) pViewData->pUnits[i]->iWidth = 0;
        }
      fPrevGrp = pViewData->pUnits[i]->fGrpNext;
      }
    }// else OLD 0.1.4
//    {
//    for(i=0; i<pViewData->usUnits; i++)
//      {
//      if(pViewData->pUnits[i]->iRow != r) continue;
//      if(fPrevGrp) continue;
//      if(pViewData->pUnits[i]->usFlags & STUF_MANUAL)
//        {
//        if(pViewData->pUnits[i]->iWidth == -1)
//          {
//          pViewData->pUnits[i]->iWidth = (INT)WinSendMsg(pViewData->pUnits[i]->hwnd,
//                                                         USTM_QUERYWIDTH,
//                                                         (MPARAM)0L, (MPARAM)0L);
//          if(iNumManual && !pViewData->pUnits[i]->fGrpNext) // first we check for grouped manuals
//            if(pViewData->pUnits[i]->iWidth < (iBarWidth - iPixelsLeft) / iNumManual
//               - (WinQuerySysValue(HWND_DESKTOP, SV_CXSIZEBORDER) + WinQuerySysValue(HWND_DESKTOP,
//               SV_CXBORDER) + pViewData->viewConfig.bUnitSpacing)) // check if there free space
//              pViewData->pUnits[i]->iWidth = (iBarWidth - iPixelsLeft) / iNumManual
//              - (WinQuerySysValue(HWND_DESKTOP, SV_CXSIZEBORDER) + WinQuerySysValue(HWND_DESKTOP,
//              SV_CXBORDER) + pViewData->viewConfig.bUnitSpacing);  // then resize manual element
//          }
//        }
//      fPrevGrp = pViewData->pUnits[i]->fGrpNext;
//      }
//    } OLD 0.1.4
  iPixelsLeft = 0;
  fPrevGrp = FALSE;
  for(i=0; i<pViewData->usUnits; i++)
    {
    if(pViewData->pUnits[i]->iRow != r) continue;
    if(fPrevGrp)
      {
      WinShowWindow(pViewData->pUnits[i]->hwnd, FALSE);
      fPrevGrp = pViewData->pUnits[i]->fGrpNext;
      continue;
      }
    if(pViewData->pUnits[i]->fGrpNext) iPixelsLeft += pViewData->viewConfig.page2.bRowHeight;

    WinSetWindowPos(pViewData->pUnits[i]->hwnd, HWND_TOP, iPixelsLeft +
                    pViewData->viewConfig.page2.bBorderWidth + pViewData->viewConfig.page2.bViewSpacing,
                    pViewData->viewConfig.page2.bBorderWidth + pViewData->viewConfig.page2.bViewSpacing +
                    (pViewData->viewConfig.page2.bViewSpacing + pViewData->viewConfig.page2.bRowHeight)*
                    (pViewData->viewConfig.bRows-r-1),
                    pViewData->pUnits[i]->iWidth, pViewData->viewConfig.page2.bRowHeight,
                    SWP_MOVE | SWP_SIZE | SWP_SHOW);

    iPixelsLeft += pViewData->pUnits[i]->iWidth + pViewData->viewConfig.page2.bUnitSpacing
                +  (pViewData->viewConfig.page2.fDrawVertbars ? 2 : 0);
    fPrevGrp = pViewData->pUnits[i]->fGrpNext;

    if((pViewData->pUnits[i]->usFlags & STUF_MANUAL) || fPrevGrp)
      iPixelsLeft += bSizeWidth; // NEW 0.1.8
    }
  }

return TRUE;
}

VOID    UctReleaseAll(PVIEWDATA pViewData)
{
int i;

for(i=0; i<pViewData->usUnits; i++)
  {
  WinDestroyWindow(pViewData->pUnits[i]->hwnd);
  WinDestroyWindow(pViewData->pUnits[i]->hwnd_Menu);
  free(pViewData->pUnits[i]); // release memory
  }
}

INT     UctGetIndex(PVIEWDATA pvd, PUNIT pUnit)
{
INT i;

for(i=0; i<pvd->usUnits; i++)
  if((pvd->pUnits[i] == pUnit) && (pvd->pUnits[i]->hwnd == pUnit->hwnd))
    return i;

return -1;
}

BOOL    UctMoveLeft(PVIEWDATA pvd, INT iIndex)
{
INT i = iIndex;
if(iIndex >= pvd->usUnits) return FALSE;

while(pvd->pUnits[i]->fGrpNext && (i<pvd->usUnits-1)) i++;

if(!iIndex)
  {
  if(pvd->pUnits[iIndex]->iRow)
    {
    do{
      pvd->pUnits[iIndex]->iRow--; iIndex++;
      } while(pvd->pUnits[iIndex-1]->fGrpNext && (iIndex <= i));
    return TRUE;
    }
  return FALSE;
  }

if(pvd->pUnits[iIndex]->iRow > pvd->pUnits[iIndex-1]->iRow)
  {
  do{
    pvd->pUnits[iIndex]->iRow--; iIndex++;
    } while(pvd->pUnits[iIndex-1]->fGrpNext && (iIndex <= i));
  return TRUE;
  }

if(pvd->pUnits[iIndex]->iRow == pvd->pUnits[iIndex-1]->iRow)
  {
  PUNIT tmp;
  tmp = pvd->pUnits[iIndex-1];
  for(;iIndex<=i; iIndex++)
    pvd->pUnits[iIndex-1] = pvd->pUnits[iIndex];
  pvd->pUnits[i] = tmp;
  return TRUE;
  }

return FALSE; // strange error???
}

BOOL    UctMoveRight(PVIEWDATA pvd, INT iIndex)
{
INT i = iIndex;
if(iIndex >= pvd->usUnits) return FALSE;

while(pvd->pUnits[i]->fGrpNext && (i<pvd->usUnits-1)) i++;

if(i == pvd->usUnits - 1)
  {
  if(pvd->pUnits[i]->iRow >= pvd->viewConfig.bRows-1)
    return FALSE;
  else
    {
    do{
      pvd->pUnits[iIndex]->iRow++; iIndex++;
      } while(pvd->pUnits[iIndex-1]->fGrpNext && (iIndex <= i));
    return TRUE;
    }
  }

if(pvd->pUnits[i]->iRow < pvd->pUnits[i+1]->iRow)
  {
  do{
    pvd->pUnits[iIndex]->iRow++; iIndex++;
    } while(pvd->pUnits[iIndex-1]->fGrpNext && (iIndex <= i));
  return TRUE;
  }

if(pvd->pUnits[iIndex]->iRow == pvd->pUnits[iIndex+1]->iRow)
  {
  PUNIT tmp;
  tmp = pvd->pUnits[i+1];
  for(;i>=iIndex;i--)
    pvd->pUnits[i+1] = pvd->pUnits[i];
  pvd->pUnits[iIndex] = tmp;
  return TRUE;
  }

return FALSE; // strange error???
}

BOOL    UctGroupLeft(PVIEWDATA  pvd, INT iIndex)
{
if(!iIndex) return FALSE;

if(pvd->pUnits[iIndex-1]->iRow == pvd->pUnits[iIndex]->iRow)
  {
  pvd->pUnits[iIndex-1]->fGrpNext = TRUE;
  return TRUE;
  }

return FALSE;
}

BOOL    UctGroupRight(PVIEWDATA  pvd, INT iIndex)
{
if(iIndex>=pvd->usUnits-1) return FALSE;

if(pvd->pUnits[iIndex+1]->iRow == pvd->pUnits[iIndex]->iRow)
  {
  while((pvd->pUnits[iIndex]->fGrpNext) && (iIndex < pvd->usUnits-1))
    iIndex++;
  pvd->pUnits[iIndex]->fGrpNext = TRUE;
  return TRUE;
  }

return FALSE;
}

BOOL    UctUngroupOne(PVIEWDATA pvd, INT iIndex)
{
if(!pvd->pUnits[iIndex]->fGrpNext) return FALSE;

pvd->pUnits[iIndex]->fGrpNext = FALSE;
return TRUE;
}

INT     UctGetLastInGroup(PVIEWDATA pvd, INT iIndex)
{
INT i = iIndex;
if(!pvd->pUnits[iIndex]->fGrpNext) return iIndex;

while(pvd->pUnits[i]->fGrpNext && (i < pvd->usUnits-1)) i++;

return i;
}

PPICKEDUNITS    UctPickupUnits(PVIEWDATA pvd, INT iIndex) // NEW 0.1.9
{
PPICKEDUNITS ppu;
INT i, iLast = UctGetLastInGroup(pvd, iIndex);

ppu = malloc(sizeof(PICKEDUNITS) + iLast - iIndex); // allocate data for picked up units

if(ppu)
  {
  ppu->usUnits = iLast - iIndex + 1;

  for(i = iIndex; i <= iLast; i++)
    ppu->pUnits[i - iIndex] = pvd->pUnits[i];

  if((pvd->usUnits - iLast - 1) > 0)
    for(i = iLast + 1; i < pvd->usUnits; i++)
      pvd->pUnits[iIndex + i - iLast - 1] = pvd->pUnits[i];
//    memcpy(&pvd->pUnits[iIndex], &pvd->pUnits[iLast + 1],
//           (pvd->usUnits - iLast - 1) * sizeof(PUNIT)); // remove from list

  pvd->usUnits -= ppu->usUnits;
  }

return ppu;
}

BOOL    UctDropUnits(PVIEWDATA pvd, INT iBefore, PPICKEDUNITS ppu) // NEW 0.1.9
{
INT i, iRow = 0;
BOOL fGrpNextOn = FALSE;

//if(iBefore > 0)
  fGrpNextOn = pvd->pUnits[iBefore - 1]->fGrpNext;

if(pvd->usUnits)
  {
  iRow = (pvd->usUnits == iBefore) ? pvd->pUnits[iBefore - 1]->iRow
                                   : pvd->pUnits[iBefore]->iRow;
  for(i = pvd->usUnits - 1; i >= iBefore; i--)
    pvd->pUnits[i + ppu->usUnits] = pvd->pUnits[i];
  }

//memcpy(&pvd->pUnits[iBefore], &ppu->pUnits[0], ppu->usUnits * sizeof(PUNIT));

for(i = 0; i < ppu->usUnits; i++)
  {
  pvd->pUnits[i + iBefore] = ppu->pUnits[i];
  pvd->pUnits[i + iBefore]->iRow = iRow;
  //pvd->pUnits[i + iBefore]->fGrpNext = fGrpNextOn;
  }

pvd->usUnits += ppu->usUnits;

free(ppu);

return TRUE;
}

INT     UctUnitFromPoint(PVIEWDATA pvd, PPOINTL pptl, PRECTL prcl) // NEW 0.1.9
{
INT i, iRow;
BYTE bSizeWidth = (!pvd->viewConfig.page2.fHideSpacebars) ?
                  ((WinQuerySysValue(HWND_DESKTOP, SV_CXSIZEBORDER) + 1)/2 +
                   WinQuerySysValue(HWND_DESKTOP, SV_CXBORDER)) : 0;


if(pptl->y < pvd->viewConfig.page2.bBorderWidth) return -1;

iRow = (pptl->y - pvd->viewConfig.page2.bBorderWidth) /
       (pvd->viewConfig.page2.bViewSpacing + pvd->viewConfig.page2.bRowHeight);

for(i = 0; i < pvd->usUnits; i ++)
  {
  SWP swp;
  WinQueryWindowPos(pvd->pUnits[i]->hwnd, &swp);

  if(pvd->pUnits[i]->fGrpNext)
    {
    if((pptl->y >= swp.y) && (pptl->y < swp.y + swp.cy) &&
       (pptl->x <= swp.x) && (pptl->x > swp.x - pvd->viewConfig.page2.bRowHeight))
      {
      iRow = pvd->pUnits[i]->iRow;
      prcl->xLeft = swp.x - pvd->viewConfig.page2.bRowHeight;
      if(prcl->xLeft < 0) prcl->xLeft = 0;
      prcl->xRight = swp.x;
      prcl->yBottom = swp.y;
      prcl->yTop = swp.y + swp.cy;
      return i;
      }

    if((pptl->y >= swp.y) && (pptl->y <= (swp.y + swp.cy)) &&
       (pptl->x >= (swp.x - pvd->viewConfig.page2.bRowHeight -
        pvd->viewConfig.page2.bUnitSpacing - bSizeWidth - 1)) &&
       (pptl->x <= (swp.x - pvd->viewConfig.page2.bRowHeight)))
      {
      iRow = pvd->pUnits[i]->iRow;
      prcl->xLeft = swp.x - pvd->viewConfig.page2.bRowHeight - bSizeWidth;
      if(prcl->xLeft < 0) prcl->xLeft = 0;
      prcl->xRight = swp.x - pvd->viewConfig.page2.bRowHeight;
      prcl->yBottom = swp.y;
      prcl->yTop = swp.y + swp.cy;
      return i;
      }
    }
    else if((pptl->y >= swp.y) && (pptl->y <= (swp.y + swp.cy)) &&
        (pptl->x <= swp.x) &&
        (pptl->x >= (swp.x - pvd->viewConfig.page2.bUnitSpacing - bSizeWidth - 1)))
      {
      iRow = pvd->pUnits[i]->iRow;
      prcl->xLeft = swp.x - pvd->viewConfig.page2.bUnitSpacing - bSizeWidth;
      if(prcl->xLeft < 0) prcl->xLeft = 0;
      prcl->xRight = swp.x;
      prcl->yBottom = swp.y;
      prcl->yTop = swp.y + swp.cy;
      return i;
      }
  }

if(!pvd->usUnits)
  {
  WinQueryWindowRect(pvd->hwnd, prcl);
  prcl->xLeft += pvd->viewConfig.page2.bBorderWidth;
  prcl->yBottom += pvd->viewConfig.page2.bBorderWidth;
  prcl->xRight -= pvd->viewConfig.page2.bBorderWidth;
  prcl->yTop -= pvd->viewConfig.page2.bBorderWidth;
  return 0;
  }

for(i = 0; i < pvd->usUnits; i++)
  {
  SWP swp;
  WinQueryWindowPos(pvd->pUnits[i]->hwnd, &swp);

  if((pptl->y >= swp.y) && (pptl->y < swp.y + swp.cy))
    {
    if(i == pvd->usUnits - 1)
      {
      WinQueryWindowRect(pvd->hwnd, prcl);
      prcl->xRight -= pvd->viewConfig.page2.bBorderWidth;
      prcl->xLeft = swp.x + swp.cx;
      prcl->yBottom = swp.y;
      prcl->yTop = swp.y + swp.cy;
      return i;
      }
      else if(pvd->pUnits[i + 1]->iRow > pvd->pUnits[i]->iRow)
        {
        WinQueryWindowRect(pvd->hwnd, prcl);
        prcl->xRight -= pvd->viewConfig.page2.bBorderWidth;
        prcl->xLeft = swp.x + swp.cx;
        prcl->yBottom = swp.y;
        prcl->yTop = swp.y + swp.cy;
        return i;
        }
    }
  }

return -1;
}

BOOL    UctShiftGroup(PVIEWDATA pvd, INT iIndex)
{
INT iLast, i;
PUNIT pUnitTemp;

if(!pvd->pUnits[iIndex]->fGrpNext) return FALSE;

iLast = UctGetLastInGroup(pvd, iIndex);

pvd->pUnits[iLast]->fGrpNext = TRUE;
pUnitTemp = pvd->pUnits[iIndex];
pUnitTemp->fGrpNext = FALSE;

pvd->pUnits[iIndex + 1]->iWidth = pvd->pUnits[iIndex]->iWidth;

//memcpy(&pvd->pUnits[iIndex], &pvd->pUnits[iIndex + 1],
//       (iLast - iIndex) * sizeof(PUNIT));

for(i = iIndex + 1; i <= iLast; i++)
  pvd->pUnits[i - 1] = pvd->pUnits[i];

pvd->pUnits[iLast] = pUnitTemp;

return TRUE;
}

BOOL    UctSwapGroup(PVIEWDATA pvd, INT iFirstIndex, INT iLastIndex)
{
BOOL fFirst, fLast;
PUNIT pUnitTemp;

fFirst = pvd->pUnits[iFirstIndex]->fGrpNext;
fLast = pvd->pUnits[iLastIndex]->fGrpNext;
pvd->pUnits[iLastIndex]->iWidth = pvd->pUnits[iFirstIndex]->iWidth;

if(!fFirst) return FALSE;

pUnitTemp = pvd->pUnits[iFirstIndex];
pvd->pUnits[iFirstIndex] = pvd->pUnits[iLastIndex];
pvd->pUnits[iLastIndex] = pUnitTemp;
pvd->pUnits[iLastIndex]->fGrpNext = fLast;
pvd->pUnits[iFirstIndex]->fGrpNext = fFirst;

return TRUE;
}

BOOL    UctControlPopupMenu(HWND hwndMenu, PVIEWDATA pvd, PUNIT pUnit)
{
INT iIndex;
BOOL fMoveLeft = TRUE,
     fMoveRight = TRUE,
     fGroupLeft = TRUE,
     fGroupRight = TRUE,
     fUngroup = TRUE;

iIndex = UctGetIndex(pvd, pUnit);

if(iIndex == -1)return FALSE;

if((iIndex == 0) && (pUnit->iRow == 0)) fMoveLeft = FALSE;

if((UctGetLastInGroup(pvd,iIndex) == pvd->usUnits-1) &&
   (pUnit->iRow == pvd->viewConfig.bRows-1)) fMoveRight = FALSE;

if(iIndex>0)
  {
  if(pUnit->iRow != pvd->pUnits[iIndex-1]->iRow) fGroupLeft = FALSE;
  } else fGroupLeft = FALSE;

if(UctGetLastInGroup(pvd,iIndex)<pvd->usUnits-1)
  {
  if(pUnit->iRow != pvd->pUnits[UctGetLastInGroup(pvd,iIndex)+1]->iRow)
    fGroupRight = FALSE;
  } else fGroupRight = FALSE;

if(!pUnit->fGrpNext) fUngroup = FALSE;

WinEnableMenuItem(hwndMenu, STIDC_UNITLEFT, fMoveLeft);
WinEnableMenuItem(hwndMenu, STIDC_UNITRIGHT, fMoveRight);
WinEnableMenuItem(hwndMenu, STIDC_GROUPRIGHT, fGroupRight);
WinEnableMenuItem(hwndMenu, STIDC_GROUPLEFT, fGroupLeft);
WinEnableMenuItem(hwndMenu, STIDC_UNGROUP, fUngroup);
EnableMenuClassList(hwndMenu, pvd);

return TRUE;
}

BOOL    UctRemoveUnit(PVIEWDATA pvd, INT iIndex)
{
INT i;
if(WinSendMsg(pvd->pUnits[iIndex]->hwnd, USTM_REMOVED, (MPARAM)0L, (MPARAM)0L))
  return FALSE;

DbgPrintf("Removing unit %s (hwnd=%d)\n", pvd->pUnits[iIndex]->szClass,
          pvd->pUnits[iIndex]->hwnd);

WinDestroyWindow(pvd->pUnits[iIndex]->hwnd);
free(pvd->pUnits[iIndex]);

pvd->usUnits--; // remove from list

for(i=iIndex; i<pvd->usUnits; i++)
  pvd->pUnits[i] = pvd->pUnits[i+1];

return TRUE;
}

BOOL    UctAddUnit(PVIEWDATA pvd, PSZ pszName, /*INT iRow,*/ INT iIndex) // ### 0.1.9
{
INT i, c=0, r=0, iIns;
PUNIT pNewUnit;
BOOL fCreated = FALSE;

/*iIns = pvd->usUnits;

for(i=0; i<pvd->usUnits; i++)
  {
  if((pvd->pUnits[i]->iRow == iRow) && (iIndex == c))
    {
    iIns = i;
    break;
    }
  if(pvd->pUnits[i]->iRow != r)
    {
    c=0;
    r=pvd->pUnits[i]->iRow;
    } else c++;
  }*/

for(i=0; i<ulClasses; i++)
  if(!strcmp(pWClasses[i].pszName, pszName))
    {
    pNewUnit = (PUNIT)malloc(max(pWClasses[i].ulSafeAlloc,sizeof(UNIT)));
    memset(pNewUnit, 0L, pWClasses[i].ulSafeAlloc);
    pNewUnit->cbFix = pWClasses[i].ulFix;
    pNewUnit->usFlags = pWClasses[i].usFlags;
    pNewUnit->iRow = pvd->iRow;
    pNewUnit->iWidth = -1;
    strcpy(pNewUnit->szClass, pWClasses[i].pszName);
    fCreated = UctInsertUnit(pNewUnit, pvd,/*iIns*/ iIndex, TRUE); // ### 0.1.9
    break;
    }

return fCreated;
}

MRESULT EXPENTRY SubclStaticProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
PFNWP pfnwpOrg = (PFNWP) WinQueryWindowULong(hwnd, QWL_USER);
MRESULT rc;
CHAR buf[56];

switch(msg)
  {
  case WM_PRESPARAMCHANGED:
  rc = pfnwpOrg(hwnd, msg, mp1, mp2);
  GetItemFont(hwnd, buf);
  WinSetWindowText(hwnd, buf);
  return rc;

  case WM_PAINT:
    {
    HPS hps;
    RECTL rcl;
    rc = pfnwpOrg(hwnd, msg, mp1, mp2);
    WinQueryWindowRect(hwnd, &rcl);
    hps = WinGetPS(hwnd);
    WinDrawBorder(hps, &rcl, 2L, 2L, 0L, 0L, 0x400L);
    WinReleasePS(hps);
    return rc;
    }

  case WM_BUTTON1DBLCLK:
    {
    HOBJECT hobjPalette;
    hobjPalette = WinQueryObject((SHORT2FROMMP(mp2) & KC_SHIFT) ?
                                 "<WP_FNTPAL>" : "<WP_HIRESCLRPAL>");
    if(hobjPalette) WinOpenObject(hobjPalette, 0, TRUE);
    return (MRESULT) (hobjPalette != NULLHANDLE);
    }

  case WM_COMMAND:
  switch((SHORT)mp1)
    {
    case 101:
      {
      HOBJECT hobjPalette;
      hobjPalette = WinQueryObject("<WP_HIRESCLRPAL>");
      if(hobjPalette) WinOpenObject(hobjPalette, 0, TRUE);
      return (MRESULT) (hobjPalette != NULLHANDLE);
      break;
      }
    case 102:
      {
      HOBJECT hobjPalette;
      hobjPalette = WinQueryObject("<WP_FNTPAL>");
      if(hobjPalette) WinOpenObject(hobjPalette, 0, TRUE);
      return (MRESULT) (hobjPalette != NULLHANDLE);
      break;
      }
    }
  return (MRESULT)0L;

  case WM_MENUEND:
    {
    RECTL rcl;
    WinDestroyWindow((HWND)mp2);
    WinQueryWindowRect(hwnd, &rcl);
    WinEnableWindowUpdate(hwnd, TRUE);
    WinInvalidateRect(hwnd, &rcl, FALSE);
    return (MRESULT)0L;
    }

  case WM_CONTEXTMENU:
    {
    HPS hps;
    RECTL rcl;
    INT x, y;
    HWND hwndMenu = WinLoadMenu(HWND_DESKTOP, hmSystrayRes, IDR_PALMENU);

    if(hwndMenu)
      {
      WinQueryWindowRect(hwnd, &rcl);
      hps = WinGetPS(hwnd);
      GpiCreateLogColorTable(hps, 0L, LCOLF_RGB, 0L, 0L, (PLONG) NULL);
      DrawFence(hps, &rcl, abs(rcl.yTop-rcl.yBottom)/3);
      WinReleasePS(hps);
      WinEnableWindowUpdate(hwnd, FALSE);

      x = SHORT1FROMMP(mp1); // get mouse pointer position
      y = SHORT2FROMMP(mp1);
      SetItemFont(hwndMenu, "9.WarpSans");
      WinPopupMenu(hwnd, hwnd, hwndMenu, x, y, 0,
                   PU_HCONSTRAIN   | PU_VCONSTRAIN |
                   PU_MOUSEBUTTON1 | PU_KEYBOARD   );
      }
    return (MRESULT) (hwndMenu != NULLHANDLE);
    }
  }

return pfnwpOrg(hwnd, msg, mp1, mp2);
}

MRESULT EXPENTRY ColorFontDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
PUNITNBINFO punbInfo = (PUNITNBINFO) WinQueryWindowULong(hwnd, QWL_USER);
INT i;

switch(msg)
  {
  case WM_INITDLG:
  //DosBeep(1000, 100);
  punbInfo = (PUNITNBINFO) mp2;
  WinSetWindowULong(hwnd, QWL_USER, (ULONG)mp2);
  for(i=0; i<(IDD_TEXT9 - IDD_TEXT1 + 1); i++)
    if(i<punbInfo->sNumfcInfo)
      {
      PFNWP pfnOld;
      WinSetDlgItemText(hwnd, i+IDD_INFO1, punbInfo->ppszfcInfo[i]);
      WinSetDlgItemText(hwnd, i+IDD_TEXT1, punbInfo->pfcInfo[i].szFont);
      SetItemTextColor(WinWindowFromID(hwnd, i+IDD_TEXT1), punbInfo->pfcInfo[i].lTextColor);
      SetItemBackColor(WinWindowFromID(hwnd, i+IDD_TEXT1), punbInfo->pfcInfo[i].lBackColor);
      SetItemFont(WinWindowFromID(hwnd, i+IDD_TEXT1), punbInfo->pfcInfo[i].szFont);
      pfnOld = WinSubclassWindow(WinWindowFromID(hwnd, i+IDD_TEXT1),
                                 (PFNWP)SubclStaticProc);

      WinSetWindowULong(WinWindowFromID(hwnd, i+IDD_TEXT1), QWL_USER,
                        (ULONG)pfnOld);
      }
    else
      {
      WinShowWindow(WinWindowFromID(hwnd, i+IDD_TEXT1), FALSE);
      WinShowWindow(WinWindowFromID(hwnd, i+IDD_INFO1), FALSE);
      }
  break;

  case WM_DESTROY:
  for(i=0; i<(IDD_TEXT9 - IDD_TEXT1 + 1); i++)
    if(i<punbInfo->sNumfcInfo)
      {
      WinSetDlgItemText(hwnd, i+IDD_INFO1, punbInfo->ppszfcInfo[i]);
      WinSetDlgItemText(hwnd, i+IDD_TEXT1, punbInfo->pfcInfo[i].szFont);
      punbInfo->pfcInfo[i].lTextColor = GetItemTextColor(WinWindowFromID(hwnd, i+IDD_TEXT1));
      punbInfo->pfcInfo[i].lBackColor = GetItemBackColor(WinWindowFromID(hwnd, i+IDD_TEXT1));
      GetItemFont(WinWindowFromID(hwnd, i+IDD_TEXT1), punbInfo->pfcInfo[i].szFont);
      if(!i)
        {
        RECTL rcl;
        SetItemTextColor(punbInfo->pUnit->hwnd, punbInfo->pfcInfo[i].lTextColor);
        SetItemBackColor(punbInfo->pUnit->hwnd, punbInfo->pfcInfo[i].lBackColor);
        SetItemFont(punbInfo->pUnit->hwnd, punbInfo->pfcInfo[i].szFont);
        WinQueryWindowRect(punbInfo->pUnit->hwnd, &rcl);
        WinInvalidateRect(punbInfo->pUnit->hwnd, &rcl, TRUE);
        }
      }
  break;

  case WM_COMMAND:
  return (MRESULT)0L;
  }

return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

MRESULT EXPENTRY UnitTitleDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
PUNIT pUnit = (PUNIT) WinQueryWindowULong(hwnd, QWL_USER);
INT i;

switch(msg)
  {
  case WM_INITDLG:
  //DosBeep(1000, 100);
  pUnit = (PUNIT) mp2;
  WinSetWindowULong(hwnd, QWL_USER, (ULONG)mp2);
  WinSendDlgItemMsg(hwnd, IDD_UNITTITLETEXT, EM_SETTEXTLIMIT, (MPARAM)100, NULL);
  WinSetDlgItemText(hwnd, IDD_UNITTITLETEXT, pUnit->szUnitTitle);
  break;

  case WM_DESTROY:
  WinQueryDlgItemText(hwnd, IDD_UNITTITLETEXT, 100, pUnit->szUnitTitle);
  break;

  case WM_COMMAND:
  return (MRESULT)0L;
  }

return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

MRESULT EXPENTRY UctSettingsDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
PUNITNBINFO punbInfo;// = (PUNITNBINFO) WinQueryWindowULong(hwnd, QWL_USER);
PUNITPGINFO pupgInfo;
HWND hwndNb;
ULONG id, i, ulWidestTab = 0L;
ULONG idFirst;
PWCLASS pwc;
CHAR buf[80];
BOOL fWarp3;
HPS hpsNb;
SIZEL szl;
static SWP swpDlg;

switch(msg)
  {
  case WM_INITDLG:
  punbInfo = (PUNITNBINFO) mp2;
  WinSetWindowULong(hwnd, QWL_USER, (ULONG)mp2);

  pupgInfo = punbInfo->pupgInfo;
  hwndNb = WinWindowFromID(hwnd, IDD_NOTEBOOK);
  WinQueryWindowPos(hwnd, &swpDlg);
  idFirst = 0L;

  fWarp3 = (((WinQueryVersion(WinQueryAnchorBlock(hwnd)) >> 8) & 255) < 40);

  if(fWarp3)
    {
    WinSetWindowULong(hwndNb, QWL_STYLE, WS_GROUP      | WS_VISIBLE     |    
                      BKS_SPIRALBIND | BKS_MAJORTABTOP | BKS_BACKPAGESTR);
    WinShowWindow(hwndNb, TRUE);
    hpsNb = WinGetPS(hwndNb);
    }

  while(pupgInfo)
    {
    pupgInfo->hwnd = WinLoadDlg(hwndNb, hwndNb, (PFNWP)pupgInfo->pfnDlgProc,
                                pupgInfo->res, pupgInfo->id, pupgInfo->pCreateParams);

    if(pupgInfo->hwnd)
      {
      //DosBeep(500, 200);
      id = (ULONG)WinSendMsg(hwndNb, BKM_INSERTPAGE, (MPARAM)0L, pupgInfo->mp2InsertFlags);
      pupgInfo->ulNBPageID = id;
      WinSendMsg(hwndNb, BKM_SETTABTEXT, MPFROMLONG(id), MPFROMP(pupgInfo->pszTabText));
      WinSendMsg(hwndNb, BKM_SETSTATUSLINETEXT, MPFROMLONG(id), MPFROMP(pupgInfo->pszStatusText));
      WinSendMsg(hwndNb, BKM_SETPAGEWINDOWHWND, MPFROMLONG(id), MPFROMHWND(pupgInfo->hwnd));
      if(pupgInfo->id == punbInfo->idTurnTo)
        {
        idFirst = id;
        punbInfo->pupgCurrent = pupgInfo;
        }
      if(fWarp3)
        {
        QueryTextBox(hpsNb, pupgInfo->pszTabText, &szl);
        if(szl.cx > ulWidestTab) ulWidestTab = szl.cx;
        }
      }
    //DosBeep(1000, 1000);
    pupgInfo = pupgInfo->pupgInfoNext;
    }

  if(fWarp3)
    {
    WinReleasePS(hpsNb);

    WinSendMsg(hwndNb, BKM_SETDIMENSIONS,
               MPFROM2SHORT((ulWidestTab + 8), (szl.cy + 8)), (MPARAM)BKA_MAJORTAB);

//    i = SYSCLR_DIALOGBACKGROUND;
//    WinSetPresParam(hwndNb, PP_ACTIVECOLORINDEX, sizeof(ULONG), &i);
//    WinSetPresParam(hwndNb, PP_BACKGROUNDCOLORINDEX, sizeof(ULONG), &i);

    WinSendMsg(hwndNb, BKM_SETNOTEBOOKCOLORS,
               MPFROMLONG(SYSCLR_DIALOGBACKGROUND),
               MPFROMLONG(BKA_BACKGROUNDMAJORCOLORINDEX));

    WinSendMsg(hwndNb, BKM_SETNOTEBOOKCOLORS,
               MPFROMLONG(SYSCLR_DIALOGBACKGROUND),
               MPFROMLONG(BKA_BACKGROUNDPAGECOLORINDEX));


    }

  WinSendMsg(hwndNb, BKM_TURNTOPAGE, (MPARAM)idFirst, (MPARAM)0L);

  if(punbInfo->hptrWindowIcon)
    WinSendMsg(hwnd, WM_SETICON, (MPARAM)punbInfo->hptrWindowIcon, (MPARAM)0L);

  pwc = GenSearchClass(punbInfo->pUnit->szClass);
  if(pwc)
    {
    sprintf(buf, GenLoadNls(NULL, IDS_XSETTINGS, "%s - Properties"),
           pwc->pszViewName);

    WinSetWindowText(hwnd, buf);
    break;
    }

  break;

/*  case WM_SIZE: won't work with dialogs (unfortunately)
    {
    USHORT cxOld, cyOld, cxNew, cyNew;
    SWP swp;
    cxOld = SHORT1FROMMP(mp1); cyOld = SHORT2FROMMP(mp1);
    cxNew = SHORT1FROMMP(mp2); cyNew = SHORT2FROMMP(mp2);

    hwndNb = WinWindowFromID(hwnd, IDD_NOTEBOOK);
    WinQueryWindowPos(hwndNb, &swp);

    WinSetWindowPos(hwndNb, HWND_TOP, 0L, 0L,
                    swp.cx + cxOld - cxNew,
                    swp.cy + cyOld - cyNew, SWP_SIZE);
    DosBeep(3000, 40);
    break;
    }*/

  case WM_WINDOWPOSCHANGED: // use WM_WINDOWPOSCHANGED instead of WM_SIZE
    {
    PSWP pswp = (PSWP)mp1;
    if(pswp && (pswp->fl & SWP_SIZE))
      {
      SWP swpNb;

      hwndNb = WinWindowFromID(hwnd, IDD_NOTEBOOK);
      WinQueryWindowPos(hwndNb, &swpNb);

      WinSetWindowPos(hwndNb, HWND_TOP, 0L, 0L,
                      swpNb.cx + pswp->cx - swpDlg.cx,
                      swpNb.cy + pswp->cy - swpDlg.cy, SWP_SIZE);

      memcpy(&swpDlg, pswp, sizeof(SWP));
//      DosBeep(3000, 40);
      }
    break;
    }

  case WM_CONTROL:
  punbInfo = (PUNITNBINFO) WinQueryWindowULong(hwnd, QWL_USER);
  if(SHORT1FROMMP(mp1) == IDD_NOTEBOOK)
    switch(SHORT2FROMMP(mp1))
      {
      case BKN_PAGESELECTEDPENDING:
        {
        PPAGESELECTNOTIFY ppsn = (PPAGESELECTNOTIFY)mp2;
        pupgInfo = punbInfo->pupgInfo;

        while(pupgInfo)
          {
          if(pupgInfo->ulNBPageID == ppsn->ulPageIdNew)
            {
            punbInfo->pupgCurrent = pupgInfo;
            WinEnableControl(hwnd, IDC_UNDO, ((pupgInfo->ulPageFlags & NPF_UNDO) != 0));
            WinEnableControl(hwnd, IDC_DEFAULT, ((pupgInfo->ulPageFlags & NPF_DEFAULT) != 0));
            WinEnableControl(hwnd, IDC_HELP, ((pupgInfo->ulPageFlags & NPF_HELP) != 0));
            break;
            }
          pupgInfo = pupgInfo->pupgInfoNext;
          }
        break;
        }
      }
  break;

  case WM_COMMAND:
  punbInfo = (PUNITNBINFO) WinQueryWindowULong(hwnd, QWL_USER);
  switch((SHORT)mp1) // new in 0.1.4, notebook commandcenter ;-)
    {
//    case IDC_UNDO:
//    break;

//    case IDC_DEFAULT:
//    break;

    case IDC_HELP: // new in 0.1.5
    pwc = GenSearchClass(punbInfo->pUnit->szClass);
    if(!(punbInfo->pupgCurrent->ulPageFlags & NPF_BYPASSHELP))
      {
      if(pwc && pwc->pszHelpFileName)
        {
        static CHAR szHelpFileName[CBMAXSTRING]; // uh oh?
        // 0.3.3 check for full path
        if((pwc->pszHelpFileName[0] != '\\') && (pwc->pszHelpFileName[1] != ':'))
          sprintf(szHelpFileName, "%s%s", szCommonPath, pwc->pszHelpFileName);
        else strcpy(szHelpFileName, pwc->pszHelpFileName);

        DbgPrintf("Calling nb help  for %s (%s:%d)\n", punbInfo->pUnit->szClass,
                  szHelpFileName, pwc->ulHelpPanelID);

        sprintf(szHelpFileName, "%s%s", szCommonPath, pwc->pszHelpFileName);
        // ignore result since we are in WM_COMMAND here
        _wpDisplayHelp(punbInfo->pvd->somSelf, pwc->ulHelpPanelID, szHelpFileName);
        }
      break;
      }
    // fall throught
    default:
    return (MRESULT)WinSendMsg(punbInfo->pupgCurrent->hwnd, WM_COMMAND, mp1, mp2);

    }
  return (MRESULT)TRUE; // 0.1.5 proceed, changed from 0L
  }

return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

static UNITNBINFO unbInfo; // force 2 heap memory ][%-(6)
static UNITPGINFO upgInfo[2];

PSZ	pszPresentation = NULL,
	pszColorsAndFonts = NULL,
	pszTitle = NULL,
	pszUnitTitle = NULL;

BOOL    UctProcessSettings(HWND hwnd, PVIEWDATA pvd, PUNIT pUnit)
{
unbInfo.pUnit = pUnit;
unbInfo.pvd = pvd;

if(!WinSendMsg(hwnd, USTM_QUERYNBINFO, MPFROMP(&unbInfo), (MPARAM)0L))
  return FALSE; // if no font/color or other settings

upgInfo[1].res = hmSystrayRes;
upgInfo[1].hwnd = NULLHANDLE;
upgInfo[1].id = IDR_FONTSANDCOLORS;

if(!pszPresentation)
  pszPresentation = strdup(GenLoadNls(NULL, IDS_PRESENTATION, "Presentation"));
if(!pszColorsAndFonts)
  pszColorsAndFonts = strdup(GenLoadNls(NULL, IDS_FONTSNCOLORS, "Colors & fonts"));
if(!pszTitle)
  pszTitle = strdup(GenLoadNls(NULL, IDS_HEADER, "Title"));
if(!pszUnitTitle)
  pszUnitTitle = strdup(GenLoadNls(NULL, IDS_UNITHEADER, "Unit title"));

upgInfo[1].pszTabText = pszPresentation;
upgInfo[1].pszStatusText = pszColorsAndFonts;
upgInfo[1].pfnDlgProc = (PFNWP)ColorFontDlgProc;
upgInfo[1].pCreateParams = (PVOID)&unbInfo;
upgInfo[1].mp2InsertFlags = MPFROM2SHORT((BKA_STATUSTEXTON |
                                          BKA_AUTOPAGESIZE |
                                          BKA_MAJOR), BKA_LAST);
upgInfo[1].pupgInfoNext = unbInfo.pupgInfo;
upgInfo[1].ulPageFlags = NPF_HELP;

upgInfo[0].res = hmSystrayRes;
upgInfo[0].hwnd = NULLHANDLE;
upgInfo[0].id = IDR_UNITTITLEDIALOG;
upgInfo[0].pszTabText = pszTitle;
upgInfo[0].pszStatusText = pszUnitTitle;
upgInfo[0].pfnDlgProc = (PFNWP)UnitTitleDlgProc;
upgInfo[0].pCreateParams = (PVOID)pUnit;
upgInfo[0].mp2InsertFlags = MPFROM2SHORT((BKA_STATUSTEXTON |
                                          BKA_AUTOPAGESIZE |
                                          BKA_MAJOR), BKA_LAST);
upgInfo[0].pupgInfoNext = &upgInfo[1];

upgInfo[0].ulPageFlags = NPF_HELP;
unbInfo.pupgInfo = &upgInfo;

// Finally, get control into Unit Settings dialog

WinDlgBox(HWND_DESKTOP, (HWND)hwnd, (PFNWP)UctSettingsDlgProc,
          hmSystrayRes, IDR_UNITNOTEBOOK, (PVOID)&unbInfo);

return TRUE;
}

BOOL    UctCommand(HWND hwnd, MPARAM mp1, MPARAM mp2, PUNIT pUnit)
{
PVIEWDATA pvd = (PVIEWDATA)pUnit->pViewData;

switch((SHORT)mp1)
  {
  case STIDC_UNITSETTINGS:
  DbgPrintf("Calling settings for %s (hwnd=%d)\n", pUnit->szClass, pUnit->hwnd);
  UctProcessSettings(hwnd, pvd, pUnit);
  return TRUE;

  case STIDC_UNITHELP:
    {
    PWCLASS pwc = GenSearchClass(pUnit->szClass);
    if(pwc && pwc->pszHelpFileName)
      {
      static CHAR szHelpFileName[CBMAXSTRING];
      // 0.3.3 check for full path
      if((pwc->pszHelpFileName[0] != '\\') && (pwc->pszHelpFileName[1] != ':'))
        sprintf(szHelpFileName, "%s%s", szCommonPath, pwc->pszHelpFileName);
      else strcpy(szHelpFileName, pwc->pszHelpFileName);

      DbgPrintf("Calling unit help for %s (%s:%d)\n", pUnit->szClass,
                szHelpFileName, pwc->ulHelpPanelID);

      return _wpDisplayHelp(pvd->somSelf, pwc->ulHelpPanelID, szHelpFileName);
      }
    break;
    }

  case STIDC_REMOVEUNIT:
  if(UctRemoveUnit(pvd, UctGetIndex(pvd,pUnit)))
    ViewUpdateView(pvd);
  break;

  case STIDC_UNITLEFT:
  if(UctMoveLeft(pvd, UctGetIndex(pvd,pUnit)))
    ViewUpdateView(pvd);
  break;

  case STIDC_UNITRIGHT:
  if(UctMoveRight(pvd, UctGetIndex(pvd,pUnit)))
    ViewUpdateView(pvd);
  break;

  case STIDC_GROUPLEFT:
  if(UctGroupLeft(pvd, UctGetIndex(pvd,pUnit)))
    ViewUpdateView(pvd);
  break;

  case STIDC_GROUPRIGHT:
  if(UctGroupRight(pvd, UctGetIndex(pvd,pUnit)))
    ViewUpdateView(pvd);
  break;

  case STIDC_UNGROUP:
  if(UctUngroupOne(pvd, UctGetIndex(pvd,pUnit)))
    ViewUpdateView(pvd);
  break;

  default:
  pvd->iRow = pUnit->iRow;
  pvd->fGrpClicked = FALSE;
  if(((USHORT)mp1 > STIDC_ADDUNIT) && ((USHORT)mp1 < (STIDC_ADDUNIT + ulClasses + 1L)))
    {
    INT iAdd;
    RECTL rcl;
    for(iAdd = 0; iAdd < pvd->usUnits; iAdd ++)
      if(pvd->pUnits[iAdd] == pUnit) break;

    if(iAdd < pvd->usUnits) iAdd ++;

    if(UctAddUnit(pvd, pWClasses[(SHORT)mp1 - STIDC_ADDUNIT - 1].pszName, iAdd))
       ViewUpdateView(pvd);
    else DosBeep(1000, 100);
    break;
    }
  return (BOOL)WinSendMsg(pvd->hwnd, WM_COMMAND, mp1, mp2);
  }

return TRUE;
}

BOOL    UctContextMenu(HWND hwnd, MPARAM mp1, MPARAM mp2, PUNIT pUnit)
{
//BOOL rc = TRUE;
HPS hps;
RECTL rcl;
POINTL ptl;
MENUITEM mi;

if(!pUnit->hwnd_Menu) return FALSE;

//if(!WinSendMsg(pUnit->hwnd_Menu, MM_QUERYITEM,
//              MPFROM2SHORT(STIDC_ADDUNIT, TRUE),
//              MPFROMP(&mi))) // Search for exists "Add menu" item...
//  {
//  if(mi.hwndSubMenu) WinDestroyWindow(mi.hwndSubMenu);
//  WinSendMsg(pUnit->hwnd_Menu, MM_DELETEITEM, MPFROM2SHORT(STIDC_ADDUNIT,
//             TRUE), (MPARAM)0L);
//  }
//
//  BuildMenuClassList(pUnit->hwnd_Menu); // Create from scratch
//  }

WinQueryWindowRect(hwnd, &rcl);
hps = WinGetPS(hwnd);
GpiCreateLogColorTable(hps, 0L, LCOLF_RGB, 0L, 0L, (PLONG) NULL);
DrawFence(hps, &rcl, abs(rcl.yTop-rcl.yBottom)/3);
WinReleasePS(hps);
WinEnableWindowUpdate(hwnd, FALSE);

UctControlPopupMenu(pUnit->hwnd_Menu, (PVIEWDATA)pUnit->pViewData, pUnit);

ptl.x = SHORT1FROMMP(mp1); // get mouse pointer position
ptl.y = SHORT2FROMMP(mp1);

return WinPopupMenu(pUnit->hwnd, pUnit->hwnd, pUnit->hwnd_Menu,
                    ptl.x, ptl.y, 0, PU_HCONSTRAIN   | PU_VCONSTRAIN |
                                     PU_MOUSEBUTTON1 | PU_KEYBOARD   );
}

// NEW in 0.1.6c

BOOL    UctBeginDrag(HWND hwnd, MPARAM mp1, MPARAM mp2, PUNIT pUnit)
{
PDRAGINFO pdinfo;            /* Pointer to DRAGINFO structure         */
BOOL      fResult;           /* Result indicator                      */
DRAGITEM  ditem;             /* DRAGITEM structure                    */
DRAGIMAGE dimg;              /* DRAGIMAGE structure                   */
HPOINTER  hptrIcon;          /* Icon handle                           */
HWND      hwndDrop;          /* Target window                         */

hptrIcon = (HPOINTER)WinSendMsg(hwnd, USTM_QUERYICON, (MPARAM)0L, (MPARAM)0L);

if(!hptrIcon)
  hptrIcon = WinQuerySysPointer(HWND_DESKTOP, SPTR_FILE, FALSE);

/*************************************************************/
/* Initialize the DRAGITEM structure                         */
/*************************************************************/

ditem.hwndItem = hwnd;             /* Conversation partner   ????  */
ditem.ulItemID = (ULONG)pUnit;     /* Identifies item being dragged*/

ditem.hstrType = DrgAddStrHandle(DRT_UNKNOWN); // ###

ditem.hstrRMF = DrgAddStrHandle("<DRM_DDE,DRF_UNKNOWN>"); // ###

ditem.hstrContainerName = DrgAddStrHandle("Systray"); // do we need NLS here?
ditem.hstrSourceName = DrgAddStrHandle(pUnit->szClass);
ditem.hstrTargetName = DrgAddStrHandle(pUnit->szClass);

ditem.cxOffset = ditem.cyOffset = 0;
ditem.fsControl = 0;
ditem.fsSupportedOps = DO_MOVEABLE; // | DO_COPYABLE | DO_LINKABLE;

/*************************************************************/
/* Create the DRAGINFO structure                             */
/*************************************************************/

pdinfo = DrgAllocDraginfo(1);
if (!pdinfo) return (FALSE); /* If allocation fails,         */
                             /* return FALSE                 */

/*************************************************************/
/* Initialize the DRAGIMAGE structure                        */
/*************************************************************/

dimg.cb = sizeof(DRAGIMAGE); /* Size control block           */
dimg.cptl = 0;
dimg.hImage = hptrIcon;      /* Image handle passed to       */
                             /* DrgDrag                      */
dimg.fl = DRG_ICON;

dimg.cxOffset = 0;           /* Offset of the origin of      */
dimg.cyOffset = 0;           /* the image from the pointer   */
                             /* hotspot                      */

/*************************************************************/
/* Set the drag item                                         */
/*************************************************************/

fResult = DrgSetDragitem(pdinfo, &ditem, (ULONG)sizeof(ditem), 0);

/*************************************************************/
/* Perform the drag operation:                               */
/* - Give the user a visual cue by changing the pointer to a */
/*   bit map                                                 */
/* - Send DM_DRAGOVER messages to the target window (in this */
/*   case it is also the source)                             */
/* NOTE: DrgDrag will fail if another window in the same     */
/*       thread already has the capture.                     */
/*************************************************************/

hwndDrop = DrgDrag(WinQueryWindow(hwnd, QW_OWNER), // 0.3.2
                   /* Source of the drag             */
                   pdinfo,            /* Pointer to DRAGINFO structure  */
                   (PDRAGIMAGE)&dimg, /* Drag image                  */
                   1,                 /* Size of the pdimg array        */
                   VK_ENDDRAG,        /* Release of direct-manipulation */
                   NULL);             /* Reserved                       */

if(!hwndDrop) // drop failed, free drag operation shared heap
  DrgFreeDraginfo(pdinfo);

return TRUE; // successfull operation
}

MRESULT EXPENTRY SubclUnitProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
PUNIT pUnit = (PUNIT)WinQueryWindowULong(hwnd, 0L);

switch(msg)
  {
  case USTM_FILLGROUPTITLE:
    {
    MRESULT mrc;
    mrc = pUnit->pfnOldUnitProc(hwnd, msg, mp1, mp2);
    if(mrc) return mrc;
    else
      {
      PSZ pszDest = (PSZ)mp1;
      PWCLASS pwc;
      pwc = GenSearchClass(pUnit->szClass);
      if(pwc && pszDest)
        {
        strcpy(pszDest, pwc->pszViewName);
        return (MRESULT)TRUE;
        }
        else
        return (MRESULT)FALSE;
      }
    break;
    }

  case USTM_SELFCONTROLMENU:
  return (MRESULT) UctControlPopupMenu((HWND)mp1,
                                       (PVIEWDATA)pUnit->pViewData,
                                       pUnit);

  case USTM_RESIZE:
  if(pUnit->iWidth != (INT)mp1)
    {
    pUnit->iWidth = (INT)mp1;
    ViewUpdateView((PVIEWDATA)pUnit->pViewData);
    return (MRESULT)TRUE;
    }
  else return (MRESULT)FALSE;

  case USTM_MENUSHOWING:
  fMenuWork = (BOOL)mp1;
  //DosBeep(1000, 100);
  DbgPrintf("Popup menu mutex called (fMenuWork=%d)\n", fMenuWork);
  return (MRESULT)0L;

  case USTM_FORCEHINT:
  //DbgPrintf("Forcing unit hint (hwnd=%d, psz=%s)\n",
  //          (ULONG)mp1, mp2 ? mp2 : "NULL");
  return (MRESULT)ViewDisplayHint((HWND)mp1, (PSZ)mp2);

  case WM_MOUSEMOVE:
  if(pUnit->fGrpNext && !(pUnit->usFlags & STUF_NONEXTHANDLER))
    {
    WinSetPointer(HWND_DESKTOP, hptrHand);
    return (MRESULT)TRUE;
    }
  break;

  case WM_BUTTON1CLICK:
  if(pUnit->fGrpNext &&
     !(pUnit->usFlags & STUF_NONEXTHANDLER) &&
     !(SHORT2FROMMP(mp2) & KC_SHIFT))
    {
    INT iIndex = UctGetIndex((PVIEWDATA)pUnit->pViewData, pUnit);
    if(UctShiftGroup((PVIEWDATA)pUnit->pViewData, iIndex))
      ViewUpdateView((PVIEWDATA)pUnit->pViewData);

    return (MRESULT)1L;
    }
  break;

  case USTM_NEXTUNIT:
  if(pUnit->fGrpNext)
    {
    INT iIndex = UctGetIndex((PVIEWDATA)pUnit->pViewData, pUnit);
    if(UctShiftGroup((PVIEWDATA)pUnit->pViewData, iIndex))
      ViewUpdateView((PVIEWDATA)pUnit->pViewData);
    }
  return (MRESULT)0L;

  case WM_BEGINDRAG: // unit drag
  if(UctBeginDrag(hwnd, mp1, mp2, pUnit)) return (MRESULT)TRUE;
  break;

  case u_WM_MOVEALONGWINDOW:
    {
    ULONG i;
    if(!(pUnit->usFlags & STUF_NOHINT))
      {
      PWCLASS pwc = GenSearchClass(pUnit->szClass);
      if(pUnit->szUnitTitle[0])
        ViewDisplayHint(hwnd, pUnit->szUnitTitle);
      else if(pwc)
             ViewDisplayHint(hwnd, pwc->pszViewName);
      }
    break;
    }

  case WM_COMMAND:
  UctCommand(hwnd, mp1, mp2, pUnit);
  break;

  case WM_CONTEXTMENU:
    {
    HWND hwndTop = WinQueryWindow(HWND_DESKTOP, QW_TOP);
    CHAR szWindowClass[CBMAXSTRING];
    WinQueryClassName(hwndTop, CBMAXSTRING, szWindowClass);
    if(strcmp(szWindowClass, "#4")) // check for "Already" menu on top
                                    // in some VERY strange cases
      fMenuWork = UctContextMenu(hwnd, mp1, mp2, pUnit);
    return (MRESULT) 0L;
    }

  case WM_MENUEND:
  fMenuWork = FALSE; // 0.3.3 bugfix
  if(pUnit->hwnd_Menu && ((HWND)mp2 == pUnit->hwnd_Menu))
    {
    RECTL rcl;
    WinEnableWindowUpdate(hwnd, TRUE);
    WinQueryWindowRect(hwnd, &rcl);
    WinInvalidateRect(hwnd, &rcl, TRUE);
    return (MRESULT) 0L;
    }
  break;
  }

if(pUnit) return pUnit->pfnOldUnitProc(hwnd, msg, mp1, mp2);
else      return WinDefWindowProc(hwnd, msg, mp1, mp2);
}

BOOL    UctTimerUpdate(PVIEWDATA pvd)
{
INT i;

if(!pvd->usUnits) return FALSE;

for(i=0; i<pvd->usUnits; i++)
  {
  PUNIT pUnit = pvd->pUnits[i];
  if(!pUnit->ulRefresh) continue;

  if(pUnit->ulCounter == pUnit->ulRefresh-1)
    {
    pUnit->ulCounter = 0L;
    // touch unit with timer message
    WinPostMsg(pUnit->hwnd, USTM_REFRESHTIMER, (MPARAM)pvd, (MPARAM)pUnit);
    } else pUnit->ulCounter++;
  }

return TRUE;
}
