/* rexx -  Default REXX script handling folder callbacks of
           WPS-Wizard */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

call RxFuncAdd 'UniLoadFuncs', 'RexxUni', 'UniLoadFuncs'
call UniLoadFuncs

call RxFuncAdd 'xmlloadfuncs', 'rexxxml', 'xmlloadfuncs'
call xmlloadfuncs

call xmlloadfuncs

NUMERIC DIGITS 15 /* We need this for window handles */

currentObject = 0
timerTicks = 0

cp = UniQueryCp()

SELECT
WHEN ARG(1)="/GADGETSTARTED" THEN DO

	theObject=ARG(2)

	zInfo=""
	global.rssItems="<RSS_ITEMS>"
	gadgetText=""

	SIGNAL ON SYNTAX NAME errorHandler
	SIGNAL ON ERROR NAME errorHandler

	defaultPos=system.screen.width-220||" 100 200 150"

	/* Info for storing data in WPS-wizard ini file */
	INIFile=system.path.wpswizardini
	APPKEY="rssgadget"
	ZINFOPOS="rsspos"
	ZINFOFONT="rssfont"
	RSSINFOFEEDINTERVAL="rssfeedinterval"
	RSSINFOITEMINTERVAL="rssiteminterval"
	

	PARSE VAR defaultPos x y cx cy rest

	stem._x=x    /* x  */
	stem._y=y    /* y  */
	stem._cx=cx   /* cx */
	stem._cy=cy   /* cy */
	stem._type=HTML_GADGET    /* Gadget type */
	stem._hwnd=ARG(3) /* hwnd */
	stem._flags=GSTYLE_POPUP + GSTYLE_BORDER
	stem._font="8.Helv" /* font */
	feedsupdate = 60
	itemsupdate = 8

/* Get saved position if any */
	ret=Sysini(INIFile, APPKEY, ZINFOPOS)
	IF  ret >< "ERROR:" THEN DO
		PARSE VAR ret stem._x stem._y stem._cx stem._cy rest
	END
/* Get saved font if any */
	ret=Sysini(INIFile, APPKEY, ZINFOFONT)
	IF  ret >< "ERROR:" THEN DO
		stem._font=ret
	END
		ret=Sysini(INIFile, APPKEY, RSSINFOITEMINTERVAL)
	IF  ret >< "ERROR:" THEN DO
		itemsupdate=ret
	END
		ret=Sysini(INIFile, APPKEY, RSSINFOFEEDINTERVAL)
	IF  ret >< "ERROR:" THEN DO
		feedsupdate=ret
	END

    /* Get the persistent object handle */


    hObject=WPSWizCallWinFunc( "winQueryObject" ,"<RSS_ITEMS>")
    rssItemsFolder = 0
    if hObject\=0 THEN DO
	    /* Get the class object of the given object pointer */
	    classObject=WPSWizCallWPSFunc("somGetClass",theObject)

	    /* Get the object pointer from the handle */
	    rssItemsFolder=WPSWizCallWPSClsFunc("wpclsQueryObject", classObject, hObject)

    	/* The object was locked because of "wpclsQueryObject" */
	    rc=WPSWizCallWPSFunc("wpUnlockObject", rssItemsFolder)
    END

    hObject=WPSWizCallWinFunc( "winQueryObject" ,"<RSS_FEEDS>")
    rssFeedsFolder = 0
    if hObject\=0 THEN DO
	    /* Get the class object of the given object pointer */
	    classObject=WPSWizCallWPSFunc("somGetClass",theObject)

	    /* Get the object pointer from the handle */
	    rssFeedsFolder=WPSWizCallWPSClsFunc("wpclsQueryObject", classObject, hObject)

    	/* The object was locked because of "wpclsQueryObject" */
	    rc=WPSWizCallWPSFunc("wpUnlockObject", rssFeedsFolder)
	    rc= WPSWizCallWPSFunc("wpRefresh", rssFeedsFolder, OPEN_CONTENTS, 0);
    END

    call updateRSSFolder


    CurrentObject = WPSWizCallWPSFunc("wpQueryContent", rssitemsfolder , 0, QC_FIRST);
    gadgetText = formatText(CurrentObject)

    ret=WPSWizCallWPSFunc("wpUnlockObject", rssitemsfolder);



	ret=WizStartTimer( ARG(3), 10, (itemsupdate*1000))
	ret=WizStartTimer( ARG(3), 20, (feedsupdate*1000))
	
	rc=WizCreateGadget( "DESKTOP", "stem." , "rssgadget")
	ret = rssGadget.Text(gadgetText)
       DO FOREVER
	ret=WIZGETMESSAGE( ARG(3))

	if ret<>'' THEN
		INTERPRET "call "ret
	
	
	END /* FOREVER */
	EXIT(0)
END
OTHERWISE
	/* Start the gadget */
	PARSE SOURCE . . theScript
	IF ARG(1)="" THEN
		call SysSetObjectData "<WP_DESKTOP>", "WIZLAUNCHGADGET="theScript
	Exit(0)
END

rssGadget.onCommand:
/*
	ARG(1): hwnd of client area
	ARG(2): ID
	ARG(3): source (menu or button)
*/
	PARSE SOURCE . . theScript
	IF ARG(2)=1 THEN DO
		call SysIni iniFile, APPKEY, ZINFOPOS,  rssGadget.position()
		call SysIni iniFile, APPKEY, ZINFOFONT, rssGadget.font()
		call SysIni iniFile, APPKEY, RSSINFOITEMINTERVAL, itemsupdate
		call SysIni iniFile, APPKEY, RSSINFOFEEDINTERVAL, feedsupdate
		rc=wizDestroyGadget("rssgadget")
		exit(0)
	END
	IF ARG(2)=2 then do
	    call updateRSSFolder
	End
	IF ARG(2)=3 then do
	    /* Open object which shows now */
	    filename=WPSWizCallFunc("cwQueryRealName",currentObject, 1);
        call sysSetObjectData filename, "OPEN=DEFAULT"
	End
return


rssGadget.onPopUp:
/*
	ARG(1): hwnd of client area
	ARG(2): x
	ARG(3): y
*/
menu.0=3
menu.1="Close Gadget"
menu.2="Reload Items"
menu.3="Open current Item"

menu._x=ARG(2)
menu._y=ARG(3)

	ret=WPSWizCallWinFunc("menuPopupMenu", ARG(1), 'menu.')
return


onTimer:

        call Logmessage "in timer: "||arg(1)
        Select
        when ARG(1)=10 then
            do

            lastObject = WPSWizCallWPSFunc("wpQueryContent", rssitemsfolder , 0, 2);
            firstObject = WPSWizCallWPSFunc("wpQueryContent", rssitemsfolder , 0, 0);
            select
                when CurrentObject = 0  /* the last fetch next failed because folder was empty */
                then Do
                    CurrentObject = firstObject
                end
                when lastObject >< CurrentObject
                then DO
                    CurrentObject =  WPSWizCallWPSFunc("wpQueryContent", rssitemsfolder , CurrentObject, 1);
                end
                otherwise
                    currentObject = firstObject
            end

            rc = rssGadget.Text(formatText(CurrentObject))
        end
        when ARG(1)= 20 then
            do
            call UpdateRSSFolder

            end
        Otherwise
        end



return

quit:
	PARSE SOURCE . . theScript
	call SysPutEa theScript, "GADGETPOS", rssgadget.Position()
	
exit(0)


errorHandler:
    PARSE SOURCE . . theScript

    ret=WPSWizGadgetFunc("cwDisplayRexxError", ret)
    ret=WPSWizGadgetFunc("cwDisplayRexxError", theScript||": ")
    ret=WPSWizGadgetFunc("cwDisplayRexxError", "Error in line "||SIGL)


exit(0)

updateRSSFolder:
    PARSE SOURCE . . theScript


    /* Check if the <RSS_FEEDS> folder was found, if not create it on the desktop */
    if rssFeedsFolder = 0 then do
       ret = SysCreateObject("WPUrlFolder","RSS Feeds","<WP_DESKTOP>","OBJECTID=<RSS_FEEDS>;WIZSETREXXSCRIPT="||filespec('drive',theScript)||filespec('path',theScript)||"rssfeedfolder.rx")
       hObject=WPSWizCallWinFunc( "winQueryObject" ,"<RSS_FEEDS>")
       rssFeedsFolder = 0
        if hObject\=0 THEN DO
    	    /* Get the class object of the given object pointer */
	        classObject=WPSWizCallWPSFunc("somGetClass",theObject)

	        /* Get the object pointer from the handle */
	        rssFeedsFolder=WPSWizCallWPSClsFunc("wpclsQueryObject", classObject, hObject)

        	/* The object was locked because of "wpclsQueryObject" */
    	    rc=WPSWizCallWPSFunc("wpUnlockObject", rssFeedsFolder)
        END
       rc= WPSWizCallWPSFunc("wpRefresh", rssFeedsFolder, OPEN_CONTENTS, 0);

    end

    /* Check if the <RSS_ITEMS> folder was found, if not create it on the desktop */
    if rssItemsFolder = 0 then do
        call lineout filespec('drive',theScript)||filespec('path',theScript)||"rss.log",filespec('drive',theScript)||filespec('path',theScript)||"rssfolder.rx"
        ret = SysCreateObject("WPUrlFolder","RSS Items","<WP_DESKTOP>","OBJECTID=<RSS_ITEMS>;WIZSETREXXSCRIPT="||filespec('drive',theScript)||filespec('path',theScript)||"rssfolder.rx")
        hObject=WPSWizCallWinFunc( "winQueryObject" ,"<RSS_ITEMS>")
        rssItemsFolder = 0
        if hObject\=0 THEN DO
    	    /* Get the class object of the given object pointer */
	        classObject=WPSWizCallWPSFunc("somGetClass",theObject)

    	    /* Get the object pointer from the handle */
	        rssItemsFolder=WPSWizCallWPSClsFunc("wpclsQueryObject", classObject, hObject)

        	/* The object was locked because of "wpclsQueryObject" */
	        rc=WPSWizCallWPSFunc("wpUnlockObject", rssItemsFolder)
        END

    end


    /* Empty the RSS_ITEMS Folder */

    CurrentItem= WPSWizCallWPSFunc("wpQueryContent", rssItemsFolder , 0, QC_FIRST);

    DO while CurrentItem <> 0
        rc=WPSWizCallWPSFunc("wpDelete",currentItem, flConfirmation);
        CurrentItem= WPSWizCallWPSFunc("wpQueryContent", rssItemsFolder , 0, QC_FIRST);
    end



    /* Now itterate over all the feeds in the feeds folder */

    CurrentFeed= WPSWizCallWPSFunc("wpQueryContent", rssFeedsFolder , 0, QC_FIRST);
    call logMessage 'in update: feeds:'||rssFeedsFolder||" "||WPSWizCallFunc("cwIsObj", rssFeedsFolder)||" items:"||rssItemsFolder
    call logMessage 'feed:'||currentfeed
    DO while CurrentFeed <> 0


    urlFile = WPSWizCallFunc("cwQueryRealName", CurrentFeed, 1)
    url = LINEIN(urlFile)

    call stream urlFile,'c','CLOSE'

    call logmessage 'XML Version:'||xmlVersion()
    doc = xmlParseXml(url);
    if doc = 0 then leave

    ret = xmlExpandNode('maintree.',doc)

    /* check for version 2 information */
    FeedChannels = xmlFindNode('//rss/channel',maintree.children)
    DO Itemcount= 1 to xmlNodesetCount(FeedChannels)
            feedTitle = xmlEvalExpression("title",xmlNodesetItem(FeedChannels,ItemCount))
            mycontext = xmlNewContext(doc)
            prefix=""
    end
    if xmlNodesetCount(FeedChannels) = 0 then do
        mycontext = xmlNewContext(doc,'rss=http://purl.org/rss/1.0/')
        prefix = "rss:"
        FeedChannels = xmlFindNode('//rss:channel',maintree.children,mycontext)
         DO Itemcount= 1 to xmlNodesetCount(FeedChannels)
            feedTitle = xmlEvalExpression("rss:title",xmlNodesetItem(FeedChannels,ItemCount),mycontext)
        end

     end

     xpathItems = "//"||prefix||"item"
        Items = xmlFindNode(xpathItems,maintree.children,mycontext)


    call logmessage "er zijn " ||xmlNodesetCount(Items)|| " Items gevonden "
    /*call treewalk maintree.children ,1 ,'test'*/

    DO Itemcount= 1 to xmlNodesetCount(Items)
        link = xmlEvalExpression(""||prefix||"link",xmlNodesetItem(Items,ItemCount),mycontext)
        title = translate(cleanupHtml(UniXlat(xmlEvalExpression(""||prefix||"title",xmlNodesetItem(Items,ItemCount),mycontext),cp,'UTF-8')),' ', d2c(8))
        description = xmlFindNode(""||prefix||"description",xmlNodesetItem(Items,ItemCount),mycontext)


        if description >0 then do
            rc = xmlExpandNode('fulldescription.',xmlNodesetItem(description,1))
            if fulldescription.children >< 0 then do
                rc = xmlExpandNode('textdescription.',fulldescription.children)
                text = textdescription.content
            end
        end
        /* We use a temp file name to be sure we can attach the commen to a URL with illegal characters in the file */

        fullFolder = WPSWizCallFunc("cwQueryRealName", rssitemsfolder, 1)
        fullpath = systempfilename(fullfolder"\rssi????")

        ret = SysCreateObject("WPUrl",filespec('name',fullpath),"<RSS_ITEMS>","URL="||link||";WIZSETREXXSCRIPT="||filespec('drive',theScript)||filespec('path',theScript)||"rssobject.rx;")
        comment = translate(UniXlat(cleanupHTML(text),cp,'UTF-8'),'   ',d2c(8)||d2c(10)||x2c('7F'))
        lenght = x2c(right(right(d2x(length(comment)),4,'0'),2))||x2c(left(right(d2x(length(comment)),4,'0'),2))
        ret = SysPutEA(fullpath,".RSSDescription",'FEFF'x || lenght || comment)

        /* Now change the title */
        ret = SysSetObjectData(fullpath,"TITLE="feedTitle||" - "||title);
     end

    CurrentFeed =  WPSWizCallWPSFunc("wpQueryContent", rssFeedsFolder , CurrentFeed, 1);

    end
    updaterunning = 0
return

formatText:

    parse arg myObject

    if myObject >< 0 then
    do
        File=WPSWizCallFunc("cwQueryRealName", myObject, 1)
        if SysGetEA(File, ".rssDescription", "COMMENT") = 0 then do
            parse var comment 5 text
        end
        formatedText='<h1><font color="#000000ff">'||WPSWizCallWPSFunc("wpQueryTitle", myObject)||'</font></h1>'
        formatedText = formatedText||'<p><font size="5" color="#00dddddd">'||text||'</font></p>'
        if length(formatedtext) > 512 then formatedtext=left(formatedtext,512)||"..."

        /*formatedText = WPSWizCallWPSFunc("wpQueryTitle", myObject);*/
        end
    else
        formatedText = "RSS Item Folder is empty"
return formatedText

cleanupHTML:
parse arg htmltoclean

cleanHTML = htmltoclean
currentlt = pos('<', htmltoclean)
currentgt = pos('>', htmltoclean)

do while currentlt <> 0
    cleanHTML = delstr(cleanHTML,currentlt,(currentgt-currentlt)+1)
    currentlt = pos('<', cleanhtml)
    currentgt = pos('>', cleanhtml)

end


return cleanHTML

logMessage:

PARSE ARG message
PARSE SOURCE . . theScript
call lineout filespec('drive',theScript)||filespec('path',theScript)||"rss.log",message
call stream filespec('drive',theScript)||filespec('path',theScript)||"rss.log",'c','CLOSE'

return
