//===========================================================================\
// ApiExPM.h: General purpose PM macros and definitions
//            These definitions are meant to be available to any program
// 24-12-2001 * by Alessandro Cantatore * v...
//===========================================================================/


#ifndef _APIEX_PM_H_
   #define _APIEX_PM_H_

// new type definitions -----------------------------------------------------
// image handle : this is used by the control which can display both icons
// and bitmaps
typedef LHANDLE HIMAGE;
typedef HIMAGE * PHIMAGE;

// Message result definitions -----------------------------------------------
#define MRFALSE ((MRESULT)0)
#define MRTRUE  ((MRESULT)1)

// Message parameter definitions --------------------------------------------
#define MPFALSE ((MPARAM)0)
#define MPTRUE  ((MPARAM)1)

// Undocumented window style ------------------------------------------------
#ifndef WS_TOPMOST
  #define WS_TOPMOST  0x00200000
#endif

// ------------------ WINDOW POSITION AND SIZE ------------------------------

// structure to describe the position and size of a window rectangle:
typedef struct {
   LONG x, y, cx, cy;
} WPOSSIZE, * PWPOSSIZE;

// structure to describe the position and size of a window rectangle:
typedef struct {
   SHORT x, y, cx, cy;
} WPOSSIZES, * PWPOSSIZES;

// structure used to pack a control size into 4 bytes
#pragma pack(2)
typedef struct {
   SHORT cx, cy;
} SIZES, * PSIZES;
#pragma pack()

// POINTL structure macros --------------------------------------------------
// general purpose point and rectangle manipulation macros
// the ppt and prect parameters must be pointer to POINT and RECTL
// Initializes a point structure
#define PointSet(ppt, _x, _y)   \
  (((PPOINTL)(ppt))->x = (_x),  \
   ((PPOINTL)(ppt))->y = (_y))

// RECTL structure macros ---------------------------------------------------

// Simmetrically shifts the rectangle coordinates by _dx_,_dy_ pixels
#define RectInflate(_pr_, _dx_, _dy_)                                \
                           (((PRECTL)(_pr_))->xLeft -= (_dx_),     \
                            ((PRECTL)(_pr_))->yBottom -= (_dy_),   \
                            ((PRECTL)(_pr_))->xRight += (_dx_),    \
                            ((PRECTL)(_pr_))->yTop += (_dy_))
// Initializes a rectangle with the coordinates (_x0_,_y0_) - (_x1_,_y1_)
#define RectSet(_pr_, _x0_, _y0_, _x1_, _y1_)                            \
                           (((PRECTL)(_pr_))->xLeft = (_x0_),      \
                            ((PRECTL)(_pr_))->yBottom = (_y0_),    \
                            ((PRECTL)(_pr_))->xRight = (_x1_),     \
                            ((PRECTL)(_pr_))->yTop = (_y1_))
// Initializes a rectangle with the coordinates (_x0_,_y0_) - (_x1_,_y1_)
#define RectSetByDelta(_pr_, _x0_, _y0_, _x1_, _y1_)                      \
                           (((PRECTL)(_pr_))->xLeft += (_x0_),      \
                            ((PRECTL)(_pr_))->yBottom += (_y0_),    \
                            ((PRECTL)(_pr_))->xRight += (_x1_),     \
                            ((PRECTL)(_pr_))->yTop += (_y1_))
// shifts the coordinates of a rectangle by _dx_, _dy_ pixels
#define RectShift(_pr_, _dx_, _dy_)                                  \
                           (((PRECTL)(_pr_))->xLeft += (_dx_),     \
                            ((PRECTL)(_pr_))->yBottom += (_dy_),   \
                            ((PRECTL)(_pr_))->xRight += (_dx_),    \
                            ((PRECTL)(_pr_))->yTop += (_dy_))
// returns TRUE if a RECTL structure is empty
#define RectIsEmpty(_pr_)                                        \
((((PRECTL)(_pr_))->xLeft >= ((PRECTL)(_pr_))->xRight) ||       \
 (((PRECTL)(_pr_))->yBottom >= ((PRECTL)(_pr_))->yTop))

// top and right coordinates of a window (used with WinSetMultWindowPos() )
#define mwposXright(pswp, idx) ((pswp)[idx].x + (pswp)[idx].cx)
#define mwposYtop(pswp, idx)   ((pswp)[idx].y + (pswp)[idx].cy)


// Undocumented messages ----------------------------------------------------

// These messages are generated by Warp 4 and superior versions
// These messages are posted to a window when the mouse pointer enters
// or leaves the window rectangle.
// The default window procedure returns FALSE in both cases

// mouse getting inside the window area
// mp1 : handle of the window the mouse is moving to
// mp2 : handle of the window previously under the mouse
#define WM_MOUSEENTER      0x041e

// mouse getting outside the window area
// mp1 : handle of the window the mouse is moving away from
// mp2 : handle of the window the mouse is moving to
#define WM_MOUSEEXIT       0x041f    // mouse leaving the window area


// MOUSE and MOUSE pointer macros -------------------------------------------

// gets x, y coordinates from a mouse message parameter
#define MOUSEX(mp)          ((SHORT)(ULONG)(mp))
#define MOUSEY(mp)          ((SHORT)((ULONG)mp >> 16))


// New system pointer: display a hand with a finger -------------------------
#define SPTR_HANDCLICK   (SPTR_CPTR + 1)

// Macro to set a system pointer (used in WM_MOUSEMOVE processing)
#define WinSetSysPointer(iptr) \
   (WinSetPointer(HWND_DESKTOP, WinQuerySysPointer(HWND_DESKTOP, (iptr), 0)))


// keyboard macros ----------------------------------------------------------
#define pmKbdIsKeyPressed(_vkey_) \
   ((WinGetKeyState(HWND_DESKTOP, _vkey_) & 0x8000) > 0)

// various PM macros --------------------------------------------------------



#define WinHAB(_hwnd_)         (WinQueryAnchorBlock(_hwnd_))
#define WinID(_hwnd_)          (WinQueryWindowUShort((_hwnd_), QWS_ID))
#define WinNext(_hwnd_)        (WinQueryWindow((_hwnd_), QW_NEXT))
#define WinOwner(_hwnd_)       (WinQueryWindow((_hwnd_), QW_OWNER))
#define WinParent(_hwnd_)      (WinQueryWindow((_hwnd_), QW_PARENT))
#define WinStyle(_hwnd_)       (WinQueryWindowULong((_hwnd_), QWL_STYLE))

#define WinXRestore(_hwnd_)    (WinQueryWindowUShort((_hwnd_), QWS_XRESTORE))
#define WinYRestore(_hwnd_)    (WinQueryWindowUShort((_hwnd_), QWS_YRESTORE))
#define WinCxRestore(_hwnd_)   (WinQueryWindowUShort((_hwnd_), QWS_CXRESTORE))
#define WinCyRestore(_hwnd_)   (WinQueryWindowUShort((_hwnd_), QWS_CYRESTORE))
#define WinXRestoreSet(_hwnd_, _us_) \
   (WinSetWindowUShort((_hwnd_), QWS_XRESTORE, (_us_)))
#define WinYRestoreSet(_hwnd_, _us_) \
   (WinSetWindowUShort((_hwnd_), QWS_YRESTORE, (_us_)))
#define WinCxRestoreSet(_hwnd_, _us_) \
   (WinSetWindowUShort((_hwnd_), QWS_CXRESTORE, (_us_)))
#define WinCyRestoreSet(_hwnd_, _us_) \
   (WinSetWindowUShort((_hwnd_), QWS_CYRESTORE, (_us_)))

#define WinStyleSet(hwnd, style) \
   (WinSetWindowULong((hwnd), QWL_STYLE, (style)))

// WinQuerySysValue () macro
#define WinSysVal(ival)      (WinQuerySysValue(HWND_DESKTOP, (ival)))

// definisce un PHELPTABLE da un HELPTABLE id
#define PHLPTBLFROMID(x)   ((PHELPTABLE)((x) | 0xffff0000))

// non-blocking wait-thread macro
#define WinThreadTerminated(ptid) \
   ((BOOL)(ERROR_THREAD_NOT_TERMINATED != DosWaitThread((ptid), DCWW_NOWAIT)))

// set the font of a window
#define WinFontSet(_hwnd_, _font_) \
(WinSetPresParam((_hwnd_), PP_FONTNAMESIZE, strlen(_font_) + 1, _font_))

// send a notification message to the owner
#define WinOwnerNotify(_hwnd_, _notification_, _mp_)          \
   (WinSendMsg(WinOwner(_hwnd_), WM_CONTROL,                  \
               MPFROM2SHORT(WinID(_hwnd_), (_notification_)), \
               (MPARAM)(_mp_)))

// DIALOG item macros -------------------------------------------------------

#define DlgItemHwnd(hwnd, id)    (WinWindowFromID((hwnd), (id)))

#define DlgItemIdSet(hwnd, idOld, idNew) \
   (WinSetWindowUShort(DlgItemHwnd((hwnd), (idOld)), QWS_ID, (idNew)))

#define DlgItemEnable(hwnd, id, benable) \
   (WinEnableWindow(DlgItemHwnd((hwnd), (id)), (benable)))

#define DlgItemIsEnabled(hwnd, id) \
   (WinIsWindowEnabled(DlgItemHwnd((hwnd), (id))))

#define DlgItemShow(hwnd, id, bshow) \
   (WinShowWindow(DlgItemHwnd((hwnd), (id)), (bshow)))

#define DlgItemIsVisible(hwnd, id) \
   (WinIsWindowVisible(DlgItemHwnd((hwnd), (id))))

#define DlgItemGetPos(hwnd, id, pswp) \
   (WinQueryWindowPos(WinWindowFromID((hwnd), (id)), (pswp)))

#define DlgItemSetPos(hwnd, id, hBehind, x, y, cx, cy, fl) \
   (WinSetWindowPos(WinWindowFromID((hwnd), (id)), \
                    (hBehind), (x), (y), (cx), (cy), (fl)))

#define DlgItemSetPresParam(hwnd, id, type, cb, pval) \
   (WinSetPresParam(DlgItemHwnd((hwnd), (id)), (type), (cb), (pval)))

#define DlgItemPresParam(hwnd, id, type1, type2, ptype, cb, pval, fl) \
   (WinQueryPresParam(DlgItemHwnd((hwnd), (id)), \
                      (type1), (type2), (ptype), (cb), (pval), (fl)))

#define DlgItemText(hwnd, id, cbBuf, buf) \
   (WinQueryDlgItemText((hwnd), (id), (cbBuf), (buf)))

#define DlgItemTextLength(hwnd, id) \
   (WinQueryDlgItemTextLength((hwnd), (id)))

#define DlgItemTextSet(hwnd, id, text) \
   (WinSetDlgItemText((hwnd), (id), (text)))

// enable multiple controls
#define DlgItemEnableMulti(hwnd, idx, idFirst, idLast, flag) \
   idx = (idFirst);                                          \
   do {                                                      \
      DlgItemEnable((hwnd), (idx), (BOOL)(flag));                  \
   } while (++idx <= idLast )

// get the rectangle of a dialog item
#define DlgItemRect(hwnd, id, pr) \
   (WinQueryWindowRect(DlgItemHwnd((hwnd), (id)), (pr)))

// ------------------ PM CONTROLS MACROS ------------------------------------
// d* macro are for dialogs, w* macro are for windows


// BUTTONS ------------------------------------------------------------------

// emulate a click event on a button
#define dBtnClick(hwnd, id, bUp) \
   ((USHORT)WinSendDlgItemMsg((hwnd), (id), BM_CLICK, (MPARAM)(bUp), MPVOID))
#define wBtnClick(hwnd, bUp) \
   ((USHORT)WinSendMsg((hwnd), BM_CLICK, (MPARAM)(bUp), MPVOID))

// sets a button check state
#define dBtnCheckSet(hwnd, id, state) \
   ((USHORT)WinSendDlgItemMsg((hwnd), (id), BM_SETCHECK, \
                              (MPARAM)(state), MPVOID))
#define wBtnCheckSet(hwnd, state) \
   ((USHORT)WinSendMsg((hwnd), BM_SETCHECK, (MPARAM)(state), MPVOID))

// gets a button check state
#define dBtnCheckState(hwnd, id) \
   ((USHORT)WinSendDlgItemMsg((hwnd), (id), BM_QUERYCHECK, MPVOID, MPVOID))
#define wBtnCheckState(hwnd) \
   ((USHORT)WinSendMsg((hwnd), BM_QUERYCHECK, MPVOID, MPVOID))

// returns the check index of a group of radiobutton (0 = first radiobutton)
#define dBtnCheckIndex(hwnd, id) \
   ((SHORT)WinSendDlgItemMsg((hwnd), (id), BM_QUERYCHECKINDEX, MPVOID, MPVOID))
#define wBtnCheckIndex(hwnd) \
   ((SHORT)WinSendMsg((hwnd), BM_QUERYCHECKINDEX, MPVOID, MPVOID))


// CONTAINERS ---------------------------------------------------------------

// allocates one minirecordcore type structure
// (cb is the total size of the structure to be allocated)
#define dCnrAllocMini(hwnd, id, cb) \
((PMINIRECORDCORE)WinSendDlgItemMsg((hwnd), (id), CM_ALLOCRECORD, \
                                    (MPARAM)((cb) - sizeof(MINIRECORDCORE)),\
                                    (MPARAM)1))
#define wCnrAllocMini(hwnd, cb) \
((PMINIRECORDCORE)WinSendMsg((hwnd), CM_ALLOCRECORD, \
                             (MPARAM)((cb) - sizeof(MINIRECORDCORE)),\
                             (MPARAM)1))

// allocates multiple minirecordcore type structures
// (cb is the total size of the structure to be allocated)
#define dCnrAllocMultiMini(hwnd, id, cb, cRec) \
((PMINIRECORDCORE)WinSendDlgItemMsg((hwnd), (id), CM_ALLOCRECORD, \
                                    (MPARAM)((cb) - sizeof(MINIRECORDCORE)),\
                                    (MPARAM)(cRec)))
#define wCnrAllocMultiMini(hwnd, cb, cRec) \
((PMINIRECORDCORE)WinSendMsg((hwnd), CM_ALLOCRECORD, \
                             (MPARAM)((cb) - sizeof(MINIRECORDCORE)),\
                             (MPARAM)(cRec)))

// Allocates the structures describing the columns when in detail view
#define dCnrAllocColumns(hwnd, id, cCols) \
((PFIELDINFO)WinSendDlgItemMsg((hwnd), (id), CM_ALLOCDETAILFIELDINFO, \
                               (MPARAM)(cCols), MPVOID))
#define wCnrAllocColumns(hwnd, cCols) \
((PFIELDINFO)WinSendMsg((hwnd), CM_ALLOCDETAILFIELDINFO, \
                        (MPARAM)(cCols), MPVOID))

// Frees the structures describing the columns when in detail view
#define dCnrFreeColumns(hwnd, id, pCol, cCols) \
((PFIELDINFO)WinSendDlgItemMsg((hwnd), (id), CM_FREEDETAILFIELDINFO, \
                               (MPARAM)(pCol), (MPARAM)(cCols)))
#define wCnrFreeColumns(hwnd, pCol, cCols) \
((PFIELDINFO)WinSendMsg((hwnd), CM_FREEDETAILFIELDINFO, \
                        (MPARAM)(pCol), (MPARAM)(cCols)))

// query a field info (CMA_FIRST, CMA_LAST, CMA_NEXT, CMA_PREV)
#define dCnrGetFieldInfo(hwnd, id, pfi, idx) \
((PFIELDINFO)WinSendDlgItemMsg((hwnd), (id), CM_QUERYDETAILFIELDINFO, \
                         (MPARAM)(pfi), (MPARAM)(idx)))
#define wCnrGetFieldInfo(hwnd, pfi, idx) \
((PFIELDINFO)WinSendMsg((hwnd), CM_QUERYDETAILFIELDINFO, \
                        (MPARAM)(pfi), (MPARAM)(idx)))


// Arranges the content of a container
#define dCnrArrange(hwnd, id, type, flag) \
((BOOL)WinSendDlgItemMsg((hwnd), (id), CM_ARRANGE, \
                         (MPARAM)(type), (MPARAM)(flag)))
#define wCnrArrange(hwnd, type, flag) \
((BOOL)WinSendMsg((hwnd), CM_ARRANGE, (MPARAM)(type), (MPARAM)(flag)))

// inserts one minirecordcore type structure in a container
#define dCnrInsMini(hwnd, id, pRec, pRecIns) \
((ULONG)WinSendDlgItemMsg((hwnd), (id), CM_INSERTRECORD, \
                             (MPARAM)(pRec), (MPARAM)(pRecIns)))
#define wCnrInsMini(hwnd, pRec, pRecIns) \
((ULONG)WinSendMsg((hwnd), CM_INSERTRECORD, (MPARAM)(pRec), (MPARAM)(pRecIns)))

// inserts one or more columns in a container
#define dCnrInsColumns(hwnd, id, pFi, pFiIns) \
((ULONG)WinSendDlgItemMsg((hwnd), (id), CM_INSERTDETAILFIELDINFO, \
                             (MPARAM)(pFi), (MPARAM)(pFiIns)))
#define wCnrInsColumns(hwnd, pFi, pFiIns) \
((ULONG)WinSendMsg((hwnd), CM_INSERTDETAILFIELDINFO, \
                   (MPARAM)(pFi), (MPARAM)(pFiIns)))

// set the container info
#define dCnrInfoSet(hwnd, id, pci, flags) \
((BOOL)WinSendDlgItemMsg((hwnd), (id), CM_SETCNRINFO, \
                             (MPARAM)(pci), (MPARAM)(flags)))
#define wCnrInfoSet(hwnd, pci, flags) \
((BOOL)WinSendMsg((hwnd), CM_SETCNRINFO, (MPARAM)(pci), (MPARAM)(flags)))

// get a container record
#define dCnrGetRecord(hwnd, id, pRec, iRec, order) \
((BOOL)WinSendDlgItemMsg((hwnd), (id), CM_QUERYRECORD, \
                         (MPARAM)(pRec), MPFROM2SHORT((iRec), (order))))
#define wCnrGetRecord(hwnd, pRec, iRec, order) \
((BOOL)WinSendMsg((hwnd), CM_QUERYRECORD, \
                  (MPARAM)(pRec), MPFROM2SHORT((iRec), (order))))

// removes and frees all the container records
#define dCnrRemAllRecords(hwnd, id) \
((BOOL)WinSendDlgItemMsg((hwnd), (id), CM_REMOVERECORD, \
                         MPVOID, MPFROM2SHORT(0, CMA_FREE | CMA_INVALIDATE)))
#define wCnrRemAllRecords(hwnd) \
((BOOL)WinSendMsg((hwnd), CM_REMOVERECORD, \
                  MPVOID, MPFROM2SHORT(0, CMA_FREE | CMA_INVALIDATE)))

// return the address of the first selected container record
#define dCnrSelectedRecord(hwnd, id) \
((PVOID)WinSendDlgItemMsg((hwnd), (id), CM_QUERYRECORDEMPHASIS, \
                          (MPARAM)CMA_FIRST, (MPARAM)CRA_SELECTED))
#define wCnrSelectedRecord(hwnd) \
((PVOID)WinSendMsg((hwnd), CM_QUERYRECORDEMPHASIS, \
                   (MPARAM)CMA_FIRST, (MPARAM)CRA_SELECTED))

// returns TRUE if 'p' returned by wCnrSelectedRecord is a valid address
#define wCnrIsValidRecord(p)   ((p) && ((INT)(p) != -1))

// redraws a container record
#define dCnrRedrawRecord(hwnd, id, prec, crec, flag) \
((PVOID)WinSendDlgItemMsg((hwnd), (id), CM_INVALIDATERECORD, \
                          (MPARAM)(prec), MPFROM2SHORT((crec), (flag))))
#define wCnrRedrawRecord(hwnd, prec, crec, flag) \
((PVOID)WinSendMsg((hwnd), CM_INVALIDATERECORD, \
                   (MPARAM)(prec), MPFROM2SHORT((crec), (flag))))

// select a container record
#define dCnrSelectRecord(hwnd, id, prec, bsel) \
((BOOL)WinSendDlgItemMsg((hwnd), (id), CM_SETRECORDEMPHASIS, \
                          (MPARAM)(prec), MPFROM2SHORT((bsel), CRA_SELECTED)))
#define wCnrSelectRecord(hwnd, prec, bsel) \
((BOOL)WinSendMsg((hwnd), CM_SETRECORDEMPHASIS, \
                   (MPARAM)(prec), MPFROM2SHORT((bsel), CRA_SELECTED)))

// disable/enable a container record
#define dCnrDisableRecord(hwnd, id, prec, bdisable) \
((BOOL)WinSendDlgItemMsg((hwnd), (id), CM_SETRECORDEMPHASIS, \
                          (MPARAM)(prec), MPFROM2SHORT((bdisable), CRA_DISABLED)))
#define wCnrDisableRecord(hwnd, prec, bdisable) \
((BOOL)WinSendMsg((hwnd), CM_SETRECORDEMPHASIS, \
                   (MPARAM)(prec), MPFROM2SHORT((bdisable), CRA_DISABLED)))

// sets the emphasis attributes of the specified container record
#define dCnrEmphasizeRecord(hwnd, id, prec, bool, flag) \
((BOOL)WinSendDlgItemMsg((hwnd), (id), CM_SETRECORDEMPHASIS, \
                          (MPARAM)(prec), MPFROM2SHORT((bool), (flag))))
#define wCnrEmphasizeRecord(hwnd, prec, bool, flag) \
((BOOL)WinSendMsg((hwnd), CM_SETRECORDEMPHASIS, \
                   (MPARAM)(prec), MPFROM2SHORT((bool), (flag))))


// ENTRY FIELD macros -------------------------------------------------------

// changes the readonly style of the entry field
#define dEfSetReadOnly(hwnd, id, bReadOnly) \
   ((BOOL)WinSendDlgItemMsg((hwnd), (id), EM_SETREADONLY, \
                            (MPARAM)(bReadOnly), MPVOID))
#define wEfSetReadOnly(hwnd, bReadOnly) \
   ((BOOL)WinSendMsg((hwnd), EM_SETREADONLY, (MPARAM)(bReadOnly), MPVOID))

// changes the maximum size of the text allowed for an entry field
#define dEfSetTextLimit(hwnd, id, limit) \
   ((BOOL)WinSendDlgItemMsg((hwnd), (id), EM_SETTEXTLIMIT, \
                            (MPARAM)(limit), MPVOID))
#define wEfSetTextLimit(hwnd, limit) \
   ((BOOL)WinSendMsg((hwnd), EM_SETTEXTLIMIT, (MPARAM)(limit), MPVOID))


// listbox ------------------------------------------------------------------

// delete all items
#define dLbxEmpty(hwnd, id) \
   ((BOOL)WinSendDlgItemMsg((hwnd), (id), LM_DELETEALL, MPVOID, MPVOID))
#define wLbxEmpty(hwnd) \
   ((BOOL)WinSendMsg((hwnd), LM_DELETEALL, MPVOID, MPVOID))

// delete one item
#define dLbxItemDel(hwnd, id, iitem) \
   ((BOOL)WinSendDlgItemMsg((hwnd), (id), LM_DELETEITEM, \
                            (MPARAM)(iitem), MPVOID))
#define wLbxItemDel(hwnd, iitem) \
   ((BOOL)WinSendMsg((hwnd), LM_DELETEITEM, (MPARAM)(iitem), MPVOID))


// insert an item
#define dLbxItemIns(hwnd, id, iitem, pitem) \
   ((SHORT)WinSendDlgItemMsg((hwnd), (id), LM_INSERTITEM, \
                             (MPARAM)(iitem), (MPARAM)(pitem)))
#define wLbxItemIns(hwnd, iitem, pitem) \
   ((SHORT)WinSendMsg((hwnd), LM_INSERTITEM, \
                      (MPARAM)(iitem), (MPARAM)(pitem)))

// insert an item and a handle
#define dLbxItemAndHndIns(hwnd, id, iitem, pitem, hnd) \
((BOOL)WinSendDlgItemMsg((hwnd), (id), LM_SETITEMHANDLE, \
                    (MPARAM)WinSendDlgItemMsg((hwnd), (id), LM_INSERTITEM,\
                                       (MPARAM)(iitem), (MPARAM)(pitem)), \
                    (MPARAM)(hnd)))
#define wLbxItemAndHndIns(hwnd, iitem, pitem, hnd) \
((BOOL)WinSendMsg((hwnd), LM_SETITEMHANDLE, \
                  (MPARAM)WinSendMsg((hwnd), LM_INSERTITEM,\
                                     (MPARAM)(iitem), (MPARAM)(pitem)), \
                  (MPARAM)(hnd)))

// query the first selected item
#define dLbxItemSelected(hwnd, id) \
   ((SHORT)WinSendDlgItemMsg((hwnd), (id), LM_QUERYSELECTION, \
                             (MPARAM)LIT_FIRST, MPVOID))
#define wLbxItemSelected(hwnd) \
   ((SHORT)WinSendMsg((hwnd), LM_QUERYSELECTION, (MPARAM)LIT_FIRST, MPVOID))

// get the item count
#define dLbxItemCount(hwnd, id) \
   ((SHORT)WinSendDlgItemMsg((hwnd), (id), LM_QUERYITEMCOUNT, MPVOID, MPVOID))
#define wLbxItemCount(hwnd) \
   ((SHORT)WinSendMsg((hwnd), LM_QUERYITEMCOUNT, MPVOID, MPVOID))

// get the handle of an item

#define dLbxItemHnd(hwnd, id, iitem) \
   ((ULONG)WinSendDlgItemMsg((hwnd), (id), LM_QUERYITEMHANDLE, \
                             (MPARAM)(iitem), MPVOID))
#define wLbxItemHnd(hwnd, iitem) \
   ((ULONG)WinSendMsg((hwnd), LM_QUERYITEMHANDLE, (MPARAM)(iitem), MPVOID))

// set the handle of an item

#define dLbxItemHndSet(hwnd, id, iitem, handle) \
   ((ULONG)WinSendDlgItemMsg((hwnd), (id), LM_SETITEMHANDLE, \
                             (MPARAM)(iitem), (MPARAM)(handle)))
#define wLbxItemHndSet(hwnd, iitem, handle) \
   ((ULONG)WinSendMsg((hwnd), LM_QUERYITEMHANDLE, \
                      (MPARAM)(iitem), (MPARAM)(handle)))

// select an item
#define dLbxItemSelect(hwnd, id, iitem) \
   ((BOOL)WinSendDlgItemMsg((hwnd), (id), LM_SELECTITEM, \
                             (MPARAM)(iitem), (MPARAM)TRUE))
#define wLbxItemSelect(hwnd, iitem) \
   ((BOOL)WinSendMsg((hwnd), LM_SELECTITEM, (MPARAM)(iitem), (MPARAM)TRUE))

// get the text of the item iitem
#define dLbxItemText(hwnd, id, iitem, cbBuf, pszText) \
   ((SHORT)WinSendDlgItemMsg((hwnd), (id), LM_QUERYITEMTEXT, \
                      MPFROM2SHORT((iitem), (cbBuf)), (MPARAM)(pszText)))
#define wLbxItemText(hwnd, iitem, cbBuf, pszText) \
   ((SHORT)WinSendMsg((hwnd), LM_QUERYITEMTEXT, \
                      MPFROM2SHORT((iitem), (cbBuf)), (MPARAM)(pszText)))

// get the lenght of the text of the item iitem
#define dLbxItemTextLength(hwnd, id, iitem) \
   ((SHORT)WinSendDlgItemMsg((hwnd), (id), LM_QUERYITEMTEXTLENGTH, \
                             (MPARAM)(iitem), MPVOID))
#define wLbxItemTextLength(hwnd, iitem) \
   ((SHORT)WinSendMsg((hwnd), LM_QUERYITEMTEXTLENGTH, (MPARAM)(iitem), MPVOID))

// find an item from its text
#define dLbxItemTextSearch(hwnd, id, flSearch, iStart, pszText) \
   ((SHORT)WinSendDlgItemMsg((hwnd), (id), LM_SEARCHSTRING, \
                      MPFROM2SHORT((flSearch), (iStart)), (MPARAM)(pszText)))
#define wLbxItemTextSearch(hwnd, flSearch, iStart, pszText) \
   ((SHORT)WinSendMsg((hwnd), LM_SEARCHSTRING, \
                      MPFROM2SHORT((flSearch), (iStart)), (MPARAM)(pszText)))

// query the handle of the first selected item
#define dLbxItemSelectedHnd(hwnd, id) \
   dLbxItemHnd((hwnd), (id), dLbxItemSelected((hwnd), (id)))
#define wLbxItemSelectedHnd(hwnd) \
   wLbxItemHnd((hwnd), wLbxItemSelected(hwnd))

// query the text of the first selected item
#define dLbxItemSelectedText(hwnd, id, cbBuf, pszText) \
   dLbxItemText((hwnd), (id), dLbxItemSelected((hwnd), (id)), (cbBuf), (pszText))
#define wLbxItemSelectedText(hwnd, cbBuf, pszText) \
   wLbxItemText((hwnd), wLbxItemSelected(hwnd), (cbBuf), (pszText))

// insert an item only if it is unique
#define dLbxItemInsUnique(hwnd, id, iitem, pitem, flSearch) \
(  (LIT_NONE \
   == dLbxItemTextSearch((hwnd), (id), (flSearch), LIT_FIRST, (pitem))) ? \
      dLbxItemIns((hwnd), (id), (iitem), (pitem)) : \
      LIT_NONE)
#define wLbxItemInsUnique(hwnd, iitem, pitem, flSearch) \
(  (LIT_NONE \
   == wLbxItemTextSearch((hwnd), (flSearch), LIT_FIRST, (pitem))) ? \
      wLbxItemIns((hwnd), (iitem), (pitem)) : \
      LIT_NONE)

// MENU macros --------------------------------------------------------------

// creates a submenu to be dynamically inserted in a menu
// hwnd : parent menu handle
#define WinCreateSubmenu(hwnd) \
((HWND)WinCreateWindow(HWND_OBJECT, WC_MENU, NULL, 0, 0, 0, 0, 0, (hwnd), \
                       HWND_TOP, 0, NULL, NULL))

// inserts a menu item
// hwnd     : parent menu handle
// pmi      : address of MENUITEM structure
// itemText : item text
#define wMenuItemIns(hwnd, pmi, itemText) \
((SHORT)WinSendMsg((hwnd), MM_INSERTITEM, (MPARAM)(pmi), (MPARAM)(itemText)))

// check/unchecks menuitem id
#define dMenuItemCheck(hwnd, id, bCheck) \
   ((BOOL)WinSendDlgItemMsg(hwnd, FID_MENU, MM_SETITEMATTR, \
                MPFROM2SHORT(id, TRUE), \
                MPFROM2SHORT(MIA_CHECKED, ((!(!(bCheck))) << 13))))
#define wMenuItemCheck(hwnd, id, bCheck) \
   ((BOOL)WinSendMsg(hwnd, MM_SETITEMATTR, MPFROM2SHORT(id, TRUE), \
                MPFROM2SHORT(MIA_CHECKED, ((!(!(bCheck))) << 13))))

// enable/disable a menuitem id (hwnd is the handle of the frame window)
#define dMenuItemEnable(hwnd, id, bEnable) \
   ((BOOL)WinSendDlgItemMsg(hwnd, FID_MENU, MM_SETITEMATTR, \
                     MPFROM2SHORT(id, TRUE), \
                     MPFROM2SHORT(MIA_DISABLED, ((!(bEnable)) << 14))))
// enable/disable a menuitem id
#define wMenuItemEnable(hwnd, id, bEnable) \
   ((BOOL)WinSendMsg(hwnd, MM_SETITEMATTR, MPFROM2SHORT(id, TRUE), \
                     MPFROM2SHORT(MIA_DISABLED, ((!(bEnable)) << 14))))

// changes the text of the menuitem id
#define wMenuItemTextSet(hwnd, id, text) \
   ((BOOL)WinSendMsg((hwnd), MM_SETITEMTEXT, (MPARAM)(id), (MPARAM)(text)))


// SCROLL BAR macros --------------------------------------------------------

#define dScrollPosSet(hwnd, id, ipos) \
   ((BOOL)WinSendDlgItemMsg((hwnd), (id), SBM_SETPOS, \
                            MPFROMSHORT(ipos), MPVOID))
#define wScrollPosSet(hwnd, ipos) \
   ((BOOL)WinSendMsg((hwnd), SBM_SETPOS, MPFROMSHORT(ipos), MPVOID))


// SPIN BUTTON macros -------------------------------------------------------


// gets the value of a spinbutton (as LONG)
#define dSpinBtnLong(hwnd, id, pulValue) \
   ((BOOL)WinSendDlgItemMsg((hwnd), (id), SPBM_QUERYVALUE, \
                            (MPARAM)(pulValue), \
                            MPFROM2SHORT(0, SPBQ_ALWAYSUPDATE)))

#define wSpinBtnLong(hwnd, pulValue) \
   ((BOOL)WinSendMsg((hwnd), SPBM_QUERYVALUE, \
                     (MPARAM)(pulValue), MPFROM2SHORT(0, SPBQ_ALWAYSUPDATE)))


#define dSpinBtnSetArray(hwnd, id, aPsz, cPsz) \
   ((BOOL)WinSendDlgItemMsg((hwnd), (id), SPBM_SETARRAY, \
                            (MPARAM)(aPsz), (MPARAM)(cPsz)))
#define wSpinBtnSetArray(hwnd, aPsz, cPsz) \
   ((BOOL)WinSendMsg((hwnd), SPBM_SETARRAY, (MPARAM)(aPsz), (MPARAM)(cPsz)))

#define dSpinBtnSetValue(hwnd, id, value) \
   ((BOOL)WinSendDlgItemMsg((hwnd), (id), SPBM_SETCURRENTVALUE, \
                            (MPARAM)(value), MPVOID))
#define wSpinBtnSetValue(hwnd, value) \
   ((BOOL)WinSendMsg((hwnd), SPBM_SETCURRENTVALUE, (MPARAM)(value), MPVOID))

#define dSpinBtnSetLimits(hwnd, id, bottom, top) \
   ((BOOL)WinSendDlgItemMsg((hwnd), (id), SPBM_SETLIMITS, \
                            (MPARAM)(top), (MPARAM)(bottom)))
#define wSpinBtnSetLimits(hwnd, bottom, top) \
   ((BOOL)WinSendMsg((hwnd), SPBM_SETLIMITS, (MPARAM)(top), (MPARAM)(bottom)))


#endif // #ifndef _APIEX_PM_H_
