
/*
 * winh.h:
 *      header file for prfh.h, which
 *      contains those Presentation Manager helper functions
 *      which deal with Profile (Prf*) functions. These can be
 *      used w/out the rest of the XFolder source in any PM
 *      program.
 *      This file is new with V0.82.
 *
 *      Copyright (C) 1997-99 Ulrich Mller.
 *      This file is part of the XFolder source package.
 *      XFolder is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published
 *      by the Free Software Foundation, in version 2 as it comes in the
 *      "COPYING" file of the XFolder main distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#if __cplusplus
extern "C" {
#endif

#ifndef PRFH_HEADER_INCLUDED
    #define PRFH_HEADER_INCLUDED

    /*
     * prfhQueryKeysForApp:
     *      returns the keys list for an INI application. This
     *      list is copied into a newly allocated buffer, of which
     *      the address is returned.  You should free() this buffer
     *      when you're done. Returns NULL upon errors.
     */

    PSZ prfhQueryKeysForApp(HINI hIni,      // in: INI handle
                            PSZ pszApp);    // in: application to query

    /*
     * prfhCopyProfile:
     *      this function copies a given profile into a
     *      new file. hOld is the handle, pszOld the filename
     *      of the profile to be copied (e.g. HINI_USERPROFILE
     *      and "?:\OS2\OS2.INI"; pszNew must point to a
     *      buffer which will contain the new filename ending
     *      in ".XFL" after prfhCopyProfile returns
     *      (e.g. "?:\OS2\OS2.XFL").
     *      You may specify a Callback procedure which gets
     *      called upon every copied application in the INI
     *      file; this way, you can provide a progress bar.
     *      fncbError gets called upon errors.
     */

    BOOL prfhCopyProfile(HAB hab,               // in:  anchor block
                         HFILE hfLog,           // in:  logfile handle or NULLHANDLE for no log
                         HINI hOld,             // in:  HINI to copy
                         PSZ pszOld,            // in:  fully qualif. filename of hOld
                         PSZ pszNew,            // out: new filename
                         PFNWP fncbUpdate,      // in:  progress callback
                         HWND hwnd, ULONG msg, ULONG ulCount, ULONG ulMax,
                                                // in:  passed to fncbUpdate
                         PFNWP fncbError,       // in:  error callback
                         PULONG pulFunc2);      // in:  passed to fncbError

    /*
     * prfhSaveINIs:
     *      this will enforce saving of OS2.INI and OS2SYS.INI
     *      by calling prfhCopyProfile (above) on them; the therefrom
     *      resulting ".XFL" files will replace the original
     *      ".INI" files.
     *      Specify fncbUpdate and fncbError like in prfhCopyProfile.
     */

    APIRET prfhSaveINIs(HAB hab,                // in:  anchor block
                         HFILE hfLog,           // in:  logfile handle or NULLHANDLE for no log
                         PFNWP fncbUpdate,      // in:  progress callback
                         HWND hwnd, ULONG msg,  // in:  params passed to fncbUpdate
                         PFNWP fncbError,       // in:  error callback
                         PULONG pulFunc2);      // in:  passed to fncbError

    /*
     * prfhQueryColor:
     *      returns a system color in OS2.INI's PM_Colors as a LONG
     */

    LONG prfhQueryColor(PSZ pszKeyName, PSZ pszDefault);

#endif

#if __cplusplus
}
#endif

