
/*
 *@@sourcefile xfdesk.c:
 *      This file contains the following major XFolder parts:
 *
 *      --  XFldDesktop SOM stuff
 *
 *      Check the other files starting with xf* for the
 *      other XFolder classes.
 *
 *      XFldDesktop provides access to the eXtended
 *      shutdown feature by modifying popup menus and
 *      settings noteboks. Also, the Worker thread needs
 *      notifications when the Desktop has populated
 *      after startup.
 *
 *      This class must always be installed.
 *
 *@@somclass XFldDesktop xfdesk_
 *@@somclass M_XFldDesktop xfdeskM_
 */

/*
 *      Copyright (C) 1997-99 Ulrich Mller.
 *      This file is part of the XFolder source package.
 *      XFolder is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published
 *      by the Free Software Foundation, in version 2 as it comes in the
 *      "COPYING" file of the XFolder main distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

/*
 *  This file was generated by the SOM Compiler and Emitter Framework.
 *  Generated using:
 *      SOM Emitter emitctm: 2.41
 */

#ifndef SOM_Module_xfdesk_Source
#define SOM_Module_xfdesk_Source
#endif
#define XFldDesktop_Class_Source
#define M_XFldDesktop_Class_Source

/*
 *  Suggested #include order:
 *  1)  os2.h
 *  2)  C library headers
 *  3)  SOM headers which work with precompiled header files
 *  4)  headers in /helpers
 *  5)  headers in /main with dlgids.h and common.h first
 *  6)  #pragma hdrstop to prevent VAC++ crashes
 *  7)  other needed SOM headers
 *  8)  for non-SOM-class files: corresponding header (e.g. classlst.h)
 */

#define INCL_DOSSEMAPHORES      // needed for xthreads.h
#define INCL_DOSEXCEPTIONS
#define INCL_DOSERRORS

#define INCL_WINWINDOWMGR
#define INCL_WINFRAMEMGR        // WM_FORMATFRAME, SC_CLOSE etc.
#define INCL_WINPOINTERS

#define INCL_WINDIALOGS
#define INCL_WINSTATICS
#define INCL_WINMENUS           // needed for menus.h
#define INCL_WINENTRYFIELDS
#define INCL_WINBUTTONS
#define INCL_WINLISTBOXES
#define INCL_WINSTDBOOK         // notebooks
#define INCL_WINSTDSPIN         // spin buttons
#define INCL_WINSTDCNR          // needed for winh.h

#define INCL_WINSHELLDATA       // profile funcs

#include <os2.h>

// C library headers
#include <stdio.h>

// headers in /helpers
#include "dosh.h"               // Control Program helper routines
#include "winh.h"               // PM helper routines

#include "animate.h"            // icon and other animations

// SOM headers which don't crash with prec. header files
#include "xfdesk.ih"

// headers in /main
#include "dlgids.h"             // all the IDs that are shared with NLS
#include "common.h"             // the majestic XFolder include file

#include "apm.h"                // APM power-off for XShutdown
#include "notebook.h"           // generic XFolder notebook handling
#include "sound.h"              // declarations for SOUND.DLL
#include "xshutdwn.h"           // eXtended Shutdown
#include "xthreads.h"           // XFolder threads; this includes threads.h

// other SOM headers
#pragma hdrstop                 // VAC++ keeps crashing otherwise

/* ******************************************************************
 *                                                                  *
 *   Global variables                                               *
 *                                                                  *
 ********************************************************************/

SHUTDOWNPARAMS      sdParms = {0};

SHUTDOWNANIM        sdAnim = {0};

/* ******************************************************************
 *                                                                  *
 *   here come the XFldDesktop instance methods                     *
 *                                                                  *
 ********************************************************************/

/*
 * fnwpConfirm:
 *      dlg proc for XShutdown confirmation windows.
 */

MRESULT EXPENTRY fnwpConfirm(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    MRESULT mrc = MPNULL;
    switch (msg) {
         case WM_CONTROL: {
            if (SHORT1FROMMP(mp1) == ID_SDDI_REBOOT)
                winhEnableDlgItem(hwndDlg, ID_SDDI_BOOTMGR,
                        winhIsDlgItemChecked(hwndDlg, ID_SDDI_REBOOT));
            mrc = fnwpDlgGeneric(hwndDlg, msg, mp1, mp2);
        break; } //continue

        default:
            mrc = fnwpDlgGeneric(hwndDlg, msg, mp1, mp2);
    }
    return (mrc);
}

/*
 *@@ xsdConfirmShutdown:
 *      this displays the eXtended Shutdown (not Restart WPS)
 *      confirmation box. Returns MBID_YES/NO.
 */

ULONG xsdConfirmShutdown(VOID)
{
    ULONG       ulReturn;
    HWND        hwndConfirm;
    HMODULE     hmodResource = NLS_MODULE;
    CHAR        szDefault[100];
    ULONG       ulKeyLength;
    PSZ         p, pINI = NULL;
    PGLOBALSETTINGS pGlobalSettings = cmnQueryGlobalSettings();
    PTHREADGLOBALS pThreadGlobals = xthrQueryGlobals();

    pThreadGlobals->hSDIcon = WinLoadPointer(HWND_DESKTOP, hmodResource,
                    ID_SDICON);

    cmnSetHelpPanel(ID_XMH_XSHUTDOWN);
    hwndConfirm = WinLoadDlg(HWND_DESKTOP, NULLHANDLE,
                    fnwpConfirm,
                    hmodResource,
                    ID_SDD_CONFIRM,
                    NULL);

    WinPostMsg(hwndConfirm,
               WM_SETICON,
               (MPARAM)pThreadGlobals->hSDIcon,
                NULL);

    // prepare confirmation box items
    winhSetDlgItemChecked(hwndConfirm, ID_SDDI_REBOOT, sdParms.optReboot);
    winhSetDlgItemChecked(hwndConfirm, ID_SDDI_MESSAGEAGAIN, sdParms.optConfirm);
    winhEnableDlgItem(hwndConfirm, ID_SDDI_BOOTMGR, sdParms.optReboot);

    // insert ext reboot items into combo box;
    // first: "Default"
    WinLoadString(WinQueryAnchorBlock(HWND_DESKTOP),
            NLS_MODULE,
            ID_SDSI_DEFAULT,
            sizeof(szDefault)-1,
            szDefault);

    WinSendDlgItemMsg(hwndConfirm, ID_SDDI_BOOTMGR,
                    LM_INSERTITEM,
                    (MPARAM)LIT_END,
                    (MPARAM)szDefault);

    // now check for more items in OS2.INI
    if (PrfQueryProfileSize(HINI_USER,
                INIAPP_XFOLDER, INIKEY_BOOTMGR,
                &ulKeyLength))
    {
        // _Pmpf(( "Size: %d", ulKeyLength ));
        // items exist: evaluate
        pINI = malloc(ulKeyLength);
        if (pINI)
        {
            PrfQueryProfileData(HINI_USER,
                        INIAPP_XFOLDER, INIKEY_BOOTMGR,
                        pINI,
                        &ulKeyLength);
            p = pINI;
            // _Pmpf(( "%s", p ));
            while (strlen(p)) {
                WinSendDlgItemMsg(hwndConfirm, ID_SDDI_BOOTMGR,
                                LM_INSERTITEM,
                                (MPARAM)LIT_END,
                                (MPARAM)p);
                p += (strlen(p)+1);
                p += (strlen(p)+1);
            }
        }
        WinSendDlgItemMsg(hwndConfirm, ID_SDDI_BOOTMGR,
                        LM_SELECTITEM,
                        (MPARAM)pGlobalSettings->usLastRebootExt, // item index
                        (MPARAM)TRUE); // select (not deselect)

    } else {
        // no items found: disable
        WinSendDlgItemMsg(hwndConfirm, ID_SDDI_BOOTMGR,
                        LM_SELECTITEM,
                        (MPARAM)0, // item index
                        (MPARAM)TRUE); // select (not deselect)
        // winhEnableDlgItem(hwndConfirm, ID_SDDI_BOOTMGR, FALSE);
    }

    winhCenterWindow(hwndConfirm);

    xsdLoadAnimation(&sdAnim);
    anmPrepareAnimation(WinWindowFromID(hwndConfirm, ID_SDDI_ICON),
                    XSD_ANIM_COUNT,
                    &(sdAnim.ahptr[0]),
                    150,    // delay
                    TRUE);  // start now

    ulReturn = WinProcessDlg(hwndConfirm);

    anmStopAnimation(WinWindowFromID(hwndConfirm, ID_SDDI_ICON));
    xsdFreeAnimation(&sdAnim);

    if (ulReturn == DID_OK) {
        sdParms.optReboot = (winhIsDlgItemChecked(hwndConfirm, ID_SDDI_REBOOT));
        if (!(winhIsDlgItemChecked(hwndConfirm, ID_SDDI_MESSAGEAGAIN)))
        {
            pGlobalSettings->ulXShutdownFlags &= ~XSD_CONFIRM;
        }
        if (sdParms.optReboot) {
            USHORT usSelected = (USHORT)WinSendDlgItemMsg(hwndConfirm, ID_SDDI_BOOTMGR,
                    LM_QUERYSELECTION, (MPARAM)LIT_CURSOR, MPNULL);
            if (usSelected > 0) {
                USHORT us;
                p = pINI;
                for (us = 0; us < (usSelected-1); us++) {
                    p += (strlen(p)+1);
                    p += (strlen(p)+1);
                }
                p += (strlen(p)+1);
                strcpy(sdParms.szRebootCommand, p);
            }
            pGlobalSettings->usLastRebootExt = usSelected;
        }
        PrfWriteProfileData(HINI_USERPROFILE, INIAPP_XFOLDER, INIKEY_GLOBALSETTINGS,
             pGlobalSettings, sizeof(GLOBALSETTINGS));
    }

    if (pINI)
        free(pINI);

    WinDestroyWindow(hwndConfirm);

    return (ulReturn);
}

/*
 *@@ xsdConfirmRestartWPS:
 *      this displays the WPS restart
 *      confirmation box. Returns MBID_YES/NO.
 */

ULONG xsdConfirmRestartWPS(VOID)
{
    ULONG       ulReturn;
    HWND        hwndConfirm;
    HMODULE     hmodResource = NLS_MODULE;
    PGLOBALSETTINGS pGlobalSettings = cmnQueryGlobalSettings();

    HPOINTER hSDIcon = WinLoadPointer(HWND_DESKTOP, hmodResource,
                    ID_SDICON);

    cmnSetHelpPanel(ID_XMH_RESTARTWPS);
    hwndConfirm = WinLoadDlg(HWND_DESKTOP, NULLHANDLE,
                    fnwpConfirm,
                    hmodResource,
                    ID_SDD_CONFIRMWPS,
                    NULL);

    WinPostMsg(hwndConfirm,
               WM_SETICON,
               (MPARAM)hSDIcon,
                NULL);

    winhSetDlgItemChecked(hwndConfirm, ID_SDDI_WPS_CLOSEWINDOWS, sdParms.optWPSCloseWindows);
    winhSetDlgItemChecked(hwndConfirm, ID_SDDI_WPS_STARTUPFOLDER, sdParms.optWPSCloseWindows);
    winhSetDlgItemChecked(hwndConfirm, ID_SDDI_MESSAGEAGAIN, sdParms.optConfirm);
    winhCenterWindow(hwndConfirm);

    xsdLoadAnimation(&sdAnim);
    anmPrepareAnimation(WinWindowFromID(hwndConfirm, ID_SDDI_ICON),
                    XSD_ANIM_COUNT,
                    &(sdAnim.ahptr[0]),
                    150,    // delay
                    TRUE);  // start now

    // *** go!
    ulReturn = WinProcessDlg(hwndConfirm);

    anmStopAnimation(WinWindowFromID(hwndConfirm, ID_SDDI_ICON));
    xsdFreeAnimation(&sdAnim);

    if (ulReturn == DID_OK) {
        sdParms.optWPSCloseWindows =
                winhIsDlgItemChecked(hwndConfirm, ID_SDDI_WPS_CLOSEWINDOWS);
        if (sdParms.optWPSCloseWindows)
            pGlobalSettings->ulXShutdownFlags |= XSD_WPS_CLOSEWINDOWS;
        else
            pGlobalSettings->ulXShutdownFlags &= ~XSD_WPS_CLOSEWINDOWS;
        sdParms.optWPSReuseStartupFolder =
                winhIsDlgItemChecked(hwndConfirm, ID_SDDI_WPS_STARTUPFOLDER);
        if (!(winhIsDlgItemChecked(hwndConfirm, ID_SDDI_MESSAGEAGAIN)))
            pGlobalSettings->ulXShutdownFlags &= ~XSD_CONFIRM;
        PrfWriteProfileData(HINI_USERPROFILE, INIAPP_XFOLDER, INIKEY_GLOBALSETTINGS,
                 pGlobalSettings, sizeof(GLOBALSETTINGS));
    }

    WinDestroyWindow(hwndConfirm);

    return (ulReturn);
}

/*
 *@@ xfInitiateShutdown:
 *           Shutdown entry point; checks pGlobalSettings->XShutdown
 *           for all the XSD_* flags (shutdown options).
 *           If compiled with XFLDR_DEBUG defined (in common.h),
 *           debug mode will also be turned on if the SHIFT key is
 *           pressed at call time.
 *
 *           This routine will display a confirmation box,
 *           if the settings want it, and then start the
 *           main shutdown thread (xsd_fntShutdownThread),
 *           which will keep running even after shutdown
 *           is complete, unless the user presses the
 *           "Cancel shutdown" button.
 *
 *           Although this method does return almost
 *           immediately (after the confirmation dlg is dismissed),
 *           the shutdown will proceed in the separate thread.
 */

SOM_Scope BOOL  SOMLINK xfdesk_xfInitiateShutdown(XFldDesktop *somSelf)
{
    ULONG               ulSpooled = 0;
    PGLOBALSETTINGS     pGlobalSettings = cmnQueryGlobalSettings();
    PTHREADGLOBALS      pThreadGlobals = xthrQueryGlobals();

    // XFldDesktopData *somThis = XFldDesktopGetData(somSelf);
    XFldDesktopMethodDebug("XFldDesktop","xfdesk_xfInitiateShutdown");

    if (thrQueryID(pThreadGlobals->ptiShutdownThread))
        // shutdown thread already running: return!
        return FALSE;

    pThreadGlobals->fShutdownRunning = TRUE;

    sdParms.optReboot =  ((pGlobalSettings->ulXShutdownFlags & XSD_REBOOT) != 0);
    sdParms.optRestartWPS = FALSE;
    sdParms.optWPSCloseWindows = TRUE;
    sdParms.optWPSReuseStartupFolder = sdParms.optWPSCloseWindows;
    sdParms.optConfirm = ((pGlobalSettings->ulXShutdownFlags & XSD_CONFIRM) != 0);
    sdParms.optAutoCloseVIO = ((pGlobalSettings->ulXShutdownFlags & XSD_AUTOCLOSEVIO) != 0);
    sdParms.optLog = ((pGlobalSettings->ulXShutdownFlags & XSD_LOG) != 0);
    sdParms.optAnimate = ((pGlobalSettings->ulXShutdownFlags & XSD_ANIMATE) != 0);
    sdParms.optAPMPowerOff = (  ((pGlobalSettings->ulXShutdownFlags & XSD_APMPOWEROFF) != 0)
                      && (apmPowerOffSupported())
                     );

    #ifdef DEBUG_SHUTDOWN
        sdParms.optDebug = doshQueryShiftState();
    #else
        sdParms.optDebug = FALSE;
    #endif

    strcpy(sdParms.szRebootCommand, "");

    if (sdParms.optConfirm) {
        ULONG ulReturn = xsdConfirmShutdown();
        if (ulReturn != DID_OK) {
            pThreadGlobals->fShutdownRunning = FALSE;
            return FALSE;
        }
    }

    // check for pending spool jobs
    ulSpooled = winhQueryPendingSpoolJobs();
    if (ulSpooled) {
        // if we have any, issue a warning message and
        // allow the user to abort shutdown
        CHAR szTemp[20];
        PSZ pTable[1];
        sprintf(szTemp, "%d", ulSpooled);
        pTable[0] = szTemp;
        if (cmnMessageBoxMsgExt(HWND_DESKTOP, 114, pTable, 1, 115,
                        MB_YESNO | MB_DEFBUTTON2)
                    != MBID_YES)
        {
            pThreadGlobals->fShutdownRunning = FALSE;
            return (FALSE);
        }
    }

    // everything OK: create shutdown thread,
    // which will handle the rest
    thrCreate(&(pThreadGlobals->ptiShutdownThread),
                xsd_fntShutdownThread,
                (ULONG)&sdParms);
    xthrPlaySystemSound(MMSOUND_XFLD_SHUTDOWN);
    return TRUE;
}

/*
 *@@ xsdInitiateShutdownExt:
 *      just like the XFldDesktop method, but this one
 *      allows setting all the shutdown parameters by
 *      using the SHUTDOWNPARAMS structure. This is used
 *      for calling XShutdown externally, which is done
 *      by sending XOM_EXTERNALSHUTDOWN to the XFolder
 *      object window (see xfobj.c).
 *      NOTE: The memory block pointed to by psdp is
 *      not released by this function.
 */

BOOL xsdInitiateShutdownExt(PSHUTDOWNPARAMS psdp)
{
    PTHREADGLOBALS      pThreadGlobals = xthrQueryGlobals();

    if (thrQueryID(pThreadGlobals->ptiShutdownThread))
        // shutdown thread already running: return!
        return FALSE;

    if (psdp == NULL)
        return FALSE;

    pThreadGlobals->fShutdownRunning = TRUE;

    sdParms.optReboot =  psdp->optReboot;
    sdParms.optRestartWPS = psdp->optRestartWPS;
    sdParms.optWPSCloseWindows = psdp->optWPSCloseWindows;
    sdParms.optConfirm = psdp->optConfirm;
    sdParms.optAutoCloseVIO = psdp->optAutoCloseVIO;
    sdParms.optLog = psdp->optLog;
    sdParms.optAnimate = psdp->optAnimate;

    sdParms.optDebug = psdp->optDebug;

    strcpy(sdParms.szRebootCommand, psdp->szRebootCommand);

    if (sdParms.optConfirm) {
        ULONG ulReturn;
        if (sdParms.optRestartWPS)
            ulReturn = xsdConfirmRestartWPS();
        else
            ulReturn = xsdConfirmShutdown();

        if (ulReturn != DID_OK) {
            pThreadGlobals->fShutdownRunning = FALSE;
            return (FALSE);
        }
    }

    // everything OK: create shutdown thread,
    // which will handle the rest
    thrCreate(&(pThreadGlobals->ptiShutdownThread),
                xsd_fntShutdownThread,
                (ULONG)&sdParms);
    xthrPlaySystemSound(MMSOUND_XFLD_SHUTDOWN);
    return (TRUE);
}

/*
 *@@ xfRestartWPS:
 *           pretty similar to xfInitiateShutdown, i.e. will also
 *           show a confirmation box and start the Shutdown thread,
 *           except that flags are set differently so that after
 *           closing all windows, no shutdown is performed, but
 *           only the WPS is restarted.
 */

/*
 *@@ xfRestartWPS:
 *           pretty similar to XFldDesktop::xfInitiateShutdown, i.e.
 *           will also show a confirmation box and start the Shutdown
 *           thread, except that flags are set differently so that
 *           after closing all windows, no shutdown is performed, but
 *           only the WPS is restarted.
 */

SOM_Scope BOOL  SOMLINK xfdesk_xfRestartWPS(XFldDesktop *somSelf)
{
    PGLOBALSETTINGS     pGlobalSettings = cmnQueryGlobalSettings();
    PTHREADGLOBALS      pThreadGlobals = xthrQueryGlobals();

    // XFldDesktopData *somThis = XFldDesktopGetData(somSelf);
    XFldDesktopMethodDebug("XFldDesktop","xfdesk_xfRestartWPS");

    if (thrQueryID(pThreadGlobals->ptiShutdownThread))
        // shutdown thread already running: return!
        return FALSE;

    pThreadGlobals->fShutdownRunning = TRUE;

    sdParms.optReboot =  FALSE;
    sdParms.optRestartWPS = TRUE;
    sdParms.optWPSCloseWindows = ((pGlobalSettings->ulXShutdownFlags & XSD_WPS_CLOSEWINDOWS) != 0);
    sdParms.optWPSReuseStartupFolder = sdParms.optWPSCloseWindows;
    sdParms.optConfirm = ((pGlobalSettings->ulXShutdownFlags & XSD_CONFIRM) != 0);
    sdParms.optAutoCloseVIO = ((pGlobalSettings->ulXShutdownFlags & XSD_AUTOCLOSEVIO) != 0);
    sdParms.optLog =  ((pGlobalSettings->ulXShutdownFlags & XSD_LOG) != 0);
    #ifdef DEBUG_SHUTDOWN
        sdParms.optDebug = doshQueryShiftState();
    #else
        sdParms.optDebug = FALSE;
    #endif

    if (sdParms.optConfirm) {
        ULONG ulReturn = xsdConfirmRestartWPS();
        if (ulReturn != DID_OK) {
            pThreadGlobals->fShutdownRunning = FALSE;
            return (FALSE);
        }
    }

    // everything OK: create shutdown thread,
    // which will handle the rest
    thrCreate(&(pThreadGlobals->ptiShutdownThread),
                xsd_fntShutdownThread,
                (ULONG)&sdParms);
    xthrPlaySystemSound(MMSOUND_XFLD_RESTARTWPS);

    return (TRUE);
}

/*
 *@@ wpFilterPopupMenu:
 *           remove "Create another" for Desktop, because
 *           we don't want to allow creating another Desktop;
 *           for some reason, the "Create another" option
 *           doesn't seem to be working right with XFolder,
 *           so we need to add all this manually (see
 *           XFldObject::wpFilterPopupMenu)
 */

/*
 *@@ wpFilterPopupMenu:
 *           remove "Create another" for Desktop, because
 *           we don't want to allow creating another Desktop.
 *           For some reason, the "Create another" option
 *           doesn't seem to be working right with XFolder,
 *           so we need to add all this manually (see
 *           XFldObject::wpFilterPopupMenu).
 */

SOM_Scope ULONG  SOMLINK xfdesk_wpFilterPopupMenu(XFldDesktop *somSelf,
                                                  ULONG ulFlags,
                                                  HWND hwndCnr,
                                                  BOOL fMultiSelect)
{
    // XFldDesktopData *somThis = XFldDesktopGetData(somSelf);
    XFldDesktopMethodDebug("XFldDesktop","xfdesk_wpFilterPopupMenu");

    return (XFldDesktop_parent_WPDesktop_wpFilterPopupMenu(somSelf,
                                                           ulFlags,
                                                           hwndCnr,
                                                           fMultiSelect)
            & ~CTXT_CRANOTHER
        );
}

/*
 *@@ wpModifyPopupMenu:
 *           play with the Desktop menu entries
 *           (Shutdown and such)
 */

SOM_Scope BOOL  SOMLINK xfdesk_wpModifyPopupMenu(XFldDesktop *somSelf,
                                                    HWND hwndMenu,
                                                    HWND hwndCnr,
                                                    ULONG iPosition)
{
    BOOL rc;
    PGLOBALSETTINGS     pGlobalSettings = cmnQueryGlobalSettings();
    PTHREADGLOBALS      pThreadGlobals = xthrQueryGlobals();

    // XFldDesktopData *somThis = XFldDesktopGetData(somSelf);
    XFldDesktopMethodDebug("XFldDesktop","xfdesk_wpModifyPopupMenu");

    /* calling the parent (which is XFolder!) will insert all the
       variable menu items */
    rc = XFldDesktop_parent_WPDesktop_wpModifyPopupMenu(somSelf,
                                                           hwndMenu,
                                                           hwndCnr,
                                                           iPosition);

    if (_wpIsCurrentDesktop(somSelf))
    {
        if (pGlobalSettings->ulXShutdownFlags & XSD_RESTARTWPS) {
            // insert "Restart WPS"
            winhInsertMenuItem(hwndMenu,
                        (SHORT)WinSendMsg(hwndMenu,   // position
                                MM_ITEMPOSITIONFROMID,
                                MPFROM2SHORT(WPMENUID_SHUTDOWN, FALSE),
                                MPNULL) + 1,
                        (pGlobalSettings->VarMenuOffset + ID_XFMI_OFS_RESTARTWPS),
                        (cmnQueryNLSStrings())->pszRestartWPS,
                        MIS_TEXT,
                        (   (thrQueryID(pThreadGlobals->ptiShutdownThread)
                         || (pThreadGlobals->fShutdownRunning)
                        )
                            ? MIA_DISABLED
                            : 0));

            if ((pGlobalSettings->ulXShutdownFlags & XSD_CONFIRM) == 0)
                // if XShutdown confirmations have been disabled,
                // remove "..." from menu entry
                winhMenuRemoveEllipse(hwndMenu, (pGlobalSettings->VarMenuOffset + ID_XFMI_OFS_RESTARTWPS));
        }

        // remove default entries?
        if (pGlobalSettings->ulXShutdownFlags & XSD_DTM_LOCKUP)
            WinSendMsg(hwndMenu, MM_REMOVEITEM,
                MPFROM2SHORT(WPMENUID_LOCKUP, FALSE),
                MPNULL);
        if (pGlobalSettings->ulXShutdownFlags & XSD_DTM_SYSTEMSETUP)
            WinSendMsg(hwndMenu, MM_REMOVEITEM,
                MPFROM2SHORT(WPMENUID_SYSTEMSETUP, FALSE),
                MPNULL);

        if (pGlobalSettings->ulXShutdownFlags & XSD_DTM_SHUTDOWN)
            WinSendMsg(hwndMenu, MM_REMOVEITEM,
                MPFROM2SHORT(WPMENUID_SHUTDOWN, FALSE),
                MPNULL);
        else {
            // "Shutdown" entry:
            if (    (pThreadGlobals->fShutdownRunning)
                 || (thrQueryID(pThreadGlobals->ptiShutdownThread))
               )
            { // if XShutdown is already running,
              // disable "Shutdown" entry
                WinSendMsg(hwndMenu, MM_SETITEMATTR,
                        MPFROM2SHORT(WPMENUID_SHUTDOWN, FALSE),
                        MPFROM2SHORT(MIA_DISABLED, MIA_DISABLED));
            }
            if ((pGlobalSettings->ulXShutdownFlags & (XSD_CONFIRM | XSD_ENABLED))
                        == XSD_ENABLED)
                // if XShutdown confirmations have been disabled,
                // remove "..." from menu entry
                winhMenuRemoveEllipse(hwndMenu, WPMENUID_SHUTDOWN);
        }
    }

    return (rc);
}

/*
 *@@ wpMenuItemSelected:
 *           process input when any menu item was selected;
 *           intercept Shutdown and such
 */

SOM_Scope BOOL  SOMLINK xfdesk_wpMenuItemSelected(XFldDesktop *somSelf,
                                                     HWND hwndFrame,
                                                     ULONG ulMenuId)
{
    PGLOBALSETTINGS pGlobalSettings = cmnQueryGlobalSettings();
    PTHREADGLOBALS      pThreadGlobals = xthrQueryGlobals();

    // XFldDesktopData *somThis = XFldDesktopGetData(somSelf);
    XFldDesktopMethodDebug("XFldDesktop","xfdesk_wpMenuItemSelected");

    if (!(pThreadGlobals->fShutdownRunning))
    {
        if ((ulMenuId - (pGlobalSettings->VarMenuOffset)) == ID_XFMI_OFS_RESTARTWPS)
        {
            _xfRestartWPS(somSelf);
            return (TRUE);
        }
        else if (    (ulMenuId == WPMENUID_SHUTDOWN)
                 &&  ((pGlobalSettings->ulXShutdownFlags & XSD_ENABLED) != 0)
                 &&  (pGlobalSettings->NoWorkerThread == 0)
                )
        {
            _xfInitiateShutdown(somSelf);
            return (TRUE);
        }
    }

    return (XFldDesktop_parent_WPDesktop_wpMenuItemSelected(somSelf,
                                                            hwndFrame,
                                                            ulMenuId));
}

/*
 * fncbWPSDesktop1InitPage:
 *      notebook callback function (notebook.c) for the
 *      first "XDesktop" page in the Desktop's settings
 *      notebook.
 *      Sets the controls on the page according to the
 *      Global Settings.
 */

VOID fncbDesktop1InitPage(PVOID pnbi,   // notebook info struct
                         ULONG ulExtra)        // INIT_* flags (notebook.h)
{
    PCREATENOTEBOOKPAGE pcnbp = (PCREATENOTEBOOKPAGE)pnbi;
    PGLOBALSETTINGS pGlobalSettings = cmnQueryGlobalSettings();

    if (ulExtra & CBI_INIT)
    {
        CHAR szAPMVersion[30];
        sprintf(szAPMVersion, "APM %s", apmQueryVersion());
        WinSetDlgItemText(pcnbp->hwndPage, ID_XSDI_SD_APMVERSION, szAPMVersion);
    }

    if (ulExtra & CBI_SET)
    {
        winhSetDlgItemChecked(pcnbp->hwndPage, ID_XSDI_DTM_SYSTEMSETUP,
            (pGlobalSettings->ulXShutdownFlags & XSD_DTM_SYSTEMSETUP) == 0);
        winhSetDlgItemChecked(pcnbp->hwndPage, ID_XSDI_DTM_LOCKUP  ,
            (pGlobalSettings->ulXShutdownFlags & XSD_DTM_LOCKUP) == 0);
        winhSetDlgItemChecked(pcnbp->hwndPage, ID_XSDI_DTM_SHUTDOWN,
            (pGlobalSettings->ulXShutdownFlags & XSD_DTM_SHUTDOWN) == 0);

        winhSetDlgItemChecked(pcnbp->hwndPage, ID_XSDI_SD_RESTARTWPS,
            (pGlobalSettings->ulXShutdownFlags & XSD_RESTARTWPS) != 0);
        winhSetDlgItemChecked(pcnbp->hwndPage, ID_XSDI_SD_ENABLED,
            (pGlobalSettings->ulXShutdownFlags & XSD_ENABLED) != 0);
        winhSetDlgItemChecked(pcnbp->hwndPage, ID_XSDI_SD_REBOOT,
            (pGlobalSettings->ulXShutdownFlags & XSD_REBOOT) != 0);
        winhSetDlgItemChecked(pcnbp->hwndPage, ID_XSDI_SD_ANIMATE,
            (pGlobalSettings->ulXShutdownFlags & XSD_ANIMATE) != 0);
        winhSetDlgItemChecked(pcnbp->hwndPage, ID_XSDI_SD_APMPOWEROFF,
            (apmPowerOffSupported())
                ? ((pGlobalSettings->ulXShutdownFlags & XSD_APMPOWEROFF) != 0)
                : FALSE
            );
        winhSetDlgItemChecked(pcnbp->hwndPage, ID_XSDI_SD_CONFIRM,
            (pGlobalSettings->ulXShutdownFlags & XSD_CONFIRM) != 0);
        winhSetDlgItemChecked(pcnbp->hwndPage, ID_XSDI_SD_AUTOCLOSEVIO,
            (pGlobalSettings->ulXShutdownFlags & XSD_AUTOCLOSEVIO) != 0);
        winhSetDlgItemChecked(pcnbp->hwndPage, ID_XSDI_SD_LOG,
            (pGlobalSettings->ulXShutdownFlags & XSD_LOG) != 0);
    }

    if (ulExtra & CBI_ENABLE)
    {
        BOOL fXShutdownValid =
                (   ((pGlobalSettings->ulXShutdownFlags & XSD_DTM_SHUTDOWN) == 0)
                 && (pGlobalSettings->NoWorkerThread == 0)
                );
        BOOL fXShutdownEnabled =
                (   (fXShutdownValid)
                 && (pGlobalSettings->ulXShutdownFlags & XSD_ENABLED)
                );
        BOOL fXShutdownOrWPSValid =
                (   (   ((pGlobalSettings->ulXShutdownFlags & (XSD_DTM_SHUTDOWN | XSD_ENABLED)) == XSD_ENABLED)
                     || (pGlobalSettings->ulXShutdownFlags & XSD_RESTARTWPS)
                    )
                 && (pGlobalSettings->NoWorkerThread == 0)
                );

        winhEnableDlgItem(pcnbp->hwndPage, ID_XSDI_SD_ENABLED, fXShutdownValid);
        winhEnableDlgItem(pcnbp->hwndPage, ID_XSDI_SD_REBOOT,  fXShutdownEnabled);
        winhEnableDlgItem(pcnbp->hwndPage, ID_XSDI_SD_REBOOTEXT, fXShutdownEnabled);
        winhEnableDlgItem(pcnbp->hwndPage, ID_XSDI_SD_ANIMATE, fXShutdownEnabled);
        winhEnableDlgItem(pcnbp->hwndPage, ID_XSDI_SD_APMPOWEROFF,
                    ( fXShutdownEnabled && (apmPowerOffSupported()) )
                );

        winhEnableDlgItem(pcnbp->hwndPage, ID_XSDI_SD_CONFIRM, fXShutdownOrWPSValid);
        winhEnableDlgItem(pcnbp->hwndPage, ID_XSDI_SD_AUTOCLOSEVIO, fXShutdownOrWPSValid);
        winhEnableDlgItem(pcnbp->hwndPage, ID_XSDI_SD_AUTOCLOSEDETAILS, fXShutdownOrWPSValid);
        winhEnableDlgItem(pcnbp->hwndPage, ID_XSDI_SD_LOG, fXShutdownOrWPSValid);
    }
}

/*
 * fncbDesktop1ItemChanged:
 *      notebook callback function (notebook.c) for the
 *      first "XDesktop" page in the Desktop's settings
 *      notebook.
 *      Reacts to changes of any of the dialog controls.
 */

MRESULT fncbDesktop1ItemChanged(PVOID pnbi,
                USHORT usItemID, USHORT usNotifyCode,
                ULONG ulExtra)      // for checkboxes: contains new state
{
    PCREATENOTEBOOKPAGE pcnbp = (PCREATENOTEBOOKPAGE)pnbi;
    PGLOBALSETTINGS pGlobalSettings = cmnQueryGlobalSettings();
    ULONG ulChange = 1;
    ULONG ulFlag = -1;

    LONG lTemp;

    switch (usItemID) {
        case ID_XSDI_DTM_SYSTEMSETUP:
            if (ulExtra)
                pGlobalSettings->ulXShutdownFlags &= ~XSD_DTM_SYSTEMSETUP;
            else
                pGlobalSettings->ulXShutdownFlags |= XSD_DTM_SYSTEMSETUP;
        break;

        case ID_XSDI_DTM_LOCKUP:
            if (ulExtra)
                pGlobalSettings->ulXShutdownFlags &= ~XSD_DTM_LOCKUP;
            else
                pGlobalSettings->ulXShutdownFlags |= XSD_DTM_LOCKUP;
        break;

        case ID_XSDI_DTM_SHUTDOWN:
            if (ulExtra)
                pGlobalSettings->ulXShutdownFlags &= ~XSD_DTM_SHUTDOWN;
            else
                pGlobalSettings->ulXShutdownFlags |= XSD_DTM_SHUTDOWN;
        break;

        case ID_XSDI_SD_RESTARTWPS:
            ulFlag = XSD_RESTARTWPS;
        break;

        case ID_XSDI_SD_ENABLED:
            ulFlag = XSD_ENABLED;
        break;

        case ID_XSDI_SD_REBOOT:
            ulFlag = XSD_REBOOT;
        break;

        case ID_XSDI_SD_ANIMATE:
            ulFlag = XSD_ANIMATE;
        break;

        case ID_XSDI_SD_APMPOWEROFF:
            ulFlag = XSD_APMPOWEROFF;
        break;

        case ID_XSDI_SD_CONFIRM:
            ulFlag = XSD_CONFIRM;
        break;

        case ID_XSDI_SD_AUTOCLOSEVIO:
            ulFlag = XSD_AUTOCLOSEVIO;
        break;

        case ID_XSDI_SD_LOG:
            ulFlag = XSD_LOG;
        break;

        // Reboot Actions (Desktop page 1)
        case ID_XSDI_SD_REBOOTEXT:
            cmnSetHelpPanel(ID_XFH_REBOOTEXT);
            WinDlgBox(HWND_DESKTOP,         // parent is desktop
                  pcnbp->hwndPage,                  // owner
                  (PFNWP)fnwpRebootExt,     // dialog procedure
                  NLS_MODULE,
                  ID_XSD_REBOOTEXT,        // dialog resource id
                  (PVOID)NULL);            // no dialog parameters
            ulChange = 0;
        break;

        // Auto-close details (Desktop page 1)
        case ID_XSDI_SD_AUTOCLOSEDETAILS:
            cmnSetHelpPanel(ID_XFH_AUTOCLOSEDETAILS);
            WinDlgBox(HWND_DESKTOP,         // parent is desktop
                  pcnbp->hwndPage,             // owner
                  (PFNWP)fnwpAutoCloseDetails,    // dialog procedure
                  NLS_MODULE,  // from resource file
                  ID_XSD_AUTOCLOSE,        // dialog resource id
                  (PVOID)NULL);            // no dialog parameters
            ulChange = 0;
        break;

        default:
            ulChange = 0;
    }

    if (ulFlag != -1)
        if (ulExtra)
            pGlobalSettings->ulXShutdownFlags |= ulFlag;
        else
            pGlobalSettings->ulXShutdownFlags &= ~ulFlag;

    if (ulChange) {
        // enable/disable items
        fncbDesktop1InitPage(pnbi, CBI_ENABLE);
        cmnStoreGlobalSettings();
    }

    return ((MPARAM)-1);
}

/*
 * fncbWPSDesktop2InitPage:
 *      notebook callback function (notebook.c) for the
 *      second "XDesktop" page in the Desktop's settings
 *      notebook.
 *      Sets the controls on the page according to the
 *      Global Settings.
 */

VOID fncbDesktop2InitPage(PVOID pnbi,   // notebook info struct
                         ULONG ulExtra)        // INIT_* flags (notebook.h)
{
    PCREATENOTEBOOKPAGE pcnbp = (PCREATENOTEBOOKPAGE)pnbi;
    PGLOBALSETTINGS pGlobalSettings = cmnQueryGlobalSettings();

    if (ulExtra & CBI_SET)
    {
        winhSetDlgItemChecked(pcnbp->hwndPage, ID_XSDI_SD_SHOWSTARTUPPROGRESS,
            pGlobalSettings->ShowStartupProgress);
        winhSetDlgItemSpinData(pcnbp->hwndPage, ID_XSDI_SD_STARTUPDELAY, 500, 10000, pGlobalSettings->ulStartupDelay);
    }

    if (ulExtra & CBI_ENABLE)
    {
        BOOL fEnable = (   (pGlobalSettings->NoWorkerThread == 0)
                        && (pGlobalSettings->NoSubclassing == 0)
                       );

        if (WinQueryObject(XFOLDER_STARTUPID))
            winhEnableDlgItem(pcnbp->hwndPage, ID_XSDI_SD_CREATESTARTUPFLDR, FALSE);
        if (WinQueryObject(XFOLDER_SHUTDOWNID))
            winhEnableDlgItem(pcnbp->hwndPage, ID_XSDI_SD_CREATESHUTDOWNFLDR, FALSE);

        winhEnableDlgItem(pcnbp->hwndPage, ID_XSDI_SD_SHOWSTARTUPPROGRESS, fEnable);
        winhEnableDlgItem(pcnbp->hwndPage, ID_XSDI_SD_STARTUPDELAY, fEnable);
    }
}

/*
 * fncbDesktop2ItemChanged:
 *      notebook callback function (notebook.c) for the
 *      second "XDesktop" page in the Desktop's settings
 *      notebook.
 *      Reacts to changes of any of the dialog controls.
 */

MRESULT fncbDesktop2ItemChanged(PVOID pnbi,
                USHORT usItemID, USHORT usNotifyCode,
                ULONG ulExtra)      // for checkboxes: contains new state
{
    PCREATENOTEBOOKPAGE pcnbp = (PCREATENOTEBOOKPAGE)pnbi;
    PGLOBALSETTINGS pGlobalSettings = cmnQueryGlobalSettings();
    ULONG   ulChange = 1;

    CHAR    szSetup[200];
    LONG    lTemp;
    HOBJECT hObj;
    MRESULT mrc = (MRESULT)-1;

    switch (usItemID) {

        case ID_XSDI_SD_SHOWSTARTUPPROGRESS:
            pGlobalSettings->ShowStartupProgress = ulExtra;
        break;

        case ID_XSDI_SD_STARTUPDELAY:
            pGlobalSettings->ulStartupDelay = winhAdjustDlgItemSpinData(
                                    pcnbp->hwndPage, usItemID,
                                    250, usNotifyCode);
        break;

        // "Create startup folder" (Desktop page 2)
        case ID_XSDI_SD_CREATESTARTUPFLDR:
            sprintf(szSetup,
                "DEFAULTVIEW=ICON;ICONVIEW=NONFLOWED,MINI;"
                "OBJECTID=%s;",
                XFOLDER_STARTUPID);
            if (hObj = WinCreateObject("XFldStartup", "XFolder Startup",
                    szSetup,
                    "<WP_DESKTOP>",
                    CO_UPDATEIFEXISTS))
                winhEnableDlgItem(pcnbp->hwndPage, ID_XSDI_SD_CREATESTARTUPFLDR, FALSE);
            else
                cmnMessageBoxMsg(pcnbp->hwndPage, 104, 105, MB_OK);
            ulChange = 0;
        break;

        // "Create shutdown folder" (Desktop page 2)
        case ID_XSDI_SD_CREATESHUTDOWNFLDR:
            // cmnQueryXFolderPath(szPath, sizeof(szPath));
            sprintf(szSetup,
                "DEFAULTVIEW=ICON;ICONVIEW=NONFLOWED,MINI;"
                // "ICONFILE=%s\\xfshut1.ico;ICONNFILE=1,%s\\xfshut2.ico;"
                "OBJECTID=%s;",
                XFOLDER_SHUTDOWNID);
            if (hObj = WinCreateObject("XFldShutdown", "XFolder Shutdown",
                    szSetup,
                    "<WP_DESKTOP>",
                    CO_UPDATEIFEXISTS))
                winhEnableDlgItem(pcnbp->hwndPage, ID_XSDI_SD_CREATESHUTDOWNFLDR, FALSE);
            else
                cmnMessageBoxMsg(pcnbp->hwndPage, 104, 106, MB_OK);
            ulChange = 0;
        break;

        default:
            ulChange = 0;
    }

    if (ulChange) {
        // enable/disable items
        cmnStoreGlobalSettings();
    }

    return (mrc);
}

/*
 *@@ wpAddSettingsPages:
 *           insert "XFldDesktop" settings page into notebook; as opposed
 *           to the "XFolder" page, which deals with instance data, we save
 *           these settings in the GlobalSettings structure, because there
 *           should ever be only one desktop
 */

/*
 *@@ wpAddSettingsPages:
 *           insert "XFldDesktop" settings page into notebook; as opposed
 *           to the "XFolder" page, which deals with instance data, we save
 *           these settings in the GlobalSettings structure, because there
 *           should ever be only one active Desktop.
 */

SOM_Scope BOOL  SOMLINK xfdesk_wpAddSettingsPages(XFldDesktop *somSelf,
                                                     HWND hwndNotebook)
{
    BOOL            rc;

    // XFldDesktopData *somThis = XFldDesktopGetData(somSelf);
    XFldDesktopMethodDebug("XFldDesktop","xfdesk_wpAddSettingsPages");

    rc = (XFldDesktop_parent_WPDesktop_wpAddSettingsPages(somSelf,
                                                            hwndNotebook));
    if (_wpIsCurrentDesktop(somSelf))
    {
        PSZ pszHelpLibrary = cmnQueryHelpLibrary();
        PCREATENOTEBOOKPAGE pcnbp;

        // insert Shutdown settings page 2
        pcnbp = malloc(sizeof(CREATENOTEBOOKPAGE));
        memset(pcnbp, 0, sizeof(CREATENOTEBOOKPAGE));
        pcnbp->somSelf = somSelf;
        pcnbp->hwndNotebook = hwndNotebook;
        pcnbp->hmod = NLS_MODULE;
        pcnbp->fEnumerate = TRUE;
        pcnbp->pszName = "~XDesktop";
        pcnbp->ulDlgID = ID_XSD_SETTINGS_DTP2;
        pcnbp->ulDefaultHelpPanel  = ID_XSH_SETTINGS_DTP1+1;
        pcnbp->ulPageID = SP_DTP2;
        pcnbp->pfncbInitPage    = fncbDesktop2InitPage;
        pcnbp->pfncbItemChanged = fncbDesktop2ItemChanged;
        ntbInsertPage(pcnbp);

        // insert Shutdown settings page 1
        pcnbp = malloc(sizeof(CREATENOTEBOOKPAGE));
        memset(pcnbp, 0, sizeof(CREATENOTEBOOKPAGE));
        pcnbp->somSelf = somSelf;
        pcnbp->hwndNotebook = hwndNotebook;
        pcnbp->hmod = NLS_MODULE;
        pcnbp->fMajorTab = TRUE;
        pcnbp->fEnumerate = TRUE;
        pcnbp->pszName = "~XDesktop";
        pcnbp->ulDlgID = ID_XSD_SETTINGS_DTP1;
        pcnbp->ulDefaultHelpPanel  = ID_XSH_SETTINGS_DTP1;
        pcnbp->ulPageID = SP_DTP1;
        pcnbp->pfncbInitPage    = fncbDesktop1InitPage;
        pcnbp->pfncbItemChanged = fncbDesktop1ItemChanged;
        ntbInsertPage(pcnbp);
    }
    return (rc);
}

/*
 *@@ wpOpen:
 *           after the Desktop is opened, we begin the the startup process,
 *           so we need to give a signal to the Worker thread
 */

/*
 *@@ wpOpen:
 *           after the Desktop is opened, we need to begin processing the
 *           startup folder, so we need to post a message to the
 *           Worker thread, which will then take over.
 */

SOM_Scope HWND  SOMLINK xfdesk_wpOpen(XFldDesktop *somSelf,
                                         HWND hwndCnr, ULONG ulView,
                                         ULONG param)
{
    HWND hwnd;
    XFldDesktopData *somThis = XFldDesktopGetData(somSelf);
    XFldDesktopMethodDebug("XFldDesktop","xfdesk_wpOpen");

    hwnd = XFldDesktop_parent_WPDesktop_wpOpen(somSelf, hwndCnr,
                                                ulView, param);
    if (!_DesktopOpen)
        if (_wpIsCurrentDesktop(somSelf)) {
            _DesktopOpen = TRUE;
            xthrPostWorkerMsg(WOM_DESKTOPREADY, (MPARAM)somSelf, MPNULL);
            // the worker thread will now loop until the Desktop
            // is populated also
        }

    return (hwnd);
}

/*
 *@@ wpInitData:
 *           initialize XFldDesktop instance data
 */

/*
 *@@ wpInitData:
 *           initialize XFldDesktop instance data.
 */

SOM_Scope void  SOMLINK xfdesk_wpInitData(XFldDesktop *somSelf)
{
    XFldDesktopData *somThis = XFldDesktopGetData(somSelf);
    XFldDesktopMethodDebug("XFldDesktop","xfdesk_wpInitData");

    _DesktopOpen = FALSE;

    XFldDesktop_parent_WPDesktop_wpInitData(somSelf);
}

/*
 *@@ wpclsInitData:
 *           initialize XFldDesktop class data
 */

SOM_Scope void  SOMLINK xfdeskM_wpclsInitData(M_XFldDesktop *somSelf)
{
    // M_XFldDesktopData *somThis = M_XFldDesktopGetData(somSelf);
    M_XFldDesktopMethodDebug("M_XFldDesktop","xfdeskM_wpclsInitData");

    M_XFldDesktop_parent_M_WPDesktop_wpclsInitData(somSelf);
}

/*
 *@@ wpclsQuerySettingsPageSize:
 *           this WPObject class method should return the
 *           size of the largest settings page in dialog
 *           units; if a settings notebook is initially
 *           opened, i.e. no window pos has been stored
 *           yet, the WPS will use this size, to avoid
 *           truncated settings pages.
 */

SOM_Scope BOOL  SOMLINK xfdeskM_wpclsQuerySettingsPageSize(M_XFldDesktop *somSelf,
                                                           PSIZEL pSizl)
{
    BOOL brc;
    /* M_XFldDesktopData *somThis = M_XFldDesktopGetData(somSelf); */
    M_XFldDesktopMethodDebug("M_XFldDesktop","xfdeskM_wpclsQuerySettingsPageSize");

    brc = M_XFldDesktop_parent_M_WPDesktop_wpclsQuerySettingsPageSize(somSelf,
                                                                        pSizl);
    if (brc) {
        LONG lCompCY = 153;
        if (doshIsWarp4())
            // on Warp 4, reduce again, because we're moving
            // the notebook buttons to the bottom
            lCompCY -= WARP4_NOTEBOOK_OFFSET;

        if (pSizl->cy < lCompCY)
            pSizl->cy = lCompCY;  // this is the height of the "XDesktop" page,
                                // which is pretty large
        if (pSizl->cx < 260)
            pSizl->cx = 260;    // and the width

    }
    return (brc);
}

/*
 *@@ wpclsQueryIconData:
 *           give XFldDesktop's a new default closed icon, if the
 *           global settings allow this.
 *           This is loaded from /ICONS/ICONS.DLL.
 */

SOM_Scope ULONG  SOMLINK xfdeskM_wpclsQueryIconData(M_XFldDesktop *somSelf,
                                                    PICONINFO pIconInfo)
{
    ULONG ulrc;
    PGLOBALSETTINGS pGlobalSettings = cmnQueryGlobalSettings();
    // M_XFldDesktopData *somThis = M_XFldDesktopGetData(somSelf);
    M_XFldDesktopMethodDebug("M_XFldDesktop","xfdeskM_wpclsQueryIconData");

    if (pGlobalSettings->ReplIcons)
    {
        // icon replacements allowed:
        if (pIconInfo) {
            pIconInfo->fFormat = ICON_RESOURCE;
            pIconInfo->hmod = cmnQueryIconsDLL();
            pIconInfo->resid = 110;
        }
        ulrc = sizeof(ICONINFO);
    }
    else
        // icon replacements not allowed: call default
        ulrc = M_XFldDesktop_parent_M_WPDesktop_wpclsQueryIconData(somSelf,
                                                                pIconInfo);
    return (ulrc);
}

/*
 *@@ wpclsQueryIconDataN:
 *           give XFldDesktop's a new open closed icon, if the
 *           global settings allow this.
 *           This is loaded from /ICONS/ICONS.DLL.
 */

SOM_Scope ULONG  SOMLINK xfdeskM_wpclsQueryIconDataN(M_XFldDesktop *somSelf,
                                                     ICONINFO* pIconInfo,
                                                     ULONG ulIconIndex)
{
    ULONG ulrc;
    PGLOBALSETTINGS pGlobalSettings = cmnQueryGlobalSettings();
    // M_XFldDesktopData *somThis = M_XFldDesktopGetData(somSelf);
    M_XFldDesktopMethodDebug("M_XFldDesktop","xfdeskM_wpclsQueryIconDataN");

    if (pGlobalSettings->ReplIcons)
    {
        // icon replacements allowed:
        if (pIconInfo) {
            pIconInfo->fFormat = ICON_RESOURCE;
            pIconInfo->hmod = cmnQueryIconsDLL();
            pIconInfo->resid = 111;
        }
        ulrc = sizeof(ICONINFO);
    }
    else
        // icon replacements not allowed: call default
        ulrc = M_XFldDesktop_parent_M_WPDesktop_wpclsQueryIconDataN(somSelf,
                                                                 pIconInfo,
                                                                 ulIconIndex);
    return (ulrc);
}

