/*
 * treesize.h:
 *      header file for treesize.h.
 *
 *      Copyright (C) 1997-98 Ulrich Mller.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of the XFolder main distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#define SV_SIZE             1
#define SV_EASIZE           2
#define SV_NAME             3

#define SD_BYTES            1
#define SD_KBYTES           2
#define SD_MBYTES           3

typedef struct _DIRINFO {
    struct _DIRINFO     *pParent;
    CHAR                szFullPath[CCHMAXPATH]; // "F:\OS2"
    CHAR                szThis[CCHMAXPATH];     // "OS2"
    CHAR                szRecordText[CCHMAXPATH+50];          // what appears in the cnr
    double              dTotalSize;
    double              dTotalEASize;
    ULONG               ulRecursionLevel;       // 1 for root level
    PRECORDCORE         precc;      // PSIZERECORDCORE actually
} DIRINFO, *PDIRINFO;

/* extended RECORDCORE structure */
typedef struct _SIZERECORDCORE {
    RECORDCORE     recc;
    PDIRINFO       pdi;
    BOOL           fDisplayValid;        // TRUE only if display is valid
} SIZERECORDCORE, *PSIZERECORDCORE;

#define ID_TSD_MAIN         200
#define ID_TSDI_CNR         201
#define ID_TSDI_TEXT1       202
#define ID_TSDI_ICON        203
#define DID_CLEAR           204

#define ID_TSD_PRODINFO     250

#define ID_TSM_CONTEXT      300
#define ID_TSM_SORT         301
#define ID_TSMI_SORTBYNAME  302
#define ID_TSMI_SORTBYSIZE  303
#define ID_TSMI_SORTBYEASIZE 304
#define ID_TSMI_COLLECTEAS  305
#define ID_TSMI_LOWPRTY     306
#define ID_TSM_SIZES        310
#define ID_TSMI_SIZE_BYTES  311
#define ID_TSMI_SIZE_KBYTES 312
#define ID_TSMI_SIZE_MBYTES 313

#define ID_TSMI_PRODINFO    320

#define ID_ICON             1000

#define WM_START            WM_USER
#define WM_BEGINDIRECTORY   WM_USER+1
#define WM_DONEDIRECTORY    WM_USER+2
#define WM_DONEWITHALL      WM_USER+3



