/* WPWEATHER v0.4  (c) Frank Wochatz  mail@subsys.de */
/* +++++++ nachfolgende Zeilen anpassen ! +++++++ */

WeatherURL.0 = 3 /* Anzahl der Wetter-URLs  (1, 2 oder 3) */
WeatherURL.1 = ""
WeatherURL.2 = ""
WeatherURL.3 = ""

/* Achtung: URLs mssen in Anfhrungszeichen stehen! */ 

WeatherLOG = "1" /* 1=weather log on, 0 = weather log off */
/* ++++++++++++++++++++++++++++++++++++++++++++++++ */


parse source . . ScriptFile
inst_drive = filespec("D", ScriptFile)
inst_path = filespec("P", scriptfile)
installpath=inst_drive||inst_path
iconpath=inst_drive||inst_path||'ICONS\'
le='0d0a'x


/* init RexxUtil */
if rxfuncquery('SysLoadFuncs') then do
 call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
 call SysLoadFuncs
end


do w=1 to WeatherURL.0


input_file=installpath||"weather"||w||".dat"
weather_log_file=installpath||"weather"||w||".log"
object_id="<WP_WEATHER"||w||">"

rc=GetWeatherData(WeatherURL.w, input_file)

i = 0

in_string=charin(input_file,1,4096)
rc=ParseHtml(in_string)
ObjectText=BuildObjectText()

weathericon=iconpath||GetIconFile(in_string)

/* create or upgrade object */
call SysCreateObject 'WPProgram',objecttext,'<WP_DESKTOP>','OBJECTID='||object_id||';EXENAME='||ScriptFile||';TITLE='||ObjectText||';ICONFILE='||weathericon||';','Update'

if WeatherLOG = 1 then call WriteLog(ObjectText)

end

exit


ParseHtml: PROCEDURE EXPOSE i string.
parse arg sub_in_string

parse var sub_in_string dummy '>' sub_in_string

sub_in_string=strip(sub_in_string)

if sub_in_string = "" then return(0)

first_sub_in_string=left(sub_in_string,1)

if first_sub_in_string \= '<' & first_sub_in_string \= '.' & first_sub_in_string \= "'" then do
        i = i+1
        parse var sub_in_string string.i '<' sub_in_string
/* say "->" string.i  ------ for debugging only */
        end
string = ParseHtml(sub_in_string)
return(0)


BuildObjectText: PROCEDURE EXPOSE i string. le

ObjectText = string.1||le||,
string.2||le||,
string.3||le||,
string.4 string.5||le||,
string.6 string.7||le||,
string.8 string.9

ObjectText = PC2ISO(ObjectText, 850)
ObjectText = HTML2TXT(ObjectText)

return(ObjectText)

HTML2TXT: Procedure
parse arg string

string=StrRepl(string, '&Ouml;', '')
string=StrRepl(string, '&ouml;', '')
string=StrRepl(string, '&Uuml;', '')
string=StrRepl(string, '&uuml;', '')
string=StrRepl(string, '&Auml;', '')
string=StrRepl(string, '&auml;', '')
string=StrRepl(string, '&szlig;', '')
string=StrRepl(string, '&deg;', '')

return(string)





RETURN string

PC2ISO: Procedure

  PARSE ARG thisString, outp

  do

  aISO = 'a1 a2 a3 bf c0 c1 c2 c3 c4 c5 c6 c7 c8 c9 ca cb cc cd ce cf d0',
         'd1 d2 d3 d4 d5 d6 d8 d9 da db dc dd de df e0 e1 e2 e3 e4 e5 e6',
         'e7 e8 e9 ea eb ec ed ee ef f0 f1 f2 f3 f4 f5 f6 f8 f9 fa fb fc',
         'fd fe ff'

  aPC =  'ad bd 9c a8 b7 b5 b6 c7 8e 8f 92 80 d4 90 d2 d3 de d6 d7 d8 d1',
         'a5 d2 d3 d4 e5 99 d8 eb e9 ea 9a ed e8 e1 85 a0 83 c6 84 86 91',
         '87 8a 82 88 89 8d a1 8c 8b d0 a4 95 a2 93 e4 94 9b 97 a3 96 81',
         'ec e7 98'

  if outp = 1004 then
    string = Translate(thisString, x2c(aISO), x2c(aPC))
  else
    if outp = 850 then
    string = Translate(thisString, X2C(aPC), X2C(aISO))
   end
RETURN string

GetIconFile: procedure
parse arg string
parse var string substring '.gif' dummy

substring=strip(substring, 'T', "b")
substring=strip(substring, 'T', "s")
substring=strip(substring, 'T', "_")

iconfile = filespec('N', substring) || '.ico'
RETURN iconfile


GetWeatherData:
parse arg WeatherURL, input_file
'WGET' WeatherURL '-O' input_file
return(0)


WriteLog: procedure expose weather_log_file ObjectText le
call Charout weather_log_file, '------------------------------------------'||le||date('O')||'-'||time('N')||le||ObjectText||le
call Charout weather_log_file /* close file */
return(0)


StrRepl: Procedure
Parse Arg _string, _origin, _replStr

/*---( Find a substring to replace? )---*/
_lastPos = LastPos( _origin, _string )


If _lastPos > 0 Then Do

  /*---( Get prefix to the substring )---*/
  If _lastPos = 1 Then _prefix = ''
  Else _prefix = SubStr( _string, 1, _lastPos - 1 )

  /*---( Get suffix of the substring )---*/
  _suffix = SubStr( _string, _lastPos + Length( _origin ))

  /*---( Find next substring to replace )---*/
  Return StrRepl( _prefix, _origin, _replStr ) || _replStr || _suffix

End
Else
  Return _string
