/**/


 call RxFuncAdd    'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
 call SysLoadFuncs

 rc         = 0;

 IniAppname =    'Wireless LAN Monitor:Properties';
 OptionList =    'Debug_TCPIPConfig',               /* configure TCP/IP        */
                 'Debug_DriverAccess',              /* access DIM modules      */
                 'Debug_EnableNetworkSelection',    /* enables profile page    */
                 'Debug_Dialog',                    /* enable dialog messages  */

 Unused =        'Debug_DHCPRejectOptions',         /* enables DHCP workaround */

 fShow      = 0;
 fDebug     = 0;
 OptNum     = 0;


 DO 1

    /* check parms */
    ARG Parms;
    Parms = STRIP( Parms);
    IF (Parms = '') THEN
       fShow = 1;

    DO WHILE (Parms \= '')
       PARSE VAR Parms ThisParm Parms;
       ThisParm = STRIP( ThisParm);
       SELECT
          WHEN (DATATYPE( ThisParm) = 'NUM') THEN OptNum = ThisParm;
          WHEN (ThisParm = 'ON')  THEN fDebug = 1;
          WHEN (ThisParm = 'OFF') THEN fDebug = 0;
          OTHERWISE                    NOP;
       END;
    END;

    /* check parms */
    IF (OptNum > 0) THEN
    DO
       IF (OptNum > WORDS( OptionList)) THEN
       DO
          SAY 'error: invalid option number.';
          rc = 87; /* ERROR_INVALID_PARAMETER */
       END;
       OptionList = WORD( OptionList, OptNum);
    END;

    /* ----- */

    IF (\fShow) THEN
    DO
       CALL CHAROUT, 'turning debug ';
       IF (fDebug) THEN
          SAY 'on.';
       ELSE
          SAY 'off.';
    END;

    /* ----- */

    WorkCount = 0;
    DO WHILE (OptionList \= '')
       PARSE VAR OptionList ThisKey OptionList;

       WorkCount = WorkCount + 1;
       IF (OptNum > 0) THEN
          CALL CHAROUT, '- '
       ELSE
          CALL CHAROUT, WorkCount' '

       IF (fShow) THEN
       DO
          CALL CHAROUT, ThisKey ': ';
          PARSE VALUE SysIni(, IniAppname, ThisKey) WITH ThisValue'0'x;
          IF (ThisValue = 'ERROR:') THEN
             SAY 0;
          ELSE
             SAY ThisValue;
       END;
       ELSE
       DO
          SAY ThisKey;

          IF (fDebug) THEN
             DebugValue = fDebug'0'x
          else
             DebugValue = 'DELETE:';
          rcx = SysIni(, IniAppname, ThisKey, DebugValue);
       END;
    END;

 END;

 RETURN( rc);

