/* ͻ
 Dit REXX-script kijkt naar aanwezige (tijdelijke)Word-bestanden,             
                 start MicroSoft Word 6.0 voor 16 bits OS en                  
                 maakt nieuwe (tijdelijke) bestanden,                         
                 met gebruik making van de lange bestandsnamen.               
                                                                              
 gemaakt:     11-04-2004, door EfZet                                          
 gewijzigd:   03-06-2004.                                                     
 gewijzigd:   03-04-2017, Word 6 (en 97-compatible), 1 bestand, geen WordView 
 */

CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'          /* RexxUtil laden */
CALL SysLoadFuncs                                                  /* functies starten */
CALL RxFuncAdd 'RxExtra', 'RxExtras', 'RxExtra'                    /* RexxUtil laden */
CALL RxExtra("Load")                                               /* functies starten */

'@echo off'
Call SysCls

pad1 = 'C:\OFFICE43\WINWORD\'
pad2 = 'C:\VAR\TEMP\'

red=    '1B'x||"["||"31"||";"||"40"||";"||"1"||"m"
yellow= '1B'x||"["||"33"||";"||"40"||";"||"1"||"m"
blue  = '1B'x||"["||"34"||";"||"40"||";"||"1"||"m"
normal= '1B'x||"["||"0"||"m"

Parse Arg all
ArgCount = words(all);

/* geen parameter -> helppagina */
IF word(all,1) = '' THEN CALL help

/* tijdelijke bestanden wissen */
IF word(all,1) = 'schoon' THEN DO
  'if exist 'pad2'wordvw??.doc del 'pad2'wordvw??.doc >nul'
  EXIT
END

/* 1e doc-bestand kopieren en daarna openen in Word,
                    bij 2e doc-bestand wordt deze alleen gekopieerd */
CALL SysFileTree pad2'wordvw??.doc','file','FO'
nr = file.0
IF nr = '0' THEN
  DO

/* het "registreren" en inlezen van de bestanden */
    nr = '01'
    'copy %1 /b 'pad2'wordvw'nr'.doc >nul'
    IF substr(word(all,1),1,1) = '"' THEN
      'echo Wordvw'nr'.doc = %1 >>'pad2'wordvw.txt'
    ELSE
      'echo Wordvw'nr'.doc = "%1" >>'pad2'wordvw.txt'

    'start /win /c 'pad1'winword.exe 'pad2'wordvw'nr'.doc'
    SAY;SAY '    Microsoft Word wordt geopend met:'
    'echo     %1'

/* testen van het "open staan" van Word en
                      na "sluiten" het wissen van tijdelijke bestanden */
    CALL RxNap 10000                                               /* 1000=1 sec */
    test = 'ok'
    DO WHILE test = 'ok'
      CALL RxQuerySwitchList "temp."
      test = 'nok'
      DO i = 1 TO temp.0
        IF substr(temp.i,1,14) = 'Microsoft Word' THEN test = 'ok'
      END

/* Tonen van geopende DOC-bestanden */
      Call SysCls
      CALL SysFileSearch ' ', pad2'wordvw.txt', line.
      SAY;SAY 'Microsoft Word is geopend met:';SAY
      DO a = 1 TO line.0
        SAY '   'red line.a normal
      END
      SAY;SAY 'Na afsluiten van Word wordt dit automatisch gesloten!'
      CALL RxNap 1000                                              /* 1000=1 sec */
    END
    Call SysCls
    'if exist 'pad2'wordvw??.doc del 'pad2'wordvw??.* >nul'
    EXIT
  END
ELSE

/* volgende doc-bestanden kopieren */
  DO
    i = file.0
    nr = substr(file.i,length(file.i)-5,2)
    IF substr(nr,1,1) = '0' THEN
      DO
        nr2 = substr(nr,2,1)+1
        nr = '0'nr2
      END
    ELSE
      nr = nr+1

    'copy %1 /b 'pad2'wordvw'nr'.doc >nul'
    IF substr(word(all,1),1,1) = '"' THEN
      'echo Wordvw'nr'.doc = %1 >>'pad2'wordvw.txt'
    ELSE
      'echo Wordvw'nr'.doc = "%1" >>'pad2'wordvw.txt'

    CALL RxSwitchTo 'Microsoft Word'
    EXIT
  END

help:
SAY;SAY;SAY yellow'     WordView help'normal
SAY;SAY '     syntax:   WordView 'blue'schoon'normal
SAY '               Verwijdert de tijdelijke bestanden'
SAY;SAY '     syntax:   WordView 'blue'*.DOC-bestand'normal
SAY '               -Bij eerste keer wordt het bestand gekopieerd en'
SAY '                wordt Word met het bestand geopend'
SAY '                Er wordt in een venster getoont welke bestand geopend is'
SAY '               -Als WordV gesloten wordt, worden de tijdelijke bestanden'
SAY '                verwijderd en het venster gesloten'
SAY;SAY;SAY '     Voor het eerste gebruik moet op regel 20 en 21 aangegeven worden:'
SAY '     pad1=path naar het Word programma en'
SAY '     pad2=path naar tijdelijke bestanden)'
SAY;SAY '     Dit script maakt gebruik van rxextras.dll (rxx1g.zip op Hobbes)'

