/* @(#) generic/sproc/ins_syn_sql 84.3 7/21/93 */

use master
go

/*
** Create a procedure to print out error messages
*/
if exists (select name from sysobjects where name = "sybsyntax_printmsg")
begin
	drop procedure sybsyntax_printmsg
end
go

create procedure sybsyntax_printmsg
	@message_num	int
as
	declare @msg varchar(255)
	exec sp_getmessage @message_num, @msg output
	print @msg

go

/* create the database, if it does not exist */
if not exists (select name from sysdatabases where name = "sybsyntax")
begin
	/* is the space left on the default database devices > size of model? */
	if  (select sum (high-low +1)  from sysdevices where status & 1 = 1)
	-  (select (isnull (sum(size), 0)) from sysusages, sysdevices
		where vstart >= sysdevices.low
		and vstart <= sysdevices.high
		and sysdevices.status &1 = 1)
		> (select sum(sysusages.size) from sysusages where dbid = 3)
	begin
		create database sybsyntax
	end
	else
		/*
		** 18047, "There is not enough room on the default devices to create the sybsyntax database."
		*/
		exec sybsyntax_printmsg 18047

end
go

if exists (select name from sysdatabases where name = "sybsyntax")
	use sybsyntax
else
	/*
	** 18048, "The sybsyntax database couldn't be created."
	*/
	exec sybsyntax_printmsg 18048
go

/* create the sybsyntax table if it doesn't exist, and sybsyntax does */
if exists (select name from master..sysdatabases where name = "sybsyntax")
begin
	if not exists (select name
			from sybsyntax..sysobjects
			where name = "sybsyntax"
				and type = "U" and uid = 1)
	begin
	/* The table does not exist. Create it. */
		create table sybsyntax
		(commandname	varchar(50)	not null,
		module		varchar(20)	not null,
		linenum		smallint	not null,
		syntax		varchar(78)	not null,
		langid		smallint	null)
	end
end
go

/*
** If the table existed from before. It could be an older version.
** Check to make sure that it has a langid column.
*/
if not exists (select name from sybsyntax..syscolumns 
			 where id = object_id("sybsyntax..sybsyntax")
			 and name = "langid")
begin
	alter table sybsyntax..sybsyntax
	add langid smallint null
end
go

/* create the index on the sybsyntax table */
if not exists (select name from sysindexes where name = "sybsyntax_cuix")
begin
	create unique clustered index sybsyntax_cuix
		on sybsyntax(module, commandname, linenum)
end
go

/* delete existing rows for this module, if there are any
** For DB-Library/C, delete only DB-Library/C. For Transact-SQL,
** delete SQL, sprocs and utilities
*/

if exists (select module from sybsyntax
		where module = "Client-Library/C")

begin
	delete from sybsyntax where module = "Client-Library/C"
	delete from sybsyntax where module = "Bulk Copy"
	delete from sybsyntax where module = "CS-Library/C"
	dump transaction sybsyntax with truncate_only
end
go

use master
go

/* drop the insert_syntax procedure, and re-create it */
if exists (select name from sysobjects where name = "insert_syntax")
begin
	drop procedure insert_syntax
end
go

create procedure insert_syntax
	@command varchar(50),
	@module varchar(20),
	@linenum smallint,
	@syntax varchar(78),
	@lang_id smallint = null
as
if exists (select name
		from master..sysdatabases
		where name = "sybsyntax")
begin
	insert sybsyntax..sybsyntax values
		(@command, @module, @linenum, @syntax, @lang_id)
end
go
use master
go


exec insert_syntax 'ct_bind',
'Client-Library/C',      1 ,
'ct_bind - Bind server results to program variables.'
go
exec insert_syntax 'ct_bind',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_bind(cmd, item, datafmt, buffer,'
go
exec insert_syntax 'ct_bind',
'Client-Library/C',      3 ,
'                  copied, indicator)'
go
exec insert_syntax 'ct_bind',
'Client-Library/C',      4 ,
'    CS_COMMAND    *cmd;'
go
exec insert_syntax 'ct_bind',
'Client-Library/C',      5 ,
'    CS_INT        item;'
go
exec insert_syntax 'ct_bind',
'Client-Library/C',      6 ,
'    CS_DATAFMT    *datafmt;'
go
exec insert_syntax 'ct_bind',
'Client-Library/C',      7 ,
'    CS_VOID       *buffer;'
go
exec insert_syntax 'ct_bind',
'Client-Library/C',      8 ,
'    CS_INT        *copied;'
go
exec insert_syntax 'ct_bind',
'Client-Library/C',      9 ,
'    CS_SMALLINT   *indicator;'
go
exec insert_syntax 'ct_br_column',
'Client-Library/C',      1 ,
'ct_br_column - Retrieve information about a column generated by a'
go
exec insert_syntax 'ct_br_column',
'Client-Library/C',      2 ,
'        browse-mode select.'
go
exec insert_syntax 'ct_br_column',
'Client-Library/C',      3 ,
'    CS_RETCODE ct_br_column(cmd, colnum, browsedesc)'
go
exec insert_syntax 'ct_br_column',
'Client-Library/C',      4 ,
'    CS_COMMAND                  *cmd;'
go
exec insert_syntax 'ct_br_column',
'Client-Library/C',      5 ,
'    CS_INT        colnum;'
go
exec insert_syntax 'ct_br_column',
'Client-Library/C',      6 ,
'    CS_BROWSEDESC *browsedesc;'
go
exec insert_syntax 'ct_br_table',
'Client-Library/C',      1 ,
'ct_br_table - Return information about browse mode tables.'
go
exec insert_syntax 'ct_br_table',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_br_table(cmd, tabnum, type,'
go
exec insert_syntax 'ct_br_table',
'Client-Library/C',      3 ,
'                  buffer, buflen, outlen)'
go
exec insert_syntax 'ct_br_table',
'Client-Library/C',      4 ,
'    CS_COMMAND    *cmd;'
go
exec insert_syntax 'ct_br_table',
'Client-Library/C',      5 ,
'    CS_INT        tabnum;'
go
exec insert_syntax 'ct_br_table',
'Client-Library/C',      6 ,
'    CS_INT        type;'
go
exec insert_syntax 'ct_br_table',
'Client-Library/C',      7 ,
'    CS_VOID       *buffer;'
go
exec insert_syntax 'ct_br_table',
'Client-Library/C',      8 ,
'    CS_INT        buflen;'
go
exec insert_syntax 'ct_br_table',
'Client-Library/C',      9 ,
'    CS_INT        *outlen;'
go
exec insert_syntax 'ct_callback',
'Client-Library/C',      1 ,
'ct_callback - Install or retrieve a Client-Library callback'
go
exec insert_syntax 'ct_callback',
'Client-Library/C',      2 ,
'        routine.'
go
exec insert_syntax 'ct_callback',
'Client-Library/C',      3 ,
'    CS_RETCODE ct_callback(context, connection,'
go
exec insert_syntax 'ct_callback',
'Client-Library/C',      4 ,
'                  action, type, func)'
go
exec insert_syntax 'ct_callback',
'Client-Library/C',      5 ,
'    CS_CONTEXT    *context;'
go
exec insert_syntax 'ct_callback',
'Client-Library/C',      6 ,
'    CS_CONNECTION *connection;'
go
exec insert_syntax 'ct_callback',
'Client-Library/C',      7 ,
'    CS_INT        action;'
go
exec insert_syntax 'ct_callback',
'Client-Library/C',      8 ,
'    CS_INT        type;'
go
exec insert_syntax 'ct_callback',
'Client-Library/C',      9 ,
'    CS_VOID       *func;'
go
exec insert_syntax 'ct_cancel',
'Client-Library/C',      1 ,
'ct_cancel - Cancel a command or the results of a command.'
go
exec insert_syntax 'ct_cancel',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_cancel(connection, cmd, type)'
go
exec insert_syntax 'ct_cancel',
'Client-Library/C',      3 ,
'    CS_CONNECTION *connection;'
go
exec insert_syntax 'ct_cancel',
'Client-Library/C',      4 ,
'    CS_COMMAND    *cmd;'
go
exec insert_syntax 'ct_cancel',
'Client-Library/C',      5 ,
'    CS_INT        type;'
go
exec insert_syntax 'ct_capability',
'Client-Library/C',      1 ,
'ct_capability - Set or retrieve a client/server capability.'
go
exec insert_syntax 'ct_capability',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_capability(connection, action, type,'
go
exec insert_syntax 'ct_capability',
'Client-Library/C',      3 ,
'                  capability, value)'
go
exec insert_syntax 'ct_capability',
'Client-Library/C',      4 ,
'    CS_CONNECTION *connection;'
go
exec insert_syntax 'ct_capability',
'Client-Library/C',      5 ,
'    CS_INT        action;'
go
exec insert_syntax 'ct_capability',
'Client-Library/C',      6 ,
'    CS_INT        type;'
go
exec insert_syntax 'ct_capability',
'Client-Library/C',      7 ,
'    CS_INT        capability;'
go
exec insert_syntax 'ct_capability',
'Client-Library/C',      8 ,
'    CS_VOID       *value;'
go
exec insert_syntax 'ct_close',
'Client-Library/C',      1 ,
'ct_close - Close a server connection.'
go
exec insert_syntax 'ct_close',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_close(connection, option)'
go
exec insert_syntax 'ct_close',
'Client-Library/C',      3 ,
'    CS_CONNECTION *connection;'
go
exec insert_syntax 'ct_close',
'Client-Library/C',      4 ,
'    CS_INT        option;'
go
exec insert_syntax 'ct_cmd_alloc',
'Client-Library/C',      1 ,
'ct_cmd_alloc - Allocate a CS_COMMAND structure.'
go
exec insert_syntax 'ct_cmd_alloc',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_cmd_alloc(connection, cmd_pointer)'
go
exec insert_syntax 'ct_cmd_alloc',
'Client-Library/C',      3 ,
'    CS_CONNECTION *connection;'
go
exec insert_syntax 'ct_cmd_alloc',
'Client-Library/C',      4 ,
'    CS_COMMAND    **cmd_pointer;'
go
exec insert_syntax 'ct_cmd_drop',
'Client-Library/C',      1 ,
'ct_cmd_drop - De-allocate a CS_COMMAND structure.'
go
exec insert_syntax 'ct_cmd_drop',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_cmd_drop(cmd)'
go
exec insert_syntax 'ct_cmd_drop',
'Client-Library/C',      3 ,
'    CS_COMMAND    *cmd;'
go
exec insert_syntax 'ct_cmd_props',
'Client-Library/C',      1 ,
'ct_cmd_props - Set or retrieve command structure properties.'
go
exec insert_syntax 'ct_cmd_props',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_cmd_props(cmd, action, property, buffer,'
go
exec insert_syntax 'ct_cmd_props',
'Client-Library/C',      3 ,
'                  buflen, outlen)'
go
exec insert_syntax 'ct_cmd_props',
'Client-Library/C',      4 ,
'    CS_COMMAND    *cmd;'
go
exec insert_syntax 'ct_cmd_props',
'Client-Library/C',      5 ,
'    CS_INT        action;'
go
exec insert_syntax 'ct_cmd_props',
'Client-Library/C',      6 ,
'    CS_INT        property;'
go
exec insert_syntax 'ct_cmd_props',
'Client-Library/C',      7 ,
'    CS_VOID       *buffer;'
go
exec insert_syntax 'ct_cmd_props',
'Client-Library/C',      8 ,
'    CS_INT        buflen;'
go
exec insert_syntax 'ct_cmd_props',
'Client-Library/C',      9 ,
'    CS_INT        *outlen;'
go
exec insert_syntax 'ct_command',
'Client-Library/C',      1 ,
'ct_command - Initiate a language, package, RPC, message, or'
go
exec insert_syntax 'ct_command',
'Client-Library/C',      2 ,
'        send-data command.'
go
exec insert_syntax 'ct_command',
'Client-Library/C',      3 ,
'    CS_RETCODE ct_command(cmd, type, buffer, buflen,'
go
exec insert_syntax 'ct_command',
'Client-Library/C',      4 ,
'                  option)'
go
exec insert_syntax 'ct_command',
'Client-Library/C',      5 ,
'    CS_COMMAND    *cmd;'
go
exec insert_syntax 'ct_command',
'Client-Library/C',      6 ,
'    CS_INT        type;'
go
exec insert_syntax 'ct_command',
'Client-Library/C',      7 ,
'    CS_VOID       *buffer;'
go
exec insert_syntax 'ct_command',
'Client-Library/C',      8 ,
'    CS_INT        buflen;'
go
exec insert_syntax 'ct_command',
'Client-Library/C',      9 ,
'    CS_INT        option;'
go
exec insert_syntax 'ct_compute_info',
'Client-Library/C',      1 ,
'ct_compute_info - Return compute result information.'
go
exec insert_syntax 'ct_compute_info',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_compute_info(cmd, type, colnum, buffer,'
go
exec insert_syntax 'ct_compute_info',
'Client-Library/C',      3 ,
'                  buflen, outlen)'
go
exec insert_syntax 'ct_compute_info',
'Client-Library/C',      4 ,
'    CS_COMMAND    *cmd;'
go
exec insert_syntax 'ct_compute_info',
'Client-Library/C',      5 ,
'    CS_INT        type;'
go
exec insert_syntax 'ct_compute_info',
'Client-Library/C',      6 ,
'    CS_INT        colnum;'
go
exec insert_syntax 'ct_compute_info',
'Client-Library/C',      7 ,
'    CS_VOID       *buffer;'
go
exec insert_syntax 'ct_compute_info',
'Client-Library/C',      8 ,
'    CS_INT        buflen;'
go
exec insert_syntax 'ct_compute_info',
'Client-Library/C',      9 ,
'    CS_INT        *outlen;'
go
exec insert_syntax 'ct_con_alloc',
'Client-Library/C',      1 ,
'ct_con_alloc - Allocate a CS_CONNECTION structure.'
go
exec insert_syntax 'ct_con_alloc',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_con_alloc(context, con_pointer)'
go
exec insert_syntax 'ct_con_alloc',
'Client-Library/C',      3 ,
'    CS_CONTEXT    *context;'
go
exec insert_syntax 'ct_con_alloc',
'Client-Library/C',      4 ,
'    CS_CONNECTION **con_pointer;'
go
exec insert_syntax 'ct_con_drop',
'Client-Library/C',      1 ,
'ct_con_drop - De-allocate a CS_CONNECTION structure.'
go
exec insert_syntax 'ct_con_drop',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_con_drop(connection)'
go
exec insert_syntax 'ct_con_drop',
'Client-Library/C',      3 ,
'    CS_CONNECTION *connection;'
go
exec insert_syntax 'ct_con_props',
'Client-Library/C',      1 ,
'ct_con_props - Set or retrieve connection structure properties.'
go
exec insert_syntax 'ct_con_props',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_con_props(connection, action, property,'
go
exec insert_syntax 'ct_con_props',
'Client-Library/C',      3 ,
'                  buffer, buflen, outlen)'
go
exec insert_syntax 'ct_con_props',
'Client-Library/C',      4 ,
'    CS_CONNECTION *connection;'
go
exec insert_syntax 'ct_con_props',
'Client-Library/C',      5 ,
'    CS_INT        action;'
go
exec insert_syntax 'ct_con_props',
'Client-Library/C',      6 ,
'    CS_INT        property;'
go
exec insert_syntax 'ct_con_props',
'Client-Library/C',      7 ,
'    CS_VOID       *buffer;'
go
exec insert_syntax 'ct_con_props',
'Client-Library/C',      8 ,
'    CS_INT        buflen;'
go
exec insert_syntax 'ct_con_props',
'Client-Library/C',      9 ,
'    CS_INT        *outlen;'
go
exec insert_syntax 'ct_config',
'Client-Library/C',      1 ,
'ct_config - Set or retrieve context properties.'
go
exec insert_syntax 'ct_config',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_config(context, action, property,'
go
exec insert_syntax 'ct_config',
'Client-Library/C',      3 ,
'                  buffer, buflen, outlen)'
go
exec insert_syntax 'ct_config',
'Client-Library/C',      4 ,
'    CS_CONTEXT    *context;'
go
exec insert_syntax 'ct_config',
'Client-Library/C',      5 ,
'    CS_INT        action;'
go
exec insert_syntax 'ct_config',
'Client-Library/C',      6 ,
'    CS_INT        property;'
go
exec insert_syntax 'ct_config',
'Client-Library/C',      7 ,
'    CS_VOID       *buffer;'
go
exec insert_syntax 'ct_config',
'Client-Library/C',      8 ,
'    CS_INT        buflen;'
go
exec insert_syntax 'ct_config',
'Client-Library/C',      9 ,
'    CS_INT        *outlen;'
go
exec insert_syntax 'ct_connect',
'Client-Library/C',      1 ,
'ct_connect - Connect to a server.'
go
exec insert_syntax 'ct_connect',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_connect(connection, server_name,'
go
exec insert_syntax 'ct_connect',
'Client-Library/C',      3 ,
'                  snamelen)'
go
exec insert_syntax 'ct_connect',
'Client-Library/C',      4 ,
'    CS_CONNECTION *connection;'
go
exec insert_syntax 'ct_connect',
'Client-Library/C',      5 ,
'    CS_CHAR       *server_name;'
go
exec insert_syntax 'ct_connect',
'Client-Library/C',      6 ,
'    CS_INT        snamelen;'
go
exec insert_syntax 'ct_cursor',
'Client-Library/C',      1 ,
'ct_cursor - Initiate a cursor command.'
go
exec insert_syntax 'ct_cursor',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_cursor(cmd, type, name, namelen, text,'
go
exec insert_syntax 'ct_cursor',
'Client-Library/C',      3 ,
'                  textlen, option)'
go
exec insert_syntax 'ct_cursor',
'Client-Library/C',      4 ,
'    CS_COMMAND    *cmd;'
go
exec insert_syntax 'ct_cursor',
'Client-Library/C',      5 ,
'    CS_INT        type;'
go
exec insert_syntax 'ct_cursor',
'Client-Library/C',      6 ,
'    CS_CHAR       *name;'
go
exec insert_syntax 'ct_cursor',
'Client-Library/C',      7 ,
'    CS_INT        namelen;'
go
exec insert_syntax 'ct_cursor',
'Client-Library/C',      8 ,
'    CS_CHAR       *text;'
go
exec insert_syntax 'ct_cursor',
'Client-Library/C',      9 ,
'    CS_INT        textlen;'
go
exec insert_syntax 'ct_cursor',
'Client-Library/C',      10,
'    CS_INT        option;'
go
exec insert_syntax 'ct_data_info',
'Client-Library/C',      1 ,
'ct_data_info - Define or retrieve a data I/O descriptor structure.'
go
exec insert_syntax 'ct_data_info',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_data_info(cmd, action, colnum, iodesc)'
go
exec insert_syntax 'ct_data_info',
'Client-Library/C',      3 ,
'    CS_COMMAND    *cmd;'
go
exec insert_syntax 'ct_data_info',
'Client-Library/C',      4 ,
'    CS_INT        action;'
go
exec insert_syntax 'ct_data_info',
'Client-Library/C',      5 ,
'    CS_INT        colnum;'
go
exec insert_syntax 'ct_data_info',
'Client-Library/C',      6 ,
'    CS_IODESC     *iodesc;'
go
exec insert_syntax 'ct_debug',
'Client-Library/C',      1 ,
'ct_debug - Manage debug library operations.'
go
exec insert_syntax 'ct_debug',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_debug(context, connection, operation,'
go
exec insert_syntax 'ct_debug',
'Client-Library/C',      3 ,
'                  flag, filename, fnamelen)'
go
exec insert_syntax 'ct_debug',
'Client-Library/C',      4 ,
'    CS_CONTEXT    *context;'
go
exec insert_syntax 'ct_debug',
'Client-Library/C',      5 ,
'    CS_CONNECTION *connection;'
go
exec insert_syntax 'ct_debug',
'Client-Library/C',      6 ,
'    CS_INT        operation;'
go
exec insert_syntax 'ct_debug',
'Client-Library/C',      7 ,
'    CS_INT        flag;'
go
exec insert_syntax 'ct_debug',
'Client-Library/C',      8 ,
'    CS_CHAR       *filename;'
go
exec insert_syntax 'ct_debug',
'Client-Library/C',      9 ,
'    CS_INT        fnamelen;'
go
exec insert_syntax 'ct_describe',
'Client-Library/C',      1 ,
'ct_describe - Return a description of result data.'
go
exec insert_syntax 'ct_describe',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_describe(cmd, item, datafmt)'
go
exec insert_syntax 'ct_describe',
'Client-Library/C',      3 ,
'    CS_COMMAND    *cmd;'
go
exec insert_syntax 'ct_describe',
'Client-Library/C',      4 ,
'    CS_INT        item;'
go
exec insert_syntax 'ct_describe',
'Client-Library/C',      5 ,
'    CS_DATAFMT    *datafmt;'
go
exec insert_syntax 'ct_diag',
'Client-Library/C',      1 ,
'ct_diag - Manage in-line error handling.'
go
exec insert_syntax 'ct_diag',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_diag(connection, operation, type, index,'
go
exec insert_syntax 'ct_diag',
'Client-Library/C',      3 ,
'                  buffer)'
go
exec insert_syntax 'ct_diag',
'Client-Library/C',      4 ,
'    CS_CONNECTION *connection;'
go
exec insert_syntax 'ct_diag',
'Client-Library/C',      5 ,
'    CS_INT        operation;'
go
exec insert_syntax 'ct_diag',
'Client-Library/C',      6 ,
'    CS_INT        type;'
go
exec insert_syntax 'ct_diag',
'Client-Library/C',      7 ,
'    CS_INT        index;'
go
exec insert_syntax 'ct_diag',
'Client-Library/C',      8 ,
'    CS_VOID       *buffer;'
go
exec insert_syntax 'ct_dynamic',
'Client-Library/C',      1 ,
'ct_dynamic - Initiate a prepared dynamic SQL statement command.'
go
exec insert_syntax 'ct_dynamic',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_dynamic(cmd, type, id, idlen, buffer,'
go
exec insert_syntax 'ct_dynamic',
'Client-Library/C',      3 ,
'                  buflen)'
go
exec insert_syntax 'ct_dynamic',
'Client-Library/C',      4 ,
'    CS_COMMAND    *cmd;'
go
exec insert_syntax 'ct_dynamic',
'Client-Library/C',      5 ,
'    CS_INT        type;'
go
exec insert_syntax 'ct_dynamic',
'Client-Library/C',      6 ,
'    CS_CHAR       *id;'
go
exec insert_syntax 'ct_dynamic',
'Client-Library/C',      7 ,
'    CS_INT        idlen;'
go
exec insert_syntax 'ct_dynamic',
'Client-Library/C',      8 ,
'    CS_CHAR       *buffer;'
go
exec insert_syntax 'ct_dynamic',
'Client-Library/C',      9 ,
'    CS_INT        buflen;'
go
exec insert_syntax 'ct_dyndesc',
'Client-Library/C',      1 ,
'ct_dyndesc - Perform operations on a dynamic SQL descriptor area.'
go
exec insert_syntax 'ct_dyndesc',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_dyndesc(cmd, descriptor, desclen,'
go
exec insert_syntax 'ct_dyndesc',
'Client-Library/C',      3 ,
'                  operation, index, datafmt, buffer,'
go
exec insert_syntax 'ct_dyndesc',
'Client-Library/C',      4 ,
'                  buflen, copied, indicator)'
go
exec insert_syntax 'ct_dyndesc',
'Client-Library/C',      5 ,
'    CS_COMMAND    *cmd;'
go
exec insert_syntax 'ct_dyndesc',
'Client-Library/C',      6 ,
'    CS_CHAR       *descriptor;'
go
exec insert_syntax 'ct_dyndesc',
'Client-Library/C',      7 ,
'    CS_INT        desclen;'
go
exec insert_syntax 'ct_dyndesc',
'Client-Library/C',      8 ,
'    CS_INT        operation;'
go
exec insert_syntax 'ct_dyndesc',
'Client-Library/C',      9 ,
'    CS_INT        index;'
go
exec insert_syntax 'ct_dyndesc',
'Client-Library/C',      10,
'    CS_DATAFMT    *datafmt;'
go
exec insert_syntax 'ct_dyndesc',
'Client-Library/C',      11,
'    CS_VOID       *buffer;'
go
exec insert_syntax 'ct_dyndesc',
'Client-Library/C',      12,
'    CS_INT        buflen;'
go
exec insert_syntax 'ct_dyndesc',
'Client-Library/C',      13,
'    CS_INT        *copied;'
go
exec insert_syntax 'ct_dyndesc',
'Client-Library/C',      14,
'    CS_SMALLINT   *indicator;'
go
exec insert_syntax 'ct_exit',
'Client-Library/C',      1 ,
'ct_exit - Exit Client-Library.'
go
exec insert_syntax 'ct_exit',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_exit(context, option)'
go
exec insert_syntax 'ct_exit',
'Client-Library/C',      3 ,
'    CS_CONTEXT    *context;'
go
exec insert_syntax 'ct_exit',
'Client-Library/C',      4 ,
'    CS_INT        option;'
go
exec insert_syntax 'ct_fetch',
'Client-Library/C',      1 ,
'ct_fetch - Fetch result data.'
go
exec insert_syntax 'ct_fetch',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_fetch(cmd, type, offset, option,'
go
exec insert_syntax 'ct_fetch',
'Client-Library/C',      3 ,
'                  rows_read)'
go
exec insert_syntax 'ct_fetch',
'Client-Library/C',      4 ,
'    CS_COMMAND    *cmd;'
go
exec insert_syntax 'ct_fetch',
'Client-Library/C',      5 ,
'    CS_INT        type;'
go
exec insert_syntax 'ct_fetch',
'Client-Library/C',      6 ,
'    CS_INT        offset;'
go
exec insert_syntax 'ct_fetch',
'Client-Library/C',      7 ,
'    CS_INT        option;'
go
exec insert_syntax 'ct_fetch',
'Client-Library/C',      8 ,
'    CS_INT        *rows_read;'
go
exec insert_syntax 'ct_get_data',
'Client-Library/C',      1 ,
'ct_get_data - Read a chunk of data from the server.'
go
exec insert_syntax 'ct_get_data',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_get_data(cmd, item, buffer,'
go
exec insert_syntax 'ct_get_data',
'Client-Library/C',      3 ,
'                   buflen, outlen)'
go
exec insert_syntax 'ct_get_data',
'Client-Library/C',      4 ,
'    CS_COMMAND    *cmd;'
go
exec insert_syntax 'ct_get_data',
'Client-Library/C',      5 ,
'    CS_INT        item;'
go
exec insert_syntax 'ct_get_data',
'Client-Library/C',      6 ,
'    CS_VOID       *buffer;'
go
exec insert_syntax 'ct_get_data',
'Client-Library/C',      7 ,
'    CS_INT        buflen;'
go
exec insert_syntax 'ct_get_data',
'Client-Library/C',      8 ,
'    CS_INT        *outlen;'
go
exec insert_syntax 'ct_getformat',
'Client-Library/C',      1 ,
'ct_getformat - Return the server user-defined format string'
go
exec insert_syntax 'ct_getformat',
'Client-Library/C',      2 ,
'        associated with a result column.'
go
exec insert_syntax 'ct_getformat',
'Client-Library/C',      3 ,
'    CS_RETCODE ct_getformat (cmd, colnum, buffer, buflen,'
go
exec insert_syntax 'ct_getformat',
'Client-Library/C',      4 ,
'                  outlen'
go
exec insert_syntax 'ct_getformat',
'Client-Library/C',      5 ,
'    CS_COMMAND    *cmd;'
go
exec insert_syntax 'ct_getformat',
'Client-Library/C',      6 ,
'    CS_INT        colnum;'
go
exec insert_syntax 'ct_getformat',
'Client-Library/C',      7 ,
'    CS_VOID       *buffer;'
go
exec insert_syntax 'ct_getformat',
'Client-Library/C',      8 ,
'    CS_INT        buflen;'
go
exec insert_syntax 'ct_getformat',
'Client-Library/C',      9 ,
'    CS_INT        *outlen;'
go
exec insert_syntax 'ct_getloginfo',
'Client-Library/C',      1 ,
'ct_getloginfo - Transfer TDS login response information from a'
go
exec insert_syntax 'ct_getloginfo',
'Client-Library/C',      2 ,
'        CS_CONNECTION structure to a newly-allocated'
go
exec insert_syntax 'ct_getloginfo',
'Client-Library/C',      3 ,
'        CS_LOGINFO structure.'
go
exec insert_syntax 'ct_getloginfo',
'Client-Library/C',      4 ,
'    CS_RETCODE ct_getloginfo (connection, logptr)'
go
exec insert_syntax 'ct_getloginfo',
'Client-Library/C',      5 ,
'    CS_CONNECTION *connection;'
go
exec insert_syntax 'ct_getloginfo',
'Client-Library/C',      6 ,
'    CS_LOGINFO    **logptr;'
go
exec insert_syntax 'ct_init',
'Client-Library/C',      1 ,
'ct_init - Initialize Client-Library.'
go
exec insert_syntax 'ct_init',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_init(context, version)'
go
exec insert_syntax 'ct_init',
'Client-Library/C',      3 ,
'    CS_CONTEXT    *context;'
go
exec insert_syntax 'ct_init',
'Client-Library/C',      4 ,
'    CS_INT        version;'
go
exec insert_syntax 'ct_keydata',
'Client-Library/C',      1 ,
'ct_keydata - Specify or extract the contents of a key column.'
go
exec insert_syntax 'ct_keydata',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_keydata (cmd, action, colnum, buffer,'
go
exec insert_syntax 'ct_keydata',
'Client-Library/C',      3 ,
'                   buflen, outlen)'
go
exec insert_syntax 'ct_keydata',
'Client-Library/C',      4 ,
'    CS_COMMAND    *cmd;'
go
exec insert_syntax 'ct_keydata',
'Client-Library/C',      5 ,
'    CS_INT        action;'
go
exec insert_syntax 'ct_keydata',
'Client-Library/C',      6 ,
'    CS_INT        colnum;'
go
exec insert_syntax 'ct_keydata',
'Client-Library/C',      7 ,
'    CS_VOID       *buffer;'
go
exec insert_syntax 'ct_keydata',
'Client-Library/C',      8 ,
'    CS_INT        buflen;'
go
exec insert_syntax 'ct_keydata',
'Client-Library/C',      9 ,
'    CS_INT        outlen;'
go
exec insert_syntax 'ct_options',
'Client-Library/C',      1 ,
'ct_options - Set or retrieve the values of server options.'
go
exec insert_syntax 'ct_options',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_options(connection, action, option,'
go
exec insert_syntax 'ct_options',
'Client-Library/C',      3 ,
'                  param, paramlen, outlen)'
go
exec insert_syntax 'ct_options',
'Client-Library/C',      4 ,
'    CS_CONNECTION *connection;'
go
exec insert_syntax 'ct_options',
'Client-Library/C',      5 ,
'    CS_INT        action;'
go
exec insert_syntax 'ct_options',
'Client-Library/C',      6 ,
'    CS_INT        option;'
go
exec insert_syntax 'ct_options',
'Client-Library/C',      7 ,
'    CS_VOID       *param;'
go
exec insert_syntax 'ct_options',
'Client-Library/C',      8 ,
'    CS_INT        paramlen;'
go
exec insert_syntax 'ct_options',
'Client-Library/C',      9 ,
'    CS_INT        *outlen;'
go
exec insert_syntax 'ct_param',
'Client-Library/C',      1 ,
'ct_param - Define a command parameter.'
go
exec insert_syntax 'ct_param',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_param(cmd, datafmt, data, datalen,'
go
exec insert_syntax 'ct_param',
'Client-Library/C',      3 ,
'                  indicator);'
go
exec insert_syntax 'ct_param',
'Client-Library/C',      4 ,
'    CS_COMMAND    *cmd;'
go
exec insert_syntax 'ct_param',
'Client-Library/C',      5 ,
'    CS_DATAFMT    *datafmt;'
go
exec insert_syntax 'ct_param',
'Client-Library/C',      6 ,
'    CS_VOID       *data;'
go
exec insert_syntax 'ct_param',
'Client-Library/C',      7 ,
'    CS_INT        datalen;'
go
exec insert_syntax 'ct_param',
'Client-Library/C',      8 ,
'    CS_SMALLINT   indicator;'
go
exec insert_syntax 'ct_poll',
'Client-Library/C',      1 ,
'ct_poll - Poll connections for asynchronous operation'
go
exec insert_syntax 'ct_poll',
'Client-Library/C',      2 ,
'        completions and registered procedure notifications.'
go
exec insert_syntax 'ct_poll',
'Client-Library/C',      3 ,
'    CS_RETCODE ct_poll (context, connection,'
go
exec insert_syntax 'ct_poll',
'Client-Library/C',      4 ,
'                  milliseconds, compconn,'
go
exec insert_syntax 'ct_poll',
'Client-Library/C',      5 ,
'                  compcmd, compid, compstatus)'
go
exec insert_syntax 'ct_poll',
'Client-Library/C',      6 ,
'    CS_CONTEXT    *context;'
go
exec insert_syntax 'ct_poll',
'Client-Library/C',      7 ,
'    CS_CONNECTION *connection;'
go
exec insert_syntax 'ct_poll',
'Client-Library/C',      8 ,
'    CS_INT        milliseconds;'
go
exec insert_syntax 'ct_poll',
'Client-Library/C',      9 ,
'    CS_CONNECTION **compconn;'
go
exec insert_syntax 'ct_poll',
'Client-Library/C',      10,
'    CS_COMMAND    **compcmd;'
go
exec insert_syntax 'ct_poll',
'Client-Library/C',      11,
'    CS_INT        *compid;'
go
exec insert_syntax 'ct_poll',
'Client-Library/C',      12,
'    CS_RETCODE    *compstatus;'
go
exec insert_syntax 'ct_recvpassthru',
'Client-Library/C',      1 ,
'ct_recvpassthru - Receive a TDS packet from a server.'
go
exec insert_syntax 'ct_recvpassthru',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_recvpassthru (cmd, recvptr)'
go
exec insert_syntax 'ct_recvpassthru',
'Client-Library/C',      3 ,
'    CS_COMMAND    *cmd;'
go
exec insert_syntax 'ct_recvpassthru',
'Client-Library/C',      4 ,
'    CS_VOID       **recvptr;'
go
exec insert_syntax 'ct_remote_pwd',
'Client-Library/C',      1 ,
'ct_remote_pwd - Define or clear passwords to be used for'
go
exec insert_syntax 'ct_remote_pwd',
'Client-Library/C',      2 ,
'        server-to-server connections.'
go
exec insert_syntax 'ct_remote_pwd',
'Client-Library/C',      3 ,
'    CS_RETCODE ct_remote_pwd(connection, action,'
go
exec insert_syntax 'ct_remote_pwd',
'Client-Library/C',      4 ,
'                  server_name, snamelen, password,'
go
exec insert_syntax 'ct_remote_pwd',
'Client-Library/C',      5 ,
'                  pwdlen)'
go
exec insert_syntax 'ct_remote_pwd',
'Client-Library/C',      6 ,
'    CS_CONNECTION *connection;'
go
exec insert_syntax 'ct_remote_pwd',
'Client-Library/C',      7 ,
'    CS_INT        action;'
go
exec insert_syntax 'ct_remote_pwd',
'Client-Library/C',      8 ,
'    CS_CHAR       *server_name;'
go
exec insert_syntax 'ct_remote_pwd',
'Client-Library/C',      9 ,
'    CS_INT        snamelen;'
go
exec insert_syntax 'ct_remote_pwd',
'Client-Library/C',      10,
'    CS_CHAR       *password;'
go
exec insert_syntax 'ct_remote_pwd',
'Client-Library/C',      11,
'    CS_INT        pwdlen;'
go
exec insert_syntax 'ct_res_info',
'Client-Library/C',      1 ,
'ct_res_info - Return result set information.'
go
exec insert_syntax 'ct_res_info',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_res_info(cmd, type, buffer, buflen,'
go
exec insert_syntax 'ct_res_info',
'Client-Library/C',      3 ,
'                  outlen)'
go
exec insert_syntax 'ct_res_info',
'Client-Library/C',      4 ,
'    CS_COMMAND    *cmd;'
go
exec insert_syntax 'ct_res_info',
'Client-Library/C',      5 ,
'    CS_INT        type;'
go
exec insert_syntax 'ct_res_info',
'Client-Library/C',      6 ,
'    CS_VOID       *buffer;'
go
exec insert_syntax 'ct_res_info',
'Client-Library/C',      7 ,
'    CS_INT        buflen;'
go
exec insert_syntax 'ct_res_info',
'Client-Library/C',      8 ,
'    CS_INT        *outlen;'
go
exec insert_syntax 'ct_results',
'Client-Library/C',      1 ,
'ct_results - Sets up result data to be processed.'
go
exec insert_syntax 'ct_results',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_results(cmd, result_type)'
go
exec insert_syntax 'ct_results',
'Client-Library/C',      3 ,
'    CS_COMMAND    *cmd;'
go
exec insert_syntax 'ct_results',
'Client-Library/C',      4 ,
'    CS_INT        *result_type;'
go
exec insert_syntax 'ct_send',
'Client-Library/C',      1 ,
'ct_send - Send a command to the server.'
go
exec insert_syntax 'ct_send',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_send(cmd)'
go
exec insert_syntax 'ct_send',
'Client-Library/C',      3 ,
'    CS_COMMAND    *cmd;'
go
exec insert_syntax 'ct_send_data',
'Client-Library/C',      1 ,
'ct_send_data - Send a chunk of text or image data to the server.'
go
exec insert_syntax 'ct_send_data',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_send_data(cmd, buffer, buflen)'
go
exec insert_syntax 'ct_send_data',
'Client-Library/C',      3 ,
'    CS_COMMAND    *cmd;'
go
exec insert_syntax 'ct_send_data',
'Client-Library/C',      4 ,
'    CS_VOID       *buffer;'
go
exec insert_syntax 'ct_send_data',
'Client-Library/C',      5 ,
'    CS_INT        buflen;'
go
exec insert_syntax 'ct_sendpassthru',
'Client-Library/C',      1 ,
'ct_sendpassthru - Send a TDS packet to a server.'
go
exec insert_syntax 'ct_sendpassthru',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_sendpassthru (cmd, sendptr)'
go
exec insert_syntax 'ct_sendpassthru',
'Client-Library/C',      3 ,
'    CS_COMMAND    *cmd;'
go
exec insert_syntax 'ct_sendpassthru',
'Client-Library/C',      4 ,
'    CS_VOID       *sendptr;'
go
exec insert_syntax 'ct_setloginfo',
'Client-Library/C',      1 ,
'ct_setloginfo - Transfer TDS login information from a CS_LOGINFO'
go
exec insert_syntax 'ct_setloginfo',
'Client-Library/C',      2 ,
'        structure to a CS_CONNECTION structure.'
go
exec insert_syntax 'ct_setloginfo',
'Client-Library/C',      3 ,
'    CS_RETCODE ct_setloginfo (connection, loginfo)'
go
exec insert_syntax 'ct_setloginfo',
'Client-Library/C',      4 ,
'    CS_CONNECTION *connection;'
go
exec insert_syntax 'ct_setloginfo',
'Client-Library/C',      5 ,
'    CS_LOGINFO    *loginfo;'
go
exec insert_syntax 'ct_wakeup',
'Client-Library/C',      1 ,
'ct_wakeup - Call a connection''s completion callback.'
go
exec insert_syntax 'ct_wakeup',
'Client-Library/C',      2 ,
'    CS_RETCODE ct_wakeup(connection, cmd, function,'
go
exec insert_syntax 'ct_wakeup',
'Client-Library/C',      3 ,
'                  status)'
go
exec insert_syntax 'ct_wakeup',
'Client-Library/C',      4 ,
'    CS_CONNECTION *connection;'
go
exec insert_syntax 'ct_wakeup',
'Client-Library/C',      5 ,
'    CS_COMMAND    *cmd;'
go
exec insert_syntax 'ct_wakeup',
'Client-Library/C',      6 ,
'    CS_INT        function;'
go
exec insert_syntax 'ct_wakeup',
'Client-Library/C',      7 ,
'    CS_RETCODE    status;'
go

exec insert_syntax 'blk_alloc',
'Bulk Copy',             1 ,
'blk_alloc - Allocate a CS_BLKDESC structure.'
go
exec insert_syntax 'blk_alloc',
'Bulk Copy',             2 ,
'    CS_RETCODE blk_alloc(connection, version, blk_pointer)'
go
exec insert_syntax 'blk_alloc',
'Bulk Copy',             3 ,
'    CS_CONNECTION *connection;'
go
exec insert_syntax 'blk_alloc',
'Bulk Copy',             4 ,
'    CS_INT        version;'
go
exec insert_syntax 'blk_alloc',
'Bulk Copy',             5 ,
'    CS_BLKDESC    **blk_pointer;'
go
exec insert_syntax 'blk_bind',
'Bulk Copy',             1 ,
'blk_bind - Bind a program variable and a database column.'
go
exec insert_syntax 'blk_bind',
'Bulk Copy',             2 ,
'    CS_RETCODE blk_bind(blkdesc, colnum, datafmt, buffer,'
go
exec insert_syntax 'blk_bind',
'Bulk Copy',             3 ,
'                  datalen, indicator)'
go
exec insert_syntax 'blk_bind',
'Bulk Copy',             4 ,
'    CS_BLKDESC    *blkdesc;'
go
exec insert_syntax 'blk_bind',
'Bulk Copy',             5 ,
'    CS_INT        colnum;'
go
exec insert_syntax 'blk_bind',
'Bulk Copy',             6 ,
'    CS_DATAFMT    *datafmt;'
go
exec insert_syntax 'blk_bind',
'Bulk Copy',             7 ,
'    CS_VOID       *buffer;'
go
exec insert_syntax 'blk_bind',
'Bulk Copy',             8 ,
'    CS_INT        *datalen;'
go
exec insert_syntax 'blk_bind',
'Bulk Copy',             9 ,
'    CS_SMALLINT   *indicator;'
go
exec insert_syntax 'blk_colval',
'Bulk Copy',             1 ,
'blk_colval - Get the column value from a formatted bulk copy row.'
go
exec insert_syntax 'blk_colval',
'Bulk Copy',             2 ,
'    CS_RETCODE blk_colval(srvproc, blkdescp, rowp, colnum,'
go
exec insert_syntax 'blk_colval',
'Bulk Copy',             3 ,
'                  valuep, valuelen, outlenp)'
go
exec insert_syntax 'blk_colval',
'Bulk Copy',             4 ,
'    SRV_PROC      *srvproc;'
go
exec insert_syntax 'blk_colval',
'Bulk Copy',             5 ,
'    CS_BLKDESC    *blkdescp;'
go
exec insert_syntax 'blk_colval',
'Bulk Copy',             6 ,
'    CS_BLK_ROW    *rowp;'
go
exec insert_syntax 'blk_colval',
'Bulk Copy',             7 ,
'    CS_INT        colnum;'
go
exec insert_syntax 'blk_colval',
'Bulk Copy',             8 ,
'    CS_VOID       *valuep;'
go
exec insert_syntax 'blk_colval',
'Bulk Copy',             9 ,
'    CS_INT        valuelen;'
go
exec insert_syntax 'blk_colval',
'Bulk Copy',             10,
'    CS_INT        *outlenp;'
go
exec insert_syntax 'blk_default',
'Bulk Copy',             1 ,
'blk_default - Retrieve a column''s default value.'
go
exec insert_syntax 'blk_default',
'Bulk Copy',             2 ,
'    CS_RETCODE blk_default(blkdesc, colnum, buffer,'
go
exec insert_syntax 'blk_default',
'Bulk Copy',             3 ,
'                  buflen, outlen)'
go
exec insert_syntax 'blk_default',
'Bulk Copy',             4 ,
'    CS_BLKDESC    *blkdesc;'
go
exec insert_syntax 'blk_default',
'Bulk Copy',             5 ,
'    CS_INT        colnum;'
go
exec insert_syntax 'blk_default',
'Bulk Copy',             6 ,
'    CS_VOID       *buffer;'
go
exec insert_syntax 'blk_default',
'Bulk Copy',             7 ,
'    CS_INT        buflen;'
go
exec insert_syntax 'blk_default',
'Bulk Copy',             8 ,
'    CS_INT        *outlen;'
go
exec insert_syntax 'blk_describe',
'Bulk Copy',             1 ,
'blk_describe - Retrieve a description of a database column.'
go
exec insert_syntax 'blk_describe',
'Bulk Copy',             2 ,
'    CS_RETCODE blk_describe(blkdesc, colnum, datafmt)'
go
exec insert_syntax 'blk_describe',
'Bulk Copy',             3 ,
'    CS_BLKDESC    *blkdesc;'
go
exec insert_syntax 'blk_describe',
'Bulk Copy',             4 ,
'    CS_INT        colnum;'
go
exec insert_syntax 'blk_describe',
'Bulk Copy',             5 ,
'    CS_DATAFMT    *datafmt;'
go
exec insert_syntax 'blk_done',
'Bulk Copy',             1 ,
'blk_done - Mark a complete bulk copy operation or a complete bulk'
go
exec insert_syntax 'blk_done',
'Bulk Copy',             2 ,
'        copy batch.'
go
exec insert_syntax 'blk_done',
'Bulk Copy',             3 ,
'    CS_RETCODE blk_done(blkdesc, type, outrow)'
go
exec insert_syntax 'blk_done',
'Bulk Copy',             4 ,
'    CS_BLKDESC    *blkdesc;'
go
exec insert_syntax 'blk_done',
'Bulk Copy',             5 ,
'    CS_INT        type;'
go
exec insert_syntax 'blk_done',
'Bulk Copy',             6 ,
'    CS_INT        *outrow;'
go
exec insert_syntax 'blk_drop',
'Bulk Copy',             1 ,
'blk_drop - De-allocate a CS_BLKDESC structure.'
go
exec insert_syntax 'blk_drop',
'Bulk Copy',             2 ,
'    CS_RETCODE blk_drop(blkdesc)'
go
exec insert_syntax 'blk_drop',
'Bulk Copy',             3 ,
'    CS_BLKDESC    *blkdesc;'
go
exec insert_syntax 'blk_getrow',
'Bulk Copy',             1 ,
'blk_getrow - Retrieve and store a formatted bulk copy row.'
go
exec insert_syntax 'blk_getrow',
'Bulk Copy',             2 ,
'    CS_RETCODE blk_getrow(srvproc, blkdescp, rowp)'
go
exec insert_syntax 'blk_getrow',
'Bulk Copy',             3 ,
'    SRV_PROC      *srvproc;'
go
exec insert_syntax 'blk_getrow',
'Bulk Copy',             4 ,
'    CS_BLKDESC    *blkdescp;'
go
exec insert_syntax 'blk_getrow',
'Bulk Copy',             5 ,
'    CS_BLK_ROW    *rowp;'
go
exec insert_syntax 'blk_gettext',
'Bulk Copy',             1 ,
'blk_gettext - Retrieve the text or image portion of an incoming bulk'
go
exec insert_syntax 'blk_gettext',
'Bulk Copy',             2 ,
'        copy formatted row.'
go
exec insert_syntax 'blk_gettext',
'Bulk Copy',             3 ,
'    CS_RETCODE blk_gettext(srvproc,blkdescp, rowp, bufp,'
go
exec insert_syntax 'blk_gettext',
'Bulk Copy',             4 ,
'    bufsize, outlenp)'
go
exec insert_syntax 'blk_gettext',
'Bulk Copy',             5 ,
'    SRV_PROC      *srvproc;'
go
exec insert_syntax 'blk_gettext',
'Bulk Copy',             6 ,
'    CS_BLKDESC    *blkdescp;'
go
exec insert_syntax 'blk_gettext',
'Bulk Copy',             7 ,
'    CS_BLK_ROW    *rowp;'
go
exec insert_syntax 'blk_gettext',
'Bulk Copy',             8 ,
'    CS_BYTE       *bufp;'
go
exec insert_syntax 'blk_gettext',
'Bulk Copy',             9 ,
'    CS_INT        bufsize;'
go
exec insert_syntax 'blk_gettext',
'Bulk Copy',             10,
'    CS_INT        *outlenp;'
go
exec insert_syntax 'blk_init',
'Bulk Copy',             1 ,
'blk_init - Initiate a bulk copy operation.'
go
exec insert_syntax 'blk_init',
'Bulk Copy',             2 ,
'    CS_RETCODE blk_init(blkdesc, direction, tablename,'
go
exec insert_syntax 'blk_init',
'Bulk Copy',             3 ,
'                  tnamelen)'
go
exec insert_syntax 'blk_init',
'Bulk Copy',             4 ,
'    CS_BLKDESC    *blkdesc;'
go
exec insert_syntax 'blk_init',
'Bulk Copy',             5 ,
'    CS_INT        direction;'
go
exec insert_syntax 'blk_init',
'Bulk Copy',             6 ,
'    CS_CHAR       *tablename;'
go
exec insert_syntax 'blk_init',
'Bulk Copy',             7 ,
'    CS_INT        tnamelen;'
go
exec insert_syntax 'blk_rowalloc',
'Bulk Copy',             1 ,
'blk_rowalloc - Allocate space for a formatted bulk copy row.'
go
exec insert_syntax 'blk_rowalloc',
'Bulk Copy',             2 ,
'    CS_RETCODE blk_rowalloc(srvproc, row)'
go
exec insert_syntax 'blk_rowalloc',
'Bulk Copy',             3 ,
'    SRV_PROC      *srvproc;'
go
exec insert_syntax 'blk_rowalloc',
'Bulk Copy',             4 ,
'    CS_BLK_ROW    **row;'
go
exec insert_syntax 'blk_rowdrop',
'Bulk Copy',             1 ,
'blk_rowdrop - Free space previously allocated for a formatted bulk'
go
exec insert_syntax 'blk_rowdrop',
'Bulk Copy',             2 ,
'        copy row.'
go
exec insert_syntax 'blk_rowdrop',
'Bulk Copy',             3 ,
'    CS_RETCODE blk_rowdrop(srvproc, row)'
go
exec insert_syntax 'blk_rowdrop',
'Bulk Copy',             4 ,
'    SRV_PROC      *srvproc;'
go
exec insert_syntax 'blk_rowdrop',
'Bulk Copy',             5 ,
'    CS_BLK_ROW    *row;'
go
exec insert_syntax 'blk_rowxfer',
'Bulk Copy',             1 ,
'blk_rowxfer - Transfer a row during a bulk copy operation.'
go
exec insert_syntax 'blk_rowxfer',
'Bulk Copy',             2 ,
'    CS_RETCODE blk_rowxfer(blkdesc)'
go
exec insert_syntax 'blk_rowxfer',
'Bulk Copy',             3 ,
'    CS_BLKDESC    *blkdesc;'
go
exec insert_syntax 'blk_sendrow',
'Bulk Copy',             1 ,
'blk_sendrow - Send a formatted bulk copy row.'
go
exec insert_syntax 'blk_sendrow',
'Bulk Copy',             2 ,
'    CS_RETCODE blk_sendrow(blkdesc, row)'
go
exec insert_syntax 'blk_sendrow',
'Bulk Copy',             3 ,
'    CS_BLKDESC    *blkdesc;'
go
exec insert_syntax 'blk_sendrow',
'Bulk Copy',             4 ,
'    CS_BLK_ROW    *row;'
go
exec insert_syntax 'blk_sendtext',
'Bulk Copy',             1 ,
'blk_sendtext - Send text or image data in a formatted bulk copy row.'
go
exec insert_syntax 'blk_sendtext',
'Bulk Copy',             2 ,
'    CS_RETCODE blk_sendtext(blkdesc, row, buffer,'
go
exec insert_syntax 'blk_sendtext',
'Bulk Copy',             3 ,
'                  buflen)'
go
exec insert_syntax 'blk_sendtext',
'Bulk Copy',             4 ,
'    CS_BLKDESC    *blkdesc;'
go
exec insert_syntax 'blk_sendtext',
'Bulk Copy',             5 ,
'    CS_BLK_ROW    *row;'
go
exec insert_syntax 'blk_sendtext',
'Bulk Copy',             6 ,
'    CS_BYTE       *buffer;'
go
exec insert_syntax 'blk_sendtext',
'Bulk Copy',             7 ,
'    CS_INT        buflen;'
go
exec insert_syntax 'blk_srvinit',
'Bulk Copy',             1 ,
'blk_srvinit - Copy descriptions of server table columns to the'
go
exec insert_syntax 'blk_srvinit',
'Bulk Copy',             2 ,
'        client, if required.'
go
exec insert_syntax 'blk_srvinit',
'Bulk Copy',             3 ,
'    CS_RETCODE blk_srvinit(srvproc, blkdescp)'
go
exec insert_syntax 'blk_srvinit',
'Bulk Copy',             4 ,
'    SRV_PROC      *srvproc;'
go
exec insert_syntax 'blk_srvinit',
'Bulk Copy',             5 ,
'    CS_BLKDESC    *blkdescp;'
go
exec insert_syntax 'blk_textxfer',
'Bulk Copy',             1 ,
'blk_textxfer - Transfer text or image data during a bulk copy'
go
exec insert_syntax 'blk_textxfer',
'Bulk Copy',             2 ,
'        operation.'
go
exec insert_syntax 'blk_textxfer',
'Bulk Copy',             3 ,
'    CS_RETCODE blk_textxfer(blkdesc, buffer, buflen,'
go
exec insert_syntax 'blk_textxfer',
'Bulk Copy',             4 ,
'                  outlen)'
go
exec insert_syntax 'blk_textxfer',
'Bulk Copy',             5 ,
'    CS_BLKDESC    *blkdesc;'
go
exec insert_syntax 'blk_textxfer',
'Bulk Copy',             6 ,
'    CS_BYTE       *buffer;'
go
exec insert_syntax 'blk_textxfer',
'Bulk Copy',             7 ,
'    CS_INT        buflen;'
go
exec insert_syntax 'blk_textxfer',
'Bulk Copy',             8 ,
'    CS_INT        *outlen;'
go

exec insert_syntax 'cs_calc',
'CS-Library/C',          1 ,
'cs_calc - Perform an arithmetic operation.'
go
exec insert_syntax 'cs_calc',
'CS-Library/C',          2 ,
'    CS_RETCODE cs_calc(context, op, datatype, var1,'
go
exec insert_syntax 'cs_calc',
'CS-Library/C',          3 ,
'                  var2, dest)'
go
exec insert_syntax 'cs_calc',
'CS-Library/C',          4 ,
'    CS_CONTEXT    *context;'
go
exec insert_syntax 'cs_calc',
'CS-Library/C',          5 ,
'    CS_INT        op;'
go
exec insert_syntax 'cs_calc',
'CS-Library/C',          6 ,
'    CS_INT        datatype;'
go
exec insert_syntax 'cs_calc',
'CS-Library/C',          7 ,
'    CS_VOID       *var1;'
go
exec insert_syntax 'cs_calc',
'CS-Library/C',          8 ,
'    CS_VOID       *var2;'
go
exec insert_syntax 'cs_calc',
'CS-Library/C',          9 ,
'    CS_VOID       *dest;'
go
exec insert_syntax 'cs_cmp',
'CS-Library/C',          1 ,
'cs_cmp - Compare two data values.'
go
exec insert_syntax 'cs_cmp',
'CS-Library/C',          2 ,
'    CS_RETCODE cs_cmp(context, datatype, var1, var2,'
go
exec insert_syntax 'cs_cmp',
'CS-Library/C',          3 ,
'                  result)'
go
exec insert_syntax 'cs_cmp',
'CS-Library/C',          4 ,
'    CS_CONTEXT    *context;'
go
exec insert_syntax 'cs_cmp',
'CS-Library/C',          5 ,
'    CS_INT        datatype;'
go
exec insert_syntax 'cs_cmp',
'CS-Library/C',          6 ,
'    CS_VOID       *var1;'
go
exec insert_syntax 'cs_cmp',
'CS-Library/C',          7 ,
'    CS_VOID       *var2;'
go
exec insert_syntax 'cs_cmp',
'CS-Library/C',          8 ,
'    CS_INT        *result;'
go
exec insert_syntax 'cs_config',
'CS-Library/C',          1 ,
'cs_config - Set or retrieve CS-Library properties.'
go
exec insert_syntax 'cs_config',
'CS-Library/C',          2 ,
'    CS_RETCODE cs_config(context, action, property,'
go
exec insert_syntax 'cs_config',
'CS-Library/C',          3 ,
'                  buffer, buflen, outlen)'
go
exec insert_syntax 'cs_config',
'CS-Library/C',          4 ,
'    CS_CONTEXT    *context;'
go
exec insert_syntax 'cs_config',
'CS-Library/C',          5 ,
'    CS_INT        action;'
go
exec insert_syntax 'cs_config',
'CS-Library/C',          6 ,
'    CS_INT        property;'
go
exec insert_syntax 'cs_config',
'CS-Library/C',          7 ,
'    CS_VOID       *buffer;'
go
exec insert_syntax 'cs_config',
'CS-Library/C',          8 ,
'    CS_INT        buflen;'
go
exec insert_syntax 'cs_config',
'CS-Library/C',          9 ,
'    CS_INT        *outlen;'
go
exec insert_syntax 'cs_convert',
'CS-Library/C',          1 ,
'cs_convert - Convert a data value from one datatype to another.'
go
exec insert_syntax 'cs_convert',
'CS-Library/C',          2 ,
'    CS_RETCODE cs_convert(context, srcfmt, srcdata,'
go
exec insert_syntax 'cs_convert',
'CS-Library/C',          3 ,
'                  destfmt, destdata, resultlen)'
go
exec insert_syntax 'cs_convert',
'CS-Library/C',          4 ,
'    CS_CONTXT     *context;'
go
exec insert_syntax 'cs_convert',
'CS-Library/C',          5 ,
'    CS_DATAFMT    *srcfmt;'
go
exec insert_syntax 'cs_convert',
'CS-Library/C',          6 ,
'    CS_VOID       *srcdata;'
go
exec insert_syntax 'cs_convert',
'CS-Library/C',          7 ,
'    CS_DATAFMT    *destfmt;'
go
exec insert_syntax 'cs_convert',
'CS-Library/C',          8 ,
'    CS_VOID       *destdata;'
go
exec insert_syntax 'cs_convert',
'CS-Library/C',          9 ,
'    CS_INT        *resultlen;'
go
exec insert_syntax 'cs_ctx_alloc',
'CS-Library/C',          1 ,
'cs_ctx_alloc - Allocate a CS_CONTEXT structure.'
go
exec insert_syntax 'cs_ctx_alloc',
'CS-Library/C',          2 ,
'    CS_RETCODE cs_ctx_alloc(version, ctx_pointer)'
go
exec insert_syntax 'cs_ctx_alloc',
'CS-Library/C',          3 ,
'    CS_INT        version;'
go
exec insert_syntax 'cs_ctx_alloc',
'CS-Library/C',          4 ,
'    CS_CONTEXT    **ctx_pointer;'
go
exec insert_syntax 'cs_ctx_drop',
'CS-Library/C',          1 ,
'cs_ctx_drop - De-allocate a CS_CONTEXT structure.'
go
exec insert_syntax 'cs_ctx_drop',
'CS-Library/C',          2 ,
'    CS_RETCODE cs_ctx_drop(context)'
go
exec insert_syntax 'cs_ctx_drop',
'CS-Library/C',          3 ,
'    CS_CONTEXT    *context;'
go
exec insert_syntax 'cs_ctx_global',
'CS-Library/C',          1 ,
'cs_ctx_global - Allocate or return a CS_CONTEXT structure.'
go
exec insert_syntax 'cs_ctx_global',
'CS-Library/C',          2 ,
'    CS_RETCODE cs_ctx_global(version, ctx_pointer)'
go
exec insert_syntax 'cs_ctx_global',
'CS-Library/C',          3 ,
'    CS_INT        version;'
go
exec insert_syntax 'cs_ctx_global',
'CS-Library/C',          4 ,
'    CS_CONTEXT    **ctx_pointer;'
go
exec insert_syntax 'cs_diag',
'CS-Library/C',          1 ,
'cs_diag - Manage in-line error handling.'
go
exec insert_syntax 'cs_diag',
'CS-Library/C',          2 ,
'    CS_RETCODE cs_diag(context, operation, type, index,'
go
exec insert_syntax 'cs_diag',
'CS-Library/C',          3 ,
'                  buffer)'
go
exec insert_syntax 'cs_diag',
'CS-Library/C',          4 ,
'    CS_CONTEXT    *context;'
go
exec insert_syntax 'cs_diag',
'CS-Library/C',          5 ,
'    CS_INT        operation;'
go
exec insert_syntax 'cs_diag',
'CS-Library/C',          6 ,
'    CS_INT        type;'
go
exec insert_syntax 'cs_diag',
'CS-Library/C',          7 ,
'    CS_INT        index;'
go
exec insert_syntax 'cs_diag',
'CS-Library/C',          8 ,
'    CS_VOID       *buffer;'
go
exec insert_syntax 'cs_dt_crack',
'CS-Library/C',          1 ,
'cs_dt_crack - Convert a machine-readable datetime value into a'
go
exec insert_syntax 'cs_dt_crack',
'CS-Library/C',          2 ,
'        user-accessible format.'
go
exec insert_syntax 'cs_dt_crack',
'CS-Library/C',          3 ,
'    CS_RETCODE cs_dt_crack(context, datetype, dateval,'
go
exec insert_syntax 'cs_dt_crack',
'CS-Library/C',          4 ,
'                  daterec)'
go
exec insert_syntax 'cs_dt_crack',
'CS-Library/C',          5 ,
'    CS_CONTEXT    *context;'
go
exec insert_syntax 'cs_dt_crack',
'CS-Library/C',          6 ,
'    CS_INT        datetype;'
go
exec insert_syntax 'cs_dt_crack',
'CS-Library/C',          7 ,
'    CS_VOID       *dateval;'
go
exec insert_syntax 'cs_dt_crack',
'CS-Library/C',          8 ,
'    CS_DATEREC    *daterec;'
go
exec insert_syntax 'cs_dt_info',
'CS-Library/C',          1 ,
'cs_dt_info - Set or retrieve language-specific datetime'
go
exec insert_syntax 'cs_dt_info',
'CS-Library/C',          2 ,
'        information.'
go
exec insert_syntax 'cs_dt_info',
'CS-Library/C',          3 ,
'    CS_RETCODE cs_dt_info(context, action, locale, type,'
go
exec insert_syntax 'cs_dt_info',
'CS-Library/C',          4 ,
'                  item, buffer, buflen, outlen)'
go
exec insert_syntax 'cs_dt_info',
'CS-Library/C',          5 ,
'    CS_CONTEXT    *context;'
go
exec insert_syntax 'cs_dt_info',
'CS-Library/C',          6 ,
'    CS_INT        action;'
go
exec insert_syntax 'cs_dt_info',
'CS-Library/C',          7 ,
'    CS_LOCALE     *locale;'
go
exec insert_syntax 'cs_dt_info',
'CS-Library/C',          8 ,
'    CS_INT        type;'
go
exec insert_syntax 'cs_dt_info',
'CS-Library/C',          9 ,
'    CS_INT        item;'
go
exec insert_syntax 'cs_dt_info',
'CS-Library/C',          10,
'    CS_VOID       *buffer;'
go
exec insert_syntax 'cs_dt_info',
'CS-Library/C',          11,
'    CS_INT        buflen;'
go
exec insert_syntax 'cs_dt_info',
'CS-Library/C',          12,
'    CS_INT        *outlen;'
go
exec insert_syntax 'cs_loc_alloc',
'CS-Library/C',          1 ,
'cs_loc_alloc - Allocate a CS_LOCALE structure.'
go
exec insert_syntax 'cs_loc_alloc',
'CS-Library/C',          2 ,
'    CS_RETCODE cs_loc_alloc(context, loc_pointer)'
go
exec insert_syntax 'cs_loc_alloc',
'CS-Library/C',          3 ,
'    CS_CONTEXT    *context;'
go
exec insert_syntax 'cs_loc_alloc',
'CS-Library/C',          4 ,
'    CS_LOCALE     **loc_pointer;'
go
exec insert_syntax 'cs_loc_drop',
'CS-Library/C',          1 ,
'cs_loc_drop - De-allocate a CS_LOCALE structure.'
go
exec insert_syntax 'cs_loc_drop',
'CS-Library/C',          2 ,
'    CS_RETCODE cs_loc_drop(context, locale)'
go
exec insert_syntax 'cs_loc_drop',
'CS-Library/C',          3 ,
'    CS_CONTEXT    *context;'
go
exec insert_syntax 'cs_loc_drop',
'CS-Library/C',          4 ,
'    CS_LOCALE     *locale;'
go
exec insert_syntax 'cs_locale',
'CS-Library/C',          1 ,
'cs_locale - Loads a CS_LOCALE with localization values or'
go
exec insert_syntax 'cs_locale',
'CS-Library/C',          2 ,
'        retrieves the locale name previously used to load a'
go
exec insert_syntax 'cs_locale',
'CS-Library/C',          3 ,
'        CS_LOCALE.'
go
exec insert_syntax 'cs_locale',
'CS-Library/C',          4 ,
'    CS_RETCODE cs_locale(context, action, locale, type,'
go
exec insert_syntax 'cs_locale',
'CS-Library/C',          5 ,
'                  buffer, buflen, outlen)'
go
exec insert_syntax 'cs_locale',
'CS-Library/C',          6 ,
'    CS_CONTEXT    *context;'
go
exec insert_syntax 'cs_locale',
'CS-Library/C',          7 ,
'    CS_INT        action;'
go
exec insert_syntax 'cs_locale',
'CS-Library/C',          8 ,
'    CS_LOCALE     *locale;'
go
exec insert_syntax 'cs_locale',
'CS-Library/C',          9 ,
'    CS_INT        type;'
go
exec insert_syntax 'cs_locale',
'CS-Library/C',          10,
'    CS_CHAR       *buffer;'
go
exec insert_syntax 'cs_locale',
'CS-Library/C',          11,
'    CS_INT        buflen;'
go
exec insert_syntax 'cs_locale',
'CS-Library/C',          12,
'    CS_INT        *outlen;'
go
exec insert_syntax 'cs_objects',
'CS-Library/C',          1 ,
'cs_objects - Save, retrieve, or clear objects and data associated'
go
exec insert_syntax 'cs_objects',
'CS-Library/C',          2 ,
'        with them.'
go
exec insert_syntax 'cs_objects',
'CS-Library/C',          3 ,
'    CS_RETCODE cs_objects(context, action, objname,'
go
exec insert_syntax 'cs_objects',
'CS-Library/C',          4 ,
'                  objdata)'
go
exec insert_syntax 'cs_objects',
'CS-Library/C',          5 ,
'    CS_CONTEXT    *context;'
go
exec insert_syntax 'cs_objects',
'CS-Library/C',          6 ,
'    CS_INT        action;'
go
exec insert_syntax 'cs_objects',
'CS-Library/C',          7 ,
'    CS_OBJNAME    *objname;'
go
exec insert_syntax 'cs_objects',
'CS-Library/C',          8 ,
'    CS_OBJDATA    *objdata;'
go
exec insert_syntax 'cs_set_convert',
'CS-Library/C',          1 ,
'cs_set_convert - Install or retrieve a conversion routine.'
go
exec insert_syntax 'cs_set_convert',
'CS-Library/C',          2 ,
'    CS_RETCODE cs_set_convert(context, action, srctype,'
go
exec insert_syntax 'cs_set_convert',
'CS-Library/C',          3 ,
'                  desttype, func)'
go
exec insert_syntax 'cs_set_convert',
'CS-Library/C',          4 ,
'    CS_CONTEXT    *context;'
go
exec insert_syntax 'cs_set_convert',
'CS-Library/C',          5 ,
'    CS_INT        action;'
go
exec insert_syntax 'cs_set_convert',
'CS-Library/C',          6 ,
'    CS_INT        srctype;'
go
exec insert_syntax 'cs_set_convert',
'CS-Library/C',          7 ,
'    CS_INT        desttype;'
go
exec insert_syntax 'cs_set_convert',
'CS-Library/C',          8 ,
'    CS_CONV_FUNC  *func;'
go
exec insert_syntax 'cs_setnull',
'CS-Library/C',          1 ,
'cs_setnull - Define a null substitution value to be used when'
go
exec insert_syntax 'cs_setnull',
'CS-Library/C',          2 ,
'        binding or converting NULL data.'
go
exec insert_syntax 'cs_setnull',
'CS-Library/C',          3 ,
'    CS_RETCODE cs_setnull(context, datafmt, buffer,'
go
exec insert_syntax 'cs_setnull',
'CS-Library/C',          4 ,
'                  buflen)'
go
exec insert_syntax 'cs_setnull',
'CS-Library/C',          5 ,
'    CS_CONTEXT    *context;'
go
exec insert_syntax 'cs_setnull',
'CS-Library/C',          6 ,
'    CS_DATAFMT    *datafmt;'
go
exec insert_syntax 'cs_setnull',
'CS-Library/C',          7 ,
'    CS_VOID       *buffer;'
go
exec insert_syntax 'cs_setnull',
'CS-Library/C',          8 ,
'    CS_INT        buflen;'
go
exec insert_syntax 'cs_strbuild',
'CS-Library/C',          1 ,
'cs_strbuild - Construct national language message strings.'
go
exec insert_syntax 'cs_strbuild',
'CS-Library/C',          2 ,
'    CS_RETCODE cs_strbuild(context, buffer, buflen,'
go
exec insert_syntax 'cs_strbuild',
'CS-Library/C',          3 ,
'                  resultlen,    text, textlen'
go
exec insert_syntax 'cs_strbuild',
'CS-Library/C',          4 ,
'                  [, formats, formatlen]'
go
exec insert_syntax 'cs_strbuild',
'CS-Library/C',          5 ,
'                  [, arguments]);'
go
exec insert_syntax 'cs_strbuild',
'CS-Library/C',          6 ,
'    CS_CONTEXT    *context;'
go
exec insert_syntax 'cs_strbuild',
'CS-Library/C',          7 ,
'    CS_CHAR       *buffer;'
go
exec insert_syntax 'cs_strbuild',
'CS-Library/C',          8 ,
'    CS_INT        buflen;'
go
exec insert_syntax 'cs_strbuild',
'CS-Library/C',          9 ,
'    CS_INT        *resultlen;'
go
exec insert_syntax 'cs_strbuild',
'CS-Library/C',          10,
'    CS_CHAR       *text;'
go
exec insert_syntax 'cs_strbuild',
'CS-Library/C',          11,
'    CS_INT        textlen;'
go
exec insert_syntax 'cs_strbuild',
'CS-Library/C',          12,
'    CS_CHAR       *formats; /* Optional */'
go
exec insert_syntax 'cs_strbuild',
'CS-Library/C',          13,
'    CS_INT        formatlen; /* Optional */'
go
exec insert_syntax 'cs_strbuild',
'CS-Library/C',          14,
'    <optional arguments>'
go
exec insert_syntax 'cs_strcmp',
'CS-Library/C',          1 ,
'cs_strcmp - Compare two strings using a specified sort order.'
go
exec insert_syntax 'cs_strcmp',
'CS-Library/C',          2 ,
'    CS_RETCODE cs_strcmp(context, locale, type str1,'
go
exec insert_syntax 'cs_strcmp',
'CS-Library/C',          3 ,
'                  len1, str2, len2, result)'
go
exec insert_syntax 'cs_strcmp',
'CS-Library/C',          4 ,
'    CS_CONTEXT    *context;'
go
exec insert_syntax 'cs_strcmp',
'CS-Library/C',          5 ,
'    CS_LOCALE     *locale;'
go
exec insert_syntax 'cs_strcmp',
'CS-Library/C',          6 ,
'    CS_INT        type;'
go
exec insert_syntax 'cs_strcmp',
'CS-Library/C',          7 ,
'    CS_CHAR       *str1;'
go
exec insert_syntax 'cs_strcmp',
'CS-Library/C',          8 ,
'    CS_INT        len1;'
go
exec insert_syntax 'cs_strcmp',
'CS-Library/C',          9 ,
'    CS_CHAR       *str2;'
go
exec insert_syntax 'cs_strcmp',
'CS-Library/C',          10,
'    CS_INT        len2;'
go
exec insert_syntax 'cs_strcmp',
'CS-Library/C',          11,
'    CS_INT        *result;'
go
exec insert_syntax 'cs_time',
'CS-Library/C',          1 ,
'cs_time - Retrieve the current date and time.'
go
exec insert_syntax 'cs_time',
'CS-Library/C',          2 ,
'    CS_RETCODE cs_time(context, locale, buffer, buflen,'
go
exec insert_syntax 'cs_time',
'CS-Library/C',          3 ,
'                  outlen, daterec)'
go
exec insert_syntax 'cs_time',
'CS-Library/C',          4 ,
'    CS_CONTEXT    *context;'
go
exec insert_syntax 'cs_time',
'CS-Library/C',          5 ,
'    CS_LOCALE     locale;'
go
exec insert_syntax 'cs_time',
'CS-Library/C',          6 ,
'    CS_VOID       *buffer;'
go
exec insert_syntax 'cs_time',
'CS-Library/C',          7 ,
'    CS_INT        buflen;'
go
exec insert_syntax 'cs_time',
'CS-Library/C',          8 ,
'    CS_INT        *outlen;'
go
exec insert_syntax 'cs_time',
'CS-Library/C',          9 ,
'    CS_DATEREC    *daterec;'
go
exec insert_syntax 'cs_will_convert',
'CS-Library/C',          1 ,
'cs_will_convert - Indicate whether a specific datatype conversion is'
go
exec insert_syntax 'cs_will_convert',
'CS-Library/C',          2 ,
'        available in the Client/Server libraries.'
go
exec insert_syntax 'cs_will_convert',
'CS-Library/C',          3 ,
'    CS_RETCODE cs_will_convert(context, srctype, desttype,'
go
exec insert_syntax 'cs_will_convert',
'CS-Library/C',          4 ,
'                  result)'
go
exec insert_syntax 'cs_will_convert',
'CS-Library/C',          5 ,
'    CS_CONTEXT    *context;'
go
exec insert_syntax 'cs_will_convert',
'CS-Library/C',          6 ,
'    CS_INT        srctype;'
go
exec insert_syntax 'cs_will_convert',
'CS-Library/C',          7 ,
'    CS_INT        desttype;'
go
exec insert_syntax 'cs_will_convert',
'CS-Library/C',          8 ,
'    CS_BOOL       *result;'
go


/* drop the insert_syntax procedure */
if exists (select name from sysobjects where name = "insert_syntax")
begin
	drop procedure insert_syntax
end
go

/* drop the sybsyntax_printmsg procedure */
if exists (select name from sysobjects where name = "sybsyntax_printmsg")
begin
	drop procedure sybsyntax_printmsg
end
go

/* If sp_syntax already exists, drop it so that we might replace it */
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_syntax')
begin
	drop procedure sp_syntax
end
go

create procedure sp_syntax
	@word varchar(50) = null,	/* command */
	@mod varchar(20) = null,	/* module */
	@language varchar(30) = null	/* language */
as

set nocount on
declare	@pattern	varchar(52),
	@counter	tinyint,
	@mincommand	varchar(50),
	@modpattern	varchar(22),
	@modcount	tinyint,
	@minmod		varchar(20),
	@msg		varchar(255),
	@msgparam	varchar(30),
	@lang_id	smallint,
	@returncode smallint
/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	/*
	** 17260, "Can't run %1! from within a transaction."
	*/
	exec sp_getmessage 17260, @msg output
	print @msg, "sp_syntax"
	return (1)
end

/*
** Check that language is valid.
*/
if @language is not NULL
begin
    execute @returncode = sp_validlang @language
    if @returncode != 0
    begin
	    /* Us_english is always valid */
	    if @language != "us_english"
	    begin
		    /* 
		    ** 17201, "'%1!' is not an official language
		    **	name from Syslanguages."
		    */
		    exec sp_getmessage 17201, @msg output
		    print @msg, @language
		    return @returncode
	    end

	    /* set to us_english */
	    select @lang_id = NULL
    end

    else
    select @lang_id = langid from syslanguages
		where @language = name

end

/* set search string to %word% */

select @pattern = "%" + lower(@word) + "%",
	@modpattern = "%" + lower(@mod) + "%"


/* if no command/routine name is given, print the syntax and return*/

if @word is null
begin
	/*
	** 17970, "sp_syntax provides syntax help for Sybase products."
	*/
	exec sp_getmessage 17970, @msg output, @language
	print @msg
	/*
	** 17971, "These modules are installed on this Server:"
	*/
	exec sp_getmessage 17971, @msg output, @language
	print @msg
	print ""
	select distinct module Module from sybsyntax..sybsyntax
	print""
	/*
	** 17972, "Usage:  sp_syntax command [, module, language]"
	*/
	exec sp_getmessage 17972, @msg output, @language
	print @msg
	return
end

/* if no commands match, print a message and return */

if (select count(*) from sybsyntax..sybsyntax
	where commandname like @pattern) = 0
begin
	/*
	** 17973, "No command or routine has a name like '%1!'"
	*/
	exec sp_getmessage 17973, @msg output, @language
	print @msg, @word
	return
end

/* if no modules match, print a message and return */

if @mod is not null and (select count(*) from sybsyntax..sybsyntax
	where lower(module) like @modpattern) = 0
begin
	/*
	** 17974, "No module has a name like '%1!'"
	*/
	exec sp_getmessage 17974, @msg output, @language
	print @msg, @mod
	return
end

/* if command/module combo has no matches, print message and return */
if (select count(*) from sybsyntax..sybsyntax
		where lower (module) like @modpattern
		and lower (commandname) like @pattern
		and langid = @lang_id) = 0
begin
	/*
	** 17975, "No command or routine has a name like '%1!' and a module like '%2!'"
	*/
	exec sp_getmessage 17975, @msg output, @language
	print @msg, @word, @mod
	return
end

/* Put a list of all desired module names into #tempsyntax1.
** If a module was specified, find all %mod% matches.
** If @mod is null, select modules from the table with a
** matching %word%
*/

create table #tempsyntax1 (module varchar(20))
if @mod is not null
begin
	insert #tempsyntax1
		select distinct(module)
		from sybsyntax..sybsyntax
		where lower(module) like @modpattern
		and langid = @lang_id
end
else
begin
	insert #tempsyntax1
		select distinct(module)
		from sybsyntax..sybsyntax
		where commandname like @pattern
		and langid = @lang_id
end

select @modcount = (select count(*) from #tempsyntax1)

/* create a table to store the results */
create table #tempsyntax2 (c1 varchar(78))


/* find the first module in alpha order */
select @minmod = min(module)
	from #tempsyntax1

/* the loop that finds all the answers */
while @modcount > 0
begin

	/* Put module name into results */
	insert #tempsyntax2 values (@minmod)
		/* count matches for this module */
		select @counter = (select count(*)
			from sybsyntax..sybsyntax
			where commandname like @pattern
				and linenum = 1
				and module = @minmod
				and langid = @lang_id)
	/*find the first word in alpha order */
	select @mincommand = min(commandname)
		from sybsyntax..sybsyntax
		where commandname like @pattern
			and module = @minmod
			and langid = @lang_id
	while @counter > 0
	begin
		/* select the syntax info into the results */
		insert #tempsyntax2
		select syntax from sybsyntax..sybsyntax
			where commandname = @mincommand
				and module = @minmod
				and langid = @lang_id
				order by linenum
		/* add a blank line between commands */
		insert #tempsyntax2
			select ""
		select @counter = @counter - 1
		/*find the first word in alpha order */
		select @mincommand = min(commandname)
			from sybsyntax..sybsyntax
			where commandname like @pattern
				and commandname > @mincommand
				and module = @minmod
				and langid = @lang_id
	end
	/* find the next module in alpha order */
	select @minmod = min(module)
		from #tempsyntax1
		where module > @minmod
	select @modcount = @modcount - 1
end

/*
** 18049, "Syntax Help"
*/
exec sp_getmessage 18049, @msg output, @language
print @msg
select "" = c1 from #tempsyntax2
go

/* add guest user to sybsyntax db so everybody can access it */
use sybsyntax
go

if not exists (select * from sysusers where name="guest")
	exec sp_adduser guest
go

/* grant permission for sp_syntax to be executed by anybody */
use master
go

grant execute on sp_syntax to public
go
